/*
 * Decompiled with CFR 0.152.
 */
package RCM.Entities;

import RCM.Entities.WingHandler;
import RCM.RCM_Main;
import com.bulletphysics.collision.broadphase.BroadphaseInterface;
import com.bulletphysics.collision.broadphase.DbvtBroadphase;
import com.bulletphysics.collision.broadphase.Dispatcher;
import com.bulletphysics.collision.dispatch.CollisionConfiguration;
import com.bulletphysics.collision.dispatch.CollisionDispatcher;
import com.bulletphysics.collision.dispatch.DefaultCollisionConfiguration;
import com.bulletphysics.collision.shapes.BoxShape;
import com.bulletphysics.collision.shapes.CollisionShape;
import com.bulletphysics.collision.shapes.CompoundShape;
import com.bulletphysics.collision.shapes.CylinderShape;
import com.bulletphysics.dynamics.DiscreteDynamicsWorld;
import com.bulletphysics.dynamics.DynamicsWorld;
import com.bulletphysics.dynamics.RigidBody;
import com.bulletphysics.dynamics.RigidBodyConstructionInfo;
import com.bulletphysics.dynamics.constraintsolver.ConstraintSolver;
import com.bulletphysics.dynamics.constraintsolver.SequentialImpulseConstraintSolver;
import com.bulletphysics.dynamics.vehicle.DefaultVehicleRaycaster;
import com.bulletphysics.dynamics.vehicle.RaycastVehicle;
import com.bulletphysics.dynamics.vehicle.VehicleRaycaster;
import com.bulletphysics.dynamics.vehicle.VehicleTuning;
import com.bulletphysics.dynamics.vehicle.WheelInfo;
import com.bulletphysics.linearmath.DefaultMotionState;
import com.bulletphysics.linearmath.MotionState;
import com.bulletphysics.linearmath.Transform;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.vecmath.AxisAngle4f;
import javax.vecmath.Matrix4f;
import javax.vecmath.Quat4f;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3f;
import net.minecraft.entity.Entity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.World;

public class PhysicsHandler {
    private String fileName;
    private Set<RigidBody> collisionBodies = new HashSet<RigidBody>();
    public List<WingHandler> wings = new ArrayList<WingHandler>();
    public DynamicsWorld dynamicsWorld;
    public RigidBody entityBody;
    public RaycastVehicle vehicle;
    public boolean shouldLoadCollisionShapes = false;
    private int collisionShapes;
    private int numWheels;
    private int numWings;
    private float entityMass;

    public PhysicsHandler() {
        DbvtBroadphase broadphase = new DbvtBroadphase();
        DefaultCollisionConfiguration collisionConfiguration = new DefaultCollisionConfiguration();
        CollisionDispatcher dispatcher = new CollisionDispatcher((CollisionConfiguration)collisionConfiguration);
        SequentialImpulseConstraintSolver solver = new SequentialImpulseConstraintSolver();
        this.dynamicsWorld = new DiscreteDynamicsWorld((Dispatcher)dispatcher, (BroadphaseInterface)broadphase, (ConstraintSolver)solver, (CollisionConfiguration)collisionConfiguration);
        this.dynamicsWorld.setGravity(new Vector3f(0.0f, -9.81f, 0.0f));
    }

    public void getPropertiesFile(String name) throws FileNotFoundException, IOException {
        String line;
        this.fileName = name;
        URL url = this.getClass().getResource(RCM_Main.propertiesFilePath + this.fileName);
        InputStream inputstream = url.openStream();
        BufferedReader reader = new BufferedReader(new InputStreamReader(inputstream));
        while ((line = reader.readLine()) != null) {
            if (line.startsWith("Total_mass: ")) {
                this.entityMass = Float.valueOf(line.split(" ")[1]).floatValue();
                continue;
            }
            if (line.startsWith("Collision_shapes: ")) {
                this.collisionShapes = Integer.valueOf(line.split(" ")[1]);
                continue;
            }
            if (line.startsWith("Wheel_number: ")) {
                this.numWheels = Integer.valueOf(line.split(" ")[1]);
                continue;
            }
            if (!line.startsWith("Wing_number: ")) continue;
            this.numWings = Integer.valueOf(line.split(" ")[1]);
            break;
        }
        reader.close();
    }

    public void loadCollisionModel(Vector3f position, float spawnRotation) throws FileNotFoundException, IOException {
        AxisAngle4f initRotate = new AxisAngle4f(0.0f, 1.0f, 0.0f, spawnRotation);
        Quat4f localQuat = new Quat4f();
        localQuat.set(initRotate);
        BoxShape shape = null;
        Transform shapeTrans = new Transform();
        CompoundShape entityShape = new CompoundShape();
        URL url = null;
        InputStream inputstream = null;
        BufferedReader reader = null;
        for (int i = 1; i <= this.collisionShapes; ++i) {
            String line;
            url = this.getClass().getResource(RCM_Main.propertiesFilePath + this.fileName);
            inputstream = url.openStream();
            reader = new BufferedReader(new InputStreamReader(inputstream));
            shapeTrans.setIdentity();
            while ((line = reader.readLine()) != null) {
                float z;
                float y;
                float x;
                if (line.startsWith("ShapeB_" + i + ": ")) {
                    x = Float.valueOf(line.split(" ")[1]).floatValue();
                    y = Float.valueOf(line.split(" ")[2]).floatValue();
                    z = Float.valueOf(line.split(" ")[3]).floatValue();
                    shape = new BoxShape(new Vector3f(x, y, z));
                    continue;
                }
                if (line.startsWith("ShapeC_" + i + ": ")) {
                    x = Float.valueOf(line.split(" ")[1]).floatValue();
                    y = Float.valueOf(line.split(" ")[2]).floatValue();
                    z = Float.valueOf(line.split(" ")[3]).floatValue();
                    shape = new CylinderShape(new Vector3f(x, y, z));
                    continue;
                }
                if (line.startsWith("Shape_rotation_" + i + ": ")) {
                    x = Float.valueOf(line.split(" ")[1]).floatValue();
                    y = Float.valueOf(line.split(" ")[2]).floatValue();
                    z = Float.valueOf(line.split(" ")[3]).floatValue();
                    float w = Float.valueOf(line.split(" ")[4]).floatValue();
                    shapeTrans.setRotation(new Quat4f(x, y, z, w));
                    continue;
                }
                if (!line.startsWith("Shape_position_" + i + ": ")) continue;
                x = Float.valueOf(line.split(" ")[1]).floatValue();
                y = Float.valueOf(line.split(" ")[2]).floatValue();
                z = Float.valueOf(line.split(" ")[3]).floatValue();
                shapeTrans.origin.set((Tuple3f)new Vector3f(x, y, z));
                break;
            }
            reader.close();
            entityShape.addChildShape(shapeTrans, shape);
        }
        Vector3f entityInertia = new Vector3f(0.0f, 0.0f, 0.0f);
        entityShape.calculateLocalInertia(this.entityMass, entityInertia);
        DefaultMotionState motionState = new DefaultMotionState(new Transform(new Matrix4f(localQuat, position, 1.0f)));
        RigidBodyConstructionInfo entityConstructionInfo = new RigidBodyConstructionInfo(this.entityMass, (MotionState)motionState, (CollisionShape)entityShape, entityInertia);
        entityConstructionInfo.angularDamping = 0.95f;
        entityConstructionInfo.restitution = 0.2f;
        entityConstructionInfo.friction = 0.5f;
        this.entityBody = new RigidBody(entityConstructionInfo);
        this.dynamicsWorld.addRigidBody(this.entityBody);
    }

    public void loadWheels() throws FileNotFoundException, IOException {
        if (this.numWheels > 0) {
            String line;
            VehicleTuning tuning = new VehicleTuning();
            DefaultVehicleRaycaster vehicleRayCaster = new DefaultVehicleRaycaster(this.dynamicsWorld);
            this.vehicle = new RaycastVehicle(tuning, this.entityBody, (VehicleRaycaster)vehicleRayCaster);
            this.dynamicsWorld.addVehicle(this.vehicle);
            this.vehicle.setCoordinateSystem(0, 1, 2);
            float rollInfluence = 0.0f;
            float suspensionStiffness = 0.0f;
            float suspensionDamping = 0.0f;
            float suspensionCompression = 0.0f;
            float suspensionRestLength = 0.0f;
            URL url = this.getClass().getResource(RCM_Main.propertiesFilePath + this.fileName);
            InputStream inputstream = url.openStream();
            BufferedReader reader = new BufferedReader(new InputStreamReader(inputstream));
            while ((line = reader.readLine()) != null) {
                if (line.startsWith("Roll_influence: ")) {
                    rollInfluence = Float.valueOf(line.split(" ")[1]).floatValue();
                    continue;
                }
                if (line.startsWith("Suspension_stiffness: ")) {
                    suspensionStiffness = Float.valueOf(line.split(" ")[1]).floatValue();
                    continue;
                }
                if (line.startsWith("Suspension_damping: ")) {
                    suspensionDamping = Float.valueOf(line.split(" ")[1]).floatValue();
                    continue;
                }
                if (line.startsWith("Suspension_compression: ")) {
                    suspensionCompression = Float.valueOf(line.split(" ")[1]).floatValue();
                    continue;
                }
                if (!line.startsWith("Suspension_rest_length: ")) continue;
                suspensionRestLength = Float.valueOf(line.split(" ")[1]).floatValue();
                break;
            }
            reader.close();
            Vector3f wheelDirection = null;
            Vector3f wheelAxle = null;
            Vector3f connectionPoint = null;
            float radius = 0.0f;
            float frictionSlip = 0.0f;
            float brakeForce = 0.0f;
            boolean canTurn = false;
            for (int i = 1; i <= this.numWheels; ++i) {
                url = this.getClass().getResource(RCM_Main.propertiesFilePath + this.fileName);
                inputstream = url.openStream();
                reader = new BufferedReader(new InputStreamReader(inputstream));
                while ((line = reader.readLine()) != null) {
                    float z;
                    float y;
                    float x;
                    if (line.startsWith("Wheel_direction_" + i + ": ")) {
                        x = Float.valueOf(line.split(" ")[1]).floatValue();
                        y = Float.valueOf(line.split(" ")[2]).floatValue();
                        z = Float.valueOf(line.split(" ")[3]).floatValue();
                        wheelDirection = new Vector3f(x, y, z);
                        continue;
                    }
                    if (line.startsWith("Wheel_axle_" + i + ": ")) {
                        x = Float.valueOf(line.split(" ")[1]).floatValue();
                        y = Float.valueOf(line.split(" ")[2]).floatValue();
                        z = Float.valueOf(line.split(" ")[3]).floatValue();
                        wheelAxle = new Vector3f(x, y, z);
                        continue;
                    }
                    if (line.startsWith("Wheel_position_" + i + ": ")) {
                        x = Float.valueOf(line.split(" ")[1]).floatValue();
                        y = Float.valueOf(line.split(" ")[2]).floatValue();
                        z = Float.valueOf(line.split(" ")[3]).floatValue();
                        connectionPoint = new Vector3f(x, y, z);
                        continue;
                    }
                    if (line.startsWith("Wheel_radius_" + i + ": ")) {
                        radius = Float.valueOf(line.split(" ")[1]).floatValue();
                        continue;
                    }
                    if (line.startsWith("Wheel_steerable_" + i + ": ")) {
                        canTurn = Boolean.valueOf(line.split(" ")[1]);
                        continue;
                    }
                    if (line.startsWith("Wheel_friction_" + i + ": ")) {
                        frictionSlip = Float.valueOf(line.split(" ")[1]).floatValue();
                        continue;
                    }
                    if (!line.startsWith("Wheel_brake_" + i + ": ")) continue;
                    brakeForce = Float.valueOf(line.split(" ")[1]).floatValue();
                    break;
                }
                this.vehicle.addWheel(connectionPoint, wheelDirection, wheelAxle, suspensionRestLength, radius, tuning, canTurn);
                WheelInfo wheel = this.vehicle.getWheelInfo(i - 1);
                wheel.suspensionStiffness = suspensionStiffness;
                wheel.wheelsDampingRelaxation = suspensionDamping;
                wheel.wheelsDampingCompression = suspensionCompression;
                wheel.rollInfluence = rollInfluence;
                wheel.frictionSlip = frictionSlip;
                wheel.brake = brakeForce;
                reader.close();
            }
        }
    }

    public void loadWings() throws FileNotFoundException, IOException {
        if (this.numWings > 0) {
            boolean fSpan = false;
            boolean fLift = false;
            Quat4f rotation = null;
            Vector3f postion = null;
            float root = 0.0f;
            float span = 0.0f;
            float aspectRatio = 0.0f;
            float taperRatio = 0.0f;
            float stallAngle = 0.0f;
            float liftGradient = 0.0f;
            float liftOffset = 0.0f;
            URL url = null;
            InputStream inputstream = null;
            BufferedReader reader = null;
            for (int i = 1; i <= this.numWings; ++i) {
                String line;
                url = this.getClass().getResource(RCM_Main.propertiesFilePath + this.fileName);
                inputstream = url.openStream();
                reader = new BufferedReader(new InputStreamReader(inputstream));
                while ((line = reader.readLine()) != null) {
                    float z;
                    float y;
                    float x;
                    if (line.startsWith("Wing_flip_span_" + i + ": ")) {
                        fSpan = Boolean.valueOf(line.split(" ")[1]);
                        continue;
                    }
                    if (line.startsWith("Wing_flip_lift_" + i + ": ")) {
                        fLift = Boolean.valueOf(line.split(" ")[1]);
                        continue;
                    }
                    if (line.startsWith("Wing_rotation_" + i + ": ")) {
                        x = Float.valueOf(line.split(" ")[1]).floatValue();
                        y = Float.valueOf(line.split(" ")[2]).floatValue();
                        z = Float.valueOf(line.split(" ")[3]).floatValue();
                        float w = Float.valueOf(line.split(" ")[4]).floatValue();
                        rotation = new Quat4f(x, y, z, w);
                        continue;
                    }
                    if (line.startsWith("Wing_position_" + i + ": ")) {
                        x = Float.valueOf(line.split(" ")[1]).floatValue();
                        y = Float.valueOf(line.split(" ")[2]).floatValue();
                        z = Float.valueOf(line.split(" ")[3]).floatValue();
                        postion = new Vector3f(x, y, z);
                        continue;
                    }
                    if (line.startsWith("Wing_root_" + i + ": ")) {
                        root = Float.valueOf(line.split(" ")[1]).floatValue();
                        continue;
                    }
                    if (line.startsWith("Wing_span_" + i + ": ")) {
                        span = Float.valueOf(line.split(" ")[1]).floatValue();
                        continue;
                    }
                    if (line.startsWith("Wing_aspect_ratio_" + i + ": ")) {
                        aspectRatio = Float.valueOf(line.split(" ")[1]).floatValue();
                        continue;
                    }
                    if (line.startsWith("Wing_taper_ratio_" + i + ": ")) {
                        taperRatio = Float.valueOf(line.split(" ")[1]).floatValue();
                        continue;
                    }
                    if (line.startsWith("Wing_stall_angle_" + i + ": ")) {
                        stallAngle = Float.valueOf(line.split(" ")[1]).floatValue();
                        continue;
                    }
                    if (line.startsWith("Wing_lift_gradient_" + i + ": ")) {
                        liftGradient = Float.valueOf(line.split(" ")[1]).floatValue();
                        continue;
                    }
                    if (!line.startsWith("Wing_lift_offset_" + i + ": ")) continue;
                    liftOffset = Float.valueOf(line.split(" ")[1]).floatValue();
                    break;
                }
                this.wings.add(new WingHandler(fSpan, fLift, rotation, postion, root, span, aspectRatio, taperRatio, stallAngle, liftGradient, liftOffset, false));
                reader.close();
            }
        }
    }

    public void removeCollisionShapes() {
        for (RigidBody colBox : this.collisionBodies) {
            this.dynamicsWorld.removeRigidBody(colBox);
        }
        this.collisionBodies.removeAll(this.collisionBodies);
    }

    public void loadCollisionShapes(World world, Vector3f linearMotion, Vector3f position, Entity entity) {
        boolean flag = false;
        float sweptSphereRadius = 2.0f;
        AxisAlignedBB boundingBox = AxisAlignedBB.func_72330_a((double)(position.x - sweptSphereRadius), (double)(position.y - sweptSphereRadius), (double)(position.z - sweptSphereRadius), (double)(position.x + linearMotion.x * 0.05f + sweptSphereRadius), (double)(position.y + linearMotion.y * 0.05f + sweptSphereRadius), (double)(position.z + linearMotion.z * 0.05f + sweptSphereRadius));
        if (world.func_72945_a(entity, boundingBox).size() > 0) {
            for (Object obj : world.func_72945_a(entity, boundingBox)) {
                AxisAlignedBB boxAABB = (AxisAlignedBB)obj;
                Vector3f newBoxPos = new Vector3f(((float)boxAABB.field_72336_d + (float)boxAABB.field_72340_a) / 2.0f, ((float)boxAABB.field_72337_e + (float)boxAABB.field_72338_b) / 2.0f, ((float)boxAABB.field_72334_f + (float)boxAABB.field_72339_c) / 2.0f);
                for (RigidBody collisionBox : this.collisionBodies) {
                    Vector3f boxPosition = collisionBox.getMotionState().getWorldTransform((Transform)new Transform()).origin;
                    if (boxPosition.x != newBoxPos.x || boxPosition.y != newBoxPos.y || boxPosition.z != newBoxPos.z) continue;
                    flag = true;
                }
                if (!flag) {
                    Vector3f boxSize = new Vector3f(((float)boxAABB.field_72336_d - (float)boxAABB.field_72340_a) / 2.0f, ((float)boxAABB.field_72337_e - (float)boxAABB.field_72338_b) / 2.0f, ((float)boxAABB.field_72334_f - (float)boxAABB.field_72339_c) / 2.0f);
                    BoxShape groundBlock = new BoxShape(boxSize);
                    Transform startTransform = new Transform();
                    startTransform.setIdentity();
                    startTransform.origin.set((Tuple3f)newBoxPos);
                    DefaultMotionState groundMotionState = new DefaultMotionState(startTransform);
                    RigidBodyConstructionInfo groundBodyConstructionInfo = new RigidBodyConstructionInfo(0.0f, (MotionState)groundMotionState, (CollisionShape)groundBlock, new Vector3f(0.0f, 0.0f, 0.0f));
                    RigidBody groundRigidBody = new RigidBody(groundBodyConstructionInfo);
                    this.dynamicsWorld.addRigidBody(groundRigidBody);
                    this.collisionBodies.add(groundRigidBody);
                }
                flag = false;
            }
        }
    }

    public void unloadCollisionShapes(World world, Vector3f linearMotion, Vector3f position, Entity entity) {
        Vector3f dist = new Vector3f();
        HashSet<RigidBody> toRemoveColBox = new HashSet<RigidBody>();
        for (RigidBody collisionBox : this.collisionBodies) {
            Vector3f boxPosition = collisionBox.getMotionState().getWorldTransform((Transform)new Transform()).origin;
            dist.sub((Tuple3f)position, (Tuple3f)boxPosition);
            if (!(dist.length() > 10.0f)) continue;
            toRemoveColBox.add(collisionBox);
        }
        for (RigidBody colBox : toRemoveColBox) {
            this.dynamicsWorld.removeRigidBody(colBox);
            this.collisionBodies.remove(colBox);
        }
        toRemoveColBox.removeAll(toRemoveColBox);
        float sweptSphereRadius = 2.0f;
        AxisAlignedBB boundingBox = AxisAlignedBB.func_72330_a((double)(position.x - sweptSphereRadius), (double)(position.y - sweptSphereRadius), (double)(position.z - sweptSphereRadius), (double)(position.x + linearMotion.x * 0.05f + sweptSphereRadius), (double)(position.y + linearMotion.y * 0.05f + sweptSphereRadius), (double)(position.z + linearMotion.z * 0.05f + sweptSphereRadius));
        for (RigidBody collisionBox : this.collisionBodies) {
            boolean flag = false;
            Vector3f boxPosition = collisionBox.getMotionState().getWorldTransform((Transform)new Transform()).origin;
            if (world.func_72945_a(entity, boundingBox).size() > 0) {
                for (Object obj : world.func_72945_a(entity, boundingBox)) {
                    AxisAlignedBB boxAABB = (AxisAlignedBB)obj;
                    Vector3f newBoxPos = new Vector3f(((float)boxAABB.field_72336_d + (float)boxAABB.field_72340_a) / 2.0f, ((float)boxAABB.field_72337_e + (float)boxAABB.field_72338_b) / 2.0f, ((float)boxAABB.field_72334_f + (float)boxAABB.field_72339_c) / 2.0f);
                    if (boxPosition.x != newBoxPos.x || boxPosition.y != newBoxPos.y || boxPosition.z != newBoxPos.z) continue;
                    flag = true;
                }
            }
            if (flag) continue;
            toRemoveColBox.add(collisionBox);
        }
        for (RigidBody colBox : toRemoveColBox) {
            this.dynamicsWorld.removeRigidBody(colBox);
            this.collisionBodies.remove(colBox);
        }
    }
}

