/*
 * Decompiled with CFR 0.152.
 */
package de.pitman87.TF2Sentry.common;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.event.FMLServerStartedEvent;
import cpw.mods.fml.common.network.FMLEventChannel;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.registry.EntityRegistry;
import cpw.mods.fml.common.registry.GameRegistry;
import de.pitman87.TF2Sentry.common.CommonProxy;
import de.pitman87.TF2Sentry.common.PlayerTracker;
import de.pitman87.TF2Sentry.common.ServerPacketHandler;
import de.pitman87.TF2Sentry.common.entity.EntityTF2Bullet;
import de.pitman87.TF2Sentry.common.entity.EntityTF2Rocket;
import de.pitman87.TF2Sentry.common.entity.EntityTF2Sentry;
import de.pitman87.TF2Sentry.common.entity.EntityTF2Sentry2;
import de.pitman87.TF2Sentry.common.entity.EntityTF2Sentry3;
import de.pitman87.TF2Sentry.common.item.ItemTF2Monitor;
import de.pitman87.TF2Sentry.common.item.ItemTF2Sentry;
import de.pitman87.TF2Sentry.common.item.ItemTF2SentryPiece;
import de.pitman87.TF2Sentry.common.item.ItemTF2Wrench;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.Properties;
import java.util.Set;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.server.MinecraftServer;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import org.apache.logging.log4j.Level;

@Mod(modid="TF2Sentry", name="TF2 Sentry", version="1.7.2b")
public class TF2SentryMod {
    @SidedProxy(clientSide="de.pitman87.TF2Sentry.client.ClientProxy", serverSide="de.pitman87.TF2Sentry.common.CommonProxy")
    public static CommonProxy proxy;
    public static FMLEventChannel channel;
    public static String channelName;
    public static float shootVolume;
    public static float spotVolume;
    public static float explosionVolume;
    public static float upgradeVolume;
    public static boolean opsOnly;
    public static boolean infiniteAmmo;
    public static int range1;
    public static int range2;
    public static int range3;
    public static int rangeUpDown1;
    public static int rangeUpDown2;
    public static int rangeUpDown3;
    public static Item sentryRed;
    public static Item sentryBlue;
    public static Item sentryBase;
    public static Item sentryHead;
    public static Item monitor;
    public static Item wrench;
    public static Item wrenchGolden;
    public static boolean hdTextures;
    public static boolean teamsEnabled;
    public static boolean checkForUpdates;

    public static String getVersion() {
        return "1.7.2b";
    }

    public static String getModName() {
        return "TF2Sentry";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        proxy.preInit();
        Configuration configuration = new Configuration(event.getSuggestedConfigurationFile());
        try {
            configuration.load();
            Property prop = configuration.get("general", "shootVolume", "0.2");
            prop.comment = "min: 0.0\tmax 1.0";
            shootVolume = Float.valueOf(prop.getString()).floatValue();
            prop = configuration.get("general", "spotVolume", "0.2");
            prop.comment = "min: 0.0\tmax 1.0";
            spotVolume = Float.valueOf(prop.getString()).floatValue();
            prop = configuration.get("general", "explosionVolume", "0.5");
            prop.comment = "min: 0.0\tmax 1.0";
            explosionVolume = Float.valueOf(prop.getString()).floatValue();
            prop = configuration.get("general", "upgradeVolume", "0.3");
            prop.comment = "min: 0.0\tmax 1.0";
            upgradeVolume = Float.valueOf(prop.getString()).floatValue();
            prop = configuration.get("general", "opsOnly", false);
            prop.comment = "Set to true, if only OPs are allowed to change the targets!";
            opsOnly = prop.getBoolean(false);
            prop = configuration.get("general", "infiniteAmmo", false);
            prop.comment = "Set to true, if the sentry should have infite ammo!";
            infiniteAmmo = prop.getBoolean(false);
            prop = configuration.get("general", "range1", 15);
            prop.comment = "The detectingrange of sentry upgrade 1, higher range could cause laggs and crashes!";
            range1 = prop.getInt(15);
            prop = configuration.get("general", "range2", 20);
            prop.comment = "The detectingrange of sentry upgrade 2, higher range could cause laggs and crashes!";
            range2 = prop.getInt(20);
            prop = configuration.get("general", "range3", 25);
            prop.comment = "The detectingrange of sentry upgrade 3, higher range could cause laggs and crashes!";
            range3 = prop.getInt(25);
            prop = configuration.get("general", "rangeUpDown1", 7);
            prop.comment = "The up and down detectingrange of sentry upgrade 1, higher range could cause laggs and crashes!";
            rangeUpDown1 = prop.getInt(7);
            prop = configuration.get("general", "rangeUpDown2", 7);
            prop.comment = "The up and down detectingrange of sentry upgrade 2, higher range could cause laggs and crashes!";
            rangeUpDown2 = prop.getInt(7);
            prop = configuration.get("general", "rangeUpDown3", 7);
            prop.comment = "The up and down detectingrange of sentry upgrade 3, higher range could cause laggs and crashes!";
            rangeUpDown3 = prop.getInt(7);
            prop = configuration.get("general", "HDTextures", false);
            prop.comment = "set to true, if you want HD textures";
            hdTextures = prop.getBoolean(false);
            prop = configuration.get("general", "checkForUpdates", true);
            prop.comment = "set to false, to turn off updatechecker";
            checkForUpdates = prop.getBoolean(true);
        }
        catch (Exception e) {
            FMLLog.log((Level)Level.ERROR, (Throwable)e, (String)"TF2 Sentry has a problem loading it's configuration", (Object[])new Object[0]);
            FMLLog.severe((String)e.getMessage(), (Object[])new Object[0]);
        }
        finally {
            configuration.save();
        }
        sentryRed = new ItemTF2Sentry().func_77655_b("TF2SentryRed");
        sentryBlue = new ItemTF2Sentry().func_77655_b("TF2SentryBlu");
        sentryBase = new ItemTF2SentryPiece().func_77655_b("SentryBase");
        sentryHead = new ItemTF2SentryPiece().func_77655_b("SentryHead");
        monitor = new ItemTF2Monitor().func_77655_b("SentryMonitor");
        wrench = new ItemTF2Wrench(100).func_77655_b("Wrench");
        wrenchGolden = new ItemTF2Wrench(200).func_77655_b("GoldenWrench");
        GameRegistry.registerItem((Item)sentryRed, (String)"TF2SentryRed");
        GameRegistry.registerItem((Item)sentryBlue, (String)"TF2SentryBlu");
        GameRegistry.registerItem((Item)sentryBase, (String)"SentryBase");
        GameRegistry.registerItem((Item)sentryHead, (String)"SentryHead");
        GameRegistry.registerItem((Item)monitor, (String)"SentryMonitor");
        GameRegistry.registerItem((Item)wrench, (String)"Wrench");
        GameRegistry.registerItem((Item)wrenchGolden, (String)"GoldenWrench");
    }

    @Mod.EventHandler
    public void load(FMLInitializationEvent evt) {
        channel = NetworkRegistry.INSTANCE.newEventDrivenChannel(channelName);
        channel.register((Object)new ServerPacketHandler());
        EntityRegistry.registerModEntity(EntityTF2Bullet.class, (String)"TF2Bullet", (int)0, (Object)this, (int)160, (int)5, (boolean)true);
        EntityRegistry.registerModEntity(EntityTF2Rocket.class, (String)"TF2Rocket", (int)1, (Object)this, (int)160, (int)5, (boolean)true);
        EntityRegistry.registerModEntity(EntityTF2Sentry.class, (String)"TF2Sentry 1", (int)2, (Object)this, (int)160, (int)5, (boolean)true);
        EntityRegistry.registerModEntity(EntityTF2Sentry2.class, (String)"TF2Sentry 2", (int)3, (Object)this, (int)160, (int)5, (boolean)true);
        EntityRegistry.registerModEntity(EntityTF2Sentry3.class, (String)"TF2Sentry 3", (int)4, (Object)this, (int)160, (int)5, (boolean)true);
        proxy.load();
        proxy.registerRenderStuff();
        FMLCommonHandler.instance().bus().register((Object)new PlayerTracker());
        GameRegistry.addRecipe((ItemStack)new ItemStack(sentryBase, 1), (Object[])new Object[]{" X ", " X ", "X X", Character.valueOf('X'), Items.field_151042_j});
        GameRegistry.addRecipe((ItemStack)new ItemStack(sentryHead, 1), (Object[])new Object[]{"XYX", "O#O", "XYX", Character.valueOf('X'), Items.field_151042_j, Character.valueOf('Y'), Items.field_151137_ax, Character.valueOf('O'), Items.field_151016_H, Character.valueOf('#'), Blocks.field_150367_z});
        GameRegistry.addRecipe((ItemStack)new ItemStack(sentryRed, 1), (Object[])new Object[]{"#", "X", "Y", Character.valueOf('X'), sentryHead, Character.valueOf('Y'), sentryBase, Character.valueOf('#'), new ItemStack(Items.field_151100_aR, 1, 1)});
        GameRegistry.addRecipe((ItemStack)new ItemStack(sentryBlue, 1), (Object[])new Object[]{"#", "X", "Y", Character.valueOf('X'), sentryHead, Character.valueOf('Y'), sentryBase, Character.valueOf('#'), new ItemStack(Items.field_151100_aR, 1, 4)});
        GameRegistry.addRecipe((ItemStack)new ItemStack(monitor, 1), (Object[])new Object[]{"XYX", "X#X", "X#X", Character.valueOf('X'), Items.field_151137_ax, Character.valueOf('Y'), Blocks.field_150359_w, Character.valueOf('#'), Blocks.field_150430_aB});
        GameRegistry.addRecipe((ItemStack)new ItemStack(wrench, 1), (Object[])new Object[]{"X  ", "XX ", "  X", Character.valueOf('X'), Items.field_151042_j});
        GameRegistry.addRecipe((ItemStack)new ItemStack(wrenchGolden, 1), (Object[])new Object[]{"X  ", "XX ", "  X", Character.valueOf('X'), Items.field_151043_k});
        GameRegistry.addRecipe((ItemStack)new ItemStack(sentryRed, 1), (Object[])new Object[]{"X", "Y", Character.valueOf('Y'), sentryBlue, Character.valueOf('X'), new ItemStack(Items.field_151100_aR, 1, 1)});
        GameRegistry.addRecipe((ItemStack)new ItemStack(sentryBlue, 1), (Object[])new Object[]{"X", "Y", Character.valueOf('Y'), sentryRed, Character.valueOf('X'), new ItemStack(Items.field_151100_aR, 1, 4)});
    }

    @Mod.EventHandler
    public void modsLoaded(FMLPostInitializationEvent evt) {
    }

    @Mod.EventHandler
    public void serverStarted(FMLServerStartedEvent event) {
        TF2SentryMod.readTargetList();
    }

    public static void readTargetList() {
        try {
            Properties p = new Properties();
            String loca = TF2SentryMod.getPath();
            p.load(new FileInputStream(loca));
            Set<Object> set = p.keySet();
            for (String string : set) {
                if (!p.get(string).equals("true")) continue;
                ServerPacketHandler.targetsServer.add(string);
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            TF2SentryMod.createTargetList();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static void writeTargetList() {
        Properties p = new Properties();
        String loca = TF2SentryMod.getPath();
        try {
            ArrayList<String> mobs = ServerPacketHandler.targetsServer;
            for (String s : mobs) {
                p.setProperty(s, "true");
            }
            p.store(new FileOutputStream(loca), "TF2 Sentry Targetlist");
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static void createTargetList() {
        Properties properties = new Properties();
        File file = new File(TF2SentryMod.getPath());
        try {
            if (!file.exists()) {
                file.createNewFile();
            }
            if (file.canWrite()) {
                properties.setProperty("Creeper", "true");
                properties.setProperty("Skeleton", "true");
                properties.setProperty("Spider", "true");
                properties.setProperty("Giant", "true");
                properties.setProperty("Zombie", "true");
                properties.setProperty("Slime", "true");
                properties.setProperty("Ghast", "true");
                properties.setProperty("PigZombie", "true");
                properties.store(new FileOutputStream(file), "TF2 Sentry Targetlist");
            }
            TF2SentryMod.readTargetList();
        }
        catch (Exception ex) {
            System.out.println("Could not create TF2SentryTargetlist.cfg");
            ex.printStackTrace();
        }
    }

    private static String getPath() {
        MinecraftServer ms = MinecraftServer.func_71276_C();
        String s = "" + ms.func_71209_f("/TF2SentryTargetlist.txt");
        return s;
    }

    static {
        channelName = "TF2SentryMod";
        shootVolume = 0.2f;
        spotVolume = 0.2f;
        explosionVolume = 0.5f;
        upgradeVolume = 0.3f;
        opsOnly = false;
        infiniteAmmo = false;
        range1 = 15;
        range2 = 20;
        range3 = 25;
        rangeUpDown1 = 7;
        rangeUpDown2 = 7;
        rangeUpDown3 = 7;
        teamsEnabled = false;
        checkForUpdates = false;
    }
}

