/*
 * Decompiled with CFR 0.152.
 */
package tuhljin.automagy.blocks;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.particle.EffectRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import thaumcraft.common.items.wands.ItemWandCasting;
import tuhljin.automagy.blocks.ModBlockSpecialRender;
import tuhljin.automagy.lib.NeighborNotifier;
import tuhljin.automagy.lib.RedstoneCalc;
import tuhljin.automagy.lib.ThaumcraftExtension;
import tuhljin.automagy.lib.TjUtil;
import tuhljin.automagy.tiles.TileEntityHourglass;

public class BlockHourglass
extends ModBlockSpecialRender {
    public static final int TIMER_MINIMUM = 5;
    public static final int TIMER_MAXIMUM = 60;
    public static final int TIMER_INCREMENTS = 5;

    protected BlockHourglass(String name, Material material) {
        super(name, material);
        this.func_149711_c(1.0f);
        this.func_149676_a(0.35f, 0.0f, 0.35f, 0.65f, 0.4f, 0.65f);
    }

    public BlockHourglass(String name) {
        this(name, Material.field_151575_d);
        this.func_149672_a(Block.field_149766_f);
        this.func_149658_d("glass");
    }

    public TileEntity func_149915_a(World var1, int var2) {
        return new TileEntityHourglass();
    }

    @SideOnly(value=Side.CLIENT)
    public boolean addHitEffects(World world, MovingObjectPosition target, EffectRenderer er) {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean addDestroyEffects(World world, int x, int y, int z, int meta, EffectRenderer er) {
        return world.func_147439_a(x, y, z) instanceof BlockHourglass;
    }

    public boolean func_149742_c(World world, int x, int y, int z) {
        return this.func_149718_j(world, x, y, z) && super.func_149742_c(world, x, y, z);
    }

    public void func_149689_a(World world, int x, int y, int z, EntityLivingBase entity, ItemStack stack) {
        int l = MathHelper.func_76128_c((double)((double)(entity.field_70177_z * 4.0f / 360.0f) + 2.5)) & 3;
        world.func_72921_c(x, y, z, l, 2);
    }

    public boolean func_149718_j(World world, int x, int y, int z) {
        Block block;
        return World.func_147466_a((IBlockAccess)world, (int)x, (int)(y - 1), (int)z) || (block = world.func_147439_a(x, y - 1, z)) == Blocks.field_150426_aN || block == Blocks.field_150359_w || ThaumcraftExtension.blockIsPedestal(block, world.func_72805_g(x, y - 1, z), false);
    }

    public void func_149695_a(World world, int x, int y, int z, Block block) {
        if (!this.func_149718_j(world, x, y, z)) {
            this.func_149697_b(world, x, y, z, 0, 0);
            world.func_147468_f(x, y, z);
        } else if (!world.field_72995_K) {
            TileEntityHourglass te = null;
            try {
                te = (TileEntityHourglass)world.func_147438_o(x, y, z);
            }
            catch (Exception ex) {
                // empty catch block
            }
            if (te != null) {
                RedstoneCalc.PowerResult result = RedstoneCalc.getRedstonePowerAt(world, x, y, z, this.getRedstoneInputDirections((IBlockAccess)world, x, y, z));
                if (te.receivingSignal) {
                    if (result == null) {
                        te.receivingSignal = false;
                    }
                } else if (result != null) {
                    te.receivingSignal = true;
                    te.startFlipOnServer();
                }
            }
        }
    }

    public void func_149749_a(World world, int x, int y, int z, Block block, int p_149749_6_) {
        NeighborNotifier.notifyBlocksOfExtendedNeighborChange(world, x, y, z, (Block)this);
        super.func_149749_a(world, x, y, z, block, p_149749_6_);
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int side, float hitX, float hitY, float hitZ) {
        if (!world.field_72995_K) {
            Item equippedItem;
            TileEntityHourglass te = null;
            try {
                te = (TileEntityHourglass)world.func_147438_o(x, y, z);
            }
            catch (Exception ex) {
                // empty catch block
            }
            if (te == null) {
                return true;
            }
            ItemStack stack = player.func_71045_bC();
            if (stack != null && ((equippedItem = stack.func_77973_b()) == Items.field_151055_y || equippedItem instanceof ItemWandCasting)) {
                int target = te.getTargetTimeSeconds();
                if ((target += 5) > 60) {
                    target = 5;
                }
                te.setTargetTimeSeconds(target);
                TjUtil.sendFormattedChatToPlayer(player, "Automagy.chat.hourglass.setTimer", target);
                world.func_72956_a((Entity)player, "thaumcraft:key", 1.0f, 1.0f);
                return true;
            }
            if (te.startFlipOnServer()) {
                world.func_72908_a((double)x + 0.5, (double)y + 0.5, (double)z + 0.5, "thaumcraft:cameraclack", 1.0f, 1.0f);
            }
        }
        return true;
    }

    public int func_149709_b(IBlockAccess blockaccess, int x, int y, int z, int side) {
        int orientation = blockaccess.func_72805_g(x, y, z);
        if (side == 2 || side == 3 ? orientation == 0 || orientation == 2 : !(side != 4 && side != 5 || orientation != 1 && orientation != 3)) {
            return 0;
        }
        TileEntityHourglass te = null;
        try {
            te = (TileEntityHourglass)blockaccess.func_147438_o(x, y, z);
        }
        catch (Exception ex) {
            // empty catch block
        }
        if (te == null) {
            return 0;
        }
        return te.getRedstoneSignalStrength();
    }

    public boolean func_149744_f() {
        return true;
    }

    public ForgeDirection[] getRedstoneInputDirections(IBlockAccess blockaccess, int x, int y, int z) {
        int orientation = blockaccess.func_72805_g(x, y, z);
        if (orientation == 0 || orientation == 2) {
            return new ForgeDirection[]{ForgeDirection.NORTH, ForgeDirection.SOUTH, ForgeDirection.DOWN, ForgeDirection.UP};
        }
        return new ForgeDirection[]{ForgeDirection.EAST, ForgeDirection.WEST, ForgeDirection.DOWN, ForgeDirection.UP};
    }

    public boolean func_149740_M() {
        return true;
    }

    public int func_149736_g(World world, int x, int y, int z, int side) {
        TileEntityHourglass te = null;
        try {
            te = (TileEntityHourglass)world.func_147438_o(x, y, z);
        }
        catch (Exception ex) {
            // empty catch block
        }
        if (te == null) {
            return 0;
        }
        return te.getComparatorSignalStrength();
    }
}

