/*
 * Decompiled with CFR 0.152.
 */
package tuhljin.automagy.blocks;

import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.particle.EffectRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import tuhljin.automagy.blocks.ItemBlockRedcrystal;
import tuhljin.automagy.blocks.ModBlockSpecialRender;
import tuhljin.automagy.codechicken.lib.vec.BlockCoord;
import tuhljin.automagy.lib.IOrientableRedstoneConductor;
import tuhljin.automagy.lib.IRedcrystalPowerConductor;
import tuhljin.automagy.lib.RedstoneCalc;
import tuhljin.automagy.lib.ThaumcraftExtension;
import tuhljin.automagy.lib.TjUtil;
import tuhljin.automagy.lib.struct.BlockWithPos;
import tuhljin.automagy.tiles.TileEntityRedcrystal;

public class BlockRedcrystal
extends ModBlockSpecialRender
implements IOrientableRedstoneConductor,
IRedcrystalPowerConductor {
    protected final boolean CONNECT_REDSTONE_REL_TOP = false;
    protected static final int MAX_POWER = 15;
    private boolean simplePowerCheck = true;
    protected static boolean resettingPowerLevels = false;
    private HashSet<BlockCoord> newPrimaryPowerInputLocations = new HashSet();
    private HashMap<Integer, LinkedHashSet<BlockCoord>> queuedBlockUpdateLocations = new HashMap();
    private Field redstonedustAllowingPowerCheck;
    public int nextTEOrientation = -1;
    public boolean nextTENoConnections = false;

    public BlockRedcrystal(String name) {
        super(name, Material.field_151594_q, ItemBlockRedcrystal.class);
        this.func_149711_c(0.1f);
        this.func_149672_a(Block.field_149769_e);
        this.func_149649_H();
        this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 0.3f, 1.0f);
        try {
            this.redstonedustAllowingPowerCheck = Blocks.field_150488_af.getClass().getDeclaredField("field_150181_a");
            this.redstonedustAllowingPowerCheck.setAccessible(true);
        }
        catch (Exception ex) {
            FMLLog.severe((String)"[Automagy] Failed to access redstone dust's signal-checking field. Improper signal strengths may result when redstone wire is placed next to redcrystal.", (Object[])new Object[0]);
        }
    }

    public TileEntity func_149915_a(World var1, int var2) {
        TileEntityRedcrystal te = new TileEntityRedcrystal((short)this.nextTEOrientation, this.nextTENoConnections);
        this.nextTEOrientation = -1;
        this.nextTENoConnections = false;
        return te;
    }

    @Override
    public int func_149645_b() {
        return -1;
    }

    @Override
    public boolean func_149662_c() {
        return false;
    }

    @Override
    public boolean func_149686_d() {
        return false;
    }

    public void func_149726_b(World world, int x, int y, int z) {
        super.func_149726_b(world, x, y, z);
        this.updateAndPropagateChanges(world, x, y, z, true, false, false, false);
    }

    public void func_149749_a(World world, int x, int y, int z, Block block, int p_149749_6_) {
        super.func_149749_a(world, x, y, z, block, p_149749_6_);
        this.updateAndPropagateChanges(world, x, y, z, false, false, true, true);
    }

    public AxisAlignedBB func_149668_a(World p_149668_1_, int p_149668_2_, int p_149668_3_, int p_149668_4_) {
        return null;
    }

    public boolean func_149742_c(World world, int x, int y, int z) {
        int side = this.getOrientation((IBlockAccess)world, x, y, z);
        return this.func_149707_d(world, x, y, z, side);
    }

    public boolean func_149707_d(World world, int x, int y, int z, int side) {
        boolean ok;
        ForgeDirection dir = ForgeDirection.getOrientation((int)side);
        boolean bl = ok = dir == ForgeDirection.DOWN && world.isSideSolid(x, y + 1, z, ForgeDirection.DOWN) || dir == ForgeDirection.UP && world.isSideSolid(x, y - 1, z, ForgeDirection.UP) || dir == ForgeDirection.NORTH && world.isSideSolid(x, y, z + 1, ForgeDirection.NORTH) || dir == ForgeDirection.SOUTH && world.isSideSolid(x, y, z - 1, ForgeDirection.SOUTH) || dir == ForgeDirection.WEST && world.isSideSolid(x + 1, y, z, ForgeDirection.WEST) || dir == ForgeDirection.EAST && world.isSideSolid(x - 1, y, z, ForgeDirection.EAST);
        if (!ok && world.func_147439_a(x - dir.offsetX, y - dir.offsetY, z - dir.offsetZ) == Blocks.field_150426_aN) {
            return true;
        }
        return ok;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149734_b(World world, int x, int y, int z, Random rand) {
        int strength = world.func_72805_g(x, y, z);
        if (strength > 0) {
            double d0 = (double)x + 0.5 + ((double)rand.nextFloat() - 0.5) * 0.2;
            double d1 = (float)y + 0.1625f;
            double d2 = (double)z + 0.5 + ((double)rand.nextFloat() - 0.5) * 0.2;
            float f = (float)strength / 15.0f;
            float f1 = f * 0.6f + 0.4f;
            if (strength == 0) {
                f1 = 0.0f;
            }
            float f2 = f * f * 0.7f - 0.5f;
            float f3 = f * f * 0.6f - 0.7f;
            if (f2 < 0.0f) {
                f2 = 0.0f;
            }
            if (f3 < 0.0f) {
                f3 = 0.0f;
            }
            int orientation = this.getOrientation((IBlockAccess)world, x, y, z);
            switch (orientation) {
                case 0: {
                    d1 += 0.6;
                    break;
                }
                default: {
                    break;
                }
                case 2: {
                    d1 += 0.28;
                    d2 += 0.3;
                    break;
                }
                case 3: {
                    d1 += 0.28;
                    d2 -= 0.3;
                    break;
                }
                case 4: {
                    d0 += 0.3;
                    d1 += 0.28;
                    break;
                }
                case 5: {
                    d0 -= 0.3;
                    d1 += 0.28;
                }
            }
            world.func_72869_a("reddust", d0, d1, d2, (double)f1, (double)f2, (double)f3);
        }
    }

    public void func_149695_a(World world, int x, int y, int z, Block block) {
        if (!world.field_72995_K) {
            int side = this.getOrientation((IBlockAccess)world, x, y, z);
            if (side != -1) {
                if (this.func_149707_d(world, x, y, z, side)) {
                    if (!(block instanceof IRedcrystalPowerConductor)) {
                        this.updateAndPropagateChanges(world, x, y, z, true, false, false, false);
                    }
                } else {
                    this.func_149697_b(world, x, y, z, 0, 0);
                    world.func_147468_f(x, y, z);
                }
            }
            super.func_149695_a(world, x, y, z, block);
        }
    }

    public void updateAndPropagateChanges(World world, int x, int y, int z, boolean checkStrength, boolean calledByNeighborWire, boolean forcePropagate, boolean immediateNeighborUpdates) {
        if (!world.field_72995_K) {
            boolean notifyChain = false;
            boolean needClientUpdate = false;
            boolean needNotifyNeighbors = false;
            int strength = -1;
            TileEntityRedcrystal te = null;
            if (checkStrength) {
                te = (TileEntityRedcrystal)world.func_147438_o(x, y, z);
                if (te == null) {
                    return;
                }
                short orientation = te.orientation;
                if (orientation != -1) {
                    int sourceSide;
                    this.simplePowerCheck = false;
                    RedstoneCalc.PowerResult result = this.calculateRedstonePowerAt(world, x, y, z, orientation);
                    this.simplePowerCheck = true;
                    strength = result == null ? 0 : result.strength;
                    int n = sourceSide = result == null ? -1 : result.sourceDirection.ordinal();
                    if (sourceSide != te.powerSourceSide) {
                        te.powerSourceSide = (short)sourceSide;
                        needClientUpdate = true;
                        notifyChain = true;
                    }
                    if (sourceSide == -1 || strength < 1) {
                        if (te.powerSourceOutsideNetwork) {
                            te.powerSourceOutsideNetwork = false;
                            needClientUpdate = true;
                            notifyChain = true;
                        }
                    } else {
                        ForgeDirection sourceSideDir = ForgeDirection.getOrientation((int)sourceSide);
                        Block sourceBlock = world.func_147439_a(x + sourceSideDir.offsetX, y + sourceSideDir.offsetY, z + sourceSideDir.offsetZ);
                        if (sourceBlock instanceof IRedcrystalPowerConductor || RedstoneCalc.isAirBlock(sourceBlock, (IBlockAccess)world, x + sourceSideDir.offsetX, y + sourceSideDir.offsetY, z + sourceSideDir.offsetZ)) {
                            if (te.powerSourceOutsideNetwork) {
                                te.powerSourceOutsideNetwork = false;
                                needClientUpdate = true;
                                notifyChain = true;
                            }
                        } else {
                            if (!te.powerSourceOutsideNetwork) {
                                te.powerSourceOutsideNetwork = true;
                                needClientUpdate = true;
                                notifyChain = true;
                            }
                            if (resettingPowerLevels) {
                                this.newPrimaryPowerInputLocations.add(new BlockCoord(x, y, z));
                            }
                        }
                    }
                    int metadata = world.func_72805_g(x, y, z);
                    short amp = 0;
                    if (metadata == 15) {
                        amp = te.powerStability;
                    }
                    if (strength != metadata + amp) {
                        if (strength > 15) {
                            metadata = 15;
                            te.powerStability = (short)(strength - metadata);
                        } else {
                            metadata = strength;
                            if (amp > 0) {
                                te.powerStability = 0;
                            }
                        }
                        world.func_72921_c(x, y, z, metadata, 2);
                        needNotifyNeighbors = true;
                        needClientUpdate = true;
                        notifyChain = true;
                    }
                }
            } else {
                strength = 0;
                notifyChain = true;
            }
            if (notifyChain || forcePropagate) {
                LinkedHashMap<BlockCoord, ForgeDirection> wireTrace;
                if (strength == -1) {
                    strength = this.getRedstoneSignalStrength((IBlockAccess)world, x, y, z, true);
                }
                if (!(calledByNeighborWire || !needClientUpdate && checkStrength || (wireTrace = RedstoneCalc.getConnectedWireAwayFromSourceWithNoInputPoint((IBlockAccess)world, x, y, z)) == null)) {
                    for (Map.Entry<BlockCoord, ForgeDirection> entry : wireTrace.entrySet()) {
                        BlockCoord bc = entry.getKey();
                        IOrientableRedstoneConductor orc = (IOrientableRedstoneConductor)world.func_147439_a(bc.x, bc.y, bc.z);
                        if (orc.getRedstoneSignalStrength((IBlockAccess)world, x, y, z, true) <= 0) continue;
                        resettingPowerLevels = true;
                        orc.onNeighborRedstoneConductorUpdate(world, bc.x, bc.y, bc.z, entry.getValue(), 51);
                        resettingPowerLevels = false;
                    }
                    for (BlockCoord bc : this.newPrimaryPowerInputLocations) {
                        Block block = world.func_147439_a(bc.x, bc.y, bc.z);
                        if (!(block instanceof BlockRedcrystal)) continue;
                        ((BlockRedcrystal)block).updateAndPropagateChanges(world, bc.x, bc.y, bc.z, true, false, true, false);
                    }
                    this.newPrimaryPowerInputLocations.clear();
                }
                LinkedHashMap<BlockCoord, ForgeDirection> wiring = RedstoneCalc.getConnectedWireAwayFromSource((IBlockAccess)world, x, y, z);
                for (Map.Entry<BlockCoord, ForgeDirection> entry : wiring.entrySet()) {
                    BlockCoord bc = entry.getKey();
                    IOrientableRedstoneConductor orc = (IOrientableRedstoneConductor)world.func_147439_a(bc.x, bc.y, bc.z);
                    orc.onNeighborRedstoneConductorUpdate(world, bc.x, bc.y, bc.z, entry.getValue(), strength);
                }
            }
            if (needClientUpdate) {
                if (te == null) {
                    te = (TileEntityRedcrystal)world.func_147438_o(x, y, z);
                }
                te.func_70296_d();
            }
            if (needNotifyNeighbors || forcePropagate) {
                this.scheduleAreaUpdateNotification(world, x, y, z, immediateNeighborUpdates);
            }
        }
    }

    public void scheduleAreaUpdateNotification(World world, int x, int y, int z, boolean immediate) {
        if (!world.field_72995_K) {
            LinkedHashSet<Object> bcs;
            int dimension = world.field_73011_w.field_76574_g;
            if (this.queuedBlockUpdateLocations.containsKey(dimension)) {
                bcs = this.queuedBlockUpdateLocations.get(dimension);
            } else {
                bcs = new LinkedHashSet();
                this.queuedBlockUpdateLocations.put(dimension, bcs);
            }
            bcs.add(new BlockCoord(x - 1, y, z));
            bcs.add(new BlockCoord(x + 1, y, z));
            bcs.add(new BlockCoord(x, y - 1, z));
            bcs.add(new BlockCoord(x, y + 1, z));
            bcs.add(new BlockCoord(x, y, z - 1));
            bcs.add(new BlockCoord(x, y, z + 1));
            bcs.add(new BlockCoord(x - 1, y - 1, z));
            bcs.add(new BlockCoord(x - 1, y, z - 1));
            bcs.add(new BlockCoord(x - 1, y, z + 1));
            bcs.add(new BlockCoord(x - 1, y + 1, z));
            bcs.add(new BlockCoord(x, y - 1, z - 1));
            bcs.add(new BlockCoord(x, y - 1, z + 1));
            bcs.add(new BlockCoord(x, y + 1, z - 1));
            bcs.add(new BlockCoord(x, y + 1, z + 1));
            bcs.add(new BlockCoord(x + 1, y - 1, z));
            bcs.add(new BlockCoord(x + 1, y, z - 1));
            bcs.add(new BlockCoord(x + 1, y, z + 1));
            bcs.add(new BlockCoord(x + 1, y + 1, z));
            bcs.add(new BlockCoord(x - 2, y, z));
            bcs.add(new BlockCoord(x + 2, y, z));
            bcs.add(new BlockCoord(x, y - 2, z));
            bcs.add(new BlockCoord(x, y + 2, z));
            bcs.add(new BlockCoord(x, y, z - 2));
            bcs.add(new BlockCoord(x, y, z + 2));
            if (immediate) {
                this.handleQueuedBlockUpdates(world);
            } else {
                world.func_147464_a(x, y, z, (Block)this, 1);
            }
        }
    }

    private void handleQueuedBlockUpdates(World world) {
        if (!world.field_72995_K) {
            int dimension = world.field_73011_w.field_76574_g;
            LinkedHashSet<BlockCoord> bcs = this.queuedBlockUpdateLocations.get(dimension);
            if (bcs == null) {
                return;
            }
            BlockCoord[] queue = bcs.toArray(new BlockCoord[bcs.size()]);
            bcs.clear();
            for (BlockCoord bc : queue) {
                world.func_147460_e(bc.x, bc.y, bc.z, (Block)this);
            }
        }
    }

    public void func_149674_a(World world, int x, int y, int z, Random rand) {
        this.handleQueuedBlockUpdates(world);
    }

    @Override
    public void onNeighborRedstoneConductorUpdate(World world, int x, int y, int z, ForgeDirection neighborDir, int neighborStrength) {
        int strength = this.getRedstoneSignalStrength((IBlockAccess)world, x, y, z, true);
        if (neighborStrength > strength || this.getRedstoneSignalSourceSide((IBlockAccess)world, x, y, z) == neighborDir.ordinal()) {
            this.updateAndPropagateChanges(world, x, y, z, true, true, false, false);
        }
    }

    public void onNeighborRedstoneConductorUpdate(World world, int x, int y, int z) {
        this.updateAndPropagateChanges(world, x, y, z, true, true, false, false);
    }

    @Override
    public boolean isRedstoneSignalInputPoint(IBlockAccess blockaccess, int x, int y, int z) {
        try {
            TileEntityRedcrystal te = (TileEntityRedcrystal)blockaccess.func_147438_o(x, y, z);
            return te.powerSourceOutsideNetwork;
        }
        catch (Exception ex) {
            return false;
        }
    }

    protected RedstoneCalc.PowerResult calculateRedstonePowerAt(World world, int x, int y, int z, int orientation) {
        return RedstoneCalc.getRedstonePowerAt(world, x, y, z, orientation, true, orientation, true, this.getRedstoneInputDirections((IBlockAccess)world, x, y, z));
    }

    public int getLightValue(IBlockAccess blockaccess, int x, int y, int z) {
        double strength = blockaccess.func_72805_g(x, y, z);
        strength = Math.floor(strength * 0.6666666666666666);
        return (int)strength;
    }

    public void func_149719_a(IBlockAccess blockaccess, int x, int y, int z) {
        int orientation = this.getOrientation(blockaccess, x, y, z);
        switch (orientation) {
            case 0: {
                this.func_149676_a(0.0f, 0.7f, 0.0f, 1.0f, 1.0f, 1.0f);
                break;
            }
            case 1: {
                this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 0.3f, 1.0f);
                break;
            }
            case 2: {
                this.func_149676_a(0.0f, 0.0f, 0.7f, 1.0f, 1.0f, 1.0f);
                break;
            }
            case 3: {
                this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 0.3f);
                break;
            }
            case 4: {
                this.func_149676_a(0.7f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
                break;
            }
            case 5: {
                this.func_149676_a(0.0f, 0.0f, 0.0f, 0.3f, 1.0f, 1.0f);
                break;
            }
            default: {
                this.func_149676_a(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public boolean addHitEffects(World world, MovingObjectPosition target, EffectRenderer er) {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean addDestroyEffects(World world, int x, int y, int z, int meta, EffectRenderer er) {
        return world.func_147439_a(x, y, z) instanceof BlockRedcrystal;
    }

    public boolean func_149744_f() {
        return true;
    }

    public boolean canConnectRedstone(IBlockAccess world, int x, int y, int z, int side) {
        switch (side) {
            case 0: {
                side = 2;
                break;
            }
            case 1: {
                side = 5;
                break;
            }
            case 2: {
                side = 3;
                break;
            }
            case 3: {
                side = 4;
                break;
            }
            default: {
                return false;
            }
        }
        if (side == this.getOrientation(world, x, y, z)) {
            return false;
        }
        return this.canSendRedstoneSignalInDirection(world, x, y, z, side);
    }

    public int func_149748_c(IBlockAccess blockaccess, int x, int y, int z, int side) {
        if (!this.simplePowerCheck) {
            return 0;
        }
        try {
            if (!this.redstonedustAllowingPowerCheck.getBoolean(Blocks.field_150488_af)) {
                return 0;
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
        return this.func_149709_b(blockaccess, x, y, z, side);
    }

    public int func_149709_b(IBlockAccess blockaccess, int x, int y, int z, int side) {
        if (!this.simplePowerCheck) {
            return 0;
        }
        if (side == TjUtil.getOppositeSide(this.getOrientation(blockaccess, x, y, z))) {
            return 0;
        }
        int strength = blockaccess.func_72805_g(x, y, z);
        if (strength > 0) {
            if (!this.canSendRedstoneSignalInDirection(blockaccess, x, y, z, ForgeDirection.getOrientation((int)side).getOpposite().ordinal())) {
                return 0;
            }
            try {
                if (!this.redstonedustAllowingPowerCheck.getBoolean(Blocks.field_150488_af)) {
                    --strength;
                }
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        return strength;
    }

    @Override
    public int getOrientation(IBlockAccess blockaccess, int x, int y, int z) {
        int orientation = -1;
        try {
            TileEntityRedcrystal te = (TileEntityRedcrystal)blockaccess.func_147438_o(x, y, z);
            orientation = te.orientation;
        }
        catch (Exception ex) {
            // empty catch block
        }
        return orientation;
    }

    @Override
    public int getRedstoneSignalSourceSide(IBlockAccess blockaccess, int x, int y, int z) {
        int side = -1;
        try {
            TileEntityRedcrystal te = (TileEntityRedcrystal)blockaccess.func_147438_o(x, y, z);
            side = te.powerSourceSide;
        }
        catch (Exception ex) {
            // empty catch block
        }
        return side;
    }

    @Override
    public int getRedstoneSignalStrength(IBlockAccess blockaccess, int x, int y, int z, boolean allowAmplifiedPower) {
        if (resettingPowerLevels) {
            return 0;
        }
        int strength = blockaccess.func_72805_g(x, y, z);
        if (strength == 15 && allowAmplifiedPower) {
            TileEntityRedcrystal te = (TileEntityRedcrystal)blockaccess.func_147438_o(x, y, z);
            return strength + te.powerStability;
        }
        return strength;
    }

    @Override
    public int getRedstoneSignalStrength(IBlockAccess blockaccess, int x, int y, int z, int intoDirection, boolean allowAmplifiedPower) {
        int strength = this.getRedstoneSignalStrength(blockaccess, x, y, z, allowAmplifiedPower);
        if (strength > 0 && !this.canSendRedstoneSignalInDirection(blockaccess, x, y, z, intoDirection)) {
            return 0;
        }
        return strength;
    }

    public void setConnection(IBlockAccess blockaccess, int x, int y, int z, boolean connects, int ... sides) {
        TileEntityRedcrystal te;
        try {
            te = (TileEntityRedcrystal)blockaccess.func_147438_o(x, y, z);
        }
        catch (Exception ex) {
            return;
        }
        boolean madeChanges = false;
        block8: for (int side : sides) {
            if (side == 0) {
                side = te.orientation;
            } else if (side == 1) {
                side = TjUtil.getOppositeSide(te.orientation);
            }
            switch (side) {
                case 2: {
                    te.connectN = connects;
                    madeChanges = true;
                    continue block8;
                }
                case 3: {
                    te.connectS = connects;
                    madeChanges = true;
                    continue block8;
                }
                case 4: {
                    te.connectW = connects;
                    madeChanges = true;
                    continue block8;
                }
                case 5: {
                    te.connectE = connects;
                    madeChanges = true;
                }
            }
        }
        if (madeChanges) {
            te.func_70296_d();
        }
        this.updateAndPropagateChanges(te.func_145831_w(), x, y, z, true, false, true, false);
    }

    @Override
    public boolean canSendRedstoneSignalInDirection(IBlockAccess blockaccess, int x, int y, int z, int dir) {
        TileEntityRedcrystal te;
        try {
            te = (TileEntityRedcrystal)blockaccess.func_147438_o(x, y, z);
        }
        catch (Exception ex) {
            return false;
        }
        short orientation = te.orientation;
        switch (orientation) {
            case 0: 
            case 1: {
                switch (dir) {
                    case 0: 
                    case 1: {
                        return true;
                    }
                    case 2: {
                        return te.connectN;
                    }
                    case 3: {
                        return te.connectS;
                    }
                    case 4: {
                        return te.connectW;
                    }
                    case 5: {
                        return te.connectE;
                    }
                }
                break;
            }
            case 2: {
                switch (dir) {
                    case 0: {
                        return te.connectN;
                    }
                    case 1: {
                        return te.connectS;
                    }
                    case 2: 
                    case 3: {
                        return true;
                    }
                    case 4: {
                        return te.connectW;
                    }
                    case 5: {
                        return te.connectE;
                    }
                }
                break;
            }
            case 3: {
                switch (dir) {
                    case 0: {
                        return te.connectS;
                    }
                    case 1: {
                        return te.connectN;
                    }
                    case 2: 
                    case 3: {
                        return true;
                    }
                    case 4: {
                        return te.connectW;
                    }
                    case 5: {
                        return te.connectE;
                    }
                }
                break;
            }
            case 4: {
                switch (dir) {
                    case 0: {
                        return te.connectW;
                    }
                    case 1: {
                        return te.connectE;
                    }
                    case 2: {
                        return te.connectN;
                    }
                    case 3: {
                        return te.connectS;
                    }
                    case 4: 
                    case 5: {
                        return true;
                    }
                }
                break;
            }
            case 5: {
                switch (dir) {
                    case 0: {
                        return te.connectE;
                    }
                    case 1: {
                        return te.connectW;
                    }
                    case 2: {
                        return te.connectN;
                    }
                    case 3: {
                        return te.connectS;
                    }
                    case 4: 
                    case 5: {
                        return true;
                    }
                }
            }
        }
        return false;
    }

    public ForgeDirection[] getRedstoneInputDirections(IBlockAccess blockaccess, int x, int y, int z) {
        TileEntityRedcrystal te;
        try {
            te = (TileEntityRedcrystal)blockaccess.func_147438_o(x, y, z);
        }
        catch (Exception ex) {
            return null;
        }
        ArrayList<ForgeDirection> list = new ArrayList<ForgeDirection>();
        short orientation = te.orientation;
        switch (orientation) {
            case 2: {
                if (te.connectN) {
                    list.add(ForgeDirection.DOWN);
                }
                if (te.connectS) {
                    list.add(ForgeDirection.UP);
                }
                if (te.connectW) {
                    list.add(ForgeDirection.WEST);
                }
                if (te.connectE) {
                    list.add(ForgeDirection.EAST);
                }
                list.add(ForgeDirection.NORTH);
                list.add(ForgeDirection.SOUTH);
                break;
            }
            case 3: {
                if (te.connectN) {
                    list.add(ForgeDirection.UP);
                }
                if (te.connectS) {
                    list.add(ForgeDirection.DOWN);
                }
                if (te.connectW) {
                    list.add(ForgeDirection.WEST);
                }
                if (te.connectE) {
                    list.add(ForgeDirection.EAST);
                }
                list.add(ForgeDirection.NORTH);
                list.add(ForgeDirection.SOUTH);
                break;
            }
            case 4: {
                if (te.connectN) {
                    list.add(ForgeDirection.NORTH);
                }
                if (te.connectS) {
                    list.add(ForgeDirection.SOUTH);
                }
                if (te.connectW) {
                    list.add(ForgeDirection.DOWN);
                }
                if (te.connectE) {
                    list.add(ForgeDirection.UP);
                }
                list.add(ForgeDirection.EAST);
                list.add(ForgeDirection.WEST);
                break;
            }
            case 5: {
                if (te.connectN) {
                    list.add(ForgeDirection.NORTH);
                }
                if (te.connectS) {
                    list.add(ForgeDirection.SOUTH);
                }
                if (te.connectW) {
                    list.add(ForgeDirection.UP);
                }
                if (te.connectE) {
                    list.add(ForgeDirection.DOWN);
                }
                list.add(ForgeDirection.EAST);
                list.add(ForgeDirection.WEST);
                break;
            }
            default: {
                if (te.connectN) {
                    list.add(ForgeDirection.NORTH);
                }
                if (te.connectS) {
                    list.add(ForgeDirection.SOUTH);
                }
                if (te.connectW) {
                    list.add(ForgeDirection.WEST);
                }
                if (te.connectE) {
                    list.add(ForgeDirection.EAST);
                }
                list.add(ForgeDirection.UP);
                list.add(ForgeDirection.DOWN);
            }
        }
        return list.toArray(new ForgeDirection[list.size()]);
    }

    @Override
    public boolean canReceiveRedstoneSignalFromDirection(IBlockAccess blockaccess, int x, int y, int z, int dir) {
        ForgeDirection[] dirs;
        for (ForgeDirection d : dirs = this.getRedstoneInputDirections(blockaccess, x, y, z)) {
            if (d.ordinal() != dir) continue;
            return true;
        }
        return false;
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int side, float hitX, float hitY, float hitZ) {
        if (!world.field_72995_K && ThaumcraftExtension.playerHasWandEquipped(player)) {
            int calcSide = -1;
            int orientation = this.getOrientation((IBlockAccess)world, x, y, z);
            if (side == orientation) {
                float we;
                float ns;
                switch (orientation) {
                    case 0: 
                    case 1: {
                        ns = hitZ;
                        we = hitX;
                        break;
                    }
                    case 2: 
                    case 3: {
                        ns = hitY;
                        we = hitX;
                        break;
                    }
                    case 4: 
                    case 5: {
                        ns = hitZ;
                        we = hitY;
                        break;
                    }
                    default: {
                        return false;
                    }
                }
                if ((double)ns >= 0.4 && (double)ns <= 0.6 && (double)we >= 0.4 && (double)we <= 0.6) {
                    return this.onBlockActivatedCenter(world, x, y, z, player);
                }
                if ((double)ns < 0.4) {
                    if ((double)we > 0.4 && (double)we < 0.6) {
                        calcSide = orientation == 3 ? 3 : 2;
                    }
                } else if ((double)ns > 0.6) {
                    if ((double)we > 0.4 && (double)we < 0.6) {
                        calcSide = orientation == 3 ? 2 : 3;
                    }
                } else if ((double)we < 0.4) {
                    if ((double)ns > 0.4 && (double)ns < 0.6) {
                        calcSide = orientation == 5 ? 5 : 4;
                    }
                } else if ((double)we > 0.6 && (double)ns > 0.4 && (double)ns < 0.6) {
                    calcSide = orientation == 5 ? 4 : 5;
                }
            } else {
                if (side == TjUtil.getOppositeSide(orientation)) {
                    return false;
                }
                calcSide = side == 0 ? orientation : (side == 1 ? TjUtil.getOppositeSide(orientation) : side);
            }
            if (calcSide != -1) {
                return this.onBlockActivatedAdjustedSide(world, x, y, z, player, calcSide);
            }
        }
        return ThaumcraftExtension.playerHasWandEquipped(player);
    }

    public boolean onBlockActivatedCenter(World world, int x, int y, int z, EntityPlayer player) {
        return false;
    }

    public boolean onBlockActivatedAdjustedSide(World world, int x, int y, int z, EntityPlayer player, int side) {
        if (this.toggleConnectionToDirection(world, x, y, z, side, true)) {
            world.func_72956_a((Entity)player, "thaumcraft:crystal", 1.0f, 1.0f);
            return true;
        }
        return false;
    }

    public boolean toggleConnectionToDirection(World world, int x, int y, int z, int side, boolean alterOtherConnection) {
        ForgeDirection orientationDir;
        boolean connects;
        TileEntityRedcrystal te = null;
        try {
            te = (TileEntityRedcrystal)world.func_147438_o(x, y, z);
        }
        catch (Exception ex) {
            // empty catch block
        }
        if (te == null) {
            return false;
        }
        switch (side) {
            case 2: {
                connects = te.connectN;
                break;
            }
            case 3: {
                connects = te.connectS;
                break;
            }
            case 4: {
                connects = te.connectW;
                break;
            }
            case 5: {
                connects = te.connectE;
                break;
            }
            default: {
                return false;
            }
        }
        connects = !connects;
        BlockCoord connectedPos = null;
        boolean connectionAroundCorner = false;
        boolean overheadConnection = false;
        ForgeDirection dir = orientationDir = ForgeDirection.getOrientation((int)side);
        int orientation = this.getOrientation((IBlockAccess)world, x, y, z);
        if (orientation == dir.ordinal()) {
            dir = ForgeDirection.DOWN;
        } else if (orientation == dir.getOpposite().ordinal()) {
            dir = ForgeDirection.UP;
        }
        int x2 = x + dir.offsetX;
        int y2 = y + dir.offsetY;
        int z2 = z + dir.offsetZ;
        Block block = world.func_147439_a(x2, y2, z2);
        if (block instanceof BlockRedcrystal) {
            connectedPos = new BlockCoord(x2, y2, z2);
            if (this.getOrientation((IBlockAccess)world, x2, y2, z2) == dir.getOpposite().ordinal()) {
                overheadConnection = true;
            }
        } else if (block.isAir((IBlockAccess)world, x2, y2, z2)) {
            BlockWithPos bwp = RedstoneCalc.getORCAroundCorner((IBlockAccess)world, x2, y2, z2, orientation, dir);
            if (bwp != null && bwp.block instanceof BlockRedcrystal) {
                block = bwp.block;
                connectedPos = new BlockCoord(bwp.x, bwp.y, bwp.z);
                connectionAroundCorner = true;
            }
        } else if (dir != orientationDir && (block = world.func_147439_a(x2 = x + orientationDir.offsetX, y2 = y + orientationDir.offsetY, z2 = z + orientationDir.offsetZ)) instanceof BlockRedcrystal) {
            connectedPos = new BlockCoord(x2, y2, z2);
        }
        this.setConnection((IBlockAccess)world, x, y, z, connects, side);
        if (connectedPos != null) {
            if (alterOtherConnection && !overheadConnection && block instanceof BlockRedcrystal && ((BlockRedcrystal)block).allowNeighborToChangeConnection(world, x2, y2, z2)) {
                int otherSide = TjUtil.getOppositeSide(side);
                if (connectionAroundCorner) {
                    otherSide = orientation;
                }
                ((BlockRedcrystal)block).setConnection((IBlockAccess)world, connectedPos.x, connectedPos.y, connectedPos.z, connects, otherSide);
                this.updateAndPropagateChanges(world, x, y, z, true, false, true, false);
            } else if (!connects) {
                ((BlockRedcrystal)block).updateAndPropagateChanges(world, connectedPos.x, connectedPos.y, connectedPos.z, true, false, true, false);
            }
        }
        return true;
    }

    public boolean allowNeighborToChangeConnection(World world, int x, int y, int z) {
        return true;
    }
}

