/*
 * Decompiled with CFR 0.152.
 */
package tuhljin.automagy.blocks;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import tuhljin.automagy.blocks.BlockRedcrystal;
import tuhljin.automagy.lib.IOrientableRedstoneConductor;
import tuhljin.automagy.lib.IRedcrystalPowerConductor;
import tuhljin.automagy.lib.RedstoneCalc;
import tuhljin.automagy.lib.TjUtil;
import tuhljin.automagy.tiles.TileEntityRedcrystal;

public class BlockRedcrystalDim
extends BlockRedcrystal
implements IOrientableRedstoneConductor,
IRedcrystalPowerConductor {
    public static final int MAX_CAP = 14;
    public static final int MIN_CAP = 1;

    public BlockRedcrystalDim(String name) {
        super(name);
    }

    @Override
    protected RedstoneCalc.PowerResult calculateRedstonePowerAt(World world, int x, int y, int z, int orientation) {
        RedstoneCalc.PowerResult result = super.calculateRedstonePowerAt(world, x, y, z, orientation);
        if (result != null && result.strength > 0) {
            return new RedstoneCalc.PowerResult(Math.min(result.strength, this.getRedstoneSignalCap((IBlockAccess)world, x, y, z)), result.sourceDirection);
        }
        return null;
    }

    public int getRedstoneSignalCap(IBlockAccess blockaccess, int x, int y, int z) {
        int cap = 1;
        try {
            TileEntityRedcrystal te = (TileEntityRedcrystal)blockaccess.func_147438_o(x, y, z);
            cap = te.extraData;
        }
        catch (Exception ex) {
            // empty catch block
        }
        if (cap > 14) {
            return 14;
        }
        if (cap < 1) {
            return 1;
        }
        return cap;
    }

    @Override
    public boolean onBlockActivatedCenter(World world, int x, int y, int z, EntityPlayer player) {
        if (!world.field_72995_K) {
            int cap = this.getRedstoneSignalCap((IBlockAccess)world, x, y, z);
            try {
                TileEntityRedcrystal te = (TileEntityRedcrystal)world.func_147438_o(x, y, z);
                if (++cap > 14) {
                    cap = 1;
                }
                te.extraData = cap;
                te.func_70296_d();
            }
            catch (Exception ex) {
                // empty catch block
            }
            this.updateAndPropagateChanges(world, x, y, z, true, false, true, false);
            TjUtil.sendFormattedChatToPlayer(player, "Automagy.chat.redcrystalDim.setCap", cap);
            return true;
        }
        return false;
    }
}

