/*
 * Decompiled with CFR 0.152.
 */
package tuhljin.automagy.blocks;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.client.particle.EffectRenderer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.util.ForgeDirection;
import thaumcraft.common.Thaumcraft;
import tuhljin.automagy.blocks.BlockRedcrystal;
import tuhljin.automagy.lib.RedstoneCalc;
import tuhljin.automagy.lib.TjUtil;
import tuhljin.automagy.lib.struct.WorldSpecificCoordinates;
import tuhljin.automagy.tiles.TileEntityRedcrystalMerc;

public class BlockRedcrystalMerc
extends BlockRedcrystal {
    private WorldSpecificCoordinates lastCoord = null;

    public BlockRedcrystalMerc(String name) {
        super(name);
        this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 0.32f, 1.0f);
        this.func_149672_a(field_149769_e);
        this.func_149711_c(2.5f);
        this.setHarvestLevel("pickaxe", 0);
        this.func_149658_d("thaumcraft:pedestal_top");
    }

    @Override
    public TileEntity func_149915_a(World var1, int var2) {
        TileEntityRedcrystalMerc te = new TileEntityRedcrystalMerc((short)this.nextTEOrientation, this.nextTENoConnections);
        this.nextTEOrientation = -1;
        this.nextTENoConnections = false;
        return te;
    }

    @Override
    public void func_149719_a(IBlockAccess blockaccess, int x, int y, int z) {
    }

    @Override
    public AxisAlignedBB func_149668_a(World p_149668_1_, int p_149668_2_, int p_149668_3_, int p_149668_4_) {
        return AxisAlignedBB.func_72330_a((double)((double)p_149668_2_ + this.field_149759_B), (double)((double)p_149668_3_ + this.field_149760_C), (double)((double)p_149668_4_ + this.field_149754_D), (double)((double)p_149668_2_ + this.field_149755_E), (double)((double)p_149668_3_ + this.field_149756_F), (double)((double)p_149668_4_ + this.field_149757_G));
    }

    @Override
    public boolean func_149742_c(World world, int x, int y, int z) {
        if (!TjUtil.isAcceptableSurfaceForBlock(world, x, y - 1, z, true, true)) {
            return false;
        }
        return world.func_147439_a(x, y, z).isReplaceable((IBlockAccess)world, x, y, z);
    }

    @Override
    public boolean func_149707_d(World world, int x, int y, int z, int side) {
        return TjUtil.isAcceptableSurfaceForBlock(world, x, y - 1, z, true, true);
    }

    public boolean func_149718_j(World world, int x, int y, int z) {
        return TjUtil.isAcceptableSurfaceForBlock(world, x, y - 1, z, true, true);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean addHitEffects(World world, MovingObjectPosition target, EffectRenderer er) {
        return false;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean addDestroyEffects(World world, int x, int y, int z, int meta, EffectRenderer er) {
        return false;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_149734_b(World world, int x, int y, int z, Random rand) {
        TileEntityRedcrystalMerc te = null;
        try {
            te = (TileEntityRedcrystalMerc)world.func_147438_o(x, y, z);
        }
        catch (Exception ex) {
            // empty catch block
        }
        if (te != null && te.hasValidMirrorConnection()) {
            int color;
            int strength = this.getRedstoneSignalStrength((IBlockAccess)world, x, y, z, true);
            boolean power = strength > 0;
            int n = color = power ? 8 : 6;
            if (power) {
                boolean mirrorIsSource;
                boolean bl = mirrorIsSource = te.strengthWithoutMirror != strength;
                if (rand.nextInt(4) == 0) {
                    int dz;
                    int dy;
                    int dx;
                    int sz;
                    int sy;
                    int sx;
                    if (mirrorIsSource) {
                        sx = te.mirrorX;
                        sy = te.mirrorY;
                        sz = te.mirrorZ;
                        dx = x;
                        dy = y;
                        dz = z;
                    } else {
                        sx = x;
                        sy = y;
                        sz = z;
                        dx = te.mirrorX;
                        dy = te.mirrorY;
                        dz = te.mirrorZ;
                    }
                    Thaumcraft.proxy.sourceStreamFX(world, (double)sx + 0.5, (double)sy + 0.5, (double)sz + 0.5, (float)dx + 0.5f, (float)dy + 0.5f, (float)dz + 0.5f, 0x990000);
                }
                Thaumcraft.proxy.sparkle((float)x + 0.2f + rand.nextFloat() * 0.6f, (float)y + (mirrorIsSource ? 0.8f : 0.5f), (float)z + 0.2f + rand.nextFloat() * 0.6f, 1.0f, color, mirrorIsSource ? 0.1f : -0.1f);
            } else {
                Thaumcraft.proxy.sparkle((float)x + 0.2f + rand.nextFloat() * 0.6f, (float)y + 0.2f, (float)z + 0.2f + rand.nextFloat() * 0.6f, 1.0f, color, -0.1f);
            }
        }
        super.func_149734_b(world, x, y, z, rand);
    }

    @Override
    public void func_149749_a(World world, int x, int y, int z, Block block, int p_149749_6_) {
        TileEntityRedcrystalMerc te = null;
        try {
            te = (TileEntityRedcrystalMerc)world.func_147438_o(x, y, z);
        }
        catch (Exception ex) {
            // empty catch block
        }
        WorldSpecificCoordinates worldSpecificCoordinates = this.lastCoord = te.mirrorY == -1 ? null : new WorldSpecificCoordinates(te.mirrorDim, te.mirrorX, te.mirrorY, te.mirrorZ);
        if (!world.field_72995_K) {
            te.removeFromMirrorNetwork();
        }
        super.func_149749_a(world, x, y, z, block, p_149749_6_);
    }

    public ArrayList<ItemStack> getDrops(World world, int x, int y, int z, int metadata, int fortune) {
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
        Item item = this.func_149650_a(metadata, world.field_73012_v, fortune);
        ItemStack stack = new ItemStack(item, 1, this.func_149692_a(metadata));
        TileEntityRedcrystalMerc te = null;
        try {
            te = (TileEntityRedcrystalMerc)world.func_147438_o(x, y, z);
        }
        catch (Exception ex) {
            // empty catch block
        }
        if (te != null) {
            if (te.mirrorY != -1) {
                stack.func_77983_a("mirrorX", (NBTBase)new NBTTagInt(te.mirrorX));
                stack.func_77983_a("mirrorY", (NBTBase)new NBTTagInt(te.mirrorY));
                stack.func_77983_a("mirrorZ", (NBTBase)new NBTTagInt(te.mirrorZ));
                stack.func_77983_a("mirrorDim", (NBTBase)new NBTTagInt(te.mirrorDim));
                stack.func_77983_a("mirrorDimName", (NBTBase)new NBTTagString(DimensionManager.getProvider((int)te.mirrorDim).func_80007_l()));
            }
        } else if (this.lastCoord != null) {
            stack.func_77983_a("mirrorX", (NBTBase)new NBTTagInt(this.lastCoord.x));
            stack.func_77983_a("mirrorY", (NBTBase)new NBTTagInt(this.lastCoord.y));
            stack.func_77983_a("mirrorZ", (NBTBase)new NBTTagInt(this.lastCoord.z));
            stack.func_77983_a("mirrorDim", (NBTBase)new NBTTagInt(this.lastCoord.dim));
            stack.func_77983_a("mirrorDimName", (NBTBase)new NBTTagString(DimensionManager.getProvider((int)this.lastCoord.dim).func_80007_l()));
        }
        this.lastCoord = null;
        drops.add(stack);
        return drops;
    }

    @Override
    protected RedstoneCalc.PowerResult calculateRedstonePowerAt(World world, int x, int y, int z, int orientation) {
        TileEntityRedcrystalMerc te;
        int receivingStrength = 0;
        try {
            te = (TileEntityRedcrystalMerc)world.func_147438_o(x, y, z);
        }
        catch (Exception ex) {
            return null;
        }
        if (te != null && (receivingStrength = Math.max(te.extraData - 1, 0)) >= 50) {
            return new RedstoneCalc.PowerResult(receivingStrength, ForgeDirection.UNKNOWN);
        }
        RedstoneCalc.PowerResult result = super.calculateRedstonePowerAt(world, x, y, z, orientation);
        if (result != null && result.strength > 0) {
            te.strengthWithoutMirror = result.strength;
            te.markDirty(false);
            if (receivingStrength > result.strength) {
                return new RedstoneCalc.PowerResult(receivingStrength, ForgeDirection.UNKNOWN);
            }
            return result;
        }
        te.strengthWithoutMirror = 0;
        te.markDirty(false);
        if (receivingStrength > 0) {
            return new RedstoneCalc.PowerResult(receivingStrength, ForgeDirection.UNKNOWN);
        }
        return null;
    }

    @Override
    public void updateAndPropagateChanges(World world, int x, int y, int z, boolean checkStrength, boolean calledByNeighborWire, boolean forcePropagate, boolean immediateNeighborUpdates) {
        super.updateAndPropagateChanges(world, x, y, z, checkStrength, calledByNeighborWire, forcePropagate, immediateNeighborUpdates);
        if (!world.field_72995_K) {
            TileEntityRedcrystalMerc te = null;
            boolean receivingStrength = false;
            try {
                te = (TileEntityRedcrystalMerc)world.func_147438_o(x, y, z);
            }
            catch (Exception ex) {
                // empty catch block
            }
            if (te != null && !resettingPowerLevels) {
                te.updateMirrorNetwork();
            }
        }
    }
}

