/*
 * Decompiled with CFR 0.152.
 */
package tuhljin.automagy.lib;

import baubles.api.BaublesApi;
import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import thaumcraft.api.ThaumcraftApiHelper;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.api.potions.PotionFluxTaint;
import thaumcraft.api.wands.IWandFocus;
import thaumcraft.common.Thaumcraft;
import thaumcraft.common.blocks.BlockCosmeticSolid;
import thaumcraft.common.blocks.BlockHole;
import thaumcraft.common.blocks.BlockStoneDevice;
import thaumcraft.common.blocks.BlockWoodenDevice;
import thaumcraft.common.items.ItemResource;
import thaumcraft.common.items.wands.ItemWandCasting;
import thaumcraft.common.lib.network.PacketHandler;
import thaumcraft.common.lib.network.playerdata.PacketResearchComplete;
import thaumcraft.common.tiles.TileMirror;
import thaumcraft.common.tiles.TileMirrorEssentia;
import thaumcraft.common.tiles.TileWandPedestal;
import tuhljin.automagy.lib.inventory.HashableItemWithoutSize;
import tuhljin.automagy.lib.struct.WorldSpecificCoordinates;

public class ThaumcraftExtension {
    public static boolean addFluxTaintPotionEffect(EntityLivingBase entity, int duration, int amplifier) {
        try {
            entity.func_70690_d(new PotionEffect(PotionFluxTaint.instance.field_76415_H, duration, amplifier, false));
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static boolean playerHasWandEquipped(EntityPlayer player) {
        ItemStack stack = player.func_71045_bC();
        return stack != null && stack.func_77973_b() instanceof ItemWandCasting;
    }

    public static ItemStack getWandInRechargePedestal(TileEntity te) {
        if (!(te instanceof TileWandPedestal)) {
            return null;
        }
        ItemStack stack = null;
        if (!(te instanceof IInventory)) {
            FMLLog.warning((String)"[Automagy] Error: Expected TileWandPedestal to implement IInventory.", (Object[])new Object[0]);
            return null;
        }
        try {
            stack = ((IInventory)te).func_70301_a(0);
        }
        catch (Exception ex) {
            FMLLog.warning((String)"[Automagy] Could not invoke TileWandPedestal method getStackInSlot.", (Object[])new Object[0]);
            return null;
        }
        return stack;
    }

    public static boolean blockIsPedestal(Block block, int metadata, boolean allowWandRecharger) {
        if (block instanceof BlockStoneDevice) {
            if (metadata == 1) {
                return true;
            }
            if (metadata == 5) {
                return allowWandRecharger;
            }
        }
        return false;
    }

    public static boolean blockIsArcaneBore(Block block, int metadata, boolean allowWandRecharger) {
        if (block instanceof BlockWoodenDevice) {
            return metadata == 5;
        }
        return false;
    }

    public static boolean blockIsPortableHole(Block block) {
        return block instanceof BlockHole;
    }

    public static boolean blockIsFetter(World world, int x, int y, int z, boolean activeOnly) {
        Block block = world.func_147439_a(x, y, z);
        if (block instanceof BlockCosmeticSolid) {
            int metadata = world.func_72805_g(x, y, z);
            if (metadata == 9) {
                return !activeOnly;
            }
            if (metadata == 10) {
                return true;
            }
        }
        return false;
    }

    public static boolean tileIsMirror(TileEntity te) {
        return te instanceof TileMirror || te instanceof TileMirrorEssentia;
    }

    public static boolean itemIsJarLabel(ItemStack stack) {
        return stack.func_77973_b() instanceof ItemResource && stack.func_77960_j() == 13;
    }

    public static AspectList getAspectsFromItem(ItemStack stack) {
        if (stack.func_77942_o()) {
            AspectList aspects = new AspectList();
            aspects.readFromNBT(stack.func_77978_p());
            return aspects.size() > 0 ? aspects : null;
        }
        return null;
    }

    public static boolean isResearchComplete(EntityPlayer player, String key) {
        String name = player.func_70005_c_();
        return ThaumcraftApiHelper.isResearchComplete((String)name, (String)key);
    }

    public static boolean isResearchDiscovered(EntityPlayer player, String key) {
        String name = player.func_70005_c_();
        return ThaumcraftApiHelper.isResearchComplete((String)name, (String)key) || ThaumcraftApiHelper.isResearchComplete((String)name, (String)("@" + key));
    }

    public static void triggerResearchUnlock(EntityPlayerMP player, String key) {
        PacketHandler.INSTANCE.sendTo((IMessage)new PacketResearchComplete("@" + key), player);
        Thaumcraft.proxy.getResearchManager().completeResearch((EntityPlayer)player, "@" + key);
    }

    public static WorldSpecificCoordinates getLinkedMirrorCoordinates(TileEntity te) {
        if (te instanceof TileMirror) {
            TileMirror tem = (TileMirror)te;
            if (tem.linked) {
                return new WorldSpecificCoordinates(tem.linkDim, tem.linkX, tem.linkY, tem.linkZ);
            }
        } else if (te instanceof TileMirrorEssentia) {
            TileMirrorEssentia tem = (TileMirrorEssentia)te;
            if (tem.linked) {
                return new WorldSpecificCoordinates(tem.linkDim, tem.linkX, tem.linkY, tem.linkZ);
            }
        }
        return null;
    }

    public static IWandFocus getWandFocus(ItemStack wand) {
        Item wi = wand.func_77973_b();
        if (wi instanceof ItemWandCasting) {
            return ((ItemWandCasting)wi).getFocus(wand);
        }
        return null;
    }

    public static boolean playerIsWearingBauble(EntityPlayer player, HashableItemWithoutSize item) {
        IInventory baubles = BaublesApi.getBaubles((EntityPlayer)player);
        if (baubles != null) {
            int size = baubles.func_70302_i_();
            for (int i = 0; i < size; ++i) {
                ItemStack stack = baubles.func_70301_a(i);
                if (stack == null || !item.isSameItem(stack)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean areAspectListsIdentical(AspectList a, AspectList b) {
        if (a.size() != b.size()) {
            return false;
        }
        for (Aspect aspect : a.getAspects()) {
            if (a.getAmount(aspect) == b.getAmount(aspect)) continue;
            return false;
        }
        return true;
    }
}

