/*
 * Decompiled with CFR 0.152.
 */
package tuhljin.automagy.lib.events;

import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.common.eventhandler.EventPriority;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.monster.EntitySpider;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.entity.EntityEvent;
import net.minecraftforge.event.entity.living.EnderTeleportEvent;
import net.minecraftforge.event.entity.living.LivingSpawnEvent;
import net.minecraftforge.event.entity.player.EntityInteractEvent;
import thaumcraft.api.ThaumcraftApiHelper;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.common.entities.golems.EntityGolemBase;
import tuhljin.automagy.items.ItemEntityEye;
import tuhljin.automagy.items.ItemGolemLinker;
import tuhljin.automagy.items.ModItems;
import tuhljin.automagy.lib.GolemLink;
import tuhljin.automagy.lib.ThaumcraftExtension;
import tuhljin.automagy.lib.TjUtil;
import tuhljin.automagy.lib.inventory.HashableItemWithoutSize;
import tuhljin.automagy.network.MessageParticles;

public class AutomagyEventHandler {
    public static final int ENDERMAN_SPAWN_INCREASE_CHANCE = 16;
    public static final int TELEPORT_RIFT_FEEDBACK_SIZE = 8;
    public static final float TELEPORT_RIFT_FEEDBACK_DAMAGE = 10.0f;
    public static AspectList disjunctionVisCost = new AspectList().add(Aspect.ENTROPY, 100);

    @SubscribeEvent
    public void onEntityConstructing(EntityEvent.EntityConstructing event) {
        if (event.entity instanceof EntityGolemBase && GolemLink.get((EntityGolemBase)event.entity) == null) {
            GolemLink golemLink = GolemLink.register((EntityGolemBase)event.entity);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void onEntityInteractEvent(EntityInteractEvent event) {
        ItemStack heldStack;
        if (event.target instanceof EntityGolemBase && (heldStack = event.entityPlayer.func_71045_bC()) != null) {
            Item item = heldStack.func_77973_b();
            if (item instanceof ItemGolemLinker) {
                if (((ItemGolemLinker)item).interactWithGolem(heldStack, event.entityPlayer, (EntityGolemBase)event.target)) {
                    event.setCanceled(true);
                }
            } else if (item instanceof ItemEntityEye) {
                ((ItemEntityEye)item).linkToEntity(heldStack, (EntityLivingBase)event.target, event.entityPlayer);
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public void onCheckSpawn(LivingSpawnEvent.CheckSpawn event) {
        if (event.entityLiving instanceof EntitySkeleton || event.entityLiving instanceof EntitySpider || event.entityLiving instanceof EntityZombie || event.entityLiving instanceof EntityCreeper) {
            World world = event.world;
            HashableItemWithoutSize item = new HashableItemWithoutSize(ModItems.ingredientHorizontal, 0, null);
            if (world.field_73012_v.nextInt(16) == 0 && this.biomeIsValidSpawn(world, (int)event.x, (int)event.y, (int)event.z, EntityEnderman.class) && this.getNearbyPlayerWithItem(item, world, event.x, event.y, event.z, 289.0) != null) {
                EntityLiving enderman;
                float f = event.x + 0.5f;
                float f1 = event.y;
                float f2 = event.z + 0.5f;
                try {
                    enderman = (EntityLiving)EntityEnderman.class.getConstructor(World.class).newInstance(event.world);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    return;
                }
                enderman.func_70012_b((double)f, (double)f1, (double)f2, world.field_73012_v.nextFloat() * 360.0f, 0.0f);
                Event.Result canSpawn = ForgeEventFactory.canEntitySpawn((EntityLiving)enderman, (World)world, (float)f, (float)f1, (float)f2);
                if (canSpawn == Event.Result.ALLOW || canSpawn == Event.Result.DEFAULT && enderman.func_70601_bi()) {
                    event.setResult(Event.Result.DENY);
                    world.func_72838_d((Entity)enderman);
                    if (!ForgeEventFactory.doSpecialSpawn((EntityLiving)enderman, (World)world, (float)f, (float)f1, (float)f2)) {
                        enderman.func_110161_a(null);
                    }
                }
            }
        }
    }

    @SubscribeEvent
    public void onEnderTeleport(EnderTeleportEvent event) {
        EntityLivingBase entity = event.entityLiving;
        if (entity == null || entity instanceof EntityPlayer || entity.func_110143_aJ() <= 0.0f || entity.field_70128_L) {
            return;
        }
        if (!this.positionIsValidForTeleport(entity, event.targetX, event.targetY, event.targetZ)) {
            return;
        }
        World world = entity.field_70170_p;
        HashableItemWithoutSize item = new HashableItemWithoutSize(ModItems.ringEnderDisjunction, 0, null);
        boolean validInterrupt = false;
        boolean goingAway = false;
        EntityPlayer player = this.getNearbyPlayerWearingBaubleAndConsumeVis(item, world, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, 8.0, disjunctionVisCost);
        int x = 0;
        int y = -1;
        int z = 0;
        if (player != null) {
            validInterrupt = true;
            goingAway = true;
            x = (int)entity.field_70165_t;
            y = (int)entity.field_70163_u;
            z = (int)entity.field_70161_v;
        } else {
            player = this.getNearbyPlayerWearingBaubleAndConsumeVis(item, world, event.targetX, event.targetY, event.targetZ, 8.0, disjunctionVisCost);
            if (player != null) {
                validInterrupt = true;
                x = (int)event.targetX;
                y = (int)event.targetY;
                z = (int)event.targetZ;
            }
        }
        if (validInterrupt) {
            DamageSource source = new EntityDamageSource("magic", (Entity)player).func_82726_p();
            entity.func_70097_a(source, 10.0f);
            if (goingAway && entity.func_110143_aJ() <= 0.0f) {
                event.setCanceled(true);
            }
            MessageParticles.sendToClients(world, x, y, z, 0, 0, 0, (short)3);
            if (goingAway) {
                entity.func_85030_a("thaumcraft:ice", 0.5f, 1.2f + world.field_73012_v.nextFloat() / 4.0f);
                entity.func_85030_a("thaumcraft:ice", 0.3f, 0.4f + world.field_73012_v.nextFloat() / 4.0f);
            } else {
                world.func_72908_a((double)x + 0.5, (double)(y + 1), (double)z + 0.5, "thaumcraft:ice", 0.5f, 1.2f + world.field_73012_v.nextFloat() / 4.0f);
                world.func_72908_a((double)x + 0.5, (double)(y + 1), (double)z + 0.5, "thaumcraft:ice", 0.3f, 0.4f + world.field_73012_v.nextFloat() / 4.0f);
            }
        }
    }

    public EntityPlayer getNearbyPlayerWithItem(HashableItemWithoutSize item, World world, double x, double y, double z, double maxDistance) {
        Object entityplayer = null;
        for (int i = 0; i < world.field_73010_i.size(); ++i) {
            EntityPlayer entityplayer1 = (EntityPlayer)world.field_73010_i.get(i);
            double d5 = entityplayer1.func_70092_e(x, y, z);
            if (!(maxDistance < 0.0) && !(d5 < maxDistance * maxDistance) || !TjUtil.playerHasItem(entityplayer1, item)) continue;
            return entityplayer1;
        }
        return null;
    }

    public EntityPlayer getNearbyPlayerWearingBaubleAndConsumeVis(HashableItemWithoutSize item, World world, double x, double y, double z, double maxDistance, AspectList visCost) {
        for (int i = 0; i < world.field_73010_i.size(); ++i) {
            EntityPlayer entityplayer1 = (EntityPlayer)world.field_73010_i.get(i);
            double d5 = entityplayer1.func_70092_e(x, y, z);
            if (!(maxDistance < 0.0) && !(d5 < maxDistance * maxDistance) || !ThaumcraftExtension.playerIsWearingBauble(entityplayer1, item) || visCost != null && !ThaumcraftApiHelper.consumeVisFromInventory((EntityPlayer)entityplayer1, (AspectList)visCost)) continue;
            return entityplayer1;
        }
        return null;
    }

    public boolean positionIsValidForTeleport(EntityLivingBase entity, double x, double y, double z) {
        int k;
        int j;
        double oldX = entity.field_70165_t;
        double oldY = entity.field_70163_u;
        double oldZ = entity.field_70161_v;
        double newY = y;
        int i = MathHelper.func_76128_c((double)x);
        if (entity.field_70170_p.func_72899_e(i, j = MathHelper.func_76128_c((double)y), k = MathHelper.func_76128_c((double)z))) {
            boolean flag1 = false;
            while (!flag1 && j > 0) {
                Block block = entity.field_70170_p.func_147439_a(i, j - 1, k);
                if (block.func_149688_o().func_76230_c()) {
                    flag1 = true;
                    continue;
                }
                newY -= 1.0;
                --j;
            }
            if (flag1) {
                entity.func_70107_b(x, newY, z);
                if (entity.field_70170_p.func_72945_a((Entity)entity, entity.field_70121_D).isEmpty() && !entity.field_70170_p.func_72953_d(entity.field_70121_D)) {
                    entity.func_70107_b(oldX, oldY, oldZ);
                    return true;
                }
                entity.func_70107_b(oldX, oldY, oldZ);
            }
        }
        return false;
    }

    public boolean biomeIsValidSpawn(World world, int x, int y, int z, Class<? extends EntityLivingBase> entityClass) {
        List list = world.func_72863_F().func_73155_a(EnumCreatureType.monster, x, y, z);
        for (Object entry : list) {
            try {
                BiomeGenBase.SpawnListEntry spawnEntry = (BiomeGenBase.SpawnListEntry)entry;
                if (spawnEntry.field_76300_b != entityClass) continue;
                return true;
            }
            catch (Exception ex) {
            }
        }
        return false;
    }
}

