/*
 * Decompiled with CFR 0.152.
 */
package tuhljin.automagy.network;

import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import thaumcraft.client.fx.bolt.FXLightningBolt;
import thaumcraft.common.Thaumcraft;
import tuhljin.automagy.lib.References;
import tuhljin.automagy.network.PacketHandler;
import tuhljin.automagy.tiles.TileEntityEssentiaLocus;

public class MessageParticles
implements IMessage,
IMessageHandler<MessageParticles, IMessage> {
    public static final short BREAKBLOCK = 0;
    public static final short BOLT_BLACK = 1;
    public static final short SMOKE = 2;
    public static final short ENDER_DISJUNCTION = 3;
    public static final short ABSORB_CLUSTER = 4;
    protected short id;
    protected int dim;
    protected int x;
    protected int y;
    protected int z;
    protected int x2;
    protected int y2;
    protected int z2;

    public MessageParticles() {
    }

    public MessageParticles(int dim, int x, int y, int z, int x2, int y2, int z2, short id) {
        this.id = id;
        this.dim = dim;
        this.x = x;
        this.y = y;
        this.z = z;
        this.x2 = x2;
        this.y2 = y2;
        this.z2 = z2;
    }

    public void fromBytes(ByteBuf buf) {
        this.id = buf.readShort();
        this.dim = buf.readInt();
        this.x = buf.readInt();
        this.y = buf.readInt();
        this.z = buf.readInt();
        this.x2 = buf.readInt();
        this.y2 = buf.readInt();
        this.z2 = buf.readInt();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeShort((int)this.id);
        buf.writeInt(this.dim);
        buf.writeInt(this.x);
        buf.writeInt(this.y);
        buf.writeInt(this.z);
        buf.writeInt(this.x2);
        buf.writeInt(this.y2);
        buf.writeInt(this.z2);
    }

    @SideOnly(value=Side.CLIENT)
    public IMessage onMessage(MessageParticles message, MessageContext ctx) {
        WorldClient world = FMLClientHandler.instance().getClient().field_71441_e;
        if (world.field_73011_w.field_76574_g == message.dim) {
            this.dim = message.dim;
            this.x = message.x;
            this.y = message.y;
            this.z = message.z;
            this.x2 = message.x2;
            this.y2 = message.y2;
            this.z2 = message.z2;
            switch (message.id) {
                case 0: {
                    this.showBreakBlock((World)world);
                    break;
                }
                case 1: {
                    for (int i = 0; i < 7; ++i) {
                        this.showBolt((World)world, 5);
                    }
                    world.func_72980_b((double)this.x + 0.5, (double)this.y + 0.5, (double)this.z + 0.5, "thaumcraft:zap", 0.2f, world.field_73012_v.nextFloat() * 0.5f + 0.4f, false);
                    world.func_72980_b((double)this.x + 0.5, (double)this.y + 0.5, (double)this.z + 0.5, "random.eat", 0.7f, world.field_73012_v.nextFloat() * 0.5f + 0.1f, false);
                    world.func_72980_b((double)this.x + 0.5, (double)this.y + 0.5, (double)this.z + 0.5, "random.eat", 0.5f, world.field_73012_v.nextFloat() * 0.5f + 1.0f, false);
                    break;
                }
                case 2: {
                    for (int i = 0; i < 35; ++i) {
                        this.showSmoke((World)world);
                    }
                    break;
                }
                case 3: {
                    for (int i = 0; i < 20; ++i) {
                        Thaumcraft.proxy.splooshFX((World)world, this.x, this.y, this.z);
                        Thaumcraft.proxy.splooshFX((World)world, this.x, this.y + 1, this.z);
                        Thaumcraft.proxy.splooshFX((World)world, this.x, this.y + 2, this.z);
                    }
                    break;
                }
                case 4: {
                    TileEntity te = world.func_147438_o(this.x, this.y, this.z);
                    if (te instanceof TileEntityEssentiaLocus) {
                        ((TileEntityEssentiaLocus)te).ticksToAnim = 40;
                    }
                    Thaumcraft.proxy.blockSparkle((World)world, this.x, this.y, this.z, References.META_WATER, 5);
                    Thaumcraft.proxy.blockSparkle((World)world, this.x2, this.y2, this.z2, References.META_WATER, 30);
                    Thaumcraft.proxy.blockSparkle((World)world, this.x2 - 1, this.y2, this.z2 - 1, References.META_WATER, 2);
                    Thaumcraft.proxy.blockSparkle((World)world, this.x2 - 1, this.y2, this.z2, References.META_WATER, 2);
                    Thaumcraft.proxy.blockSparkle((World)world, this.x2 - 1, this.y2, this.z2 + 1, References.META_WATER, 2);
                    Thaumcraft.proxy.blockSparkle((World)world, this.x2, this.y2, this.z2 - 1, References.META_WATER, 2);
                    Thaumcraft.proxy.blockSparkle((World)world, this.x2, this.y2, this.z2 + 1, References.META_WATER, 2);
                    Thaumcraft.proxy.blockSparkle((World)world, this.x2 + 1, this.y2, this.z2 - 1, References.META_WATER, 2);
                    Thaumcraft.proxy.blockSparkle((World)world, this.x2 + 1, this.y2, this.z2, References.META_WATER, 2);
                    Thaumcraft.proxy.blockSparkle((World)world, this.x2 + 1, this.y2, this.z2 + 1, References.META_WATER, 2);
                }
            }
        }
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    private void showBreakBlock(World world) {
        try {
            Block block = world.func_147439_a(this.x, this.y, this.z);
            int md = world.func_72805_g(this.x, this.y, this.z);
            Minecraft.func_71410_x().field_71452_i.func_147215_a(this.x, this.y, this.z, block, md);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void showBolt(World world, int color) {
        FXLightningBolt bolt = new FXLightningBolt(world, (double)this.x + 0.5, (double)this.y + 0.5, (double)this.z + 0.5, (double)this.x2 + 0.25 + (double)(world.field_73012_v.nextFloat() / 2.0f), (double)this.y2 + 0.25 + (double)(world.field_73012_v.nextFloat() / 2.0f), (double)this.z2 + 0.25 + (double)(world.field_73012_v.nextFloat() / 2.0f), world.field_73012_v.nextLong(), 20, 2.0f, 1);
        bolt.defaultFractal();
        bolt.setType(color);
        bolt.setWidth(0.015f);
        bolt.finalizeBolt();
    }

    @SideOnly(value=Side.CLIENT)
    private void showSmoke(World world) {
        world.func_72869_a("smoke", (double)this.x + 0.5, (double)this.y + 0.25 + world.field_73012_v.nextDouble(), (double)this.z, world.field_73012_v.nextGaussian() * 0.05, 0.005, world.field_73012_v.nextGaussian() * 0.05);
    }

    public static void sendToClients(int range, World world, int x, int y, int z, int x2, int y2, int z2, short id) {
        if (world.field_72995_K) {
            return;
        }
        int dim = world.field_73011_w.field_76574_g;
        NetworkRegistry.TargetPoint point = new NetworkRegistry.TargetPoint(dim, (double)x, (double)y, (double)z, (double)range);
        PacketHandler.INSTANCE.sendToAllAround((IMessage)new MessageParticles(dim, x, y, z, x2, y2, z2, id), point);
    }

    public static void sendToClients(World world, int x, int y, int z, int x2, int y2, int z2, short id) {
        MessageParticles.sendToClients(20, world, x, y, z, x2, y2, z2, id);
    }
}

