/*
 * Decompiled with CFR 0.152.
 */
package tuhljin.automagy.tiles;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import tuhljin.automagy.items.InventoryWithFilterOptions;
import tuhljin.automagy.items.ItemEnchantedPaper;
import tuhljin.automagy.lib.TjUtil;
import tuhljin.automagy.lib.inventory.FilteringItemList;
import tuhljin.automagy.lib.inventory.HashableItemWithoutSize;
import tuhljin.automagy.tiles.IContainsFilter;
import tuhljin.automagy.tiles.InventoryObjectFilter;
import tuhljin.automagy.tiles.TileEntityMawHungry;

public class TileEntityMawFinical
extends TileEntityMawHungry
implements IContainsFilter {
    public InventoryObjectFilter filterContainingInventory = new InventoryObjectFilter(this, "Finical Maw Filter", 1);
    private InventoryWithFilterOptions filter = null;
    private boolean filterIsBlacklist;
    private Pattern filterNamePattern;

    @Override
    protected ItemStack depositItem(ItemStack stack, IInventory inv, int side) {
        if (this.filter == null) {
            return super.depositItem(stack, inv, side);
        }
        int amt = Math.min(this.getMaxAllowedAfterFilter(stack, inv), stack.field_77994_a);
        ItemStack depositStack = stack.func_77946_l();
        depositStack.field_77994_a = amt;
        int remaining = stack.field_77994_a - amt;
        ItemStack leftovers = super.depositItem(depositStack, inv, side);
        if (leftovers != null) {
            remaining += leftovers.field_77994_a;
        }
        if (remaining < 1) {
            return null;
        }
        ItemStack newStack = stack.func_77946_l();
        newStack.field_77994_a = remaining;
        return newStack;
    }

    @Override
    public void onFilterInventoryChanged(int slot, ItemStack prevStack) {
        ItemStack stack = this.filterContainingInventory.func_70301_a(slot);
        if (stack == null) {
            this.filter = null;
        } else {
            this.filter = ItemEnchantedPaper.getFilterInventory(stack);
            if (this.filter != null) {
                this.filterIsBlacklist = stack.func_77960_j() == 2;
                this.filterNamePattern = this.filter.nameFilter.isEmpty() ? null : TjUtil.getSafePatternUsingAsteriskForWildcard(this.filter.nameFilter.toLowerCase());
            }
        }
    }

    @Override
    public void writeCustomNBT(NBTTagCompound nbttagcompound) {
        super.writeCustomNBT(nbttagcompound);
        this.filterContainingInventory.writeCustomNBT(nbttagcompound);
    }

    @Override
    public void readCustomNBT(NBTTagCompound nbttagcompound) {
        super.readCustomNBT(nbttagcompound);
        this.filterContainingInventory.readCustomNBT(nbttagcompound);
        ItemStack filterStack = this.filterContainingInventory.func_70301_a(0);
        if (filterStack == null) {
            this.filter = null;
        } else {
            this.filter = ItemEnchantedPaper.getFilterInventory(filterStack);
            if (this.filter != null) {
                this.filterIsBlacklist = filterStack.func_77960_j() == 2;
                this.filterNamePattern = this.filter.nameFilter.isEmpty() ? null : TjUtil.getSafePatternUsingAsteriskForWildcard(this.filter.nameFilter.toLowerCase());
            }
        }
    }

    private int getMaxAllowedAfterFilter(ItemStack keyStack, IInventory invDest) {
        ItemStack stack = null;
        boolean found = false;
        for (int i = 0; i < this.filter.func_70302_i_(); ++i) {
            stack = this.filter.func_70301_a(i);
            if (stack == null || stack.func_77973_b() != keyStack.func_77973_b() || !this.filter.ignoreMetadata && stack.func_77960_j() != keyStack.func_77960_j()) continue;
            if (this.filter.ignoreNBT) {
                found = true;
                break;
            }
            if (!ItemStack.func_77970_a((ItemStack)stack, (ItemStack)keyStack)) continue;
            found = true;
            break;
        }
        if (!found) {
            String name;
            Matcher m;
            if (this.filterNamePattern != null && (m = this.filterNamePattern.matcher(name = keyStack.func_82833_r().toLowerCase())).matches()) {
                return this.filterIsBlacklist ? 0 : Integer.MAX_VALUE;
            }
            return this.filterIsBlacklist ? Integer.MAX_VALUE : 0;
        }
        if (!this.filter.useItemCount) {
            return this.filterIsBlacklist ? 0 : Integer.MAX_VALUE;
        }
        if (this.filterIsBlacklist) {
            int qtyNeighborTotal = keyStack.field_77994_a;
            return qtyNeighborTotal - stack.field_77994_a;
        }
        FilteringItemList dest = new FilteringItemList().populateFromInventory(invDest, false);
        HashableItemWithoutSize item = new HashableItemWithoutSize(keyStack);
        int qtyHere = dest.get(item, this.filter.ignoreMetadata, this.filter.ignoreNBT);
        return stack.field_77994_a - qtyHere;
    }

    public boolean isUseableByPlayer(EntityPlayer player) {
        return this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e) == this && player.func_70092_e((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5) <= 64.0;
    }
}

