/*
 * Decompiled with CFR 0.152.
 */
package tuhljin.automagy.tiles;

import cpw.mods.fml.common.FMLLog;
import java.util.Iterator;
import java.util.Map;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.util.ForgeDirection;
import tuhljin.automagy.blocks.BlockTally;
import tuhljin.automagy.lib.IRestrictedInventoryAccess;
import tuhljin.automagy.lib.NeighborNotifier;
import tuhljin.automagy.lib.inventory.FilteringItemList;
import tuhljin.automagy.lib.inventory.HashableItemWithoutSize;
import tuhljin.automagy.lib.struct.WorldSpecificCoordinates;
import tuhljin.automagy.tiles.ModTileEntityWithFilterMainInventory;
import tuhljin.automagy.tiles.TileEntityRemoteComparator;

public class TileEntityTally
extends ModTileEntityWithFilterMainInventory
implements IRestrictedInventoryAccess {
    protected final int COOLDOWN_TIME = 10;
    public int targetX;
    public int targetY = -1;
    public int targetZ;
    public boolean requireAllMatches = true;
    protected int cooldown = -1;

    public TileEntityTally() {
        super("blockTally");
    }

    public void findNewTarget(boolean neighborMayBeRemoteComparator) {
        TileEntity te;
        this.cooldown = this.cooldown == -1 ? 5 + this.field_145850_b.field_73012_v.nextInt(5) : 10;
        int orientation = BlockTally.getOrientation((IBlockAccess)this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
        if (orientation == 0 && (te = this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d + 1, this.field_145849_e)) instanceof TileEntityRemoteComparator) {
            if (!neighborMayBeRemoteComparator) {
                return;
            }
            this.targetY = -1;
            WorldSpecificCoordinates coord = ((TileEntityRemoteComparator)te).getLinkLocation();
            if (((TileEntityRemoteComparator)te).coordinatesAreInRange(coord) && coord != null) {
                this.targetX = coord.x;
                this.targetY = coord.y;
                this.targetZ = coord.z;
            }
            this.calculateRedstoneSignalStrength();
            this.func_70296_d();
            return;
        }
        ForgeDirection dir = ForgeDirection.getOrientation((int)orientation).getOpposite();
        this.targetX = this.field_145851_c + dir.offsetX;
        this.targetY = this.field_145848_d + dir.offsetY;
        this.targetZ = this.field_145849_e + dir.offsetZ;
        this.calculateRedstoneSignalStrength();
        this.func_70296_d();
    }

    @Override
    public boolean canUpdate() {
        return true;
    }

    public void func_145845_h() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (this.cooldown > 0) {
            --this.cooldown;
            return;
        }
        this.cooldown = 10;
        this.calculateRedstoneSignalStrength();
    }

    private void calculateRedstoneSignalStrength() {
        if (this.filter == null) {
            this.setPower(false);
            return;
        }
        IInventory target = this.getTarget();
        if (target == null) {
            this.setPower(false);
            return;
        }
        boolean partialMatching = this.filterIsBlacklist ? !this.requireAllMatches : this.requireAllMatches;
        FilteringItemList invMap = new FilteringItemList().populateFromInventory(target, false);
        boolean anyQualify = false;
        int size = this.filter.func_70302_i_();
        for (int i = 0; i < size; ++i) {
            ItemStack stack = this.filter.func_70301_a(i);
            if (stack == null) continue;
            HashableItemWithoutSize item = new HashableItemWithoutSize(stack);
            int amt = invMap.get(item, this.filter.ignoreMetadata, this.filter.ignoreNBT);
            if (this.compare(amt, stack.field_77994_a)) {
                if (!partialMatching) {
                    this.setPower(true);
                    return;
                }
                anyQualify = true;
                continue;
            }
            if (!partialMatching) continue;
            this.setPower(false);
            return;
        }
        if (this.filterNamePattern == null) {
            this.setPower(anyQualify);
        } else {
            Iterator<Map.Entry<HashableItemWithoutSize, Integer>> iter = invMap.getIterator();
            while (iter.hasNext()) {
                Map.Entry<HashableItemWithoutSize, Integer> entry = iter.next();
                HashableItemWithoutSize key = entry.getKey();
                if (!this.nameFilterMatches(key)) continue;
                this.setPower(!this.filterIsBlacklist);
                return;
            }
            this.setPower(this.filterIsBlacklist);
        }
    }

    private boolean compare(int a, int b) {
        if (this.filter.useItemCount) {
            if (this.filterIsBlacklist) {
                return a < b;
            }
            return a >= b;
        }
        return this.filterIsBlacklist ? a == 0 : a > 0;
    }

    private void setPower(boolean enabled) {
        int md = this.func_145832_p();
        if (md > 5) {
            if (!enabled) {
                this.field_145850_b.func_72921_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, md - 6, 2);
                NeighborNotifier.notifyBlocksOfExtendedNeighborChange(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, this.func_145838_q());
            }
        } else if (enabled) {
            this.field_145850_b.func_72921_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, md + 6, 2);
            NeighborNotifier.notifyBlocksOfExtendedNeighborChange(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, this.func_145838_q());
        }
    }

    public IInventory getTarget() {
        if (this.targetY == -1) {
            return null;
        }
        TileEntity target = this.field_145850_b.func_147438_o(this.targetX, this.targetY, this.targetZ);
        if (target instanceof IInventory) {
            return (IInventory)target;
        }
        return null;
    }

    public void receiveGUIMessage(int type, boolean data) {
        switch (type) {
            case 0: {
                this.requireAllMatches = !data;
                break;
            }
            default: {
                FMLLog.warning((String)("[Automagy] TileEntityTally received invalid packet data. Ignoring. (type=" + type + ")"), (Object[])new Object[0]);
                return;
            }
        }
        this.markDirty(false);
    }

    @Override
    public void readCustomNBT(NBTTagCompound nbttagcompound) {
        super.readCustomNBT(nbttagcompound);
        this.targetX = nbttagcompound.func_74762_e("targetX");
        this.targetY = nbttagcompound.func_74762_e("targetY");
        this.targetZ = nbttagcompound.func_74762_e("targetZ");
        this.requireAllMatches = nbttagcompound.func_74767_n("requireAllMatches");
    }

    @Override
    public void writeCustomNBT(NBTTagCompound nbttagcompound) {
        super.writeCustomNBT(nbttagcompound);
        nbttagcompound.func_74768_a("targetX", this.targetX);
        nbttagcompound.func_74768_a("targetY", this.targetY);
        nbttagcompound.func_74768_a("targetZ", this.targetZ);
        nbttagcompound.func_74757_a("requireAllMatches", this.requireAllMatches);
    }

    @Override
    public boolean greedyChestCanSteal(TileEntity greedyChest, ForgeDirection fromSide) {
        return false;
    }
}

