/*
 * Decompiled with CFR 0.152.
 */
package tuhljin.automagy.lib;

import cpw.mods.fml.common.FMLLog;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import java.util.regex.Pattern;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.StatCollector;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import tuhljin.automagy.codechicken.lib.vec.BlockCoord;
import tuhljin.automagy.lib.inventory.HashableItemWithoutSize;

public class TjUtil {
    private static Random rand = new Random();
    public static final char decimalSeparator;

    public static void sendChatToPlayer(EntityPlayer player, String message) {
        message = StatCollector.func_74838_a((String)message);
        TjUtil.sendRawChatToPlayer(player, message, EnumChatFormatting.DARK_AQUA);
    }

    public static void sendFormattedChatToPlayer(EntityPlayer player, String message, Object ... data) {
        message = StatCollector.func_74837_a((String)message, (Object[])data);
        TjUtil.sendRawChatToPlayer(player, message, EnumChatFormatting.DARK_AQUA);
    }

    public static void sendRawChatToPlayer(EntityPlayer player, String message, EnumChatFormatting chatFormatting) {
        if (chatFormatting != null) {
            message = chatFormatting + message;
        }
        player.func_145747_a((IChatComponent)new ChatComponentText(message));
    }

    public static ArrayList<String> getMultiLineLocalizedString(String message) {
        message = StatCollector.func_74838_a((String)message);
        String[] s = message.split("\\\\n");
        ArrayList<String> lines = new ArrayList<String>(Arrays.asList(s));
        return lines;
    }

    public static Pattern getSafePatternUsingAsteriskForWildcard(String str) {
        Pattern p;
        String s = str.replaceAll("\\*+", ".*");
        s = Pattern.quote(s);
        s = s.replace(".*", "\\E.*\\Q");
        s = s.replace("\\Q\\E", "");
        try {
            p = Pattern.compile(s);
        }
        catch (Exception ex) {
            FMLLog.severe((String)("[Automagy] Failed to create regex pattern. Name filter will not function properly. String was: " + str), (Object[])new Object[0]);
            return null;
        }
        return p;
    }

    public static int getSideFromEntityFacing(EntityLivingBase entity) {
        int l = MathHelper.func_76128_c((double)((double)(entity.field_70177_z * 4.0f / 360.0f) + 2.5)) & 3;
        switch (l) {
            case 0: {
                return 2;
            }
            case 1: {
                return 5;
            }
            case 2: {
                return 3;
            }
            case 3: {
                return 4;
            }
        }
        return -1;
    }

    public static int getOppositeSide(int side) {
        return side <= ForgeDirection.OPPOSITES.length ? ForgeDirection.OPPOSITES[side] : 6;
    }

    public static int getSWNESide(int side) {
        switch (side) {
            case 2: {
                return 2;
            }
            case 3: {
                return 0;
            }
            case 4: {
                return 1;
            }
            case 5: {
                return 3;
            }
        }
        return -1;
    }

    public static boolean isEntityLookingDown(EntityLivingBase entity) {
        return entity.field_70125_A > 0.0f;
    }

    public static int getNextSideOnBlockFromDir(int side, int dir) {
        switch (side) {
            case 0: 
            case 1: {
                switch (dir) {
                    case 0: 
                    case 1: {
                        return 6;
                    }
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: {
                        return dir;
                    }
                }
                break;
            }
            case 2: 
            case 3: {
                switch (dir) {
                    case 0: {
                        return 0;
                    }
                    case 1: {
                        return 1;
                    }
                    case 2: 
                    case 3: {
                        return 6;
                    }
                    case 4: {
                        return 4;
                    }
                    case 5: {
                        return 5;
                    }
                }
                break;
            }
            case 4: 
            case 5: {
                switch (dir) {
                    case 0: {
                        return 0;
                    }
                    case 1: {
                        return 1;
                    }
                    case 2: {
                        return 2;
                    }
                    case 3: {
                        return 3;
                    }
                    case 4: 
                    case 5: {
                        return 6;
                    }
                }
            }
        }
        return 6;
    }

    public static float getDistanceBetweenPoints(int x1, int y1, int z1, int x2, int y2, int z2) {
        float f = (x1 - x2) * (x1 - x2) + (y1 - y2) * (y1 - y2) + (z1 - z2) * (z1 - z2);
        return MathHelper.func_76129_c((float)f);
    }

    public static double getDistanceBetweenPoints_double(double x1, double y1, double z1, double x2, double y2, double z2) {
        double f = (x1 - x2) * (x1 - x2) + (y1 - y2) * (y1 - y2) + (z1 - z2) * (z1 - z2);
        return MathHelper.func_76133_a((double)f);
    }

    public static void dropItemsIntoWorld(IInventory inventory, World world, int x, int y, int z, Block block) {
        if (inventory != null) {
            for (int i1 = 0; i1 < inventory.func_70302_i_(); ++i1) {
                ItemStack stack = inventory.func_70301_a(i1);
                if (stack == null) continue;
                TjUtil.dropItemIntoWorld(stack, world, x, y, z);
            }
            if (block != null) {
                world.func_147453_f(x, y, z, block);
            }
        }
    }

    public static void dropItemsIntoWorld(ArrayList<ItemStack> list, World world, int x, int y, int z) {
        if (list != null) {
            int size = list.size();
            for (int i1 = 0; i1 < size; ++i1) {
                ItemStack stack = list.get(i1);
                if (stack == null) continue;
                TjUtil.dropItemIntoWorld(stack, world, x, y, z);
            }
        }
    }

    public static EntityItem dropItemIntoWorld(ItemStack stack, World world, double x, double y, double z) {
        float f = rand.nextFloat() * 0.8f + 0.1f;
        float f1 = rand.nextFloat() * 0.8f + 0.1f;
        EntityItem entityitem = null;
        float f2 = rand.nextFloat() * 0.8f + 0.1f;
        while (stack.field_77994_a > 0) {
            int j1 = rand.nextInt(21) + 10;
            if (j1 > stack.field_77994_a) {
                j1 = stack.field_77994_a;
            }
            stack.field_77994_a -= j1;
            entityitem = new EntityItem(world, x + (double)f, y + (double)f1, z + (double)f2, new ItemStack(stack.func_77973_b(), j1, stack.func_77960_j()));
            float f3 = 0.05f;
            entityitem.field_70159_w = (float)rand.nextGaussian() * f3;
            entityitem.field_70181_x = (float)rand.nextGaussian() * f3 + 0.2f;
            entityitem.field_70179_y = (float)rand.nextGaussian() * f3;
            if (stack.func_77942_o()) {
                entityitem.func_92059_d().func_77982_d((NBTTagCompound)stack.func_77978_p().func_74737_b());
            }
            world.func_72838_d((Entity)entityitem);
        }
        return entityitem;
    }

    public static boolean canItemsStack(ItemStack stack1, ItemStack stack2) {
        return TjUtil.areItemsEqualIgnoringSize(stack1, stack2) && stack1.func_77985_e();
    }

    public static boolean areItemsEqualIgnoringSize(ItemStack stack1, ItemStack stack2) {
        return stack1 == null || stack2 == null || stack1.func_77973_b() == stack2.func_77973_b() && (!stack2.func_77981_g() || stack2.func_77960_j() == stack1.func_77960_j()) && ItemStack.func_77970_a((ItemStack)stack2, (ItemStack)stack1);
    }

    public static boolean isPlayerOnline(String name) {
        List players = MinecraftServer.func_71276_C().func_71203_ab().field_72404_b;
        for (EntityPlayerMP curr : players) {
            if (curr.func_70005_c_() != name) continue;
            return true;
        }
        return false;
    }

    public static boolean areFloatsAlmostEqual_lowprec(float f1, float f2) {
        float epsilon = 1.0E-5f;
        return Math.abs(f1 - f2) < epsilon;
    }

    public static BlockCoord getBlockCoordPlayerIsLookingAt(EntityPlayer player, World world) {
        float f8;
        float f6;
        double d3;
        float f5;
        if (player.field_70170_p != world && player.field_70170_p.field_73011_w.field_76574_g != world.field_73011_w.field_76574_g) {
            return null;
        }
        float f = 1.0f;
        float f1 = player.field_70127_C + (player.field_70125_A - player.field_70127_C) * f;
        float f2 = player.field_70126_B + (player.field_70177_z - player.field_70126_B) * f;
        double d0 = player.field_70169_q + (player.field_70165_t - player.field_70169_q) * (double)f;
        double d1 = player.field_70167_r + (player.field_70163_u - player.field_70167_r) * (double)f + 1.62 - (double)player.field_70129_M;
        double d2 = player.field_70166_s + (player.field_70161_v - player.field_70166_s) * (double)f;
        Vec3 vec3 = Vec3.func_72443_a((double)d0, (double)d1, (double)d2);
        float f3 = MathHelper.func_76134_b((float)(-f2 * ((float)Math.PI / 180) - (float)Math.PI));
        float f4 = MathHelper.func_76126_a((float)(-f2 * ((float)Math.PI / 180) - (float)Math.PI));
        float f7 = f4 * (f5 = -MathHelper.func_76134_b((float)(-f1 * ((float)Math.PI / 180))));
        Vec3 vec31 = vec3.func_72441_c((double)f7 * (d3 = 5.0), (double)(f6 = MathHelper.func_76126_a((float)(-f1 * ((float)Math.PI / 180)))) * d3, (double)(f8 = f3 * f5) * d3);
        MovingObjectPosition movingobjectposition = world.func_72901_a(vec3, vec31, true);
        if (movingobjectposition == null) {
            return null;
        }
        if (movingobjectposition.field_72313_a == MovingObjectPosition.MovingObjectType.BLOCK) {
            int ix = movingobjectposition.field_72311_b;
            int iy = movingobjectposition.field_72312_c;
            int iz = movingobjectposition.field_72309_d;
            return new BlockCoord(ix, iy, iz);
        }
        return null;
    }

    public static boolean isAcceptableSurfaceForBlock(World world, int x, int y, int z, boolean allowGlowstone, boolean allowGlass) {
        if (World.func_147466_a((IBlockAccess)world, (int)x, (int)y, (int)z)) {
            return true;
        }
        if (allowGlowstone || allowGlass) {
            Block block = world.func_147439_a(x, y, z);
            if (allowGlowstone && block == Blocks.field_150426_aN) {
                return true;
            }
            if (allowGlass && block == Blocks.field_150359_w) {
                return true;
            }
        }
        return false;
    }

    public static boolean playerHasItem(EntityPlayer player, HashableItemWithoutSize item) {
        InventoryPlayer inv = player.field_71071_by;
        for (int i = 0; i < inv.field_70462_a.length; ++i) {
            if (inv.field_70462_a[i] == null || !item.isSameItem(inv.field_70462_a[i])) continue;
            return true;
        }
        return false;
    }

    static {
        DecimalFormat format = (DecimalFormat)DecimalFormat.getInstance();
        decimalSeparator = format.getDecimalFormatSymbols().getDecimalSeparator();
    }
}

