/*
 * Decompiled with CFR 0.152.
 */
package tuhljin.automagy.tiles;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.AxisAlignedBB;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import tuhljin.automagy.codechicken.lib.vec.BlockCoord;
import tuhljin.automagy.gui.ContainerEagerChest;
import tuhljin.automagy.gui.ContainerEagerChestConfig;
import tuhljin.automagy.items.InventoryWithFilterOptions;
import tuhljin.automagy.items.ItemEnchantedPaper;
import tuhljin.automagy.lib.TjUtil;
import tuhljin.automagy.lib.inventory.FilteringItemList;
import tuhljin.automagy.lib.inventory.FilteringItemListLinked;
import tuhljin.automagy.lib.inventory.HashableItemWithoutSize;
import tuhljin.automagy.tiles.IChestWithFilter;
import tuhljin.automagy.tiles.InventoryObjectFilter;
import tuhljin.automagy.tiles.ModTileEntityWithInventory;

public class TileEntityEagerChest
extends ModTileEntityWithInventory
implements IChestWithFilter {
    private static final int NUM_FILTER_ITEMS = 4;
    private static final int ANTICIPATION_COOLDOWN_RESET = 200;
    private static final int MAX_PLAYER_SLOT = 35;
    public InventoryObjectFilter filterContainingInventory;
    public HashSet<String> validUsers = new HashSet();
    public boolean clientIsValidUser = false;
    private int ticksSinceSync = -1;
    public float lidAngle;
    public float prevLidAngle;
    private int numUsingPlayers;
    private int anticipationCooldown = 0;
    private EntityPlayer prevClosestPlayer = null;
    private int timeSneaking = 0;
    private InventoryWithFilterOptions[] filter = new InventoryWithFilterOptions[4];
    private boolean[] filterIsBlacklist = new boolean[4];
    private Pattern[] filterNamePattern = new Pattern[4];
    private static HashMap<HashableItemWithoutSize, Integer> defaultItemCache = null;

    public TileEntityEagerChest() {
        super("blockEagerChest", 27);
        this.filterContainingInventory = new InventoryObjectFilter(this, "Eager Chest Filter", 4);
    }

    @Override
    public boolean canUpdate() {
        return true;
    }

    public void func_145845_h() {
        float f;
        if (this.field_145850_b == null) {
            return;
        }
        if (!this.field_145850_b.field_72995_K && this.numUsingPlayers != 0 && (this.ticksSinceSync + this.field_145851_c + this.field_145848_d + this.field_145849_e) % 200 == 0) {
            this.numUsingPlayers = 0;
            f = 5.0f;
            List players = this.field_145850_b.func_72872_a(EntityPlayer.class, AxisAlignedBB.func_72330_a((double)((float)this.field_145851_c - f), (double)((float)this.field_145848_d - f), (double)((float)this.field_145849_e - f), (double)((float)(this.field_145851_c + 1) + f), (double)((float)(this.field_145848_d + 1) + f), (double)((float)(this.field_145849_e + 1) + f)));
            for (EntityPlayer p : players) {
                if (!(p.field_71070_bA instanceof ContainerEagerChest) || ((ContainerEagerChest)p.field_71070_bA).getTileEntity() != this) continue;
                ++this.numUsingPlayers;
            }
        }
        ++this.ticksSinceSync;
        this.prevLidAngle = this.lidAngle;
        f = 0.1f;
        if (this.numUsingPlayers > 0 && this.lidAngle == 0.0f) {
            double d = (double)this.field_145851_c + 0.5;
            double d1 = (double)this.field_145849_e + 0.5;
            this.field_145850_b.func_72908_a(d, (double)this.field_145848_d + 0.5, d1, "random.chestopen", 0.5f, this.field_145850_b.field_73012_v.nextFloat() * 0.1f + 0.9f);
        }
        if (this.numUsingPlayers == 0 && this.lidAngle > 0.0f || this.numUsingPlayers > 0 && this.lidAngle < 1.0f) {
            float f2;
            float f1 = this.lidAngle;
            this.lidAngle = this.numUsingPlayers > 0 ? (this.lidAngle += f) : (this.lidAngle -= f);
            if (this.lidAngle > 1.0f) {
                this.lidAngle = 1.0f;
            }
            if (this.lidAngle < (f2 = 0.5f) && f1 >= f2) {
                double d2 = (double)this.field_145851_c + 0.5;
                double d3 = (double)this.field_145849_e + 0.5;
                this.field_145850_b.func_72908_a(d2, (double)this.field_145848_d + 0.5, d3, "random.chestclosed", 0.5f, this.field_145850_b.field_73012_v.nextFloat() * 0.1f + 0.9f);
            }
            if (this.lidAngle < 0.0f) {
                this.lidAngle = 0.0f;
            }
        }
        if (this.field_145850_b.field_72995_K) {
            if (this.anticipationCooldown > 0) {
                --this.anticipationCooldown;
            } else if (this.numUsingPlayers == 0 && this.lidAngle < 0.01f) {
                EntityPlayer closestPlayer = this.field_145850_b.func_72977_a((double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, 7.0);
                if (closestPlayer != this.prevClosestPlayer) {
                    this.prevClosestPlayer = closestPlayer;
                    this.timeSneaking = 0;
                }
                if (!(closestPlayer == null || closestPlayer.field_71070_bA instanceof ContainerEagerChestConfig && ((ContainerEagerChestConfig)closestPlayer.field_71070_bA).getTileEntity() == this)) {
                    boolean sneak = closestPlayer.func_70093_af();
                    double d = closestPlayer.func_70092_e((double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e);
                    d = Math.max(50.0 - d, 0.0);
                    float angle = !sneak && this.isPlayerLookingAtThis(closestPlayer) ? (float)d / 800.0f : (float)d / 1200.0f;
                    if (sneak) {
                        ++this.timeSneaking;
                        if (this.timeSneaking > 40) {
                            float f2 = 1.0f - (float)(this.timeSneaking - 40) / 30.0f;
                            angle = Math.max(angle * f2, 0.0f);
                        }
                        this.lidAngle = Math.min(this.prevLidAngle, angle);
                    } else {
                        this.timeSneaking = 0;
                        this.lidAngle = angle;
                    }
                }
            }
        }
    }

    public boolean func_145842_c(int eventNum, int arg) {
        if (eventNum == 1) {
            this.numUsingPlayers = arg;
            return true;
        }
        return super.func_145842_c(eventNum, arg);
    }

    @Override
    public void func_70295_k_() {
        if (this.field_145850_b != null) {
            ++this.numUsingPlayers;
            this.field_145850_b.func_147452_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.func_145838_q(), 1, this.numUsingPlayers);
            if (this.field_145850_b.field_72995_K) {
                this.anticipationCooldown = 200;
            }
        }
    }

    @Override
    public void func_70305_f() {
        if (this.field_145850_b != null) {
            --this.numUsingPlayers;
            this.field_145850_b.func_147452_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.func_145838_q(), 1, this.numUsingPlayers);
            if (this.field_145850_b.field_72995_K && this.numUsingPlayers < 1) {
                this.anticipationCooldown = 200;
                this.prevClosestPlayer = null;
            }
        }
    }

    @Override
    public ItemStack func_70304_b(int par1) {
        if (this.inventorySlots[par1] != null) {
            ItemStack var2 = this.inventorySlots[par1];
            this.inventorySlots[par1] = null;
            return var2;
        }
        return null;
    }

    @Override
    public int getFacing() {
        return this.func_145832_p();
    }

    @Override
    public float getLidAngle() {
        return this.lidAngle;
    }

    @Override
    public float getPrevLidAngle() {
        return this.prevLidAngle;
    }

    public boolean isPlayerLookingAtThis(EntityPlayer player) {
        BlockCoord coord = TjUtil.getBlockCoordPlayerIsLookingAt(player, this.field_145850_b);
        return coord != null && coord.x == this.field_145851_c && coord.y == this.field_145848_d && coord.z == this.field_145849_e;
    }

    public boolean willTradeWithPlayer(EntityPlayer player) {
        String name = player.func_70005_c_();
        return this.validUsers.contains(name);
    }

    public void setTradeWithPlayer(EntityPlayer player, boolean allow) {
        String name = player.func_70005_c_();
        if (allow) {
            if (name != "Rcon") {
                this.validUsers.add(name);
            }
        } else if (this.validUsers.contains(name)) {
            this.validUsers.remove(name);
        }
        this.markDirty(false);
    }

    public void attemptTradeWithPlayer(EntityPlayer player) {
        if (!player.func_70093_af() && this.willTradeWithPlayer(player)) {
            InventoryPlayer inv = player.field_71071_by;
            FilteringItemListLinked playerInvMap = new FilteringItemListLinked().populateFromInventory((IInventory)inv, true);
            FilteringItemListLinked myInvMap = new FilteringItemListLinked().populateFromInventory((IInventory)this, true);
            boolean giveFilter = this.filter[0] != null || this.filter[1] != null;
            boolean takeFilter = this.filter[2] != null || this.filter[3] != null;
            boolean didTeleport = false;
            if (takeFilter || !giveFilter) {
                didTeleport = this.doInventoryTransfer((IInventory)inv, 35, (IInventory)this, -1, playerInvMap, myInvMap, 2, 3, !takeFilter);
            }
            if (giveFilter || !takeFilter) {
                boolean bl = didTeleport = this.doInventoryTransfer((IInventory)this, -1, (IInventory)inv, 35, myInvMap, playerInvMap, 0, 1, !giveFilter) || didTeleport;
            }
            if (takeFilter || !giveFilter) {
                didTeleport = this.doInventoryTransfer((IInventory)inv, 35, (IInventory)this, -1, playerInvMap, myInvMap, 2, 3, !takeFilter) || didTeleport;
            }
            inv.func_70296_d();
            this.func_70296_d();
            if (didTeleport) {
                this.field_145850_b.func_72908_a((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5, "mob.endermen.portal", 0.5f, this.field_145850_b.field_73012_v.nextFloat() * 0.1f + 0.9f);
            }
        }
    }

    private boolean doInventoryTransfer(IInventory source, int sourceMaxSlot, IInventory dest, int destMaxSlot, FilteringItemListLinked sMap, FilteringItemListLinked dMap, int minFilterSlot, int maxFilterSlot, boolean defaultFilter) {
        boolean reverse;
        if (sourceMaxSlot == -1) {
            reverse = false;
            sourceMaxSlot = source.func_70302_i_() - 1;
        } else {
            reverse = true;
        }
        boolean didTeleport = false;
        Iterator<Map.Entry<HashableItemWithoutSize, Integer>> iter = sMap.getIterator();
        while (iter.hasNext()) {
            Map.Entry<HashableItemWithoutSize, Integer> entry = iter.next();
            HashableItemWithoutSize key = entry.getKey();
            int qtySource = entry.getValue();
            int qtyDestination = dMap.get(key);
            int toTake = defaultFilter ? this.getMaxToMoveAfterDefaultFilter(key, source == this) : this.getMaxToMoveAfterFilter(minFilterSlot, maxFilterSlot, key, sMap, dMap);
            if (toTake <= 0) continue;
            int took = 0;
            for (int i = 0; i <= sourceMaxSlot; ++i) {
                int slot = reverse ? sourceMaxSlot - i : i;
                ItemStack stack = source.func_70301_a(slot);
                if (stack != null && stack.field_77994_a > 0 && this.filterSensitiveIsSameItem(key, stack, minFilterSlot, maxFilterSlot) && (stack = source.func_70298_a(slot, Math.min(toTake - took, stack.field_77994_a))) != null && stack.field_77994_a > 0) {
                    took += stack.field_77994_a;
                    this.addToInventory(stack, dest, destMaxSlot);
                    didTeleport = true;
                }
                if (toTake - took < 1) break;
            }
            if (took == 0) continue;
            sMap.set(key, qtySource -= took, true);
            dMap.set(key, qtyDestination += took, true);
        }
        return didTeleport;
    }

    protected boolean filterSensitiveIsSameItem(HashableItemWithoutSize item, ItemStack stack, int minFilterSlot, int maxFilterSlot) {
        for (int fs = minFilterSlot; fs <= maxFilterSlot; ++fs) {
            boolean ignoreNBT;
            boolean ignoreMetadata = this.filter[fs] != null && this.filter[fs].ignoreMetadata;
            boolean bl = ignoreNBT = this.filter[fs] != null && this.filter[fs].ignoreNBT;
            if (!item.isSameItem(stack, ignoreMetadata, ignoreNBT)) continue;
            return true;
        }
        return false;
    }

    public void addToInventory(ItemStack stack, IInventory inv, int maxSlot) {
        ItemStack slottedStack;
        int slot;
        int i;
        boolean reverse;
        if (maxSlot == -1) {
            reverse = false;
            maxSlot = inv.func_70302_i_() - 1;
        } else {
            reverse = true;
        }
        if (stack.func_77985_e() && stack.func_77976_d() > 1) {
            for (i = 0; i <= maxSlot; ++i) {
                slot = reverse ? maxSlot - i : i;
                slottedStack = inv.func_70301_a(slot);
                if (slottedStack == null || !TjUtil.canItemsStack(stack, slottedStack)) continue;
                int newSize = stack.field_77994_a + slottedStack.field_77994_a;
                int stacksTo = Math.min(stack.func_77976_d(), inv.func_70297_j_());
                if (newSize <= stacksTo) {
                    slottedStack.field_77994_a = newSize;
                    inv.func_70299_a(slot, slottedStack);
                    return;
                }
                if (slottedStack.field_77994_a >= stacksTo) continue;
                stack.field_77994_a = newSize - stacksTo;
                slottedStack.field_77994_a = stacksTo;
                inv.func_70299_a(slot, slottedStack);
            }
        }
        for (i = 0; i <= maxSlot; ++i) {
            slot = reverse ? maxSlot - i : i;
            slottedStack = inv.func_70301_a(slot);
            if (slottedStack != null) continue;
            inv.func_70299_a(slot, stack);
            return;
        }
        TjUtil.dropItemIntoWorld(stack, this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    public void receiveUserValidityFromServer(boolean clientIsValidUser) {
        this.clientIsValidUser = clientIsValidUser;
    }

    private int getMaxToMoveAfterDefaultFilter(HashableItemWithoutSize item, boolean giving) {
        int val;
        if (defaultItemCache == null) {
            defaultItemCache = new HashMap();
            defaultItemCache.put(new HashableItemWithoutSize(new ItemStack(Blocks.field_150346_d)), 1);
            defaultItemCache.put(new HashableItemWithoutSize(new ItemStack(Blocks.field_150348_b)), 1);
            defaultItemCache.put(new HashableItemWithoutSize(new ItemStack(Blocks.field_150347_e)), 1);
            defaultItemCache.put(new HashableItemWithoutSize(new ItemStack(Blocks.field_150351_n)), 1);
        }
        if (!defaultItemCache.containsKey(item)) {
            AspectList aspects = new AspectList(item.getItemStack(1));
            val = aspects.getAmount(Aspect.GREED) > 0 ? 2 : 0;
            defaultItemCache.put(item, val);
        } else {
            val = defaultItemCache.get(item);
        }
        if (giving) {
            return val == 1 ? Integer.MAX_VALUE : 0;
        }
        return val == 2 ? Integer.MAX_VALUE : 0;
    }

    private int getMaxToMoveAfterFilter(int minFilterSlot, int maxFilterSlot, HashableItemWithoutSize item, FilteringItemList source, FilteringItemList dest) {
        int fs;
        ItemStack keyStack = null;
        ItemStack stack = null;
        int found = -1;
        block0: for (fs = minFilterSlot; fs <= maxFilterSlot; ++fs) {
            if (this.filter[fs] == null) continue;
            for (int i = 0; i < this.filter[fs].func_70302_i_(); ++i) {
                stack = this.filter[fs].func_70301_a(i);
                if (stack == null || stack.func_77973_b() != item.getItem() || !this.filter[fs].ignoreMetadata && stack.func_77960_j() != item.damage) continue;
                if (this.filter[fs].ignoreNBT) {
                    found = fs;
                    break block0;
                }
                if (keyStack == null) {
                    keyStack = item.getItemStack(1);
                }
                if (!ItemStack.func_77970_a((ItemStack)stack, (ItemStack)keyStack)) continue;
                found = fs;
                break block0;
            }
        }
        if (found == -1) {
            for (fs = minFilterSlot; fs <= maxFilterSlot; ++fs) {
                String name;
                Matcher m;
                if (this.filter[fs] == null || this.filterNamePattern[fs] == null) continue;
                if (keyStack == null) {
                    keyStack = item.getItemStack(1);
                }
                if (!(m = this.filterNamePattern[fs].matcher(name = keyStack.func_82833_r().toLowerCase())).matches()) continue;
                return this.filterIsBlacklist[fs] ? 0 : Integer.MAX_VALUE;
            }
            for (fs = minFilterSlot; fs <= maxFilterSlot; ++fs) {
                if (this.filter[fs] == null || this.filterIsBlacklist[fs]) continue;
                return 0;
            }
            return Integer.MAX_VALUE;
        }
        if (!this.filter[found].useItemCount) {
            return this.filterIsBlacklist[found] ? 0 : Integer.MAX_VALUE;
        }
        if (this.filterIsBlacklist[found]) {
            int qtySource = source.get(item, this.filter[found].ignoreMetadata, this.filter[found].ignoreNBT);
            return qtySource - stack.field_77994_a;
        }
        int qtyDestination = dest.get(item, this.filter[found].ignoreMetadata, this.filter[found].ignoreNBT);
        return stack.field_77994_a - qtyDestination;
    }

    protected LinkedHashMap<HashableItemWithoutSize, Integer> getMappedInventory(IInventory inv, boolean ignoreMeta, boolean ignoreNBT) {
        int size = inv.func_70302_i_();
        LinkedHashMap<HashableItemWithoutSize, Integer> map = new LinkedHashMap<HashableItemWithoutSize, Integer>();
        for (int i1 = 0; i1 < size; ++i1) {
            ItemStack stack = inv.func_70301_a(i1);
            if (stack == null) continue;
            if (ignoreMeta) {
                ItemStack newStack = new ItemStack(stack.func_77973_b(), 1, 0);
                if (!ignoreNBT && stack.func_77942_o()) {
                    newStack.func_77982_d(stack.func_77978_p());
                }
                stack = newStack;
            } else if (ignoreNBT && stack.func_77942_o()) {
                stack.func_77982_d(null);
            }
            HashableItemWithoutSize item = new HashableItemWithoutSize(stack);
            if (map.containsKey(item)) {
                map.put(item, map.get(item) + stack.field_77994_a);
                continue;
            }
            map.put(item, stack.field_77994_a);
        }
        return map;
    }

    @Override
    public void onFilterInventoryChanged(int slot, ItemStack prevStack) {
        ItemStack stack = this.filterContainingInventory.func_70301_a(slot);
        if (stack == null) {
            this.filter[slot] = null;
        } else {
            this.filter[slot] = ItemEnchantedPaper.getFilterInventory(stack);
            if (this.filter[slot] != null) {
                this.filterIsBlacklist[slot] = stack.func_77960_j() == 2;
                this.filterNamePattern[slot] = this.filter[slot].nameFilter.isEmpty() ? null : TjUtil.getSafePatternUsingAsteriskForWildcard(this.filter[slot].nameFilter.toLowerCase());
            }
        }
    }

    @Override
    public void writeCustomNBT(NBTTagCompound nbttagcompound) {
        super.writeCustomNBT(nbttagcompound);
        this.filterContainingInventory.writeCustomNBT(nbttagcompound);
        NBTTagList nbttaglist = new NBTTagList();
        for (String name : this.validUsers) {
            if (name == null || name.isEmpty()) continue;
            NBTTagCompound tagList = new NBTTagCompound();
            tagList.func_74778_a("User", name);
            nbttaglist.func_74742_a((NBTBase)tagList);
        }
        nbttagcompound.func_74782_a("ValidUsers", (NBTBase)nbttaglist);
    }

    @Override
    public void readCustomNBT(NBTTagCompound nbttagcompound) {
        super.readCustomNBT(nbttagcompound);
        this.filterContainingInventory.readCustomNBT(nbttagcompound);
        for (int slot = 0; slot < 4; ++slot) {
            ItemStack filterStack = this.filterContainingInventory.func_70301_a(slot);
            if (filterStack == null) {
                this.filter[slot] = null;
                continue;
            }
            this.filter[slot] = ItemEnchantedPaper.getFilterInventory(filterStack);
            if (this.filter[slot] == null) continue;
            this.filterIsBlacklist[slot] = filterStack.func_77960_j() == 2;
            this.filterNamePattern[slot] = this.filter[slot].nameFilter.isEmpty() ? null : TjUtil.getSafePatternUsingAsteriskForWildcard(this.filter[slot].nameFilter.toLowerCase());
        }
        NBTTagList nbttaglist = nbttagcompound.func_150295_c("ValidUsers", 10);
        this.validUsers.clear();
        int size = nbttaglist.func_74745_c();
        for (int i = 0; i < size; ++i) {
            NBTTagCompound tagList = nbttaglist.func_150305_b(i);
            String name = tagList.func_74779_i("User");
            if (name == null || name.isEmpty()) continue;
            this.validUsers.add(name);
        }
    }
}

