/*
 * Decompiled with CFR 0.152.
 */
package tuhljin.automagy.tiles;

import java.util.ArrayList;
import java.util.HashSet;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.util.ForgeDirection;
import thaumcraft.api.ItemApi;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.common.Thaumcraft;
import thaumcraft.common.blocks.BlockCrystal;
import thaumcraft.common.blocks.BlockWoodenDevice;
import thaumcraft.common.entities.EntityAspectOrb;
import thaumcraft.common.tiles.TileJarFillable;
import tuhljin.automagy.blocks.ModBlocks;
import tuhljin.automagy.codechicken.lib.vec.BlockCoord;
import tuhljin.automagy.items.ItemCrystalEye;
import tuhljin.automagy.lib.References;
import tuhljin.automagy.lib.ThaumcraftExtension;
import tuhljin.automagy.lib.TjUtil;
import tuhljin.automagy.lib.struct.WorldSpecificCoordinates;
import tuhljin.automagy.network.MessageParticles;
import tuhljin.automagy.tiles.IAspectContainerWithMax;
import tuhljin.automagy.tiles.IContainsEyes;
import tuhljin.automagy.tiles.InventoryObjectEyes;
import tuhljin.automagy.tiles.ModTileEntity;

public class TileEntityEssentiaLocus
extends ModTileEntity
implements IAspectContainerWithMax,
IContainsEyes {
    public static int MAXJARS_START = 12;
    public static int MAXJARS_INC_CLUSTER = 8;
    public static int MAXDISTANCE_START = 20;
    public static int MAXDISTANCE_INC_CLUSTER = 8;
    public int maxJars;
    public int maxEyes = 1;
    public int maxDistance;
    public InventoryObjectEyes eyesContainingInventory;
    protected AspectList aspects = new AspectList();
    protected AspectList maxAspectSpaceByType = new AspectList();
    protected int maxAspectSpaceUnclaimed;
    private int ticks;
    public static int JARS_UPDATE_FREQUENCY_CAP = 200;
    private int jarsUpdateFrequency;
    private int ticksSinceJarsUpdate = this.jarsUpdateFrequency = 40;
    public static int VALIDITY_CHECK_FREQUENCY = 60;
    private int ticksSinceValidityCheck;
    public int ticksToAnim = 0;
    private Object beam = null;
    protected HashSet<BlockCoord> jars = new HashSet();
    protected int eyeCount = 0;
    public static int rotationSpeedFactor = 3240;
    public static double clientRenderFloatingTop = 0.1;
    public static double clientRenderFloatingBtm = -0.3;
    public int clientRenderRotationHelper = 0;
    public double clientRenderFloatingDistance = clientRenderFloatingTop;
    public boolean clientRenderGoingUp = false;

    public TileEntityEssentiaLocus() {
        this.eyesContainingInventory = new InventoryObjectEyes(this, "Essentia Locus", 40, true);
    }

    @Override
    public int getMaxDistance() {
        return this.maxDistance;
    }

    @Override
    public BlockCoord getPosition() {
        return new BlockCoord(this);
    }

    public int getEyeCount() {
        return this.eyeCount;
    }

    public ItemStack removeEye() {
        if (this.eyeCount > 0) {
            int slot = this.eyeCount - 1;
            ItemStack stack = this.eyesContainingInventory.func_70301_a(slot);
            this.eyesContainingInventory.func_70299_a(slot, null);
            --this.eyeCount;
            this.func_70296_d();
            this.ticksSinceJarsUpdate = this.jarsUpdateFrequency;
            return stack;
        }
        return null;
    }

    public boolean insertEye(ItemStack stack) {
        if (this.eyeCount < this.maxEyes) {
            this.eyesContainingInventory.func_70299_a(this.eyeCount, stack.func_77979_a(1));
            ++this.eyeCount;
            this.func_70296_d();
            this.ticksSinceJarsUpdate = this.jarsUpdateFrequency;
            return true;
        }
        return false;
    }

    public boolean itemIsValidEye(ItemStack stack) {
        return this.eyesContainingInventory.func_94041_b(this.eyeCount, stack);
    }

    private int removeInvalidEyes() {
        ArrayList<ItemStack> list = this.eyesContainingInventory.removeInvalidEyes();
        int count = list.size();
        if (count > 0) {
            this.eyeCount -= count;
            this.eyesContainingInventory.organizeSlots();
            this.func_70296_d();
            TjUtil.dropItemsIntoWorld(list, this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
            this.ticksSinceJarsUpdate = this.jarsUpdateFrequency;
        }
        return count;
    }

    @Override
    public boolean canUpdate() {
        return true;
    }

    public void func_145845_h() {
        if (!this.field_145850_b.field_72995_K) {
            if (this.ticksSinceValidityCheck >= VALIDITY_CHECK_FREQUENCY) {
                this.ticksSinceValidityCheck = 0;
                if (!TileEntityEssentiaLocus.checkValidity((IBlockAccess)this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, false)) {
                    this.func_145838_q().func_149697_b(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, 0, 0);
                    this.field_145850_b.func_147468_f(this.field_145851_c, this.field_145848_d, this.field_145849_e);
                    return;
                }
                this.checkMaxes();
            } else {
                ++this.ticksSinceValidityCheck;
            }
            if (this.ticksSinceJarsUpdate >= this.jarsUpdateFrequency) {
                this.ticksSinceJarsUpdate = 0;
                this.jarsUpdateFrequency = !this.findJars() ? Math.min(this.jarsUpdateFrequency + 20, JARS_UPDATE_FREQUENCY_CAP) : 20;
            } else if (this.eyeCount > 0) {
                ++this.ticksSinceJarsUpdate;
            }
            if (this.field_145850_b.field_73012_v.nextInt(1000) == 0) {
                EntityAspectOrb orb = new EntityAspectOrb(this.field_145850_b, (double)this.field_145851_c + 0.5, (double)this.field_145848_d - 0.5, (double)this.field_145849_e + 0.5, Aspect.WATER, 1);
                this.field_145850_b.func_72838_d((Entity)orb);
            }
            ++this.ticks;
            if (this.ticks % 2 == 0) {
                AspectList aspectsNew = new AspectList();
                this.maxAspectSpaceByType.aspects.clear();
                this.maxAspectSpaceUnclaimed = 0;
                for (BlockCoord bc : this.jars) {
                    TileEntity te = this.field_145850_b.func_147438_o(bc.x, bc.y, bc.z);
                    if (te instanceof TileJarFillable) {
                        TileJarFillable jar = (TileJarFillable)te;
                        Aspect jarContains = jar.aspect;
                        if (jarContains != null) {
                            if (jar.amount > 0) {
                                aspectsNew.add(jarContains, jar.amount);
                            }
                            this.maxAspectSpaceByType.add(jarContains, jar.maxAmount);
                            continue;
                        }
                        if (jar.aspectFilter != null) {
                            this.maxAspectSpaceByType.add(jar.aspectFilter, jar.maxAmount);
                            continue;
                        }
                        this.maxAspectSpaceUnclaimed += jar.maxAmount;
                        continue;
                    }
                    if (!this.field_145850_b.func_72938_d((int)bc.x, (int)bc.z).field_76636_d) continue;
                    this.ticksSinceJarsUpdate = this.jarsUpdateFrequency;
                }
                if (!ThaumcraftExtension.areAspectListsIdentical(this.aspects, aspectsNew)) {
                    this.aspects = aspectsNew;
                    this.func_70296_d();
                }
            }
        } else {
            if (this.ticksToAnim > 0) {
                --this.ticksToAnim;
                this.beam = Thaumcraft.proxy.beamBore(this.field_145850_b, (double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.7, (double)this.field_145849_e + 0.5, (double)this.field_145851_c + 0.5, (double)(this.field_145848_d - 2), (double)this.field_145849_e + 0.5, 10, 13260, true, 10.0f, this.beam, 0);
            }
            this.clientRenderRotationHelper += 3;
            if (this.clientRenderRotationHelper >= rotationSpeedFactor) {
                this.clientRenderRotationHelper -= rotationSpeedFactor;
            }
            double adj = 0.0;
            if (this.clientRenderFloatingDistance < clientRenderFloatingBtm) {
                this.clientRenderGoingUp = true;
            } else if (this.clientRenderFloatingDistance > clientRenderFloatingTop) {
                this.clientRenderGoingUp = false;
            }
            this.clientRenderFloatingDistance += (adj += this.clientRenderGoingUp ? 0.002 : -0.002);
        }
    }

    protected boolean findJars() {
        boolean differenceFound = false;
        HashSet<BlockCoord> newJars = new HashSet<BlockCoord>();
        for (int slot = 0; slot < this.eyeCount; ++slot) {
            BlockCoord bc;
            ItemStack stack = this.eyesContainingInventory.func_70301_a(slot);
            if (stack == null) continue;
            WorldSpecificCoordinates coord = ((ItemCrystalEye)stack.func_77973_b()).getLinkLocation(stack);
            TileEntity te = this.field_145850_b.func_147438_o(coord.x, coord.y, coord.z);
            if (!(te instanceof TileJarFillable) || newJars.contains(bc = new BlockCoord(te))) continue;
            if (!this.jars.contains(bc)) {
                differenceFound = true;
            }
            newJars.add(bc);
            if (newJars.size() >= this.maxJars) break;
            if (this.findJarsHelper(newJars, coord.x, coord.y, coord.z)) {
                differenceFound = true;
            }
            if (newJars.size() >= this.maxJars) break;
        }
        if (!differenceFound && this.jars.size() != newJars.size()) {
            differenceFound = true;
        }
        this.jars = newJars;
        return differenceFound;
    }

    private boolean findJarsHelper(HashSet<BlockCoord> newJars, int x, int y, int z) {
        boolean newJarFound = false;
        for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
            BlockCoord bc;
            int x2 = x + dir.offsetX;
            int y2 = y + dir.offsetY;
            int z2 = z + dir.offsetZ;
            TileEntity te = this.field_145850_b.func_147438_o(x2, y2, z2);
            if (!(te instanceof TileJarFillable) || newJars.contains(bc = new BlockCoord(te))) continue;
            if (!this.jars.contains(bc)) {
                newJarFound = true;
            }
            newJars.add(bc);
            if (newJars.size() >= this.maxJars) break;
            if (this.findJarsHelper(newJars, x2, y2, z2)) {
                newJarFound = true;
            }
            if (newJars.size() >= this.maxJars) break;
        }
        return newJarFound;
    }

    public void checkMaxes() {
        int clusters = 0;
        clusters += this.numWaterClustersNear(this.field_145851_c - 2, this.field_145848_d - 2, this.field_145849_e - 1);
        clusters += this.numWaterClustersNear(this.field_145851_c - 2, this.field_145848_d - 2, this.field_145849_e);
        clusters += this.numWaterClustersNear(this.field_145851_c - 2, this.field_145848_d - 2, this.field_145849_e + 1);
        clusters += this.numWaterClustersNear(this.field_145851_c + 2, this.field_145848_d - 2, this.field_145849_e - 1);
        clusters += this.numWaterClustersNear(this.field_145851_c + 2, this.field_145848_d - 2, this.field_145849_e);
        clusters += this.numWaterClustersNear(this.field_145851_c + 2, this.field_145848_d - 2, this.field_145849_e + 1);
        clusters += this.numWaterClustersNear(this.field_145851_c - 1, this.field_145848_d - 2, this.field_145849_e - 2);
        clusters += this.numWaterClustersNear(this.field_145851_c, this.field_145848_d - 2, this.field_145849_e - 2);
        clusters += this.numWaterClustersNear(this.field_145851_c + 1, this.field_145848_d - 2, this.field_145849_e - 2);
        clusters += this.numWaterClustersNear(this.field_145851_c - 1, this.field_145848_d - 2, this.field_145849_e + 2);
        clusters += this.numWaterClustersNear(this.field_145851_c, this.field_145848_d - 2, this.field_145849_e + 2);
        int oldJ = this.maxJars;
        this.maxJars = MAXJARS_START + (clusters += this.numWaterClustersNear(this.field_145851_c + 1, this.field_145848_d - 2, this.field_145849_e + 2)) * MAXJARS_INC_CLUSTER;
        if (this.maxJars != oldJ) {
            this.ticksSinceJarsUpdate = this.jarsUpdateFrequency;
        }
        int numEyesOut = 0;
        int oldD = this.maxDistance;
        this.maxDistance = MAXDISTANCE_START + clusters * MAXDISTANCE_INC_CLUSTER;
        if (this.maxDistance < oldD) {
            numEyesOut = this.removeInvalidEyes();
        }
        this.maxEyes = 1 + clusters;
        if (this.eyeCount > this.maxEyes && !this.field_145850_b.field_72995_K) {
            ItemStack stack;
            int size = this.eyesContainingInventory.func_70302_i_();
            for (int i = this.maxEyes; i < size && (stack = this.eyesContainingInventory.func_70301_a(i)) != null; ++i) {
                this.eyesContainingInventory.func_70299_a(i, null);
                --this.eyeCount;
                TjUtil.dropItemIntoWorld(stack, this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
                ++numEyesOut;
            }
            this.func_70296_d();
        }
        for (int i = 0; i < numEyesOut; ++i) {
            this.field_145850_b.func_72908_a((double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, "random.pop", 0.2f, ((this.field_145850_b.field_73012_v.nextFloat() - this.field_145850_b.field_73012_v.nextFloat()) * 0.7f + 1.0f) * 1.5f);
        }
    }

    public static boolean checkValidity(IBlockAccess blockaccess, int x, int y, int z, boolean placementCheck) {
        if (placementCheck) {
            ItemStack crystal = ItemApi.getBlock((String)"blockCrystal", (int)References.META_WATER);
            if (blockaccess.func_147439_a(x, y - 1, z) != Block.func_149634_a((Item)crystal.func_77973_b()) || blockaccess.func_72805_g(x, y - 1, z) != References.META_WATER) {
                return false;
            }
        } else if (!blockaccess.func_147437_c(x, y - 1, z)) {
            return false;
        }
        if (!(blockaccess.func_147437_c(x - 1, y - 1, z - 1) && blockaccess.func_147437_c(x - 1, y - 1, z) && blockaccess.func_147437_c(x - 1, y - 1, z + 1) && blockaccess.func_147437_c(x, y - 1, z - 1) && blockaccess.func_147437_c(x, y - 1, z + 1) && blockaccess.func_147437_c(x + 1, y - 1, z - 1) && blockaccess.func_147437_c(x + 1, y - 1, z) && blockaccess.func_147437_c(x + 1, y - 1, z + 1) && blockaccess.func_147437_c(x - 1, y, z - 1) && blockaccess.func_147437_c(x - 1, y, z) && blockaccess.func_147437_c(x - 1, y, z + 1) && blockaccess.func_147437_c(x, y, z - 1) && blockaccess.func_147437_c(x, y, z + 1) && blockaccess.func_147437_c(x + 1, y, z - 1) && blockaccess.func_147437_c(x + 1, y, z) && blockaccess.func_147437_c(x + 1, y, z + 1))) {
            return false;
        }
        if (blockaccess.func_147439_a(x, y - 2, z) != Blocks.field_150368_y) {
            return false;
        }
        if (!(TileEntityEssentiaLocus.blockIsWater(blockaccess, x - 1, y - 2, z - 1, placementCheck) && TileEntityEssentiaLocus.blockIsWater(blockaccess, x - 1, y - 2, z, placementCheck) && TileEntityEssentiaLocus.blockIsWater(blockaccess, x - 1, y - 2, z + 1, placementCheck) && TileEntityEssentiaLocus.blockIsWater(blockaccess, x, y - 2, z - 1, placementCheck) && TileEntityEssentiaLocus.blockIsWater(blockaccess, x, y - 2, z + 1, placementCheck) && TileEntityEssentiaLocus.blockIsWater(blockaccess, x + 1, y - 2, z - 1, placementCheck) && TileEntityEssentiaLocus.blockIsWater(blockaccess, x + 1, y - 2, z, placementCheck) && TileEntityEssentiaLocus.blockIsWater(blockaccess, x + 1, y - 2, z + 1, placementCheck))) {
            return false;
        }
        return TileEntityEssentiaLocus.blockIsSilverwoodPlank(blockaccess, x - 2, y - 2, z - 1) && TileEntityEssentiaLocus.blockIsSilverwoodPlank(blockaccess, x - 2, y - 2, z) && TileEntityEssentiaLocus.blockIsSilverwoodPlank(blockaccess, x - 2, y - 2, z + 1) && TileEntityEssentiaLocus.blockIsSilverwoodPlank(blockaccess, x + 2, y - 2, z - 1) && TileEntityEssentiaLocus.blockIsSilverwoodPlank(blockaccess, x + 2, y - 2, z) && TileEntityEssentiaLocus.blockIsSilverwoodPlank(blockaccess, x + 2, y - 2, z + 1) && TileEntityEssentiaLocus.blockIsSilverwoodPlank(blockaccess, x - 1, y - 2, z - 2) && TileEntityEssentiaLocus.blockIsSilverwoodPlank(blockaccess, x, y - 2, z - 2) && TileEntityEssentiaLocus.blockIsSilverwoodPlank(blockaccess, x + 1, y - 2, z - 2) && TileEntityEssentiaLocus.blockIsSilverwoodPlank(blockaccess, x - 1, y - 2, z + 2) && TileEntityEssentiaLocus.blockIsSilverwoodPlank(blockaccess, x, y - 2, z + 2) && TileEntityEssentiaLocus.blockIsSilverwoodPlank(blockaccess, x + 1, y - 2, z + 2);
    }

    private static boolean blockIsSilverwoodPlank(IBlockAccess blockaccess, int x, int y, int z) {
        return blockaccess.func_147439_a(x, y, z) instanceof BlockWoodenDevice && blockaccess.func_72805_g(x, y, z) == 7;
    }

    protected static boolean blockIsWater(IBlockAccess blockaccess, int x, int y, int z, boolean sourceOnly) {
        Block block = blockaccess.func_147439_a(x, y, z);
        if (block == Blocks.field_150355_j) {
            return !sourceOnly || blockaccess.func_72805_g(x, y, z) == 0;
        }
        return !sourceOnly && block == Blocks.field_150358_i;
    }

    private int numWaterClustersNear(int x, int y, int z) {
        int count = 0;
        for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
            int x2 = x + dir.offsetX;
            int y2 = y + dir.offsetY;
            int z2 = z + dir.offsetZ;
            if (!(this.field_145850_b.func_147439_a(x2, y2, z2) instanceof BlockCrystal) || this.field_145850_b.func_72805_g(x2, y2, z2) != References.META_WATER) continue;
            ++count;
        }
        return count;
    }

    public void beginPlacementProcess() {
        ItemStack crystal = ItemApi.getBlock((String)"blockCrystal", (int)References.META_WATER);
        if (this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d - 1, this.field_145849_e) != Block.func_149634_a((Item)crystal.func_77973_b()) || this.field_145850_b.func_72805_g(this.field_145851_c, this.field_145848_d - 1, this.field_145849_e) != References.META_WATER) {
            this.field_145850_b.func_147468_f(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            TjUtil.dropItemIntoWorld(new ItemStack((Block)ModBlocks.essentiaLocus), this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
            return;
        }
        MessageParticles.sendToClients(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, this.field_145851_c, this.field_145848_d - 1, this.field_145849_e, (short)4);
        this.field_145850_b.func_147468_f(this.field_145851_c, this.field_145848_d - 1, this.field_145849_e);
    }

    @Override
    public AspectList getAspectsBase() {
        return this.maxAspectSpaceByType;
    }

    public AspectList getAspects() {
        return this.aspects;
    }

    public void setAspects(AspectList aspects) {
    }

    public boolean doesContainerAccept(Aspect tag) {
        return false;
    }

    public int addToContainer(Aspect tag, int amount) {
        return amount;
    }

    public boolean takeFromContainer(Aspect tag, int amount) {
        return false;
    }

    public boolean takeFromContainer(AspectList ot) {
        return false;
    }

    public boolean doesContainerContainAmount(Aspect tag, int amount) {
        return false;
    }

    public boolean doesContainerContain(AspectList ot) {
        return false;
    }

    public int containerContains(Aspect tag) {
        return 0;
    }

    @Override
    public void onEyesInventoryChanged(int slot, ItemStack prevStack) {
    }

    @Override
    public void writeCustomNBT(NBTTagCompound nbttagcompound) {
        super.writeCustomNBT(nbttagcompound);
        this.eyesContainingInventory.writeCustomNBT(nbttagcompound);
        this.aspects.writeToNBT(nbttagcompound);
        nbttagcompound.func_74768_a("maxEyes", this.maxEyes);
        nbttagcompound.func_74768_a("maxDistance", this.maxDistance);
    }

    @Override
    public void readCustomNBT(NBTTagCompound nbttagcompound) {
        super.readCustomNBT(nbttagcompound);
        this.eyesContainingInventory.readCustomNBT(nbttagcompound);
        this.eyeCount = 0;
        int size = this.eyesContainingInventory.func_70302_i_();
        for (int i = 0; i < size; ++i) {
            if (this.eyesContainingInventory.func_70301_a(i) == null) continue;
            ++this.eyeCount;
        }
        this.aspects.readFromNBT(nbttagcompound);
        this.maxEyes = nbttagcompound.func_74762_e("maxEyes");
        this.maxDistance = nbttagcompound.func_74762_e("maxDistance");
    }

    public AxisAlignedBB getRenderBoundingBox() {
        AxisAlignedBB bb = AxisAlignedBB.func_72330_a((double)(this.field_145851_c - 3), (double)(this.field_145848_d - 2), (double)(this.field_145849_e - 3), (double)(this.field_145851_c + 3), (double)(this.field_145848_d + 2), (double)(this.field_145849_e + 3));
        return bb;
    }

    @Override
    public int getDimensionID() {
        return this.field_145850_b.field_73011_w.field_76574_g;
    }
}

