/*
 * Decompiled with CFR 0.152.
 */
package redgear.morebackpacks.core;

import cpw.mods.fml.common.Loader;
import forestry.api.storage.BackpackManager;
import forestry.api.storage.IBackpackDefinition;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Stack;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;
import redgear.core.compat.ModConfigHelper;
import redgear.core.compat.Mods;
import redgear.core.mod.FileHelper;
import redgear.core.util.StringHelper;
import redgear.morebackpacks.core.MoreBackpacks;

public class BackpackFiller {
    private final File scriptDir;

    public BackpackFiller(File minecraftDir) {
        this.scriptDir = new File(minecraftDir, StringHelper.concat((Object[])new Object[]{"RedGear", StringHelper.slash, "morebackpacks scripts"}));
    }

    public void fillBackpacks() {
        this.fillDictionary();
        this.fillScripts();
        if (Mods.Thaum.isIn()) {
            this.fillThaumcraft();
        }
        if (Mods.MetallurgyBase.isIn()) {
            this.fillMetallurgyUtility();
        }
    }

    private void fillScripts() {
        if (!this.scriptDir.exists()) {
            this.scriptDir.mkdir();
            return;
        }
        Stack<File> subFiles = new Stack<File>();
        subFiles.addAll(Arrays.asList(this.scriptDir.listFiles()));
        if (subFiles == null || subFiles.size() == 0) {
            return;
        }
        String packName = "";
        String itemName = "";
        int start = -1;
        int end = -1;
        boolean special = false;
        boolean ignore = false;
        String buffer = "";
        while (!subFiles.empty()) {
            File file = (File)subFiles.pop();
            try {
                if (file.isDirectory()) {
                    File[] addFiles;
                    for (File addFile : addFiles = file.listFiles()) {
                        subFiles.push(addFile);
                    }
                } else if (file.getName().endsWith(".txt")) {
                    MoreBackpacks.inst.myLogger.info("Reading script file: " + file.getName());
                    ArrayList lines = FileHelper.readLines((File)file);
                    block20: for (String line : lines) {
                        line.trim();
                        boolean skip = false;
                        for (char working : line.toCharArray()) {
                            if (special) {
                                buffer = buffer + working;
                                buffer.trim();
                                special = false;
                                continue;
                            }
                            if (ignore && working != '}') continue;
                            switch (working) {
                                case '\\': {
                                    special = true;
                                    break;
                                }
                                case '#': {
                                    skip = true;
                                    break;
                                }
                                case '!': {
                                    MoreBackpacks.inst.logDebug(line.substring(line.indexOf(working) + 1));
                                    skip = true;
                                    break;
                                }
                                case '{': {
                                    if (!Loader.isModLoaded((String)buffer)) {
                                        ignore = true;
                                    }
                                    buffer = "";
                                    break;
                                }
                                case '}': {
                                    ignore = false;
                                    break;
                                }
                                case '$': {
                                    packName = "";
                                    itemName = "";
                                    start = -1;
                                    end = -1;
                                    buffer = "";
                                    ignore = false;
                                    break;
                                }
                                case '@': {
                                    packName = buffer;
                                    buffer = "";
                                    break;
                                }
                                case ':': {
                                    itemName = buffer;
                                    buffer = "";
                                    break;
                                }
                                case '-': {
                                    try {
                                        start = Integer.parseInt(buffer);
                                        buffer = "";
                                    }
                                    catch (NumberFormatException e) {
                                        start = -1;
                                    }
                                    break;
                                }
                                case ';': {
                                    try {
                                        end = Integer.parseInt(buffer);
                                    }
                                    catch (NumberFormatException e) {
                                        end = -1;
                                    }
                                    if (start == -1 && end == -1) {
                                        this.addItem(packName, itemName);
                                    }
                                    if (start != -1 && end == -1) {
                                        this.addItem(packName, itemName, start);
                                    }
                                    if (end != -1) {
                                        this.addItem(packName, itemName, start == -1 ? 0 : start, end);
                                    }
                                    start = -1;
                                    end = -1;
                                    buffer = "";
                                    break;
                                }
                                default: {
                                    buffer = buffer + working;
                                    buffer.trim();
                                }
                            }
                            if (skip) continue block20;
                        }
                    }
                } else {
                    MoreBackpacks.inst.myLogger.warning("Invalid file in script folder: " + file.getName());
                }
                packName = "";
                itemName = "";
                start = -1;
                end = -1;
                buffer = "";
            }
            catch (Exception e) {
                MoreBackpacks.inst.myLogger.warning("Error reading script file: " + file.getName());
                MoreBackpacks.inst.logDebug("", e);
            }
        }
    }

    private void fillDictionary() {
        String[] dict;
        for (String oreName : dict = OreDictionary.getOreNames()) {
            if (oreName == null || !oreName.startsWith("ore")) continue;
            this.addItem("miner", OreDictionary.getOres((String)oreName).toArray(new ItemStack[0]));
        }
    }

    private void fillThaumcraft() {
        this.addItem("miner", "tile.blockCustomOre");
        this.addItem("miner", "item.ItemShard");
        this.addItem("miner", "item.ItemResource", 3);
        this.addItem("miner", "item.ItemResource", 6);
        this.addItem("forester", "tile.blockCustomPlant");
        this.addItem("forester", "tile.blockMagicalLog");
        this.addItem("forester", "tile.blockMagicalLeaves");
        this.addItem("hunter", "item.ItemResource", 5);
    }

    private void fillMetallurgyUtility() {
        String[] names;
        for (String item : names = new String[]{"Phosphorus", "Sulfur", "Saltpeter", "Magnesium", "Potash", "Bitumen"}) {
            this.addItem("miner", "item.Metallurgy:Utility/" + item);
        }
    }

    public void addItem(String backpackKey, ItemStack item) {
        if (item == null) {
            return;
        }
        IBackpackDefinition backpack = (IBackpackDefinition)BackpackManager.definitions.get(backpackKey);
        if (backpack == null) {
            MoreBackpacks.inst.logDebug("BackpackFiller Can't Find Backpack: " + backpackKey);
            return;
        }
        backpack.addValidItem(item);
    }

    public void addItem(String backpackKey, String itemName) {
        this.addItem(backpackKey, ModConfigHelper.get((String)itemName));
    }

    public void addItem(String backpackKey, String itemName, int meta) {
        this.addItem(backpackKey, ModConfigHelper.get((String)itemName, (int)meta));
    }

    public void addItem(String backpackKey, String itemName, int startMeta, int endMeta) {
        ItemStack test = ModConfigHelper.get((String)itemName);
        if (test == null) {
            return;
        }
        this.addItem(backpackKey, test.field_77993_c, startMeta, endMeta);
    }

    public void addItem(String backpackKey, int itemID, int startMeta, int endMeta) {
        for (int i = startMeta; i <= endMeta; ++i) {
            this.addItem(backpackKey, new ItemStack(itemID, 1, i));
        }
    }

    private void addItem(String backpackKey, ItemStack[] array) {
        for (ItemStack stack : array) {
            this.addItem(backpackKey, stack);
        }
    }
}

