/*
 * Decompiled with CFR 0.152.
 */
package redgear.morebackpacks.core;

import cpw.mods.fml.common.registry.LanguageRegistry;
import forestry.api.storage.IBackpackDefinition;
import java.util.Collection;
import java.util.HashSet;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import redgear.core.compat.ModConfigHelper;
import redgear.core.util.SimpleItem;

public abstract class BasicBackpack
implements IBackpackDefinition {
    protected HashSet<SimpleItem> itemsList = new HashSet(20);
    public SimpleItem backpackT1;
    public SimpleItem backpackT2;
    private final String unlocalname;

    protected BasicBackpack(String unlocalname) {
        this.unlocalname = unlocalname;
    }

    public abstract void fill();

    public boolean modsLoaded() {
        return true;
    }

    public abstract ItemStack getCraftingItem();

    public void addValidItem(ItemStack validItem) {
        if (validItem == null) {
            return;
        }
        this.addItem(validItem.field_77993_c, validItem.func_77960_j());
    }

    public void addItem(int id, int meta) {
        if (id <= 0 || id >= Item.field_77698_e.length) {
            return;
        }
        if (Item.field_77698_e[id] == null) {
            return;
        }
        SimpleItem temp = new SimpleItem(id, meta);
        if (this.itemsList.contains(temp)) {
            return;
        }
        this.itemsList.add(temp);
    }

    public void addItem(Item validItem) {
        if (validItem != null) {
            this.addItem(validItem.field_77779_bT, 0);
        }
    }

    public void addItem(Block validItem) {
        if (validItem != null) {
            this.addItem(validItem.field_71990_ca, 0);
        }
    }

    public Collection<ItemStack> getValidItems(EntityPlayer player) {
        HashSet<ItemStack> stack = new HashSet<ItemStack>(this.itemsList.size());
        for (SimpleItem item : this.itemsList) {
            stack.add(item.getStack());
        }
        return stack;
    }

    public boolean isValidItem(EntityPlayer player, ItemStack check) {
        return this.itemsList.contains(new SimpleItem(check));
    }

    public int getSecondaryColour() {
        return 0xFFFFFF;
    }

    public void addItem(String itemName) {
        this.addValidItem(ModConfigHelper.get((String)itemName));
    }

    public void addItem(String itemName, int meta) {
        this.addValidItem(ModConfigHelper.get((String)itemName, (int)meta));
    }

    public void addItems(ItemStack[] items) {
        for (ItemStack each : items) {
            this.addValidItem(each);
        }
    }

    public void addItems(String[] itemNames) {
        for (String name : itemNames) {
            this.addItem(name);
        }
    }

    public void addItemsFromMeta(int Id, int startMeta, int endMeta) {
        for (int i = startMeta; i <= endMeta; ++i) {
            this.addItem(Id, i);
        }
    }

    public void addItemsFromMeta(int Id, int endMeta) {
        this.addItemsFromMeta(Id, 0, endMeta);
    }

    public void addItemsFromMeta(String itemName, int startMeta, int endMeta) {
        ItemStack test = ModConfigHelper.get((String)itemName);
        if (test != null) {
            this.addItemsFromMeta(test.field_77993_c, startMeta, endMeta);
        }
    }

    public void addItemsFromMeta(String itemName, int endMeta) {
        this.addItemsFromMeta(itemName, 0, endMeta);
    }

    public final String getKey() {
        return this.unlocalname.toLowerCase();
    }

    public final String getName() {
        return LanguageRegistry.instance().getStringLocalization("item.RedGear.MoreBackpacks.Backpack." + this.unlocalname + ".name");
    }
}

