/*
 * Decompiled with CFR 0.152.
 */
package redgear.morebackpacks.core;

import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.registry.GameRegistry;
import forestry.api.core.ItemInterface;
import forestry.api.recipes.RecipeManagers;
import forestry.api.storage.BackpackManager;
import forestry.api.storage.EnumBackpackType;
import forestry.api.storage.IBackpackDefinition;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidRegistry;
import redgear.core.mod.ModUtils;
import redgear.core.util.SimpleItem;
import redgear.morebackpacks.backpacks.BackpackArtist;
import redgear.morebackpacks.backpacks.BackpackElectrician;
import redgear.morebackpacks.backpacks.BackpackFarmer;
import redgear.morebackpacks.backpacks.BackpackHydraulic;
import redgear.morebackpacks.backpacks.BackpackJewler;
import redgear.morebackpacks.backpacks.BackpackLogistic;
import redgear.morebackpacks.backpacks.BackpackMagician;
import redgear.morebackpacks.backpacks.BackpackMetallurgist;
import redgear.morebackpacks.backpacks.BackpackNuclear;
import redgear.morebackpacks.backpacks.BackpackProgrammer;
import redgear.morebackpacks.backpacks.BackpackRedstone;
import redgear.morebackpacks.backpacks.BackpackSurvival;
import redgear.morebackpacks.core.BackpackFiller;
import redgear.morebackpacks.core.BasicBackpack;

@Mod(modid="RedGear|MoreBackpacks", name="More Backpacks", version="2.1.9", dependencies="required-after:RedGear|Core;required-after:Forestry;")
public class MoreBackpacks
extends ModUtils {
    @Mod.Instance(value="RedGear|MoreBackpacks")
    public static ModUtils inst;
    private ItemStack wovenSilk;
    private static BackpackFiller filler;
    private final ArrayList<BasicBackpack> backpacks = new ArrayList();

    public MoreBackpacks() {
        super(0, 23500);
    }

    public void PreInit(FMLPreInitializationEvent event) {
        filler = new BackpackFiller(event.getModConfigurationDirectory());
        this.createBackpack(new BackpackRedstone());
        this.createBackpack(new BackpackFarmer());
        this.createBackpack(new BackpackSurvival());
        this.createBackpack(new BackpackArtist());
        this.createBackpack(new BackpackMagician());
        this.createBackpack(new BackpackMetallurgist());
        this.createBackpack(new BackpackHydraulic());
        this.createBackpack(new BackpackJewler());
        this.createBackpack(new BackpackLogistic());
        this.createBackpack(new BackpackElectrician());
        this.createBackpack(new BackpackNuclear());
        this.createBackpack(new BackpackProgrammer());
    }

    protected void Init(FMLInitializationEvent event) {
    }

    public void PostInit(FMLPostInitializationEvent event) {
        this.wovenSilk = ItemInterface.getItem((String)"craftingMaterial");
        this.wovenSilk.func_77964_b(3);
        for (BasicBackpack def : this.backpacks) {
            this.fillBackpack(def);
        }
        filler.fillBackpacks();
    }

    private void createBackpack(BasicBackpack def) {
        int id = this.getId(def, EnumBackpackType.T1);
        def.backpackT1 = new SimpleItem(BackpackManager.backpackInterface.addBackpack(id, (IBackpackDefinition)def, EnumBackpackType.T1));
        id = this.getId(def, EnumBackpackType.T2);
        def.backpackT2 = new SimpleItem(BackpackManager.backpackInterface.addBackpack(id, (IBackpackDefinition)def, EnumBackpackType.T2));
        GameRegistry.registerItem((Item)def.backpackT1.getItem(), (String)(def.getKey() + "T1"));
        GameRegistry.registerItem((Item)def.backpackT2.getItem(), (String)(def.getKey() + "T2"));
        this.backpacks.add(def);
    }

    private void fillBackpack(BasicBackpack def) {
        ItemStack craftingItem = def.getCraftingItem();
        if (this.getEnabled(def.getKey()) && def.modsLoaded()) {
            if (craftingItem == null) {
                this.logDebug("Can't find special item for " + def.getName() + "!");
            } else {
                GameRegistry.addRecipe((ItemStack)def.backpackT1.getStack(), (Object[])new Object[]{"SWS", "XCX", "SWS", Character.valueOf('S'), Item.field_77683_K, Character.valueOf('W'), Block.field_72101_ab, Character.valueOf('X'), craftingItem, Character.valueOf('C'), Block.field_72077_au});
                RecipeManagers.carpenterManager.addRecipe(200, FluidRegistry.getFluidStack((String)"water", (int)1000), null, def.backpackT2.getStack(), new Object[]{"WXW", "WTW", "WWW", Character.valueOf('X'), Item.field_77702_n, Character.valueOf('W'), this.wovenSilk, Character.valueOf('T'), def.backpackT1.getStack()});
            }
        }
        def.fill();
    }

    private int getId(BasicBackpack def, EnumBackpackType type) {
        return this.getItemId(def.getKey() + (type == EnumBackpackType.T1 ? "T1" : "T2"));
    }

    private boolean getEnabled(String key) {
        return this.getBoolean(key, true);
    }

    @Mod.EventHandler
    public void PreInitialization(FMLPreInitializationEvent event) {
        super.PreInitialization(event);
    }

    @Mod.EventHandler
    public void Initialization(FMLInitializationEvent event) {
        super.Initialization(event);
    }

    @Mod.EventHandler
    public void PostInitialization(FMLPostInitializationEvent event) {
        super.PostInitialization(event);
    }
}

