/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.block;

import com.jaquadro.minecraft.storagedrawers.StorageDrawers;
import com.jaquadro.minecraft.storagedrawers.block.IExtendedBlockClickHandler;
import com.jaquadro.minecraft.storagedrawers.block.tile.TileEntityDrawers;
import com.jaquadro.minecraft.storagedrawers.core.ModCreativeTabs;
import com.jaquadro.minecraft.storagedrawers.core.ModItems;
import com.jaquadro.minecraft.storagedrawers.network.BlockClickMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.BlockWood;
import net.minecraft.block.material.Material;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.EffectRenderer;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockDrawers
extends BlockContainer
implements IExtendedBlockClickHandler {
    public final boolean halfDepth;
    public final int drawerCount;
    @SideOnly(value=Side.CLIENT)
    private IIcon[] iconSide;
    @SideOnly(value=Side.CLIENT)
    private IIcon[] iconSideV;
    @SideOnly(value=Side.CLIENT)
    private IIcon[] iconSideH;
    @SideOnly(value=Side.CLIENT)
    private IIcon[] iconFront2;
    @SideOnly(value=Side.CLIENT)
    private IIcon[] iconFront4;
    @SideOnly(value=Side.CLIENT)
    private IIcon[] iconOverlay;
    @SideOnly(value=Side.CLIENT)
    private IIcon[] iconOverlayV;
    @SideOnly(value=Side.CLIENT)
    private IIcon[] iconOverlayH;
    @SideOnly(value=Side.CLIENT)
    private IIcon[] iconOverlayCross;

    public BlockDrawers(String blockName, int drawerCount, boolean halfDepth) {
        super(Material.field_151575_d);
        this.drawerCount = drawerCount;
        this.halfDepth = halfDepth;
        this.func_149647_a(ModCreativeTabs.tabStorageDrawers);
        this.func_149711_c(5.0f);
        this.func_149672_a(Block.field_149766_f);
        this.func_149663_c(blockName);
    }

    public boolean func_149686_d() {
        return false;
    }

    public boolean func_149662_c() {
        return false;
    }

    public int func_149645_b() {
        return StorageDrawers.proxy.drawersRenderID;
    }

    public void func_149719_a(IBlockAccess blockAccess, int x, int y, int z) {
        TileEntityDrawers tile = this.getTileEntity(blockAccess, x, y, z);
        if (tile == null) {
            this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
            return;
        }
        float depth = this.halfDepth ? 0.5f : 1.0f;
        switch (tile.getDirection()) {
            case 2: {
                this.func_149676_a(0.0f, 0.0f, 1.0f - depth, 1.0f, 1.0f, 1.0f);
                break;
            }
            case 3: {
                this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, depth);
                break;
            }
            case 4: {
                this.func_149676_a(1.0f - depth, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
                break;
            }
            case 5: {
                this.func_149676_a(0.0f, 0.0f, 0.0f, depth, 1.0f, 1.0f);
            }
        }
    }

    public void func_149683_g() {
        if (this.halfDepth) {
            this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 0.5f);
        } else {
            this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
        }
    }

    public void func_149743_a(World world, int x, int y, int z, AxisAlignedBB aabb, List list, Entity entity) {
        this.func_149719_a((IBlockAccess)world, x, y, z);
        super.func_149743_a(world, x, y, z, aabb, list, entity);
    }

    public void func_149689_a(World world, int x, int y, int z, EntityLivingBase entity, ItemStack itemStack) {
        TileEntityDrawers tile = this.getTileEntitySafe(world, x, y, z);
        if (tile.getDirection() > 1) {
            return;
        }
        int quadrant = MathHelper.func_76128_c((double)((double)(entity.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
        switch (quadrant) {
            case 0: {
                tile.setDirection(2);
                break;
            }
            case 1: {
                tile.setDirection(5);
                break;
            }
            case 2: {
                tile.setDirection(3);
                break;
            }
            case 3: {
                tile.setDirection(4);
            }
        }
        if (world.field_72995_K) {
            tile.func_145843_s();
            world.func_147471_g(x, y, z);
        }
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int side, float hitX, float hitY, float hitZ) {
        ItemStack item = player.field_71071_by.func_70448_g();
        if (item == null || item.func_77973_b() == null) {
            return false;
        }
        TileEntityDrawers tileDrawers = this.getTileEntitySafe(world, x, y, z);
        if (item.func_77973_b() == ModItems.upgrade) {
            tileDrawers.setLevel(item.func_77960_j());
            world.func_147471_g(x, y, z);
            if (player != null && !player.field_71075_bZ.field_75098_d && --item.field_77994_a <= 0) {
                player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, null);
            }
            return true;
        }
        if (tileDrawers.getDirection() != side) {
            return false;
        }
        int slot = this.getDrawerSlot(side, hitX, hitY, hitZ);
        int countAdded = tileDrawers.putItemsIntoSlot(slot, item, item.field_77994_a);
        return countAdded > 0;
    }

    private int getDrawerSlot(int side, float hitX, float hitY, float hitZ) {
        if (this.drawerCount == 2) {
            return this.hitTop(hitY) ? 0 : 1;
        }
        if (this.hitLeft(side, hitX, hitZ)) {
            return this.hitTop(hitY) ? 0 : 1;
        }
        return this.hitTop(hitY) ? 2 : 3;
    }

    private boolean hitTop(float hitY) {
        return (double)hitY > 0.5;
    }

    private boolean hitLeft(int side, float hitX, float hitZ) {
        switch (side) {
            case 2: {
                return (double)hitX > 0.5;
            }
            case 3: {
                return (double)hitX < 0.5;
            }
            case 4: {
                return (double)hitZ > 0.5;
            }
            case 5: {
                return (double)hitZ < 0.5;
            }
        }
        return true;
    }

    public void func_149699_a(World world, int x, int y, int z, EntityPlayer player) {
        if (world.field_72995_K) {
            MovingObjectPosition posn = Minecraft.func_71410_x().field_71476_x;
            float hitX = (float)(posn.field_72307_f.field_72450_a - (double)posn.field_72311_b);
            float hitY = (float)(posn.field_72307_f.field_72448_b - (double)posn.field_72312_c);
            float hitZ = (float)(posn.field_72307_f.field_72449_c - (double)posn.field_72309_d);
            StorageDrawers.network.sendToServer((IMessage)new BlockClickMessage(x, y, z, posn.field_72310_e, hitX, hitY, hitZ));
        }
    }

    @Override
    public void onBlockClicked(World world, int x, int y, int z, EntityPlayer player, int side, float hitX, float hitY, float hitZ) {
        TileEntityDrawers tileDrawers = this.getTileEntitySafe(world, x, y, z);
        if (tileDrawers.getDirection() != side) {
            return;
        }
        int slot = this.getDrawerSlot(side, hitX, hitY, hitZ);
        ItemStack item = null;
        item = player.func_70093_af() ? tileDrawers.takeItemsFromSlot(slot, tileDrawers.getStackSize(slot)) : tileDrawers.takeItemsFromSlot(slot, 1);
        if (item != null && item.field_77994_a > 0) {
            this.dropItemStack(world, x, y, z, player, item);
            world.func_147471_g(x, y, z);
        }
    }

    private void dropItemStack(World world, int x, int y, int z, EntityPlayer player, ItemStack stack) {
        EntityItem entity = new EntityItem(world, player.field_70165_t, player.field_70163_u, player.field_70161_v, stack);
        world.func_72838_d((Entity)entity);
    }

    public boolean removedByPlayer(World world, EntityPlayer player, int x, int y, int z) {
        if (world.field_72995_K && player.field_71075_bZ.field_75098_d) {
            TileEntityDrawers tile = this.getTileEntity((IBlockAccess)world, x, y, z);
            MovingObjectPosition posn = Minecraft.func_71410_x().field_71476_x;
            if (tile.getDirection() == posn.field_72310_e) {
                this.func_149699_a(world, x, y, z, player);
                return false;
            }
        }
        return super.removedByPlayer(world, player, x, y, z);
    }

    public void func_149749_a(World world, int x, int y, int z, Block block, int meta) {
        TileEntityDrawers tile = this.getTileEntity((IBlockAccess)world, x, y, z);
        if (tile.getLevel() > 1) {
            this.func_149642_a(world, x, y, z, new ItemStack((Item)ModItems.upgrade, 1, tile.getLevel()));
        }
        if (tile != null) {
            for (int i = 0; i < tile.getDrawerCount(); ++i) {
                ItemStack stack;
                while (tile.getItemCount(i) > 0 && (stack = tile.takeItemsFromSlot(i, tile.getStackSize(i))) != null && stack.field_77994_a != 0) {
                    this.dropStackInBatches(world, x, y, z, stack);
                }
            }
            world.func_147453_f(x, y, z, block);
        }
        super.func_149749_a(world, x, y, z, block, meta);
    }

    private void dropStackInBatches(World world, int x, int y, int z, ItemStack stack) {
        Random rand = world.field_73012_v;
        float ex = rand.nextFloat() * 0.8f + 0.1f;
        float ey = rand.nextFloat() * 0.8f + 0.1f;
        float ez = rand.nextFloat() * 0.8f + 0.1f;
        while (stack.field_77994_a > 0) {
            int stackPartSize = rand.nextInt(21) + 10;
            if (stackPartSize > stack.field_77994_a) {
                stackPartSize = stack.field_77994_a;
            }
            stack.field_77994_a -= stackPartSize;
            EntityItem entity = new EntityItem(world, (double)((float)x + ex), (double)((float)y + ey), (double)((float)z + ez), new ItemStack(stack.func_77973_b(), stackPartSize, stack.func_77960_j()));
            float motionUnit = 0.05f;
            entity.field_70159_w = rand.nextGaussian() * (double)motionUnit;
            entity.field_70181_x = rand.nextGaussian() * (double)motionUnit + (double)0.2f;
            entity.field_70179_y = rand.nextGaussian() * (double)motionUnit;
            if (stack.func_77942_o()) {
                entity.func_92059_d().func_77982_d((NBTTagCompound)stack.func_77978_p().func_74737_b());
            }
            world.func_72838_d((Entity)entity);
        }
    }

    public TileEntityDrawers createNewTileEntity(World world, int meta) {
        return new TileEntityDrawers();
    }

    public TileEntityDrawers getTileEntity(IBlockAccess blockAccess, int x, int y, int z) {
        TileEntity tile = blockAccess.func_147438_o(x, y, z);
        return tile instanceof TileEntityDrawers ? (TileEntityDrawers)tile : null;
    }

    public TileEntityDrawers getTileEntitySafe(World world, int x, int y, int z) {
        TileEntityDrawers tile = this.getTileEntity((IBlockAccess)world, x, y, z);
        if (tile == null) {
            tile = this.createNewTileEntity(world, world.func_72805_g(x, y, z));
            world.func_147455_a(x, y, z, (TileEntity)tile);
        }
        return tile;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean addHitEffects(World worldObj, MovingObjectPosition target, EffectRenderer effectRenderer) {
        TileEntity tile = worldObj.func_147438_o(target.field_72311_b, target.field_72312_c, target.field_72309_d);
        if (tile instanceof TileEntityDrawers && ((TileEntityDrawers)tile).getDirection() == target.field_72310_e) {
            return true;
        }
        return super.addHitEffects(worldObj, target, effectRenderer);
    }

    public void func_149666_a(Item item, CreativeTabs creativeTabs, List list) {
        for (int i = 0; i < BlockWood.field_150096_a.length; ++i) {
            list.add(new ItemStack(item, 1, i));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int side, int meta) {
        meta %= BlockWood.field_150096_a.length;
        switch (side) {
            case 0: 
            case 1: {
                return this.halfDepth ? this.iconSideV[meta] : this.iconSide[meta];
            }
            case 2: 
            case 3: {
                return this.halfDepth ? this.iconSideV[meta] : this.iconSide[meta];
            }
            case 4: {
                return this.drawerCount == 2 ? this.iconFront2[meta] : this.iconFront4[meta];
            }
            case 5: {
                return this.iconSide[meta];
            }
        }
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149673_e(IBlockAccess blockAccess, int x, int y, int z, int side) {
        return this.getIcon(blockAccess, x, y, z, side, 0);
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getOverlayIcon(IBlockAccess blockAccess, int x, int y, int z, int side, int level) {
        if (level == 0) {
            return null;
        }
        return this.getIcon(blockAccess, x, y, z, side, level);
    }

    @SideOnly(value=Side.CLIENT)
    private IIcon getIcon(IBlockAccess blockAccess, int x, int y, int z, int side, int level) {
        int meta = blockAccess.func_72805_g(x, y, z) % BlockWood.field_150096_a.length;
        TileEntityDrawers tile = this.getTileEntity(blockAccess, x, y, z);
        if (tile == null || side == tile.getDirection()) {
            if (this.drawerCount == 2) {
                return level > 0 ? this.iconOverlayH[level] : this.iconFront2[meta];
            }
            return level > 0 ? this.iconOverlayCross[level] : this.iconFront4[meta];
        }
        switch (side) {
            case 0: 
            case 1: {
                if (!this.halfDepth) break;
                switch (tile.getDirection()) {
                    case 2: 
                    case 3: {
                        return level > 0 ? this.iconOverlayH[level] : this.iconSideH[meta];
                    }
                    case 4: 
                    case 5: {
                        return level > 0 ? this.iconOverlayV[level] : this.iconSideV[meta];
                    }
                }
                break;
            }
            default: {
                if (!this.halfDepth) break;
                return level > 0 ? this.iconOverlayV[level] : this.iconSideV[meta];
            }
        }
        return level > 0 ? this.iconOverlay[level] : this.iconSide[meta];
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister register) {
        String[] subtex = BlockWood.field_150096_a;
        this.iconSide = new IIcon[subtex.length];
        this.iconSideH = new IIcon[subtex.length];
        this.iconSideV = new IIcon[subtex.length];
        this.iconFront2 = new IIcon[subtex.length];
        this.iconFront4 = new IIcon[subtex.length];
        for (int i = 0; i < subtex.length; ++i) {
            this.iconFront2[i] = register.func_94245_a("StorageDrawers:drawers_" + subtex[i] + "_front_2");
            this.iconFront4[i] = register.func_94245_a("StorageDrawers:drawers_" + subtex[i] + "_front_4");
            this.iconSide[i] = register.func_94245_a("StorageDrawers:drawers_" + subtex[i] + "_side");
            this.iconSideV[i] = register.func_94245_a("StorageDrawers:drawers_" + subtex[i] + "_side_v");
            this.iconSideH[i] = register.func_94245_a("StorageDrawers:drawers_" + subtex[i] + "_side_h");
        }
        String[] overlays = new String[]{null, null, "iron", "gold", "obsidian", "diamond", "emerald"};
        this.iconOverlay = new IIcon[overlays.length];
        this.iconOverlayH = new IIcon[overlays.length];
        this.iconOverlayV = new IIcon[overlays.length];
        this.iconOverlayCross = new IIcon[overlays.length];
        for (int i = 2; i < overlays.length; ++i) {
            this.iconOverlay[i] = register.func_94245_a("StorageDrawers:overlay_" + overlays[i]);
            this.iconOverlayV[i] = register.func_94245_a("StorageDrawers:overlay_" + overlays[i] + "_v");
            this.iconOverlayH[i] = register.func_94245_a("StorageDrawers:overlay_" + overlays[i] + "_h");
            this.iconOverlayCross[i] = register.func_94245_a("StorageDrawers:overlay_" + overlays[i] + "_cross");
        }
    }
}

