/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.block.tile;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MathHelper;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityDrawers
extends TileEntity
implements ISidedInventory {
    private int direction;
    private int drawerCount = 2;
    private int drawerCapacity = 1;
    private int level = 1;
    private DrawerData[] data;
    private ItemStack[] snapshotItems;
    private int[] snapshotCounts;
    private int[] autoSides = new int[]{0, 1};
    private static final int[] drawerSlots0 = new int[0];
    private static final int[] drawerSlots2 = new int[]{0, 1};
    private static final int[] drawerSlots4 = new int[]{0, 1, 2, 3};

    public TileEntityDrawers() {
        this.setDrawerCount(2);
    }

    public int getDirection() {
        return this.direction;
    }

    public void setDirection(int direction) {
        this.direction = direction % 6;
        this.autoSides = new int[]{0, 1, ForgeDirection.OPPOSITES[direction]};
    }

    public int getDrawerCount() {
        return this.drawerCount;
    }

    public void setDrawerCount(int count) {
        this.drawerCount = count;
        this.data = new DrawerData[this.drawerCount];
        for (int i = 0; i < this.data.length; ++i) {
            this.data[i] = new DrawerData();
        }
        this.snapshotItems = new ItemStack[count];
        this.snapshotCounts = new int[count];
    }

    public int getLevel() {
        return this.level;
    }

    public void setLevel(int level) {
        this.level = MathHelper.func_76125_a((int)level, (int)1, (int)6);
    }

    public void setDrawerCapacity(int stackCount) {
        this.drawerCapacity = stackCount;
    }

    public int getSlotCount() {
        return this.data.length;
    }

    public Item getItem(int slot) {
        return this.data[slot].item;
    }

    public int getItemMeta(int slot) {
        return this.data[slot].meta;
    }

    public int getItemCount(int slot) {
        return this.data[slot].count;
    }

    public int getStackSize(int slot) {
        if (this.data[slot].getItem() == null) {
            return 0;
        }
        return this.data[slot].getItem().getItemStackLimit(null);
    }

    public ItemStack getSingleItemStack(int slot) {
        if (this.data[slot].getItem() == null) {
            return null;
        }
        ItemStack stack = new ItemStack(this.data[slot].getItem(), 1, this.data[slot].meta);
        stack.func_77982_d(this.data[slot].attrs);
        return stack;
    }

    public NBTTagCompound getItemAttrs(int slot) {
        return this.data[slot].attrs;
    }

    public ItemStack takeItemsFromSlot(int slot, int count) {
        ItemStack stack = this.getItemsFromSlot(slot, count);
        if (stack == null) {
            return null;
        }
        this.data[slot].count -= stack.field_77994_a;
        if (this.data[slot].count <= 0) {
            this.data[slot].reset();
        }
        return stack;
    }

    public int putItemsIntoSlot(int slot, ItemStack stack, int count) {
        if (this.data[slot].getItem() == null) {
            this.data[slot].setItem(stack.func_77973_b());
            this.data[slot].meta = stack.func_77960_j();
            this.data[slot].attrs = stack.func_77978_p();
        }
        if (!this.itemMatchesForSlot(slot, stack)) {
            return 0;
        }
        int countAdded = Math.min(this.data[slot].remainingCapacity(), stack.field_77994_a);
        countAdded = Math.min(countAdded, count);
        this.data[slot].count += countAdded;
        stack.field_77994_a -= countAdded;
        return countAdded;
    }

    private ItemStack getItemsFromSlot(int slot, int count) {
        if (this.data[slot].getItem() == null) {
            return null;
        }
        ItemStack stack = new ItemStack(this.data[slot].getItem(), 1, this.data[slot].meta);
        stack.field_77994_a = Math.min(stack.func_77976_d(), count);
        stack.field_77994_a = Math.min(stack.field_77994_a, this.data[slot].count);
        stack.func_77982_d(this.data[slot].attrs);
        return stack;
    }

    private boolean itemMatchesForSlot(int slot, ItemStack stack) {
        if (this.data[slot].getItem() != stack.func_77973_b() || this.data[slot].meta != stack.func_77960_j()) {
            return false;
        }
        if ((this.data[slot].attrs == null || stack.func_77978_p() == null) && this.data[slot].attrs != stack.func_77978_p()) {
            return false;
        }
        return this.data[slot].attrs == null || this.data[slot].attrs.equals((Object)stack.func_77978_p());
    }

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.direction = tag.func_74771_c("Dir");
        this.drawerCapacity = tag.func_74771_c("Cap");
        this.level = tag.func_74771_c("Lev");
        NBTTagList slots = tag.func_150295_c("Slots", 10);
        this.drawerCount = slots.func_74745_c();
        this.data = new DrawerData[slots.func_74745_c()];
        for (int i = 0; i < this.data.length; ++i) {
            NBTTagCompound slot = slots.func_150305_b(i);
            this.data[i] = new DrawerData();
            this.data[i].readFromNBT(slot);
        }
        this.autoSides = new int[]{0, 1, ForgeDirection.OPPOSITES[this.direction]};
        this.snapshotItems = new ItemStack[this.drawerCount];
        this.snapshotCounts = new int[this.drawerCount];
    }

    public void func_145841_b(NBTTagCompound tag) {
        super.func_145841_b(tag);
        tag.func_74774_a("Dir", (byte)this.direction);
        tag.func_74774_a("Cap", (byte)this.drawerCapacity);
        tag.func_74774_a("Lev", (byte)this.level);
        NBTTagList slots = new NBTTagList();
        for (int i = 0; i < this.data.length; ++i) {
            NBTTagCompound slot = new NBTTagCompound();
            this.data[i].writeToNBT(slot);
            slots.func_74742_a((NBTBase)slot);
        }
        tag.func_74782_a("Slots", (NBTBase)slots);
    }

    public Packet func_145844_m() {
        NBTTagCompound tag = new NBTTagCompound();
        this.func_145841_b(tag);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 5, tag);
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
        this.func_145831_w().func_147479_m(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    public void func_70296_d() {
        for (int i = 0; i < this.drawerCount; ++i) {
            if (this.snapshotItems[i] == null || this.snapshotItems[i].field_77994_a == this.snapshotCounts[i]) continue;
            int diff = this.snapshotItems[i].field_77994_a - this.snapshotCounts[i];
            if (diff > 0) {
                this.putItemsIntoSlot(i, this.snapshotItems[i], diff);
            } else {
                this.takeItemsFromSlot(i, -diff);
            }
            this.snapshotCounts[i] = this.snapshotItems[i].field_77994_a = 64 - Math.min(63, this.data[i].remainingCapacity());
        }
        super.func_70296_d();
    }

    public int func_70302_i_() {
        return this.drawerCount;
    }

    public ItemStack func_70301_a(int slot) {
        if (slot >= this.func_70302_i_()) {
            return null;
        }
        ItemStack stack = this.getItemsFromSlot(slot, this.getStackSize(slot));
        if (stack != null) {
            stack.field_77994_a = 64 - Math.min(63, this.data[slot].remainingCapacity());
            this.snapshotItems[slot] = stack;
            this.snapshotCounts[slot] = stack.field_77994_a;
        } else {
            this.snapshotItems[slot] = null;
            this.snapshotCounts[slot] = 0;
        }
        return stack;
    }

    public ItemStack func_70298_a(int slot, int count) {
        if (slot >= this.func_70302_i_()) {
            return null;
        }
        ItemStack stack = this.takeItemsFromSlot(slot, count);
        if (stack != null && !this.field_145850_b.field_72995_K) {
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
        return stack;
    }

    public ItemStack func_70304_b(int slot) {
        return null;
    }

    public void func_70299_a(int slot, ItemStack itemStack) {
        if (slot >= this.func_70302_i_()) {
            return;
        }
        int count = this.putItemsIntoSlot(slot, itemStack, itemStack.field_77994_a);
        if (count > 0 && !this.field_145850_b.field_72995_K) {
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
    }

    public String func_145825_b() {
        return null;
    }

    public boolean func_145818_k_() {
        return false;
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return false;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean func_94041_b(int slot, ItemStack itemStack) {
        if (slot >= this.func_70302_i_()) {
            return false;
        }
        if (this.data[slot].getItem() == null) {
            return true;
        }
        if (!this.itemMatchesForSlot(slot, itemStack)) {
            return false;
        }
        return this.data[slot].remainingCapacity() >= itemStack.field_77994_a;
    }

    public int[] func_94128_d(int side) {
        for (int i = 0; i < this.autoSides.length; ++i) {
            if (side != this.autoSides[i]) continue;
            return this.drawerCount == 2 ? drawerSlots2 : drawerSlots4;
        }
        return drawerSlots0;
    }

    public boolean func_102007_a(int slot, ItemStack stack, int side) {
        if (slot >= this.func_70302_i_()) {
            return false;
        }
        for (int i = 0; i < this.autoSides.length; ++i) {
            if (side != this.autoSides[i]) continue;
            return this.func_94041_b(slot, stack);
        }
        return false;
    }

    public boolean func_102008_b(int slot, ItemStack stack, int side) {
        return false;
    }

    private class DrawerData {
        private Item item;
        public int meta;
        public int count;
        public NBTTagCompound attrs;
        private ItemStack protoStack;

        public DrawerData() {
            this.reset();
        }

        public Item getItem() {
            return this.item;
        }

        public void setItem(Item item) {
            this.item = item;
            this.protoStack = new ItemStack(item);
        }

        public void writeToNBT(NBTTagCompound tag) {
            if (this.item != null) {
                tag.func_74777_a("Item", (short)Item.func_150891_b((Item)this.item));
                tag.func_74777_a("Meta", (short)this.meta);
                tag.func_74768_a("Count", this.count);
                if (this.attrs != null) {
                    tag.func_74782_a("Tags", (NBTBase)this.attrs);
                }
            }
        }

        public void readFromNBT(NBTTagCompound tag) {
            if (tag.func_74764_b("Item")) {
                this.item = Item.func_150899_d((int)tag.func_74765_d("Item"));
                this.meta = tag.func_74765_d("Meta");
                this.count = tag.func_74762_e("Count");
                if (tag.func_74764_b("Tags")) {
                    this.attrs = tag.func_74775_l("Tags");
                }
                this.protoStack = new ItemStack(this.item);
            }
        }

        public void reset() {
            this.item = null;
            this.meta = 0;
            this.count = 0;
            this.attrs = null;
        }

        public int maxCapacity() {
            if (this.item == null) {
                return 0;
            }
            this.protoStack.func_77964_b(this.meta);
            this.protoStack.func_77982_d(this.attrs);
            return this.item.getItemStackLimit(this.protoStack) * this.stackCapacity();
        }

        public int remainingCapacity() {
            if (this.item == null) {
                return 0;
            }
            return this.maxCapacity() - this.count;
        }

        public int stackCapacity() {
            return TileEntityDrawers.this.level * TileEntityDrawers.this.drawerCapacity;
        }
    }
}

