/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.client.renderer;

import com.jaquadro.minecraft.storagedrawers.block.BlockDrawers;
import com.jaquadro.minecraft.storagedrawers.block.tile.TileEntityDrawers;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.entity.RenderItem;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class TileEntityDrawersRenderer
extends TileEntitySpecialRenderer {
    private RenderItem itemRenderer = new RenderItem(){

        public byte getMiniBlockCount(ItemStack stack, byte original) {
            return 1;
        }

        public boolean shouldBob() {
            return false;
        }

        public boolean shouldSpreadItems() {
            return false;
        }
    };
    private double[] itemOffset2X = new double[]{0.5, 0.5};
    private double[] itemOffset2Y = new double[]{10.25, 2.25};
    private double[] itemOffset4X = new double[]{0.25, 0.25, 0.75, 0.75};
    private double[] itemOffset4Y = new double[]{10.25, 2.25, 10.25, 2.25};

    public void func_147500_a(TileEntity tile, double x, double y, double z, float partialTickTime) {
        TileEntityDrawers tileDrawers = (TileEntityDrawers)tile;
        if (tileDrawers == null) {
            return;
        }
        GL11.glPushMatrix();
        GL11.glTranslated((double)x, (double)y, (double)z);
        GL11.glEnable((int)2896);
        int drawerCount = tileDrawers.getDrawerCount();
        double depth = 1.0;
        double unit = 0.0625;
        Block block = tile.func_145831_w().func_147439_a(tile.field_145851_c, tile.field_145848_d, tile.field_145849_e);
        if (!(block instanceof BlockDrawers)) {
            return;
        }
        depth = ((BlockDrawers)block).halfDepth ? 0.5 : 1.0;
        this.itemRenderer.func_76976_a(RenderManager.field_78727_a);
        for (int i = 0; i < drawerCount; ++i) {
            ItemStack itemStack = tileDrawers.getSingleItemStack(i);
            if (itemStack == null) continue;
            GL11.glPushMatrix();
            boolean blockType = itemStack.func_94608_d() == 0 && itemStack.func_77973_b() instanceof ItemBlock && RenderBlocks.func_147739_a((int)Block.func_149634_a((Item)itemStack.func_77973_b()).func_149645_b());
            double xunit = drawerCount == 2 ? this.itemOffset2X[i] : this.itemOffset4X[i];
            double yunit = drawerCount == 2 ? this.itemOffset2Y[i] : this.itemOffset4Y[i];
            double zunit = blockType ? 2.0 * unit : unit;
            double xc = 0.0;
            double zc = 0.0;
            float r = 0.0f;
            switch (tileDrawers.getDirection()) {
                case 3: {
                    xc = xunit;
                    zc = depth - zunit;
                    r = 180.0f;
                    break;
                }
                case 2: {
                    xc = 1.0 - xunit;
                    zc = 1.0 - depth + zunit;
                    break;
                }
                case 5: {
                    xc = depth - zunit;
                    zc = xunit;
                    r = -90.0f;
                    break;
                }
                case 4: {
                    xc = 1.0 - depth + zunit;
                    zc = 1.0 - xunit;
                    r = 90.0f;
                }
            }
            if (blockType) {
                GL11.glTranslated((double)xc, (double)(unit * (yunit + 1.25)), (double)zc);
                GL11.glScaled((double)1.0, (double)1.0, (double)1.0);
                GL11.glRotatef((float)(r - 90.0f), (float)0.0f, (float)1.0f, (float)0.0f);
            } else {
                GL11.glTranslated((double)xc, (double)(unit * yunit), (double)zc);
                GL11.glScaled((double)0.6, (double)0.6, (double)0.6);
                GL11.glRotatef((float)r, (float)0.0f, (float)1.0f, (float)0.0f);
            }
            Minecraft mc = Minecraft.func_71410_x();
            boolean cache = mc.field_71474_y.field_74347_j;
            mc.field_71474_y.field_74347_j = true;
            EntityItem itemEnt = new EntityItem(null, 0.0, 0.0, 0.0, itemStack);
            itemEnt.field_70290_d = 0.0f;
            this.itemRenderer.func_76986_a(itemEnt, 0.0, 0.0, 0.0, 0.0f, 0.0f);
            mc.field_71474_y.field_74347_j = cache;
            GL11.glPopMatrix();
        }
        GL11.glPopMatrix();
    }
}

