/*
 * Decompiled with CFR 0.152.
 */
package zeldaswordskills.api.damage;

import java.util.HashSet;
import java.util.Set;
import net.minecraft.entity.Entity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.util.EntityDamageSourceIndirect;
import zeldaswordskills.api.damage.EnumDamageType;
import zeldaswordskills.api.damage.IDamageSourceStun;
import zeldaswordskills.api.damage.IDamageType;
import zeldaswordskills.api.damage.IPostDamageEffect;

public class DamageUtils {
    public static final String ARMOR_BREAK = "armorBreak";
    public static final String IARMOR_BREAK = "iArmorBreak";
    public static final String NON_SWORD = "nonSword";
    public static final String INDIRECT_SWORD = "indirectSword";

    public static DamageSource causeArmorBreakDamage(Entity entity) {
        return new DamageSourceArmorBreak(ARMOR_BREAK, entity);
    }

    public static DamageSource causeIArmorBreakDamage(Entity entity) {
        return new DamageSourceArmorBreak(IARMOR_BREAK, entity);
    }

    public static DamageSource causeNonSwordDamage(Entity entity) {
        return new EntityDamageSource(NON_SWORD, entity);
    }

    public static DamageSource causeIndirectSwordDamage(Entity direct, Entity indirect) {
        return new EntityDamageSourceIndirect(INDIRECT_SWORD, direct, indirect);
    }

    public static class DamageSourceIceIndirect
    extends EntityDamageSourceIndirect
    implements IDamageType,
    IPostDamageEffect {
        private Set<EnumDamageType> enumDamageTypes;
        private final int duration;
        private final int amplifier;

        public DamageSourceIceIndirect(String name, Entity direct, Entity indirect, int duration, int amplifier) {
            super(name, direct, indirect);
            this.duration = duration;
            this.amplifier = amplifier;
            this.enumDamageTypes = new HashSet<EnumDamageType>();
            this.enumDamageTypes.add(EnumDamageType.COLD);
        }

        @Override
        public int getDuration() {
            return this.duration;
        }

        @Override
        public int getAmplifier() {
            return this.amplifier;
        }

        @Override
        public Set<EnumDamageType> getEnumDamageTypes() {
            return this.enumDamageTypes;
        }
    }

    public static class DamageSourceIce
    extends EntityDamageSource
    implements IDamageType,
    IPostDamageEffect {
        private Set<EnumDamageType> enumDamageTypes;
        private final int duration;
        private final int amplifier;

        public DamageSourceIce(String name, Entity entity, int duration, int amplifier) {
            super(name, entity);
            this.duration = duration;
            this.amplifier = amplifier;
            this.enumDamageTypes = new HashSet<EnumDamageType>();
            this.enumDamageTypes.add(EnumDamageType.COLD);
        }

        @Override
        public int getDuration() {
            return this.duration;
        }

        @Override
        public int getAmplifier() {
            return this.amplifier;
        }

        @Override
        public Set<EnumDamageType> getEnumDamageTypes() {
            return this.enumDamageTypes;
        }
    }

    public static class DamageSourceHolyIndirect
    extends EntityDamageSourceIndirect
    implements IDamageType {
        private Set<EnumDamageType> enumDamageTypes = new HashSet<EnumDamageType>();

        public DamageSourceHolyIndirect(String name, Entity direct, Entity indirect) {
            super(name, direct, indirect);
            this.enumDamageTypes.add(EnumDamageType.HOLY);
        }

        @Override
        public Set<EnumDamageType> getEnumDamageTypes() {
            return this.enumDamageTypes;
        }
    }

    public static class DamageSourceHoly
    extends EntityDamageSource
    implements IDamageType {
        private Set<EnumDamageType> enumDamageTypes = new HashSet<EnumDamageType>();

        public DamageSourceHoly(String name, Entity entity) {
            super(name, entity);
            this.enumDamageTypes.add(EnumDamageType.HOLY);
        }

        @Override
        public Set<EnumDamageType> getEnumDamageTypes() {
            return this.enumDamageTypes;
        }
    }

    public static class DamageSourceStunIndirect
    extends EntityDamageSourceIndirect
    implements IDamageType,
    IDamageSourceStun {
        private Set<EnumDamageType> enumDamageTypes;
        private final int duration;
        private final int amplifier;
        private boolean canStunPlayers = false;

        public DamageSourceStunIndirect(String name, Entity direct, Entity indirect, int duration, int amplifier) {
            super(name, direct, indirect);
            this.duration = duration;
            this.amplifier = amplifier;
            this.enumDamageTypes = new HashSet<EnumDamageType>();
            this.enumDamageTypes.add(EnumDamageType.STUN);
        }

        @Override
        public Set<EnumDamageType> getEnumDamageTypes() {
            return this.enumDamageTypes;
        }

        @Override
        public int getDuration() {
            return this.duration;
        }

        @Override
        public int getAmplifier() {
            return this.amplifier;
        }

        public DamageSourceStunIndirect setCanStunPlayers() {
            this.canStunPlayers = true;
            return this;
        }

        @Override
        public boolean canStunPlayers() {
            return this.canStunPlayers;
        }

        @Override
        public boolean alwaysStuns() {
            return false;
        }
    }

    public static class DamageSourceStun
    extends EntityDamageSource
    implements IDamageType,
    IDamageSourceStun {
        private Set<EnumDamageType> enumDamageTypes;
        private final int duration;
        private final int amplifier;
        private boolean canStunPlayers = false;

        public DamageSourceStun(String name, Entity entity, int duration, int amplifier) {
            super(name, entity);
            this.duration = duration;
            this.amplifier = amplifier;
            this.enumDamageTypes = new HashSet<EnumDamageType>();
            this.enumDamageTypes.add(EnumDamageType.STUN);
        }

        @Override
        public Set<EnumDamageType> getEnumDamageTypes() {
            return this.enumDamageTypes;
        }

        @Override
        public int getDuration() {
            return this.duration;
        }

        @Override
        public int getAmplifier() {
            return this.amplifier;
        }

        public DamageSourceStun setCanStunPlayers() {
            this.canStunPlayers = true;
            return this;
        }

        @Override
        public boolean canStunPlayers() {
            return this.canStunPlayers;
        }

        @Override
        public boolean alwaysStuns() {
            return false;
        }
    }

    public static class DamageSourceShockIndirect
    extends EntityDamageSourceIndirect
    implements IDamageType,
    IDamageSourceStun {
        private final int duration;
        private final float hunger;
        private Set<EnumDamageType> enumDamageTypes;

        public DamageSourceShockIndirect(String name, Entity direct, Entity indirect, int duration, float hunger) {
            super(name, direct, indirect);
            this.duration = duration;
            this.hunger = hunger;
            this.func_76348_h();
            this.enumDamageTypes = new HashSet<EnumDamageType>();
            this.enumDamageTypes.add(EnumDamageType.SHOCK);
            this.enumDamageTypes.add(EnumDamageType.STUN);
        }

        @Override
        public Set<EnumDamageType> getEnumDamageTypes() {
            return this.enumDamageTypes;
        }

        @Override
        public int getDuration() {
            return this.duration;
        }

        @Override
        public int getAmplifier() {
            return 5;
        }

        @Override
        public boolean canStunPlayers() {
            return true;
        }

        @Override
        public boolean alwaysStuns() {
            return true;
        }

        public float func_76345_d() {
            return this.hunger;
        }
    }

    public static class DamageSourceShock
    extends EntityDamageSource
    implements IDamageType,
    IDamageSourceStun {
        private final int duration;
        private final float hunger;
        private Set<EnumDamageType> enumDamageTypes;

        public DamageSourceShock(String name, Entity entity, int duration, float hunger) {
            super(name, entity);
            this.duration = duration;
            this.hunger = hunger;
            this.func_76348_h();
            this.enumDamageTypes = new HashSet<EnumDamageType>();
            this.enumDamageTypes.add(EnumDamageType.SHOCK);
            this.enumDamageTypes.add(EnumDamageType.STUN);
        }

        @Override
        public Set<EnumDamageType> getEnumDamageTypes() {
            return this.enumDamageTypes;
        }

        @Override
        public int getDuration() {
            return this.duration;
        }

        @Override
        public int getAmplifier() {
            return 5;
        }

        @Override
        public boolean canStunPlayers() {
            return true;
        }

        @Override
        public boolean alwaysStuns() {
            return true;
        }

        public float func_76345_d() {
            return this.hunger;
        }
    }

    public static class DamageSourceArmorBreak
    extends EntityDamageSource {
        public DamageSourceArmorBreak(String name, Entity entity) {
            super(name, entity);
            this.func_76348_h();
        }
    }
}

