/*
 * Decompiled with CFR 0.152.
 */
package zeldaswordskills.api.damage;

import java.util.EnumMap;
import java.util.Map;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import zeldaswordskills.api.damage.IDamageSourceStun;
import zeldaswordskills.api.damage.IPostDamageEffect;
import zeldaswordskills.entity.ZSSEntityInfo;
import zeldaswordskills.entity.buff.Buff;

public enum EnumDamageType {
    COLD,
    HOLY,
    SHOCK,
    STUN;

    public static final Map<EnumDamageType, Buff> damageResistMap;
    public static final Map<EnumDamageType, Buff> damageWeaknessMap;

    public void handleSecondaryEffects(IPostDamageEffect source, EntityLivingBase entity, float damage) {
        switch (this) {
            case COLD: {
                entity.func_70690_d(new PotionEffect(Potion.field_76421_d.field_76415_H, (int)(damage * (float)source.getDuration()), source.getAmplifier()));
                break;
            }
            case STUN: {
                if (!(source instanceof IDamageSourceStun)) break;
                IDamageSourceStun stunSource = (IDamageSourceStun)source;
                int stunTime = Math.max(source.getDuration(), 2);
                int modifier = Math.max(source.getAmplifier(), 1);
                stunTime += entity.field_70170_p.field_73012_v.nextInt((int)(Math.max(damage, 1.0f) * (float)modifier)) - entity.field_70170_p.field_73012_v.nextInt(stunTime / 2);
                if (entity instanceof EntityPlayer && !stunSource.canStunPlayers()) break;
                ZSSEntityInfo.get(entity).stun(stunTime, stunSource.alwaysStuns());
                break;
            }
        }
    }

    static {
        damageResistMap = new EnumMap<EnumDamageType, Buff>(EnumDamageType.class);
        damageWeaknessMap = new EnumMap<EnumDamageType, Buff>(EnumDamageType.class);
        damageResistMap.put(COLD, Buff.RESIST_COLD);
        damageResistMap.put(HOLY, Buff.RESIST_HOLY);
        damageResistMap.put(SHOCK, Buff.RESIST_SHOCK);
        damageWeaknessMap.put(COLD, Buff.WEAKNESS_COLD);
        damageWeaknessMap.put(HOLY, Buff.WEAKNESS_HOLY);
        damageWeaknessMap.put(SHOCK, Buff.WEAKNESS_SHOCK);
    }
}

