/*
 * Decompiled with CFR 0.152.
 */
package zeldaswordskills.block;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import zeldaswordskills.ZSSMain;
import zeldaswordskills.api.block.BlockWeight;
import zeldaswordskills.block.tileentity.TileEntityPedestal;
import zeldaswordskills.creativetab.ZSSCreativeTabs;
import zeldaswordskills.item.ZSSItems;
import zeldaswordskills.util.WorldUtils;

public class BlockPedestal
extends BlockContainer {
    @SideOnly(value=Side.CLIENT)
    private IIcon iconTop;
    @SideOnly(value=Side.CLIENT)
    private IIcon iconBottom;
    @SideOnly(value=Side.CLIENT)
    private IIcon[] iconSide;

    public BlockPedestal() {
        super(Material.field_151576_e);
        this.func_149711_c(1.5f);
        this.func_149752_b(15.0f);
        this.func_149715_a(0.5f);
        this.func_149672_a(field_149769_e);
        this.func_149647_a(ZSSCreativeTabs.tabBlocks);
        this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 0.5f, 1.0f);
    }

    public TileEntity func_149915_a(World world, int meta) {
        return new TileEntityPedestal();
    }

    public boolean func_149686_d() {
        return false;
    }

    public boolean func_149662_c() {
        return false;
    }

    public int func_149656_h() {
        return 2;
    }

    public boolean canHarvestBlock(EntityPlayer player, int meta) {
        return meta == 8;
    }

    public float func_149712_f(World world, int x, int y, int z) {
        return world.func_72805_g(x, y, z) == 8 ? this.field_149782_v : -1.0f;
    }

    public float getExplosionResistance(Entity entity, World world, int x, int y, int z, double explosionX, double explosionY, double explosionZ) {
        return world.func_72805_g(x, y, z) == 8 ? this.func_149638_a(entity) : BlockWeight.getMaxResistance();
    }

    public void onBlockExploded(World world, int x, int y, int z, Explosion explosion) {
        if (world.func_72805_g(x, y, z) == 8) {
            super.onBlockExploded(world, x, y, z, explosion);
        }
    }

    public int func_149692_a(int meta) {
        return meta == 8 ? 8 : 0;
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int side, float hitX, float hitY, float hitZ) {
        if (player.func_70093_af() || !(world.func_147438_o(x, y, z) instanceof TileEntityPedestal)) {
            return false;
        }
        if (!world.field_72995_K) {
            TileEntityPedestal te = (TileEntityPedestal)world.func_147438_o(x, y, z);
            if (player.func_70694_bm() != null && player.func_70694_bm().func_77973_b() instanceof ItemSword && !te.hasSword()) {
                te.setSword(player.func_70694_bm(), player);
                player.func_70062_b(0, null);
            } else if (world.func_72805_g(x, y, z) == 8 && te.hasSword()) {
                te.retrieveSword();
            } else {
                player.openGui((Object)ZSSMain.instance, 0, world, x, y, z);
            }
        }
        return true;
    }

    public void func_149699_a(World world, int x, int y, int z, EntityPlayer player) {
        TileEntity te;
        if (!world.field_72995_K && (te = world.func_147438_o(x, y, z)) instanceof TileEntityPedestal) {
            ((TileEntityPedestal)te).changeOrientation();
        }
    }

    public void func_149689_a(World world, int x, int y, int z, EntityLivingBase entity, ItemStack stack) {
        TileEntity te;
        if (stack.func_77960_j() == 8 && (te = world.func_147438_o(x, y, z)) instanceof TileEntityPedestal) {
            ((TileEntityPedestal)te).onBlockPlaced();
        }
    }

    public void func_149749_a(World world, int x, int y, int z, Block block, int meta) {
        TileEntity te;
        if (meta != 8) {
            WorldUtils.dropContainerBlockInventory(world, x, y, z);
        } else if (meta == 8 && (te = world.func_147438_o(x, y, z)) instanceof TileEntityPedestal) {
            ((TileEntityPedestal)te).retrieveSword();
        }
        super.func_149749_a(world, x, y, z, block, meta);
    }

    public boolean func_149744_f() {
        return true;
    }

    public int func_149709_b(IBlockAccess world, int x, int y, int z, int side) {
        ItemStack sword;
        TileEntity te = world.func_147438_o(x, y, z);
        if (te instanceof TileEntityPedestal && (sword = ((TileEntityPedestal)te).getSword()) != null && sword.func_77973_b() == ZSSItems.swordMaster) {
            return 15;
        }
        return 0;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(Item item, CreativeTabs tab, List list) {
        list.add(new ItemStack(item, 1, 0));
        list.add(new ItemStack(item, 1, 8));
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int side, int meta) {
        return side == 0 ? this.iconBottom : (side == 1 ? this.iconTop : this.iconSide[Math.min(meta, 7)]);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister register) {
        this.iconTop = register.func_94245_a("zeldaswordskills:pedestal_top");
        this.iconBottom = register.func_94245_a("zeldaswordskills:pedestal_bottom");
        this.iconSide = new IIcon[8];
        for (int i = 0; i < this.iconSide.length; ++i) {
            this.iconSide[i] = register.func_94245_a("zeldaswordskills:pedestal_side_" + i);
        }
    }
}

