/*
 * Decompiled with CFR 0.152.
 */
package zeldaswordskills.client.render.entity;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.entity.Entity;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;
import zeldaswordskills.entity.projectile.EntityArrowBomb;
import zeldaswordskills.entity.projectile.EntityArrowCustom;
import zeldaswordskills.entity.projectile.EntityArrowElemental;

@SideOnly(value=Side.CLIENT)
public class RenderCustomArrow
extends Render {
    private static final ResourceLocation vanillaArrow = new ResourceLocation("zeldaswordskills", "textures/entity/arrow.png");
    private static final ResourceLocation bombArrow = new ResourceLocation("zeldaswordskills", "textures/entity/arrow_bomb.png");
    private static final ResourceLocation fireArrow = new ResourceLocation("zeldaswordskills", "textures/entity/arrow_fire.png");
    private static final ResourceLocation iceArrow = new ResourceLocation("zeldaswordskills", "textures/entity/arrow_ice.png");
    private static final ResourceLocation lightArrow = new ResourceLocation("zeldaswordskills", "textures/entity/arrow_light.png");

    public void renderArrow(EntityArrowCustom arrow, double dx, double dy, double dz, float yaw, float partialTick) {
        this.func_110777_b((Entity)arrow);
        GL11.glPushMatrix();
        GL11.glTranslated((double)dx, (double)dy, (double)dz);
        GL11.glRotatef((float)(arrow.field_70126_B + (arrow.field_70177_z - arrow.field_70126_B) * partialTick - 90.0f), (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glRotatef((float)(arrow.field_70127_C + (arrow.field_70125_A - arrow.field_70127_C) * partialTick), (float)0.0f, (float)0.0f, (float)1.0f);
        Tessellator tessellator = Tessellator.field_78398_a;
        int b0 = 0;
        float f2 = 0.0f;
        float f3 = 0.5f;
        float f4 = (float)(0 + b0 * 10) / 32.0f;
        float f5 = (float)(5 + b0 * 10) / 32.0f;
        float f6 = 0.0f;
        float f7 = 0.15625f;
        float f8 = (float)(5 + b0 * 10) / 32.0f;
        float f9 = (float)(10 + b0 * 10) / 32.0f;
        float f10 = 0.05625f;
        GL11.glEnable((int)32826);
        float f11 = (float)arrow.field_70249_b - partialTick;
        if (f11 > 0.0f) {
            float f12 = -MathHelper.func_76126_a((float)(f11 * 3.0f)) * f11;
            GL11.glRotatef((float)f12, (float)0.0f, (float)0.0f, (float)1.0f);
        }
        GL11.glRotatef((float)45.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glScalef((float)f10, (float)f10, (float)f10);
        GL11.glTranslatef((float)-4.0f, (float)0.0f, (float)0.0f);
        GL11.glNormal3f((float)f10, (float)0.0f, (float)0.0f);
        tessellator.func_78382_b();
        tessellator.func_78374_a(-7.0, -2.0, -2.0, (double)f6, (double)f8);
        tessellator.func_78374_a(-7.0, -2.0, 2.0, (double)f7, (double)f8);
        tessellator.func_78374_a(-7.0, 2.0, 2.0, (double)f7, (double)f9);
        tessellator.func_78374_a(-7.0, 2.0, -2.0, (double)f6, (double)f9);
        tessellator.func_78381_a();
        GL11.glNormal3f((float)(-f10), (float)0.0f, (float)0.0f);
        tessellator.func_78382_b();
        tessellator.func_78374_a(-7.0, 2.0, -2.0, (double)f6, (double)f8);
        tessellator.func_78374_a(-7.0, 2.0, 2.0, (double)f7, (double)f8);
        tessellator.func_78374_a(-7.0, -2.0, 2.0, (double)f7, (double)f9);
        tessellator.func_78374_a(-7.0, -2.0, -2.0, (double)f6, (double)f9);
        tessellator.func_78381_a();
        for (int i = 0; i < 4; ++i) {
            GL11.glRotatef((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            GL11.glNormal3f((float)0.0f, (float)0.0f, (float)f10);
            tessellator.func_78382_b();
            tessellator.func_78374_a(-8.0, -2.0, 0.0, (double)f2, (double)f4);
            tessellator.func_78374_a(8.0, -2.0, 0.0, (double)f3, (double)f4);
            tessellator.func_78374_a(8.0, 2.0, 0.0, (double)f3, (double)f5);
            tessellator.func_78374_a(-8.0, 2.0, 0.0, (double)f2, (double)f5);
            tessellator.func_78381_a();
        }
        GL11.glDisable((int)32826);
        GL11.glPopMatrix();
    }

    public void func_76986_a(Entity entity, double dx, double dy, double dz, float yaw, float partialTick) {
        this.renderArrow((EntityArrowCustom)entity, dx, dy, dz, yaw, partialTick);
    }

    protected ResourceLocation func_110775_a(Entity entity) {
        return this.getArrowTexture((EntityArrowCustom)entity);
    }

    protected ResourceLocation getArrowTexture(EntityArrowCustom arrow) {
        if (arrow instanceof EntityArrowBomb) {
            return this.getBombArrowTexture((EntityArrowBomb)arrow);
        }
        if (arrow instanceof EntityArrowElemental) {
            return this.getElementalArrowTexture((EntityArrowElemental)arrow);
        }
        return vanillaArrow;
    }

    protected ResourceLocation getBombArrowTexture(EntityArrowBomb arrow) {
        switch (arrow.getType()) {
            default: 
        }
        return bombArrow;
    }

    protected ResourceLocation getElementalArrowTexture(EntityArrowElemental arrow) {
        switch (arrow.getType()) {
            case FIRE: {
                return fireArrow;
            }
            case ICE: {
                return iceArrow;
            }
            case LIGHT: {
                return lightArrow;
            }
        }
        return vanillaArrow;
    }
}

