/*
 * Decompiled with CFR 0.152.
 */
package zeldaswordskills.entity;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import zeldaswordskills.client.ZSSKeyHandler;
import zeldaswordskills.entity.ZSSPlayerInfo;
import zeldaswordskills.lib.Config;
import zeldaswordskills.network.PacketDispatcher;
import zeldaswordskills.network.packet.client.SyncPlayerInfoPacket;
import zeldaswordskills.skills.ICombo;
import zeldaswordskills.skills.ILockOnTarget;
import zeldaswordskills.skills.SkillActive;
import zeldaswordskills.skills.SkillBase;

public class ZSSPlayerSkills {
    private static final UUID hardcoreHeartUUID = UUID.fromString("83E54288-6BE2-4398-A880-957654F515AB");
    private static final AttributeModifier hardcoreHeartModifier = new AttributeModifier(hardcoreHeartUUID, "Hardcore Zelda Hearts", -14.0, 0).func_111168_a(true);
    private final EntityPlayer player;
    private final ZSSPlayerInfo playerInfo;
    private final Map<Byte, SkillBase> skills;
    private final List<SkillActive> activeSkills = new LinkedList<SkillActive>();
    @SideOnly(value=Side.CLIENT)
    private SkillActive animatingSkill;
    private int fairySpinOrbsReceived = 0;

    public ZSSPlayerSkills(ZSSPlayerInfo playerInfo, EntityPlayer player) {
        this.playerInfo = playerInfo;
        this.player = player;
        this.skills = new HashMap<Byte, SkillBase>(SkillBase.getNumSkills());
    }

    public static ZSSPlayerSkills get(EntityPlayer player) {
        return ZSSPlayerInfo.get(player).getPlayerSkills();
    }

    public void resetSkills() {
        for (SkillBase skill : SkillBase.getSkills()) {
            this.skills.put(skill.getId(), skill.newInstance());
        }
        this.validateSkills();
        this.skills.clear();
        this.fairySpinOrbsReceived = 0;
        PacketDispatcher.sendTo(new SyncPlayerInfoPacket(ZSSPlayerInfo.get(this.player)), (EntityPlayerMP)this.player);
    }

    public final void validateSkills() {
        for (SkillBase skill : this.skills.values()) {
            skill.validateSkill(this.player);
        }
    }

    public void verifyMaxHealth() {
        IAttributeInstance attributeinstance = this.player.func_110148_a(SharedMonsterAttributes.field_111267_a);
        if (attributeinstance.func_111127_a(hardcoreHeartUUID) != null) {
            attributeinstance.func_111124_b(hardcoreHeartModifier);
        }
        if (Config.isHardcoreZeldaFan()) {
            attributeinstance.func_111121_a(hardcoreHeartModifier);
        }
        if (this.player.func_110143_aJ() > this.player.func_110138_aP()) {
            this.player.func_70606_j(this.player.func_110138_aP());
        }
    }

    public boolean isNayruActive() {
        return this.playerInfo.isNayruActive();
    }

    public boolean hasSkill(SkillBase skill) {
        return this.hasSkill(skill.getId());
    }

    private boolean hasSkill(byte id) {
        return this.getSkillLevel(id) > 0;
    }

    public byte getSkillLevel(SkillBase skill) {
        return this.getSkillLevel(skill.getId());
    }

    public byte getSkillLevel(byte id) {
        return this.skills.containsKey(id) ? this.skills.get(id).getLevel() : (byte)0;
    }

    public boolean isSkillActive(SkillBase skill) {
        for (SkillActive active : this.activeSkills) {
            if (active.getId() != skill.getId()) continue;
            return active.isActive();
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public SkillActive getCurrentlyAnimatingSkill() {
        return this.animatingSkill;
    }

    @SideOnly(value=Side.CLIENT)
    public void setCurrentlyAnimatingSkill(SkillActive skill) {
        this.animatingSkill = skill == null || skill.hasAnimation() ? skill : this.animatingSkill;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean canInteract() {
        if (this.animatingSkill != null && !this.animatingSkill.isActive() && !this.animatingSkill.isAnimating()) {
            this.animatingSkill = null;
        }
        return this.animatingSkill == null || !this.animatingSkill.isAnimating();
    }

    @SideOnly(value=Side.CLIENT)
    public boolean onKeyPressed(Minecraft mc, KeyBinding key) {
        for (SkillBase skill : this.skills.values()) {
            if (!(skill instanceof SkillActive) || !((SkillActive)skill).isKeyListener(mc, key) || !((SkillActive)skill).keyPressed(mc, key, this.player)) continue;
            return true;
        }
        return false;
    }

    public void onBeingAttacked(LivingAttackEvent event) {
        for (SkillActive skill : this.activeSkills) {
            if (!skill.isActive() || !skill.onBeingAttacked(this.player, event.source)) continue;
            event.setCanceled(true);
            return;
        }
    }

    public void onPostImpact(LivingHurtEvent event) {
        for (SkillActive skill : this.activeSkills) {
            if (!skill.isActive()) continue;
            event.ammount = skill.postImpact(this.player, event.entityLiving, event.ammount);
        }
        if (this.getComboSkill() != null) {
            this.getComboSkill().onHurtTarget(this.player, event);
        }
    }

    public SkillActive getActiveSkill(SkillBase skill) {
        SkillBase active = this.getPlayerSkill(skill.getId());
        return active instanceof SkillActive ? (SkillActive)active : null;
    }

    public SkillBase getPlayerSkill(SkillBase skill) {
        return this.getPlayerSkill(skill.getId());
    }

    public SkillBase getPlayerSkill(byte id) {
        return this.skills.containsKey(id) ? this.skills.get(id) : null;
    }

    public ICombo getComboSkill() {
        SkillBase skill = this.getPlayerSkill(SkillBase.swordBasic);
        if (skill != null && (((ICombo)((Object)skill)).getCombo() != null || ((SkillActive)skill).isActive())) {
            return (ICombo)((Object)skill);
        }
        return null;
    }

    public ILockOnTarget getTargetingSkill() {
        return (ILockOnTarget)((Object)this.getPlayerSkill(SkillBase.swordBasic));
    }

    public boolean grantSkill(SkillBase skill) {
        return this.grantSkill(skill.getId(), (byte)(this.getSkillLevel(skill) + 1));
    }

    public boolean grantSkill(byte id, byte targetLevel) {
        SkillBase skill;
        SkillBase skillBase = skill = this.skills.containsKey(id) ? this.skills.get(id) : SkillBase.getNewSkillInstance(id);
        if (skill.grantSkill(this.player, targetLevel)) {
            this.skills.put(id, skill);
            return true;
        }
        return false;
    }

    private void onSkillActivated(World world, SkillActive skill) {
        if (skill.isActive()) {
            this.activeSkills.add(skill);
        }
        if (world.field_72995_K) {
            this.setCurrentlyAnimatingSkill(skill);
        }
    }

    public boolean activateSkill(World world, SkillBase skill) {
        return this.activateSkill(world, skill.getId());
    }

    public boolean activateSkill(World world, byte id) {
        SkillBase skill = this.skills.get(id);
        if (skill instanceof SkillActive && ((SkillActive)skill).activate(world, this.player)) {
            this.onSkillActivated(world, (SkillActive)skill);
            return true;
        }
        return false;
    }

    public boolean triggerSkill(World world, SkillBase skill) {
        return this.triggerSkill(world, skill.getId());
    }

    public boolean triggerSkill(World world, byte id) {
        SkillBase skill = this.skills.get(id);
        if (skill instanceof SkillActive && ((SkillActive)skill).trigger(world, this.player, true)) {
            this.onSkillActivated(world, (SkillActive)skill);
            return true;
        }
        return false;
    }

    public boolean canReceiveFairyOrb() {
        return this.getSkillLevel(SkillBase.spinAttack) > this.getSkillLevel(SkillBase.superSpinAttack) && this.getSkillLevel(SkillBase.superSpinAttack) >= this.fairySpinOrbsReceived && this.getSkillLevel(SkillBase.bonusHeart) >= this.fairySpinOrbsReceived * Config.getMaxBonusHearts() / 5;
    }

    public boolean hasReceivedAllOrbs() {
        return this.fairySpinOrbsReceived == 5;
    }

    public boolean receiveFairyOrb() {
        return ++this.fairySpinOrbsReceived == 5;
    }

    @SideOnly(value=Side.CLIENT)
    public void syncClientSideSkill(byte id, NBTTagCompound compound) {
        if (SkillBase.doesSkillExist(id)) {
            this.skills.put(id, SkillBase.getNewSkillInstance(id).loadFromNBT(compound));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void onRenderTick(float partialRenderTick) {
        boolean flag = false;
        if (this.animatingSkill != null) {
            if (this.animatingSkill.isAnimating()) {
                flag = this.animatingSkill.onRenderTick(this.player, partialRenderTick);
            } else if (!this.animatingSkill.isActive()) {
                this.setCurrentlyAnimatingSkill(null);
            }
        }
        ILockOnTarget skill = this.getTargetingSkill();
        if (!flag && skill != null && skill.isLockedOn()) {
            ((SkillActive)((Object)skill)).onRenderTick(this.player, partialRenderTick);
        }
    }

    public void onUpdate() {
        for (SkillBase skill : this.skills.values()) {
            skill.onUpdate(this.player);
        }
        Iterator<SkillActive> iterator = this.activeSkills.iterator();
        while (iterator.hasNext()) {
            SkillBase skill;
            skill = iterator.next();
            if (((SkillActive)skill).isActive()) continue;
            iterator.remove();
        }
        if (this.player.field_70170_p.field_72995_K && ZSSKeyHandler.keys[6].func_151470_d() && this.isSkillActive(SkillBase.swordBasic) && this.player.func_70694_bm() != null) {
            Minecraft.func_71410_x().field_71442_b.func_78769_a(this.player, this.player.field_70170_p, this.player.func_70694_bm());
        }
    }

    public void saveNBTData(NBTTagCompound compound) {
        NBTTagList taglist = new NBTTagList();
        for (SkillBase skill : this.skills.values()) {
            NBTTagCompound skillTag = new NBTTagCompound();
            skill.writeToNBT(skillTag);
            taglist.func_74742_a((NBTBase)skillTag);
        }
        compound.func_74782_a("ZeldaSwordSkills", (NBTBase)taglist);
        compound.func_74768_a("fairySpinOrbsReceived", this.fairySpinOrbsReceived);
    }

    public void loadNBTData(NBTTagCompound compound) {
        this.skills.clear();
        NBTTagList taglist = compound.func_150295_c("ZeldaSwordSkills", 10);
        for (int i = 0; i < taglist.func_74745_c(); ++i) {
            NBTTagCompound skill = taglist.func_150305_b(i);
            byte id = skill.func_74771_c("id");
            this.skills.put(id, SkillBase.getSkill(id).loadFromNBT(skill));
        }
        this.fairySpinOrbsReceived = compound.func_74762_e("fairySpinOrbsReceived");
    }
}

