/*
 * Decompiled with CFR 0.152.
 */
package zeldaswordskills.entity;

import java.util.EnumMap;
import java.util.Map;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.stats.StatBase;
import net.minecraft.util.MathHelper;
import net.minecraft.village.MerchantRecipe;
import net.minecraft.village.Village;
import net.minecraft.world.World;
import net.minecraftforge.common.IExtendedEntityProperties;
import zeldaswordskills.ZSSAchievements;
import zeldaswordskills.entity.EntityChu;
import zeldaswordskills.entity.EntityGoron;
import zeldaswordskills.entity.EntityMaskTrader;
import zeldaswordskills.handler.TradeHandler;
import zeldaswordskills.item.ItemTreasure;
import zeldaswordskills.item.ZSSItems;
import zeldaswordskills.lib.Config;
import zeldaswordskills.util.MerchantRecipeHelper;

public class ZSSVillagerInfo
implements IExtendedEntityProperties {
    private static final String SAVE_KEY = "zssVillagerInfo";
    private static final int NONE = -1;
    private final EntityVillager villager;
    private NBTTagCompound data;
    private int desiredMask;
    private static final Map<ItemTreasure.Treasures, MerchantRecipe> treasureTrades = new EnumMap<ItemTreasure.Treasures, MerchantRecipe>(ItemTreasure.Treasures.class);
    private static final Map<ItemTreasure.Treasures, Integer> treasureVillager = new EnumMap<ItemTreasure.Treasures, Integer>(ItemTreasure.Treasures.class);
    private static final Map<ItemTreasure.Treasures, String> treasureCustom = new EnumMap<ItemTreasure.Treasures, String>(ItemTreasure.Treasures.class);
    private Village village;
    private EntityVillager mate = null;
    private int matingTime = 0;

    public ZSSVillagerInfo(EntityVillager villager) {
        this.villager = villager;
        this.data = new NBTTagCompound();
        this.desiredMask = EntityMaskTrader.getMaskMapSize();
    }

    public static final void register(EntityVillager villager) {
        villager.registerExtendedProperties(SAVE_KEY, (IExtendedEntityProperties)new ZSSVillagerInfo(villager));
    }

    public static final ZSSVillagerInfo get(EntityVillager villager) {
        return (ZSSVillagerInfo)villager.getExtendedProperties(SAVE_KEY);
    }

    public Item getMaskDesired() {
        if (this.desiredMask == EntityMaskTrader.getMaskMapSize()) {
            this.desiredMask = this.villager.field_70170_p.field_73012_v.nextFloat() < Config.getMaskBuyChance() ? this.villager.field_70170_p.field_73012_v.nextInt(EntityMaskTrader.getMaskMapSize()) : -1;
        }
        return this.desiredMask != -1 ? EntityMaskTrader.getMask(this.desiredMask) : null;
    }

    public void onMaskTrade() {
        this.desiredMask = -1;
    }

    public boolean isHunter() {
        return this.villager.func_70946_n() == TradeHandler.EnumVillager.BUTCHER.ordinal() && this.villager.func_94057_bL() != null && this.villager.func_94057_bL().contains("Hunter");
    }

    public boolean isMonsterHunter() {
        return this.isHunter() && this.villager.func_94057_bL().equals("Monster Hunter");
    }

    public boolean isInterested(ItemTreasure.Treasures treasure, ItemStack stack) {
        if (treasureCustom.containsKey((Object)treasure)) {
            boolean flag = treasureCustom.get((Object)treasure).equals(this.villager.func_94057_bL());
            if (flag && treasureCustom.get((Object)treasure).equals("Biggoron")) {
                flag = this.villager instanceof EntityGoron;
            }
            if (flag && treasure == ItemTreasure.Treasures.CLAIM_CHECK) {
                flag = stack.func_77942_o() && stack.func_77978_p().func_74764_b("finishDate") && this.villager.field_70170_p.func_72820_D() > stack.func_77978_p().func_74763_f("finishDate");
            }
            return !(!flag || treasure == ItemTreasure.Treasures.TENTACLE && !this.villager.func_70631_g_() || treasureVillager.get((Object)treasure) != null && treasureVillager.get((Object)treasure).intValue() != this.villager.func_70946_n());
        }
        return treasureVillager.get((Object)treasure).intValue() == this.villager.func_70946_n();
    }

    public boolean isFinalTrade(ItemTreasure.Treasures treasure, ItemStack stack) {
        if (treasure == ItemTreasure.Treasures.CLAIM_CHECK && treasureCustom.containsKey((Object)treasure) && treasureCustom.get((Object)treasure).equals(this.villager.func_94057_bL())) {
            if (!stack.func_77942_o()) {
                stack.func_77982_d(new NBTTagCompound());
            }
            if (!stack.func_77978_p().func_74764_b("finishDate")) {
                stack.func_77978_p().func_74772_a("finishDate", this.villager.field_70170_p.func_72820_D());
            }
            return true;
        }
        return false;
    }

    public boolean onTradedTreasure(EntityPlayer player, ItemTreasure.Treasures treasure, ItemStack stack) {
        switch (treasure) {
            case TENTACLE: {
                player.func_71029_a((StatBase)ZSSAchievements.treasureFirst);
                break;
            }
            case POCKET_EGG: {
                player.func_71029_a((StatBase)ZSSAchievements.treasureSecond);
                break;
            }
            case COJIRO: {
                return true;
            }
            case GORON_SWORD: {
                return true;
            }
            case EYE_DROPS: {
                if (!stack.func_77942_o()) {
                    stack.func_77982_d(new NBTTagCompound());
                }
                stack.func_77978_p().func_74772_a("finishDate", this.villager.field_70170_p.func_72820_D() + 48000L);
                return true;
            }
            case CLAIM_CHECK: {
                player.func_71029_a((StatBase)ZSSAchievements.treasureBiggoron);
                MerchantRecipeHelper.addUniqueTrade(this.villager.func_70934_b(player), new MerchantRecipe(new ItemStack(ZSSItems.masterOre, 3), new ItemStack(Items.field_151045_i, 4), new ItemStack(ZSSItems.swordBiggoron)));
                break;
            }
        }
        return false;
    }

    public void addJelly(EntityChu.ChuType type, int amount) {
        this.data.func_74768_a("jelliesReceived" + type.ordinal(), this.getJelliesReceived(type) + amount);
    }

    public int getJelliesReceived(EntityChu.ChuType type) {
        return this.data.func_74764_b("jelliesReceived" + type.ordinal()) ? this.data.func_74762_e("jelliesReceived" + type.ordinal()) : 0;
    }

    public boolean isChuTrader() {
        return this.villager.func_70946_n() == TradeHandler.EnumVillager.LIBRARIAN.ordinal() && this.villager.func_94057_bL().contains("Doc");
    }

    public boolean canSellType(EntityChu.ChuType type, ItemStack stack) {
        int jellies;
        for (jellies = this.getJelliesReceived(type); jellies < 15 && stack.field_77994_a > 0; ++jellies) {
            --stack.field_77994_a;
        }
        this.data.func_74768_a("jelliesReceived" + type.ordinal(), jellies);
        return jellies >= 15;
    }

    private boolean isMating() {
        return this.matingTime > 0 && this.villager.func_70874_b() == 0 && this.areSufficientDoors();
    }

    public void setMating() {
        if (this.villager.func_70874_b() == 0 && !this.isMating()) {
            Entity e;
            this.village = this.villager.field_70170_p.field_72982_D.func_75550_a(MathHelper.func_76128_c((double)this.villager.field_70165_t), MathHelper.func_76128_c((double)this.villager.field_70163_u), MathHelper.func_76128_c((double)this.villager.field_70161_v), 0);
            if (this.areSufficientDoors() && (e = this.villager.field_70170_p.func_72857_a(EntityVillager.class, this.villager.field_70121_D.func_72314_b(8.0, 3.0, 8.0), (Entity)this.villager)) != null && ((EntityVillager)e).func_70874_b() == 0) {
                this.mate = (EntityVillager)e;
                this.matingTime = 300;
                this.villager.func_70947_e(true);
            }
        }
    }

    private void updateMating() {
        if (this.isMating()) {
            --this.matingTime;
            this.villager.func_70671_ap().func_75651_a((Entity)this.mate, 10.0f, 30.0f);
            if (this.villager.func_70068_e((Entity)this.mate) > 2.25) {
                this.villager.func_70661_as().func_75497_a((Entity)this.mate, 0.25);
            } else if (this.matingTime == 0 && this.mate.func_70941_o()) {
                this.giveBirth();
                this.resetMating();
            }
            if (this.villager.func_70681_au().nextInt(35) == 0) {
                this.villager.field_70170_p.func_72960_a((Entity)this.villager, (byte)12);
            }
        }
    }

    private boolean areSufficientDoors() {
        return this.village != null ? this.village.func_75562_e() < this.village.func_75567_c() : false;
    }

    private void resetMating() {
        this.villager.func_70947_e(false);
        this.mate = null;
    }

    private void giveBirth() {
        EntityVillager baby = this.villager.func_90011_a((EntityAgeable)this.mate);
        this.mate.func_70873_a(6000);
        this.villager.func_70873_a(6000);
        baby.func_70873_a(-24000);
        baby.func_70012_b(this.villager.field_70165_t, this.villager.field_70163_u, this.villager.field_70161_v, 0.0f, 0.0f);
        this.villager.field_70170_p.func_72838_d((Entity)baby);
        this.villager.field_70170_p.func_72960_a((Entity)baby, (byte)12);
    }

    public void onUpdate() {
        this.updateMating();
    }

    public void init(Entity entity, World world) {
    }

    public void saveNBTData(NBTTagCompound compound) {
        compound.func_74782_a(SAVE_KEY, (NBTBase)this.data);
        compound.func_74768_a("desiredMask", this.desiredMask);
    }

    public void loadNBTData(NBTTagCompound compound) {
        this.data = compound.func_74764_b(SAVE_KEY) ? compound.func_74775_l(SAVE_KEY) : new NBTTagCompound();
        this.desiredMask = compound.func_74762_e("desiredMask");
    }

    public static final void addTreasureTrade(ItemTreasure.Treasures treasure, TradeHandler.EnumVillager villager, ItemStack required, ItemStack output) {
        treasureVillager.put(treasure, villager != null ? Integer.valueOf(villager.ordinal()) : null);
        treasureTrades.put(treasure, new MerchantRecipe(new ItemStack(ZSSItems.treasure, 1, treasure.ordinal()), required, output));
    }

    public static final void addTreasureTrade(ItemTreasure.Treasures treasure, String name, TradeHandler.EnumVillager villager, ItemStack required, ItemStack output) {
        treasureCustom.put(treasure, name);
        ZSSVillagerInfo.addTreasureTrade(treasure, villager, required, output);
    }

    public static final MerchantRecipe getTreasureTrade(ItemTreasure.Treasures treasure) {
        return treasureTrades.get((Object)treasure);
    }

    public static void initTrades() {
        ZSSVillagerInfo.addTreasureTrade(ItemTreasure.Treasures.EVIL_CRYSTAL, TradeHandler.EnumVillager.PRIEST, new ItemStack(ZSSItems.arrowLight, 16), new ItemStack(ZSSItems.crystalSpirit));
        ZSSVillagerInfo.addTreasureTrade(ItemTreasure.Treasures.TENTACLE, "Talon", TradeHandler.EnumVillager.FARMER, null, new ItemStack(ZSSItems.treasure, 1, ItemTreasure.Treasures.POCKET_EGG.ordinal()));
        ZSSVillagerInfo.addTreasureTrade(ItemTreasure.Treasures.POCKET_EGG, "Cucco Lady", TradeHandler.EnumVillager.FARMER, null, new ItemStack(ZSSItems.treasure, 1, ItemTreasure.Treasures.COJIRO.ordinal()));
        ZSSVillagerInfo.addTreasureTrade(ItemTreasure.Treasures.COJIRO, "Grog", TradeHandler.EnumVillager.FARMER, null, new ItemStack(ZSSItems.treasure, 1, ItemTreasure.Treasures.ODD_MUSHROOM.ordinal()));
        ZSSVillagerInfo.addTreasureTrade(ItemTreasure.Treasures.ODD_MUSHROOM, "Old Hag", TradeHandler.EnumVillager.LIBRARIAN, null, new ItemStack(ZSSItems.treasure, 1, ItemTreasure.Treasures.ODD_POTION.ordinal()));
        ZSSVillagerInfo.addTreasureTrade(ItemTreasure.Treasures.ODD_POTION, "Grog", TradeHandler.EnumVillager.FARMER, null, new ItemStack(ZSSItems.treasure, 1, ItemTreasure.Treasures.POACHER_SAW.ordinal()));
        ZSSVillagerInfo.addTreasureTrade(ItemTreasure.Treasures.POACHER_SAW, "Mutoh", TradeHandler.EnumVillager.BLACKSMITH, null, new ItemStack(ZSSItems.treasure, 1, ItemTreasure.Treasures.GORON_SWORD.ordinal()));
        ZSSVillagerInfo.addTreasureTrade(ItemTreasure.Treasures.GORON_SWORD, "Biggoron", null, null, new ItemStack(ZSSItems.treasure, 1, ItemTreasure.Treasures.PRESCRIPTION.ordinal()));
        ZSSVillagerInfo.addTreasureTrade(ItemTreasure.Treasures.PRESCRIPTION, "King Zora", TradeHandler.EnumVillager.PRIEST, null, new ItemStack(ZSSItems.treasure, 1, ItemTreasure.Treasures.EYEBALL_FROG.ordinal()));
        ZSSVillagerInfo.addTreasureTrade(ItemTreasure.Treasures.EYEBALL_FROG, "Lake Scientist", TradeHandler.EnumVillager.LIBRARIAN, null, new ItemStack(ZSSItems.treasure, 1, ItemTreasure.Treasures.EYE_DROPS.ordinal()));
        ZSSVillagerInfo.addTreasureTrade(ItemTreasure.Treasures.EYE_DROPS, "Biggoron", null, null, new ItemStack(ZSSItems.treasure, 1, ItemTreasure.Treasures.CLAIM_CHECK.ordinal()));
        ZSSVillagerInfo.addTreasureTrade(ItemTreasure.Treasures.CLAIM_CHECK, "Biggoron", null, null, new ItemStack(ZSSItems.swordBiggoron));
    }
}

