/*
 * Decompiled with CFR 0.152.
 */
package zeldaswordskills.entity.buff;

import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import zeldaswordskills.entity.buff.Buff;
import zeldaswordskills.network.PacketDispatcher;
import zeldaswordskills.network.packet.client.UpdateBuffPacket;
import zeldaswordskills.util.LogHelper;

public class BuffBase {
    private final Buff buff;
    private int duration;
    private int amplifier;

    public BuffBase(Buff buff, int duration, int amplifier) {
        this.buff = buff;
        this.duration = duration;
        this.amplifier = amplifier;
    }

    public BuffBase(BuffBase b) {
        this.buff = b.buff;
        this.duration = b.duration;
        this.amplifier = b.amplifier;
    }

    public Buff getBuff() {
        return this.buff;
    }

    public int getDuration() {
        return this.duration;
    }

    public int getAmplifier() {
        return this.amplifier;
    }

    public int getIconIndex() {
        return this.buff.iconIndex;
    }

    public boolean isDebuff() {
        return this.buff.isDebuff;
    }

    public boolean displayArrow() {
        return this.buff.displayArrow;
    }

    public boolean isPermanent() {
        return this.duration == Integer.MAX_VALUE;
    }

    public int hashCode() {
        return 31 * (31 + this.buff.ordinal()) + this.amplifier;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        BuffBase base = (BuffBase)obj;
        return this.buff == base.buff && this.duration == base.duration && this.amplifier == base.amplifier;
    }

    public String toString() {
        return this.buff.getName();
    }

    public void combine(BuffBase newBuff) {
        if (newBuff.buff != this.buff) {
            LogHelper.warning("Combining two buffs of different types should be impossible!");
        } else if (!this.isPermanent()) {
            if (newBuff.amplifier > this.amplifier) {
                this.amplifier = newBuff.amplifier;
                this.duration = newBuff.duration;
            } else if (newBuff.amplifier == this.amplifier && newBuff.duration > this.duration) {
                this.duration = newBuff.duration;
            }
        }
    }

    public void onAdded(EntityLivingBase entity) {
        if (!entity.field_70170_p.field_72995_K) {
            this.buff.onAdded(entity, this.amplifier);
            if (entity instanceof EntityPlayer) {
                PacketDispatcher.sendTo(new UpdateBuffPacket(this, false), (EntityPlayerMP)entity);
            }
        }
    }

    public void onRemoved(EntityLivingBase entity) {
        this.onRemoved(entity, true);
    }

    private void onRemoved(EntityLivingBase entity, boolean needsUpdate) {
        if (!entity.field_70170_p.field_72995_K) {
            this.buff.onRemoved(entity, this.amplifier);
            if (needsUpdate && entity instanceof EntityPlayer) {
                PacketDispatcher.sendTo(new UpdateBuffPacket(this, true), (EntityPlayerMP)entity);
            }
        }
    }

    public void onChanged(EntityLivingBase entity) {
        if (!entity.field_70170_p.field_72995_K) {
            this.onRemoved(entity, false);
            this.onAdded(entity);
        }
    }

    public boolean onUpdate(EntityLivingBase entity) {
        if (this.duration > 0 && !this.isPermanent()) {
            this.buff.onUpdate(entity, this.duration, this.amplifier);
            --this.duration;
        }
        return this.duration == 0;
    }

    public static BuffBase readFromNBT(NBTTagCompound compound) {
        Buff b = Buff.values()[compound.func_74771_c("buffId")];
        byte amp = compound.func_74771_c("amplifier");
        int dur = compound.func_74762_e("duration");
        return new BuffBase(b, dur, amp);
    }

    public NBTTagCompound writeToNBT(NBTTagCompound compound) {
        compound.func_74774_a("buffId", (byte)this.buff.ordinal());
        compound.func_74774_a("amplifier", (byte)this.amplifier);
        compound.func_74768_a("duration", this.duration);
        return compound;
    }
}

