/*
 * Decompiled with CFR 0.152.
 */
package zeldaswordskills.entity.projectile;

import cpw.mods.fml.common.registry.IEntityAdditionalSpawnData;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S2BPacketChangeGameState;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSourceIndirect;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import zeldaswordskills.util.TargetUtils;

public class EntityArrowCustom
extends EntityArrow
implements IEntityAdditionalSpawnData {
    private static final int HOMING_DATAWATCHER_INDEX = 23;
    private static final int TARGET_DATAWATCHER_INDEX = 24;
    private String shooterName = null;
    protected Block inTile;
    protected int field_70253_h;
    protected int xTile = -1;
    protected int yTile = -1;
    protected int zTile = -1;
    protected int field_70252_j = 0;
    protected int field_70257_an = 0;
    protected boolean field_70254_i = false;
    private int knockbackStrength;
    private Item arrowItem = Items.field_151032_g;

    public EntityArrowCustom(World world) {
        super(world);
    }

    public EntityArrowCustom(World world, double x, double y, double z) {
        super(world, x, y, z);
    }

    public EntityArrowCustom(World world, EntityLivingBase shooter, float velocity) {
        super(world);
        this.field_70155_l = 10.0;
        this.field_70250_c = shooter;
        if (shooter instanceof EntityPlayer) {
            this.field_70251_a = 1;
        }
        this.func_70105_a(0.5f, 0.5f);
        this.func_70012_b(shooter.field_70165_t, shooter.field_70163_u + (double)shooter.func_70047_e(), shooter.field_70161_v, shooter.field_70177_z, shooter.field_70125_A);
        this.field_70165_t -= (double)(MathHelper.func_76134_b((float)(this.field_70177_z / 180.0f * (float)Math.PI)) * 0.16f);
        this.field_70163_u -= (double)0.1f;
        this.field_70161_v -= (double)(MathHelper.func_76126_a((float)(this.field_70177_z / 180.0f * (float)Math.PI)) * 0.16f);
        this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        this.field_70129_M = 0.0f;
        this.field_70159_w = -MathHelper.func_76126_a((float)(this.field_70177_z / 180.0f * (float)Math.PI)) * MathHelper.func_76134_b((float)(this.field_70125_A / 180.0f * (float)Math.PI));
        this.field_70179_y = MathHelper.func_76134_b((float)(this.field_70177_z / 180.0f * (float)Math.PI)) * MathHelper.func_76134_b((float)(this.field_70125_A / 180.0f * (float)Math.PI));
        this.field_70181_x = -MathHelper.func_76126_a((float)(this.field_70125_A / 180.0f * (float)Math.PI));
        this.func_70186_c(this.field_70159_w, this.field_70181_x, this.field_70179_y, velocity * this.getVelocityFactor(), 1.0f);
    }

    public EntityArrowCustom(World world, EntityLivingBase shooter, EntityLivingBase target, float velocity, float wobble) {
        super(world, shooter, target, velocity, wobble);
        this.setTarget(target);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_75682_a(24, (Object)-1);
        this.field_70180_af.func_75682_a(23, (Object)0);
    }

    protected boolean isHomingArrow() {
        return (this.field_70180_af.func_75683_a(23) & 1) != 0;
    }

    public void setHomingArrow(boolean isHoming) {
        this.field_70180_af.func_75692_b(23, (Object)((byte)(isHoming ? 1 : 0)));
    }

    public Entity getShooter() {
        if (this.field_70250_c == null && this.shooterName != null) {
            this.field_70250_c = this.field_70170_p.func_72924_a(this.shooterName);
        }
        return this.field_70250_c;
    }

    protected EntityLivingBase getTarget() {
        int id = this.field_70180_af.func_75679_c(24);
        return id > 0 ? (EntityLivingBase)this.field_70170_p.func_73045_a(id) : null;
    }

    public void setTarget(EntityLivingBase target) {
        this.field_70180_af.func_75692_b(24, (Object)(target != null ? target.func_145782_y() : -1));
    }

    public EntityArrowCustom setArrowItem(Item item) {
        this.arrowItem = item;
        return this;
    }

    public void func_70071_h_() {
        super.func_70030_z();
        this.updateAngles();
        this.checkInGround();
        if (this.field_70249_b > 0) {
            --this.field_70249_b;
        }
        if (this.field_70254_i) {
            this.updateInGround();
        } else {
            this.updateInAir();
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_70016_h(double x, double y, double z) {
        if (this.field_70127_C == 0.0f && this.field_70126_B == 0.0f) {
            this.field_70252_j = 0;
        }
        super.func_70016_h(x, y, z);
    }

    public void func_70100_b_(EntityPlayer player) {
        if (!this.field_70170_p.field_72995_K && this.field_70254_i && this.field_70249_b <= 0) {
            boolean flag;
            boolean bl = flag = this.field_70251_a == 1 || this.field_70251_a == 2 && player.field_71075_bZ.field_75098_d;
            if (this.field_70251_a == 1 && !player.field_71071_by.func_70441_a(new ItemStack(this.arrowItem, 1, 0))) {
                flag = false;
            }
            if (flag) {
                this.func_85030_a("random.pop", 0.2f, ((this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.7f + 1.0f) * 2.0f);
                player.func_71001_a((Entity)this, 1);
                this.func_70106_y();
            }
        }
    }

    protected DamageSource getDamageSource(Entity entity) {
        return new EntityDamageSourceIndirect("arrow", (Entity)this, this.field_70250_c).func_76349_b();
    }

    protected boolean canTargetEntity(Entity entity) {
        return !(entity instanceof EntityEnderman);
    }

    public int getKnockbackStrength() {
        return this.knockbackStrength;
    }

    public void func_70240_a(int value) {
        this.knockbackStrength = value;
    }

    protected void updateAngles() {
        if (this.field_70127_C == 0.0f && this.field_70126_B == 0.0f) {
            float f = MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y));
            this.field_70126_B = this.field_70177_z = (float)(Math.atan2(this.field_70159_w, this.field_70179_y) * 180.0 / Math.PI);
            this.field_70127_C = this.field_70125_A = (float)(Math.atan2(this.field_70181_x, f) * 180.0 / Math.PI);
        }
    }

    protected void updatePosition() {
        this.field_70165_t += this.field_70159_w;
        this.field_70163_u += this.field_70181_x;
        this.field_70161_v += this.field_70179_y;
        float f = MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y));
        this.field_70177_z = (float)(Math.atan2(this.field_70159_w, this.field_70179_y) * 180.0 / Math.PI);
        this.field_70125_A = (float)(Math.atan2(this.field_70181_x, f) * 180.0 / Math.PI);
        while (this.field_70125_A - this.field_70127_C < -180.0f) {
            this.field_70127_C -= 360.0f;
        }
        while (this.field_70125_A - this.field_70127_C >= 180.0f) {
            this.field_70127_C += 360.0f;
        }
        while (this.field_70177_z - this.field_70126_B < -180.0f) {
            this.field_70126_B -= 360.0f;
        }
        while (this.field_70177_z - this.field_70126_B >= 180.0f) {
            this.field_70126_B += 360.0f;
        }
        this.field_70125_A = this.field_70127_C + (this.field_70125_A - this.field_70127_C) * 0.2f;
        this.field_70177_z = this.field_70126_B + (this.field_70177_z - this.field_70126_B) * 0.2f;
        float motionFactor = 0.99f;
        if (this.func_70090_H()) {
            for (int i = 0; i < 4; ++i) {
                float f3 = 0.25f;
                this.field_70170_p.func_72869_a("bubble", this.field_70165_t - this.field_70159_w * (double)f3, this.field_70163_u - this.field_70181_x * (double)f3, this.field_70161_v - this.field_70179_y * (double)f3, this.field_70159_w, this.field_70181_x, this.field_70179_y);
            }
            motionFactor = 0.8f;
        }
        this.updateMotion(motionFactor, this.getGravityVelocity());
        this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
    }

    protected void updateMotion(float factor, float adjustY) {
        EntityLivingBase target = this.getTarget();
        if (this.isHomingArrow() && target != null) {
            double d0 = target.field_70165_t - this.field_70165_t;
            double d1 = target.field_70121_D.field_72338_b + (double)target.field_70131_O - this.field_70163_u;
            double d2 = target.field_70161_v - this.field_70161_v;
            this.func_70186_c(d0, d1, d2, this.getVelocityFactor() * 2.0f, 1.0f);
        } else {
            this.field_70159_w *= (double)factor;
            this.field_70181_x *= (double)factor;
            this.field_70179_y *= (double)factor;
            this.field_70181_x -= (double)adjustY;
        }
    }

    protected void checkInGround() {
        Block block = this.field_70170_p.func_147439_a(this.xTile, this.yTile, this.zTile);
        if (block.func_149688_o() != Material.field_151579_a) {
            block.func_149719_a((IBlockAccess)this.field_70170_p, this.xTile, this.yTile, this.zTile);
            AxisAlignedBB axisalignedbb = block.func_149668_a(this.field_70170_p, this.xTile, this.yTile, this.zTile);
            if (axisalignedbb != null && axisalignedbb.func_72318_a(Vec3.func_72443_a((double)this.field_70165_t, (double)this.field_70163_u, (double)this.field_70161_v))) {
                this.field_70254_i = true;
            }
        }
    }

    protected void updateInGround() {
        Block block = this.field_70170_p.func_147439_a(this.xTile, this.yTile, this.zTile);
        int k = this.field_70170_p.func_72805_g(this.xTile, this.yTile, this.zTile);
        if (block == this.inTile && k == this.field_70253_h) {
            ++this.field_70252_j;
            if (this.field_70252_j == 1200) {
                this.func_70106_y();
            }
        } else {
            this.field_70254_i = false;
            this.field_70159_w *= (double)(this.field_70146_Z.nextFloat() * 0.2f);
            this.field_70181_x *= (double)(this.field_70146_Z.nextFloat() * 0.2f);
            this.field_70179_y *= (double)(this.field_70146_Z.nextFloat() * 0.2f);
            this.field_70252_j = 0;
            this.field_70257_an = 0;
        }
    }

    protected void updateInAir() {
        ++this.field_70257_an;
        MovingObjectPosition mop = TargetUtils.checkForImpact(this.field_70170_p, (Entity)this, this.getShooter(), 0.3, this.field_70257_an >= 5);
        if (mop != null) {
            this.onImpact(mop);
        }
        this.spawnTrailingParticles();
        this.updatePosition();
        this.func_145775_I();
    }

    protected float getVelocityFactor() {
        return 1.5f;
    }

    protected float getGravityVelocity() {
        return 0.05f;
    }

    protected String getParticleName() {
        return "crit";
    }

    protected boolean shouldSpawnParticles() {
        return this.func_70241_g() && this.getParticleName().length() > 0;
    }

    protected void spawnTrailingParticles() {
        if (this.shouldSpawnParticles()) {
            for (int i = 0; i < 4; ++i) {
                this.field_70170_p.func_72869_a(this.getParticleName(), this.field_70165_t + this.field_70159_w * (double)i / 4.0, this.field_70163_u + this.field_70181_x * (double)i / 4.0, this.field_70161_v + this.field_70179_y * (double)i / 4.0, -this.field_70159_w, -this.field_70181_x + 0.2, -this.field_70179_y);
            }
        }
    }

    protected void onImpact(MovingObjectPosition mop) {
        if (mop.field_72308_g != null) {
            this.onImpactEntity(mop);
        } else {
            this.onImpactBlock(mop);
        }
    }

    protected void onImpactEntity(MovingObjectPosition mop) {
        if (mop.field_72308_g != null) {
            this.field_70250_c = this.getShooter();
            int dmg = this.calculateDamage(mop.field_72308_g);
            if (this.func_70027_ad() && this.canTargetEntity(mop.field_72308_g)) {
                mop.field_72308_g.func_70015_d(5);
            }
            if (mop.field_72308_g.func_70097_a(this.getDamageSource(mop.field_72308_g), (float)dmg)) {
                if (mop.field_72308_g instanceof EntityLivingBase) {
                    this.handlePostDamageEffects((EntityLivingBase)mop.field_72308_g);
                    if (this.field_70250_c instanceof EntityPlayerMP && mop.field_72308_g != this.field_70250_c && mop.field_72308_g instanceof EntityPlayer) {
                        ((EntityPlayerMP)this.field_70250_c).field_71135_a.func_147359_a((Packet)new S2BPacketChangeGameState(6, 0.0f));
                    }
                }
                this.func_85030_a("random.bowhit", 1.0f, 1.2f / (this.field_70146_Z.nextFloat() * 0.2f + 0.9f));
                if (this.canTargetEntity(mop.field_72308_g)) {
                    this.func_70106_y();
                }
            } else {
                this.field_70159_w *= (double)-0.1f;
                this.field_70181_x *= (double)-0.1f;
                this.field_70179_y *= (double)-0.1f;
                this.field_70177_z += 180.0f;
                this.field_70126_B += 180.0f;
                this.field_70257_an = 0;
            }
        }
    }

    protected void onImpactBlock(MovingObjectPosition mop) {
        this.xTile = mop.field_72311_b;
        this.yTile = mop.field_72312_c;
        this.zTile = mop.field_72309_d;
        this.inTile = this.field_70170_p.func_147439_a(this.xTile, this.yTile, this.zTile);
        this.field_70253_h = this.field_70170_p.func_72805_g(this.xTile, this.yTile, this.zTile);
        this.field_70159_w = (float)(mop.field_72307_f.field_72450_a - this.field_70165_t);
        this.field_70181_x = (float)(mop.field_72307_f.field_72448_b - this.field_70163_u);
        this.field_70179_y = (float)(mop.field_72307_f.field_72449_c - this.field_70161_v);
        float f2 = MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70181_x * this.field_70181_x + this.field_70179_y * this.field_70179_y));
        this.field_70165_t -= this.field_70159_w / (double)f2 * (double)0.05f;
        this.field_70163_u -= this.field_70181_x / (double)f2 * (double)0.05f;
        this.field_70161_v -= this.field_70179_y / (double)f2 * (double)0.05f;
        this.func_85030_a("random.bowhit", 1.0f, 1.2f / (this.field_70146_Z.nextFloat() * 0.2f + 0.9f));
        this.field_70254_i = true;
        this.field_70249_b = 7;
        this.func_70243_d(false);
        if (this.inTile.func_149688_o() != Material.field_151579_a) {
            this.inTile.func_149670_a(this.field_70170_p, this.xTile, this.yTile, this.zTile, (Entity)this);
        }
    }

    protected int calculateDamage(Entity entityHit) {
        float velocity = MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70181_x * this.field_70181_x + this.field_70179_y * this.field_70179_y));
        int dmg = MathHelper.func_76143_f((double)((double)velocity * this.func_70242_d()));
        if (this.func_70241_g()) {
            dmg += this.field_70146_Z.nextInt(dmg / 2 + 2);
        }
        return dmg;
    }

    protected void handlePostDamageEffects(EntityLivingBase entityHit) {
        float f3;
        int k;
        if (!this.field_70170_p.field_72995_K) {
            entityHit.func_85034_r(entityHit.func_85035_bI() + 1);
        }
        if ((k = this.getKnockbackStrength()) > 0 && (f3 = MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y))) > 0.0f) {
            double knockback = (double)k * (double)0.6f / (double)f3;
            entityHit.func_70024_g(this.field_70159_w * knockback, 0.1, this.field_70179_y * knockback);
        }
        if (this.field_70250_c instanceof EntityLivingBase) {
            EnchantmentHelper.func_151384_a((EntityLivingBase)entityHit, (Entity)this.field_70250_c);
            EnchantmentHelper.func_151385_b((EntityLivingBase)((EntityLivingBase)this.field_70250_c), (Entity)entityHit);
        }
    }

    public void func_70014_b(NBTTagCompound compound) {
        compound.func_74777_a("xTile", (short)this.xTile);
        compound.func_74777_a("yTile", (short)this.yTile);
        compound.func_74777_a("zTile", (short)this.zTile);
        compound.func_74777_a("life", (short)this.field_70252_j);
        compound.func_74768_a("inTile", Block.func_149682_b((Block)this.inTile));
        compound.func_74774_a("inData", (byte)this.field_70253_h);
        compound.func_74774_a("shake", (byte)this.field_70249_b);
        compound.func_74774_a("inGround", (byte)(this.field_70254_i ? 1 : 0));
        compound.func_74774_a("pickup", (byte)this.field_70251_a);
        compound.func_74780_a("damage", this.func_70242_d());
        compound.func_74768_a("arrowId", Item.func_150891_b((Item)this.arrowItem));
        if ((this.shooterName == null || this.shooterName.length() == 0) && this.field_70250_c != null && this.field_70250_c instanceof EntityPlayer) {
            this.shooterName = this.field_70250_c.func_70005_c_();
        }
        compound.func_74778_a("shooter", this.shooterName == null ? "" : this.shooterName);
        compound.func_74768_a("target", this.getTarget() == null ? -1 : this.getTarget().func_145782_y());
    }

    public void func_70037_a(NBTTagCompound compound) {
        this.xTile = compound.func_74765_d("xTile");
        this.yTile = compound.func_74765_d("yTile");
        this.zTile = compound.func_74765_d("zTile");
        this.field_70252_j = compound.func_74765_d("life");
        this.inTile = Block.func_149729_e((int)compound.func_74762_e("inTile"));
        this.field_70253_h = compound.func_74771_c("inData") & 0xFF;
        this.field_70249_b = compound.func_74771_c("shake") & 0xFF;
        this.field_70254_i = compound.func_74771_c("inGround") == 1;
        this.func_70239_b(compound.func_74769_h("damage"));
        this.field_70251_a = compound.func_74771_c("pickup");
        this.arrowItem = compound.func_74764_b("arrowId") ? Item.func_150899_d((int)compound.func_74762_e("arrowId")) : Items.field_151032_g;
        this.shooterName = compound.func_74779_i("shooter");
        if (this.shooterName != null && this.shooterName.length() == 0) {
            this.shooterName = null;
        }
        this.field_70180_af.func_75692_b(24, (Object)(compound.func_74764_b("target") ? compound.func_74762_e("target") : -1));
    }

    public void writeSpawnData(ByteBuf buffer) {
        buffer.writeInt(this.field_70250_c != null ? this.field_70250_c.func_145782_y() : -1);
    }

    public void readSpawnData(ByteBuf buffer) {
        Entity shooter = this.field_70170_p.func_73045_a(buffer.readInt());
        if (shooter instanceof EntityLivingBase) {
            this.field_70250_c = (EntityLivingBase)shooter;
        }
    }
}

