/*
 * Decompiled with CFR 0.152.
 */
package zeldaswordskills.entity.projectile;

import java.util.HashSet;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.boss.IBossDisplayData;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSourceIndirect;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.ChunkPosition;
import net.minecraft.world.World;
import zeldaswordskills.api.damage.DamageUtils;
import zeldaswordskills.entity.ZSSEntityInfo;
import zeldaswordskills.entity.projectile.EntityArrowCustom;
import zeldaswordskills.lib.Config;
import zeldaswordskills.util.WorldUtils;

public class EntityArrowElemental
extends EntityArrowCustom {
    private static final String[] particles = new String[]{"flame", "magicCrit", "explode"};
    private static final int ARROWTYPE_DATAWATCHER_INDEX = 25;

    public EntityArrowElemental(World world) {
        super(world);
    }

    public EntityArrowElemental(World world, double x, double y, double z) {
        super(world, x, y, z);
    }

    public EntityArrowElemental(World world, EntityLivingBase shooter, float velocity) {
        super(world, shooter, velocity);
    }

    public EntityArrowElemental(World world, EntityLivingBase shooter, EntityLivingBase target, float velocity, float wobble) {
        super(world, shooter, target, velocity, wobble);
    }

    @Override
    public void func_70088_a() {
        super.func_70088_a();
        this.func_70239_b(4.0);
        this.field_70180_af.func_75682_a(25, (Object)ElementType.FIRE.ordinal());
    }

    public ElementType getType() {
        return ElementType.values()[this.field_70180_af.func_75679_c(25)];
    }

    public EntityArrowElemental setType(ElementType type) {
        this.field_70180_af.func_75692_b(25, (Object)type.ordinal());
        if (type == ElementType.FIRE) {
            this.func_70015_d(100);
        }
        return this;
    }

    @Override
    protected float getVelocityFactor() {
        return 1.3f;
    }

    @Override
    protected DamageSource getDamageSource(Entity entity) {
        switch (this.getType()) {
            case FIRE: {
                return new EntityDamageSourceIndirect("arrow.fire", (Entity)this, this.field_70250_c).func_76361_j().func_76349_b().func_82726_p();
            }
            case ICE: {
                return new DamageUtils.DamageSourceIceIndirect("arrow.ice", (Entity)this, this.field_70250_c, 50, 1).func_76349_b().func_82726_p();
            }
            case LIGHT: {
                return entity instanceof EntityEnderman ? new DamageUtils.DamageSourceHoly("arrow.light", (Entity)(this.field_70250_c != null ? this.field_70250_c : this)).func_76349_b().func_82726_p().func_76348_h() : new DamageUtils.DamageSourceHolyIndirect("arrow.light", (Entity)this, this.field_70250_c).func_76349_b().func_82726_p().func_76348_h();
            }
        }
        return super.getDamageSource(entity);
    }

    @Override
    protected boolean canTargetEntity(Entity entity) {
        return this.getType() == ElementType.LIGHT || super.canTargetEntity(entity);
    }

    @Override
    protected String getParticleName() {
        return particles[this.getType().ordinal()];
    }

    @Override
    protected boolean shouldSpawnParticles() {
        return true;
    }

    @Override
    protected void updateInAir() {
        boolean flag;
        super.updateInAir();
        boolean bl = flag = this.getType() == ElementType.FIRE && this.field_70170_p.func_72918_a(this.field_70121_D, Material.field_151586_h, (Entity)this);
        if (!this.field_70170_p.field_72995_K && this.getType() == ElementType.ICE && (this.field_70170_p.func_72918_a(this.field_70121_D, Material.field_151586_h, (Entity)this) || this.field_70170_p.func_72918_a(this.field_70121_D, Material.field_151587_i, (Entity)this))) {
            flag = this.affectBlocks();
        }
        if (flag) {
            if (this.getType() == ElementType.FIRE) {
                this.field_70170_p.func_72908_a(this.field_70165_t, this.field_70163_u, this.field_70161_v, "random.fizz", 1.0f, this.field_70146_Z.nextFloat() * 0.4f + 0.8f);
            }
            if (!this.field_70170_p.field_72995_K) {
                this.func_70106_y();
            }
        }
    }

    @Override
    protected void onImpactBlock(MovingObjectPosition mop) {
        boolean flag;
        boolean bl = flag = this.getType() == ElementType.LIGHT && !Config.enableLightArrowNoClip();
        if (this.getType() != ElementType.LIGHT || flag) {
            super.onImpactBlock(mop);
            if (!this.field_70170_p.field_72995_K && this.affectBlocks()) {
                this.func_70106_y();
            }
            if (flag) {
                this.extinguishLightArrow();
            }
        } else if (this.field_70173_aa < 25) {
            Block block = this.field_70170_p.func_147439_a(mop.field_72311_b, mop.field_72312_c, mop.field_72309_d);
            if (block.func_149688_o() != Material.field_151579_a) {
                block.func_149670_a(this.field_70170_p, mop.field_72311_b, mop.field_72312_c, mop.field_72309_d, (Entity)this);
            }
        } else {
            this.extinguishLightArrow();
        }
    }

    @Override
    protected void onImpactEntity(MovingObjectPosition mop) {
        if (this.getType() == ElementType.LIGHT && mop.field_72308_g instanceof EntityLivingBase && this.canOneHitKill(mop.field_72308_g)) {
            float velocity = MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70181_x * this.field_70181_x + this.field_70179_y * this.field_70179_y));
            EntityLivingBase entity = (EntityLivingBase)mop.field_72308_g;
            entity.func_70097_a(this.getDamageSource((Entity)entity), entity.func_110138_aP() * 0.425f * velocity);
            this.func_85030_a("random.bowhit", 1.0f, 1.2f / (this.field_70146_Z.nextFloat() * 0.2f + 0.9f));
            if (!this.field_70170_p.field_72995_K) {
                this.func_70106_y();
            }
        } else {
            super.onImpactEntity(mop);
        }
    }

    @Override
    protected void handlePostDamageEffects(EntityLivingBase entity) {
        super.handlePostDamageEffects(entity);
        if (!entity.field_70128_L && this.getType() == ElementType.ICE) {
            ZSSEntityInfo.get(entity).stun(this.calculateDamage((Entity)entity) * 10, true);
            int i = MathHelper.func_76128_c((double)entity.field_70165_t);
            int j = MathHelper.func_76128_c((double)entity.field_70163_u);
            int k = MathHelper.func_76128_c((double)entity.field_70161_v);
            this.field_70170_p.func_147449_b(i, j, k, Blocks.field_150432_aD);
            this.field_70170_p.func_147449_b(i, j + 1, k, Blocks.field_150432_aD);
            this.field_70170_p.func_72908_a((double)i + 0.5, (double)j + 0.5, (double)k + 0.5, "dig.glass", 1.0f, this.field_70146_Z.nextFloat() * 0.4f + 0.8f);
        }
    }

    private boolean canOneHitKill(Entity entity) {
        boolean flag = entity instanceof EntitySkeleton && ((EntitySkeleton)entity).func_82202_m() == 1;
        return !(entity instanceof IBossDisplayData) && (flag || entity instanceof EntityEnderman);
    }

    protected boolean affectBlocks() {
        boolean flag = false;
        HashSet<ChunkPosition> affectedBlocks = new HashSet<ChunkPosition>(WorldUtils.getAffectedBlocksList(this.field_70170_p, this.field_70146_Z, 1.5f, this.field_70165_t, this.field_70163_u, this.field_70161_v, null));
        block4: for (ChunkPosition position : affectedBlocks) {
            int i = position.field_151329_a;
            int j = position.field_151327_b;
            int k = position.field_151328_c;
            Block block = this.field_70170_p.func_147439_a(i, j, k);
            switch (this.getType()) {
                case FIRE: {
                    if (block.func_149688_o() == Material.field_151579_a && Config.enableFireArrowIgnite()) {
                        Block block2 = this.field_70170_p.func_147439_a(i, j - 1, k);
                        if (!block2.func_149730_j() || this.field_70146_Z.nextInt(8) != 0) continue block4;
                        this.field_70170_p.func_72908_a((double)i + 0.5, (double)j + 0.5, (double)k + 0.5, "fire.ignite", 1.0f, this.field_70146_Z.nextFloat() * 0.4f + 0.8f);
                        this.field_70170_p.func_147449_b(i, j, k, (Block)Blocks.field_150480_ab);
                        flag = true;
                        break;
                    }
                    if (!WorldUtils.canMeltBlock(this.field_70170_p, block, i, j, k)) break;
                    this.field_70170_p.func_72908_a((double)i + 0.5, (double)j + 0.5, (double)k + 0.5, "random.fizz", 1.0f, this.field_70146_Z.nextFloat() * 0.4f + 0.8f);
                    this.field_70170_p.func_147468_f(i, j, k);
                    flag = true;
                    break;
                }
                case ICE: {
                    if (block.func_149688_o() == Material.field_151586_h) {
                        this.field_70170_p.func_72908_a((double)i + 0.5, (double)j + 0.5, (double)k + 0.5, "dig.glass", 1.0f, this.field_70146_Z.nextFloat() * 0.4f + 0.8f);
                        this.field_70170_p.func_147449_b(i, j, k, Blocks.field_150432_aD);
                        flag = true;
                        break;
                    }
                    if (block.func_149688_o() == Material.field_151587_i) {
                        this.field_70170_p.func_72908_a((double)i + 0.5, (double)j + 0.5, (double)k + 0.5, "random.fizz", 1.0f, this.field_70146_Z.nextFloat() * 0.4f + 0.8f);
                        this.field_70170_p.func_147449_b(i, j, k, block == Blocks.field_150353_l ? Blocks.field_150343_Z : Blocks.field_150347_e);
                        flag = true;
                        break;
                    }
                    if (block.func_149688_o() != Material.field_151581_o) break;
                    this.field_70170_p.func_72908_a((double)i + 0.5, (double)j + 0.5, (double)k + 0.5, "random.fizz", 1.0f, this.field_70146_Z.nextFloat() * 0.4f + 0.8f);
                    this.field_70170_p.func_147468_f(i, j, k);
                    flag = true;
                    break;
                }
            }
        }
        return flag;
    }

    private void extinguishLightArrow() {
        for (int i = 0; i < 10; ++i) {
            double d0 = this.field_70146_Z.nextGaussian() * 0.02;
            double d1 = this.field_70146_Z.nextGaussian() * 0.02;
            double d2 = this.field_70146_Z.nextGaussian() * 0.02;
            this.field_70170_p.func_72869_a("explode", this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, this.field_70163_u + (double)(this.field_70146_Z.nextFloat() * this.field_70131_O), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, d0, d1, d2);
        }
        if (!this.field_70170_p.field_72995_K) {
            this.func_70106_y();
        }
    }

    @Override
    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74768_a("arrowType", this.getType().ordinal());
    }

    @Override
    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.setType(ElementType.values()[compound.func_74762_e("arrowType") % ElementType.values().length]);
    }

    public static enum ElementType {
        FIRE,
        ICE,
        LIGHT;

    }
}

