/*
 * Decompiled with CFR 0.152.
 */
package zeldaswordskills.handler;

import cpw.mods.fml.common.eventhandler.EventPriority;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.util.Set;
import net.minecraft.entity.DirtyEntityAccessor;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.living.LivingSetAttackTargetEvent;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import zeldaswordskills.api.damage.DamageUtils;
import zeldaswordskills.api.damage.EnumDamageType;
import zeldaswordskills.api.damage.IDamageType;
import zeldaswordskills.api.damage.IPostDamageEffect;
import zeldaswordskills.api.item.IArmorBreak;
import zeldaswordskills.api.item.ISwingSpeed;
import zeldaswordskills.entity.ZSSEntityInfo;
import zeldaswordskills.entity.ZSSPlayerInfo;
import zeldaswordskills.entity.ZSSPlayerSkills;
import zeldaswordskills.entity.buff.Buff;
import zeldaswordskills.item.ItemArmorTunic;
import zeldaswordskills.item.ItemFairyBottle;
import zeldaswordskills.item.ItemZeldaShield;
import zeldaswordskills.item.ItemZeldaSword;
import zeldaswordskills.item.ZSSItems;
import zeldaswordskills.lib.Config;
import zeldaswordskills.network.PacketDispatcher;
import zeldaswordskills.network.packet.client.UnpressKeyPacket;
import zeldaswordskills.network.packet.server.AddExhaustionPacket;
import zeldaswordskills.skills.ICombo;
import zeldaswordskills.skills.SkillBase;
import zeldaswordskills.skills.sword.ArmorBreak;
import zeldaswordskills.skills.sword.MortalDraw;
import zeldaswordskills.util.WorldUtils;

public class ZSSCombatEvents {
    public static void setPlayerAttackTime(EntityPlayer player) {
        if (!player.field_71075_bZ.field_75098_d) {
            ItemStack stack = player.func_70694_bm();
            int nextSwing = Config.getBaseSwingSpeed();
            if (stack != null && stack.func_77973_b() instanceof ISwingSpeed) {
                nextSwing += Math.max(player.field_70724_aR, ((ISwingSpeed)stack.func_77973_b()).getSwingSpeed());
                if (player.field_70170_p.field_72995_K) {
                    float exhaustion = ((ISwingSpeed)stack.func_77973_b()).getExhaustion();
                    if (exhaustion > 0.0f) {
                        PacketDispatcher.sendToServer(new AddExhaustionPacket(exhaustion));
                    }
                } else {
                    PacketDispatcher.sendTo(new UnpressKeyPacket(-100), (EntityPlayerMP)player);
                }
            }
            player.field_70724_aR = Math.max(player.field_70724_aR, nextSwing);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST, receiveCanceled=true)
    public void onPlayerAttack(AttackEntityEvent event) {
        if (!event.entityPlayer.field_70170_p.field_72995_K) {
            ZSSCombatEvents.setPlayerAttackTime(event.entityPlayer);
        }
    }

    @SubscribeEvent
    public void onSetAttackTarget(LivingSetAttackTargetEvent event) {
        ItemStack mask;
        if (event.target instanceof EntityPlayer && event.entity instanceof EntityLiving && (mask = ((EntityPlayer)event.target).func_82169_q(3)) != null && mask.func_77973_b() == ZSSItems.maskSpooky && event.entityLiving.func_94060_bK() != event.target) {
            ((EntityLiving)event.entity).func_70624_b(null);
        }
    }

    @SubscribeEvent
    public void onAttacked(LivingAttackEvent event) {
        EntityLivingBase entity;
        float evade;
        if (event.source.func_76346_g() instanceof EntityLivingBase) {
            event.setCanceled(ZSSEntityInfo.get((EntityLivingBase)event.source.func_76346_g()).isBuffActive(Buff.STUN));
        }
        if (!event.isCanceled() && event.entity instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)event.entity;
            ZSSPlayerSkills.get(player).onBeingAttacked(event);
            if (!event.isCanceled() && event.source.func_76347_k() && event.source.func_76364_f() == null) {
                event.setCanceled(ItemArmorTunic.onFireDamage((EntityLivingBase)player, event.ammount));
            }
        } else if (!event.isCanceled() && event.source.func_76346_g() != null && (evade = (float)ZSSEntityInfo.get(entity = event.entityLiving).getBuffAmplifier(Buff.EVADE_UP) * 0.01f) > 0.0f) {
            float penalty = (float)ZSSEntityInfo.get(entity).getBuffAmplifier(Buff.EVADE_DOWN) * 0.01f;
            if (entity.field_70170_p.field_73012_v.nextFloat() < evade - penalty) {
                WorldUtils.playSoundAtEntity((Entity)entity, "zeldaswordskills:swordmiss", 0.4f, 0.5f);
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.NORMAL)
    public void onPreHurt(LivingHurtEvent event) {
        EntityPlayer player;
        ItemStack stack;
        if (event.entity instanceof EntityPlayer && (stack = (player = (EntityPlayer)event.entity).func_70694_bm()) != null && stack.func_77973_b() instanceof ItemZeldaShield && player.func_71039_bw()) {
            ItemZeldaShield shield = (ItemZeldaShield)stack.func_77973_b();
            if (ZSSPlayerInfo.get(player).canBlock() && shield.canBlockDamage(stack, event.source)) {
                boolean shouldBlock;
                Entity opponent = event.source.func_76346_g();
                boolean bl = shouldBlock = opponent != null;
                if (shouldBlock) {
                    double dx = opponent.field_70165_t - player.field_70165_t;
                    double dz = opponent.field_70161_v - player.field_70161_v;
                    while (dx * dx + dz * dz < 1.0E-4) {
                        dx = (Math.random() - Math.random()) * 0.01;
                        dz = (Math.random() - Math.random()) * 0.01;
                    }
                    float yaw = (float)(Math.atan2(dz, dx) * 180.0 / Math.PI) - player.field_70177_z;
                    yaw -= 90.0f;
                    while (yaw < -180.0f) {
                        yaw += 360.0f;
                    }
                    while (yaw >= 180.0f) {
                        yaw -= 360.0f;
                    }
                    boolean bl2 = shouldBlock = yaw < 60.0f && yaw > -60.0f;
                }
                if (shouldBlock) {
                    shield.onBlock(player, stack, event.source, event.ammount);
                    event.setCanceled(true);
                }
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onHurt(LivingHurtEvent event) {
        EntityPlayer player;
        if (event.source.func_76346_g() instanceof EntityPlayer && !(event.source instanceof DamageUtils.DamageSourceArmorBreak)) {
            player = (EntityPlayer)event.source.func_76346_g();
            ZSSPlayerSkills skills = ZSSPlayerSkills.get(player);
            ICombo combo = skills.getComboSkill();
            if (combo != null && combo.isComboInProgress()) {
                event.ammount += (float)combo.getCombo().getSize();
            }
            if (skills.isSkillActive(SkillBase.armorBreak)) {
                ((ArmorBreak)skills.getPlayerSkill(SkillBase.armorBreak)).onImpact(player, event);
                return;
            }
            if (skills.isSkillActive(SkillBase.mortalDraw)) {
                ((MortalDraw)skills.getPlayerSkill(SkillBase.mortalDraw)).onImpact(player, event);
            }
            if (player.func_70694_bm() != null && player.func_70694_bm().func_77973_b() instanceof IArmorBreak && event.source.field_76373_n.equals("player")) {
                float damage = event.ammount * ((IArmorBreak)player.func_70694_bm().func_77973_b()).getPercentArmorIgnored() * 0.01f;
                DirtyEntityAccessor.damageEntity(event.entityLiving, DamageUtils.causeIArmorBreakDamage((Entity)player), damage);
                event.ammount -= damage;
            }
        }
        this.applyDamageModifiers(event);
        if (event.ammount > 0.0f && event.entity instanceof EntityPlayer) {
            player = (EntityPlayer)event.entity;
            if (event.source.func_76347_k() && !event.isCanceled()) {
                event.setCanceled(ItemArmorTunic.onFireDamage((EntityLivingBase)player, event.ammount));
            }
            if (event.isCanceled()) {
                return;
            }
            ICombo combo = ZSSPlayerSkills.get(player).getComboSkill();
            if (combo != null && event.ammount > 0.0f) {
                combo.onPlayerHurt(player, event);
            }
        }
        if (event.ammount > 0.0f && event.source.func_76346_g() instanceof EntityPlayer) {
            ZSSPlayerSkills.get((EntityPlayer)event.source.func_76346_g()).onPostImpact(event);
        }
        this.handleSecondaryEffects(event);
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onLivingDeathEvent(LivingDeathEvent event) {
        if (!event.entity.field_70170_p.field_72995_K && event.entity instanceof EntityPlayer) {
            event.setCanceled(ItemFairyBottle.onDeath((EntityPlayer)event.entity));
            if (!event.isCanceled()) {
                ZSSPlayerInfo.saveProxyData((EntityPlayer)event.entity);
            }
        }
        if (event.source.func_76346_g() instanceof EntityPlayer && event.entity instanceof IMob) {
            ItemZeldaSword.onKilledMob((EntityPlayer)event.source.func_76346_g(), (IMob)event.entity);
        }
    }

    private void applyDamageModifiers(LivingHurtEvent event) {
        if (event.source.func_76346_g() instanceof EntityLivingBase) {
            EntityLivingBase entity = (EntityLivingBase)event.source.func_76346_g();
            event.ammount *= 1.0f - (float)ZSSEntityInfo.get(entity).getBuffAmplifier(Buff.ATTACK_DOWN) * 0.01f;
            event.ammount *= 1.0f + (float)ZSSEntityInfo.get(entity).getBuffAmplifier(Buff.ATTACK_UP) * 0.01f;
        }
        this.applyDamageWeaknesses(event);
        this.applyDamageResistances(event);
    }

    private void applyDamageResistances(LivingHurtEvent event) {
        Set<EnumDamageType> damageTypes;
        float defenseUp = (float)ZSSEntityInfo.get(event.entityLiving).getBuffAmplifier(Buff.DEFENSE_UP) * 0.01f;
        float defenseDown = (float)ZSSEntityInfo.get(event.entityLiving).getBuffAmplifier(Buff.DEFENSE_DOWN) * 0.01f;
        event.ammount *= 1.0f + defenseDown - defenseUp;
        if (event.source instanceof IDamageType && event.ammount > 0.0f && (damageTypes = ((IDamageType)event.source).getEnumDamageTypes()) != null) {
            for (EnumDamageType type : damageTypes) {
                if (EnumDamageType.damageResistMap.get((Object)type) == null) continue;
                event.ammount *= 1.0f - (float)ZSSEntityInfo.get(event.entityLiving).getBuffAmplifier(EnumDamageType.damageResistMap.get((Object)type)) * 0.01f;
            }
        }
        if (event.source.func_76347_k()) {
            event.ammount *= 1.0f - (float)ZSSEntityInfo.get(event.entityLiving).getBuffAmplifier(Buff.RESIST_FIRE) * 0.01f;
        }
        if (event.source.func_82725_o()) {
            event.ammount *= 1.0f - (float)ZSSEntityInfo.get(event.entityLiving).getBuffAmplifier(Buff.RESIST_MAGIC) * 0.01f;
        }
    }

    private void applyDamageWeaknesses(LivingHurtEvent event) {
        Set<EnumDamageType> damageTypes;
        if (event.source instanceof IDamageType && (damageTypes = ((IDamageType)event.source).getEnumDamageTypes()) != null) {
            for (EnumDamageType type : damageTypes) {
                if (EnumDamageType.damageWeaknessMap.get((Object)type) == null) continue;
                event.ammount *= 1.0f + (float)ZSSEntityInfo.get(event.entityLiving).getBuffAmplifier(EnumDamageType.damageWeaknessMap.get((Object)type)) * 0.01f;
            }
        }
        if (event.source.func_76347_k()) {
            event.ammount *= 1.0f + (float)ZSSEntityInfo.get(event.entityLiving).getBuffAmplifier(Buff.WEAKNESS_FIRE) * 0.01f;
        }
        if (event.source.func_82725_o()) {
            event.ammount *= 1.0f + (float)ZSSEntityInfo.get(event.entityLiving).getBuffAmplifier(Buff.WEAKNESS_MAGIC) * 0.01f;
        }
    }

    private void handleSecondaryEffects(LivingHurtEvent event) {
        Set<EnumDamageType> damageTypes;
        if (event.ammount > 0.0f && event.source instanceof IDamageType && event.source instanceof IPostDamageEffect && (damageTypes = ((IDamageType)event.source).getEnumDamageTypes()) != null) {
            for (EnumDamageType type : damageTypes) {
                type.handleSecondaryEffects((IPostDamageEffect)event.source, event.entityLiving, event.ammount);
            }
        }
    }
}

