/*
 * Decompiled with CFR 0.152.
 */
package zeldaswordskills.item;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.block.material.Material;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IIcon;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StatCollector;
import net.minecraft.village.MerchantRecipe;
import net.minecraft.village.MerchantRecipeList;
import net.minecraft.world.World;
import zeldaswordskills.api.entity.BombType;
import zeldaswordskills.api.entity.CustomExplosion;
import zeldaswordskills.api.item.IHandlePickup;
import zeldaswordskills.api.item.IHandleToss;
import zeldaswordskills.api.item.IUnenchantable;
import zeldaswordskills.creativetab.ZSSCreativeTabs;
import zeldaswordskills.entity.projectile.EntityBomb;
import zeldaswordskills.item.ItemBombBag;
import zeldaswordskills.item.ZSSItems;
import zeldaswordskills.lib.Config;
import zeldaswordskills.network.PacketDispatcher;
import zeldaswordskills.network.packet.server.BombTickPacket;
import zeldaswordskills.util.MerchantRecipeHelper;
import zeldaswordskills.util.PlayerUtils;

public class ItemBomb
extends Item
implements IHandlePickup,
IHandleToss,
IUnenchantable {
    public static final ResourceLocation bombBase = new ResourceLocation("zeldaswordskills", "textures/entity/bomb.png");
    public static final ResourceLocation bombFlash = new ResourceLocation("zeldaswordskills", "textures/entity/bombflash.png");
    public static final ResourceLocation waterBase = new ResourceLocation("zeldaswordskills", "textures/entity/bombwater.png");
    public static final ResourceLocation waterFlash = new ResourceLocation("zeldaswordskills", "textures/entity/bombwaterflash.png");
    public static final ResourceLocation fireBase = new ResourceLocation("zeldaswordskills", "textures/entity/bombfire.png");
    public static final ResourceLocation fireFlash = new ResourceLocation("zeldaswordskills", "textures/entity/bombfireflash.png");
    public static final String[] bombNames = new String[]{"Bomb", "Water Bomb", "Fire Bomb"};
    @SideOnly(value=Side.CLIENT)
    private IIcon[] iconArray;
    public static final float RADIUS = 3.0f;

    public ItemBomb() {
        this.func_77656_e(0);
        this.func_77625_d(1);
        this.func_77627_a(true);
        this.func_77637_a(ZSSCreativeTabs.tabTools);
        this.func_77664_n();
    }

    public static BombType getType(ItemStack stack) {
        return ItemBomb.getType(stack.func_77960_j());
    }

    public static BombType getType(int damage) {
        return damage < BombType.values().length ? BombType.values()[damage] : BombType.BOMB_STANDARD;
    }

    public static float getRadius(BombType type) {
        return type == BombType.BOMB_WATER ? 2.25f : 3.0f;
    }

    public ItemStack func_77659_a(ItemStack stack, World world, EntityPlayer player) {
        if (!world.field_72995_K) {
            int extraTime = Config.getBombFuseTime();
            if (extraTime == 0) {
                extraTime = 56;
            }
            world.func_72838_d((Entity)new EntityBomb(world, (EntityLivingBase)player).setType(ItemBomb.getType(stack)).addTime(extraTime - stack.func_77978_p().func_74762_e("time")));
        }
        player.func_71028_bD();
        return stack;
    }

    public boolean onLeftClickEntity(ItemStack stack, EntityPlayer player, Entity entity) {
        if (entity.getClass().isAssignableFrom(EntityVillager.class)) {
            if (!player.field_70170_p.field_72995_K) {
                EntityVillager villager = (EntityVillager)entity;
                MerchantRecipeList trades = villager.func_70934_b(player);
                BombType bombType = ItemBomb.getType(stack);
                ItemStack chest = player.func_82169_q(2);
                if (villager.func_70946_n() == 2) {
                    if (chest != null && chest.func_77973_b() == ZSSItems.tunicZoraChest && bombType != BombType.BOMB_FIRE) {
                        MerchantRecipe waterBombTrade = new MerchantRecipe(new ItemStack(ZSSItems.bomb, 1, BombType.BOMB_STANDARD.ordinal()), new ItemStack(Items.field_151166_bC, 5), new ItemStack(ZSSItems.bomb, 1, BombType.BOMB_WATER.ordinal()));
                        MerchantRecipeHelper.addToListWithCheck(trades, waterBombTrade);
                        PlayerUtils.sendChat(player, StatCollector.func_74838_a((String)"chat.zss.trade.bomb.zora"));
                    } else if (Config.enableTradeBombBag() && trades.size() >= Config.getFriendTradesRequired()) {
                        MerchantRecipe bombBagTrade = new MerchantRecipe(new ItemStack(Items.field_151166_bC, Math.min(64, Config.getMinBombBagPrice() + player.field_70170_p.field_73012_v.nextInt(16))), new ItemStack(ZSSItems.bombBag));
                        MerchantRecipeHelper.addToListWithCheck(trades, bombBagTrade);
                        PlayerUtils.sendChat(player, StatCollector.func_74838_a((String)"chat.zss.trade.bomb.initiate"));
                    } else {
                        PlayerUtils.sendChat(player, StatCollector.func_74838_a((String)"chat.zss.trade.bomb.failure"));
                    }
                } else if (villager.func_70946_n() == 3 && chest != null && chest.func_77973_b() == ZSSItems.tunicGoronChest && bombType != BombType.BOMB_WATER) {
                    MerchantRecipe fireBombTrade = new MerchantRecipe(new ItemStack(ZSSItems.bomb, 1, BombType.BOMB_STANDARD.ordinal()), new ItemStack(Items.field_151166_bC, 10), new ItemStack(ZSSItems.bomb, 1, BombType.BOMB_FIRE.ordinal()));
                    MerchantRecipeHelper.addToListWithCheck(trades, fireBombTrade);
                    PlayerUtils.sendChat(player, StatCollector.func_74838_a((String)"chat.zss.trade.bomb.goron"));
                } else {
                    PlayerUtils.sendChat(player, StatCollector.func_74838_a((String)"chat.zss.trade.bomb.failure"));
                }
            }
            return true;
        }
        return entity instanceof EntityVillager || super.onLeftClickEntity(stack, player, entity);
    }

    @Override
    public boolean onPickupItem(ItemStack stack, EntityPlayer player) {
        for (ItemStack invStack : player.field_71071_by.field_70462_a) {
            if (invStack == null || !(invStack.func_77973_b() instanceof ItemBombBag)) continue;
            stack.field_77994_a -= stack.field_77994_a - ((ItemBombBag)invStack.func_77973_b()).addBombs(invStack, stack);
            if (stack.field_77994_a < 1) break;
        }
        return true;
    }

    @Override
    public void onItemTossed(EntityItem item, EntityPlayer player) {
        ItemStack stack = item.func_92059_d();
        if (stack.func_77942_o() && stack.func_77978_p().func_74764_b("time")) {
            stack.func_77978_p().func_74768_a("time", 0);
        }
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int slot, boolean isHeld) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
            stack.func_77978_p().func_74768_a("time", 0);
            stack.func_77978_p().func_74757_a("inWater", false);
        }
        if (isHeld) {
            if (entity instanceof EntityPlayer) {
                if (world.field_72995_K && Minecraft.func_71410_x().field_71462_r == null) {
                    PacketDispatcher.sendToServer(new BombTickPacket());
                }
            } else {
                this.tickBomb(stack, world, entity);
            }
        } else {
            stack.func_77978_p().func_74768_a("time", 0);
            stack.func_77978_p().func_74757_a("inWater", false);
        }
    }

    public void tickBomb(ItemStack stack, World world, Entity entity) {
        BombType type;
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
            stack.func_77978_p().func_74768_a("time", 0);
            stack.func_77978_p().func_74757_a("inWater", false);
        }
        if ((type = ItemBomb.getType(stack)) != BombType.BOMB_WATER && world.func_147439_a((int)entity.field_70165_t, (int)entity.field_70163_u + 1, (int)entity.field_70161_v).func_149688_o() == Material.field_151586_h) {
            stack.func_77978_p().func_74768_a("time", 0);
            stack.func_77978_p().func_74757_a("inWater", true);
        }
        if (this.canTick(world, type, stack.func_77978_p().func_74767_n("inWater"))) {
            int time = stack.func_77978_p().func_74762_e("time");
            if (time % 20 == 0) {
                world.func_72956_a(entity, "zeldaswordskills:bomb_fuse", 1.0f, 2.0f + entity.field_70170_p.field_73012_v.nextFloat() * 0.4f);
            }
            stack.func_77978_p().func_74768_a("time", world.field_73011_w.field_76574_g == -1 && type == BombType.BOMB_STANDARD ? Config.getBombFuseTime() : ++time);
            if (time == Config.getBombFuseTime() && !world.field_72995_K) {
                entity.func_70062_b(0, null);
                CustomExplosion.createExplosion(world, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, ItemBomb.getRadius(type), type);
            }
        }
    }

    private boolean canTick(World world, BombType type, boolean inWater) {
        if (Config.getBombFuseTime() > 0) {
            switch (type) {
                case BOMB_WATER: {
                    return world.field_73011_w.field_76574_g != -1;
                }
            }
            return !inWater;
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_77617_a(int type) {
        return this.iconArray[ItemBomb.getType(type).ordinal()];
    }

    public String func_77667_c(ItemStack stack) {
        return this.func_77658_a() + "." + stack.func_77960_j();
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item item, CreativeTabs tab, List list) {
        for (int i = 0; i < BombType.values().length; ++i) {
            list.add(new ItemStack(item, 1, i));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister register) {
        this.iconArray = new IIcon[BombType.values().length];
        for (int i = 0; i < BombType.values().length; ++i) {
            this.iconArray[i] = register.func_94245_a("zeldaswordskills:" + this.func_77658_a().substring(9) + (i + 1));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack itemstack, EntityPlayer player, List list, boolean isHeld) {
        list.add(EnumChatFormatting.ITALIC + StatCollector.func_74838_a((String)"tooltip.zss.bomb.desc.0"));
        list.add(EnumChatFormatting.ITALIC + StatCollector.func_74838_a((String)"tooltip.zss.bomb.desc.1"));
    }
}

