/*
 * Decompiled with CFR 0.152.
 */
package zeldaswordskills.item;

import com.google.common.collect.Multimap;
import cpw.mods.fml.common.Optional;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import mods.battlegear2.api.PlayerEventChild;
import mods.battlegear2.api.weapons.IBattlegearWeapon;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBreakable;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.MathHelper;
import net.minecraft.util.StatCollector;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import zeldaswordskills.api.block.BlockWeight;
import zeldaswordskills.api.block.ISmashable;
import zeldaswordskills.api.damage.DamageUtils;
import zeldaswordskills.api.item.IArmorBreak;
import zeldaswordskills.api.item.ISmashBlock;
import zeldaswordskills.api.item.ISwingSpeed;
import zeldaswordskills.api.item.IUnenchantable;
import zeldaswordskills.creativetab.ZSSCreativeTabs;
import zeldaswordskills.handler.ZSSCombatEvents;
import zeldaswordskills.item.ISpawnParticles;
import zeldaswordskills.item.ZSSItems;
import zeldaswordskills.network.PacketDispatcher;
import zeldaswordskills.network.packet.client.PacketISpawnParticles;
import zeldaswordskills.util.WorldUtils;

@Optional.Interface(iface="mods.battlegear2.api.weapons.IBattlegearWeapon", modid="battlegear2", striprefs=true)
public class ItemHammer
extends Item
implements IArmorBreak,
ISmashBlock,
ISpawnParticles,
ISwingSpeed,
IUnenchantable,
IBattlegearWeapon {
    private final BlockWeight strength;
    private final float weaponDamage;
    private final float ignoreArmorAmount;

    public ItemHammer(BlockWeight strength, float damage, float ignoreArmor) {
        this.strength = strength;
        this.weaponDamage = damage;
        this.ignoreArmorAmount = ignoreArmor;
        this.func_77664_n();
        this.func_77656_e(0);
        this.func_77625_d(1);
        this.func_77637_a(ZSSCreativeTabs.tabCombat);
    }

    public boolean func_150897_b(Block block) {
        return block instanceof ISmashable || block instanceof BlockBreakable;
    }

    @Override
    public float getPercentArmorIgnored() {
        return this.ignoreArmorAmount;
    }

    @Override
    public BlockWeight getSmashStrength(EntityPlayer player, ItemStack stack, Block block, int meta) {
        return block instanceof BlockBreakable ? this.strength.next() : this.strength;
    }

    @Override
    public void onBlockSmashed(EntityPlayer player, ItemStack stack, Block block, int meta, boolean wasSmashed) {
        if (!wasSmashed) {
            WorldUtils.playSoundAtEntity((Entity)player, "zeldaswordskills:hammer", 0.4f, 0.5f);
        }
    }

    @Override
    public float getExhaustion() {
        return this.weaponDamage / 16.0f;
    }

    @Override
    public int getSwingSpeed() {
        return 30;
    }

    public boolean func_77644_a(ItemStack stack, EntityLivingBase target, EntityLivingBase attacker) {
        WorldUtils.playSoundAtEntity((Entity)attacker, "zeldaswordskills:hammer", 0.4f, 0.5f);
        double dx = 0.15 * (attacker.field_70165_t - target.field_70165_t);
        double dz = 0.15 * (attacker.field_70161_v - target.field_70161_v);
        float f = MathHelper.func_76133_a((double)(dx * dx + dz * dz));
        if (f > 0.0f) {
            double resist = 1.0 - target.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111126_e();
            double f1 = resist * (double)(this.weaponDamage / 8.0f) * (double)0.6f;
            double k = f1 / (double)f;
            target.func_70024_g(-dx * k, 0.15 * f1, -dz * k);
        }
        return true;
    }

    public int func_77619_b() {
        return 0;
    }

    public EnumAction func_77661_b(ItemStack stack) {
        return EnumAction.block;
    }

    public int func_77626_a(ItemStack stack) {
        return 72000;
    }

    public ItemStack func_77659_a(ItemStack stack, World world, EntityPlayer player) {
        if (player.field_70724_aR == 0) {
            player.func_71008_a(stack, this.func_77626_a(stack));
        }
        return stack;
    }

    public void func_77615_a(ItemStack stack, World world, EntityPlayer player, int ticksRemaining) {
        if (this == ZSSItems.hammerSkull && player.field_70724_aR == 0) {
            int ticksInUse = this.func_77626_a(stack) - ticksRemaining;
            float charge = (float)ticksInUse / 40.0f;
            charge = Math.min((charge * charge + charge * 2.0f) / 3.0f, 1.0f);
            player.func_71020_j(charge * 2.0f);
            if (charge > 0.25f) {
                if (!player.field_70170_p.field_72995_K) {
                    PacketDispatcher.sendToAllAround(new PacketISpawnParticles(player, this, 4.0f), player, 64.0);
                }
                player.func_71038_i();
                ZSSCombatEvents.setPlayerAttackTime(player);
                WorldUtils.playSoundAtEntity((Entity)player, "zeldaswordskills:leapingblow", 0.4f, 0.5f);
                DamageSource specialAttack = new DamageUtils.DamageSourceStun("player", (Entity)player, (int)(60.0f * charge), 5).setCanStunPlayers().func_76348_h();
                float damage = this.weaponDamage * charge / 2.0f;
                if (damage > 0.5f) {
                    List entities = world.func_72872_a(EntityLivingBase.class, player.field_70121_D.func_72314_b(4.0, 0.0, 4.0));
                    for (EntityLivingBase entity : entities) {
                        if (entity == player || !entity.field_70122_E) continue;
                        entity.func_70097_a(specialAttack, damage);
                    }
                }
            }
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void spawnParticles(World world, double x, double y, double z, float radius, Vec3 lookVector) {
        int r = MathHelper.func_76123_f((float)radius);
        for (int i = 0; i < r; ++i) {
            for (int k = 0; k < r; ++k) {
                this.spawnParticlesAt(world, x + (double)i, y, z + (double)k);
                this.spawnParticlesAt(world, x + (double)i, y, z - (double)k);
                this.spawnParticlesAt(world, x - (double)i, y, z + (double)k);
                this.spawnParticlesAt(world, x - (double)i, y, z - (double)k);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void spawnParticlesAt(World world, double x, double y, double z) {
        int posY = MathHelper.func_76128_c((double)y);
        Block block = world.func_147439_a(MathHelper.func_76128_c((double)x), posY - 1, MathHelper.func_76128_c((double)z));
        if (block.func_149688_o() != Material.field_151579_a) {
            String particle = "blockcrack_" + Block.func_149682_b((Block)block) + "_" + world.func_72805_g(MathHelper.func_76128_c((double)x), posY - 1, MathHelper.func_76128_c((double)z));
            for (int i = 0; i < 4; ++i) {
                double dx = x + (double)world.field_73012_v.nextFloat() - 0.5;
                double dy = (float)posY + world.field_73012_v.nextFloat() * 0.2f;
                double dz = z + (double)world.field_73012_v.nextFloat() - 0.5;
                world.func_72869_a(particle, dx, dy, dz, world.field_73012_v.nextGaussian(), 0.0, world.field_73012_v.nextGaussian());
            }
        }
    }

    public Multimap getAttributeModifiers(ItemStack stack) {
        Multimap multimap = super.getAttributeModifiers(stack);
        multimap.put((Object)SharedMonsterAttributes.field_111264_e.func_111108_a(), (Object)new AttributeModifier(field_111210_e, "Weapon modifier", (double)this.weaponDamage, 0));
        return multimap;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister register) {
        this.field_77791_bV = register.func_94245_a("zeldaswordskills:" + this.func_77658_a().substring(9));
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean isHeld) {
        list.add(EnumChatFormatting.ITALIC + StatCollector.func_74838_a((String)("tooltip." + this.func_77658_a().substring(5) + ".desc.0")));
    }

    @Optional.Method(modid="battlegear2")
    public boolean sheatheOnBack(ItemStack stack) {
        return true;
    }

    @Optional.Method(modid="battlegear2")
    public boolean isOffhandHandDual(ItemStack stack) {
        return false;
    }

    @Optional.Method(modid="battlegear2")
    public boolean offhandAttackEntity(PlayerEventChild.OffhandAttackEvent event, ItemStack main, ItemStack offhand) {
        return false;
    }

    @Optional.Method(modid="battlegear2")
    public boolean offhandClickAir(PlayerInteractEvent event, ItemStack main, ItemStack offhand) {
        return false;
    }

    @Optional.Method(modid="battlegear2")
    public boolean offhandClickBlock(PlayerInteractEvent event, ItemStack main, ItemStack offhand) {
        return false;
    }

    @Optional.Method(modid="battlegear2")
    public void performPassiveEffects(Side side, ItemStack main, ItemStack offhand) {
    }

    @Optional.Method(modid="battlegear2")
    public boolean allowOffhand(ItemStack main, ItemStack offhand) {
        return false;
    }
}

