/*
 * Decompiled with CFR 0.152.
 */
package zeldaswordskills.item;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Items;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.util.StatCollector;
import net.minecraft.village.MerchantRecipe;
import net.minecraft.village.MerchantRecipeList;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import zeldaswordskills.api.item.IUnenchantable;
import zeldaswordskills.creativetab.ZSSCreativeTabs;
import zeldaswordskills.util.MerchantRecipeHelper;
import zeldaswordskills.util.PlayerUtils;
import zeldaswordskills.util.TargetUtils;

public class ItemMagicMirror
extends Item
implements IUnenchantable {
    @SideOnly(value=Side.CLIENT)
    private IIcon[] iconArray;

    public ItemMagicMirror() {
        this.func_77625_d(1);
        this.func_77656_e(16);
        this.func_77637_a(ZSSCreativeTabs.tabTools);
    }

    public int func_77626_a(ItemStack stack) {
        return 140;
    }

    public EnumAction func_77661_b(ItemStack stack) {
        return EnumAction.block;
    }

    public ItemStack func_77659_a(ItemStack stack, World world, EntityPlayer player) {
        player.func_71008_a(stack, this.func_77626_a(stack));
        return stack;
    }

    public void func_77615_a(ItemStack stack, World world, EntityPlayer player, int ticksRemaining) {
        if (!world.field_72995_K && ticksRemaining < this.func_77626_a(stack) / 2) {
            switch (player.field_71093_bK) {
                case -1: {
                    ((EntityPlayerMP)player).field_71133_b.func_71203_ab().transferPlayerToDimension((EntityPlayerMP)player, 0, ((WorldServer)world).func_85176_s());
                    double dy = player.field_70170_p.func_72976_f(MathHelper.func_76128_c((double)player.field_70165_t), MathHelper.func_76128_c((double)player.field_70161_v));
                    player.func_70634_a(player.field_70165_t, dy + 1.0, player.field_70161_v);
                    break;
                }
                case 0: {
                    double[] coordinates = this.getLastPosition(stack);
                    if (coordinates == null || TargetUtils.canEntitySeeSky(world, (Entity)player)) break;
                    player.func_70634_a(coordinates[0], coordinates[1], coordinates[2]);
                    break;
                }
            }
            stack.func_77972_a(1, (EntityLivingBase)player);
            if (stack.field_77994_a == 0 || stack.func_77960_j() == stack.func_77958_k()) {
                player.func_71028_bD();
            }
        }
    }

    public boolean onLeftClickEntity(ItemStack stack, EntityPlayer player, Entity entity) {
        if (!player.field_70170_p.field_72995_K && entity.getClass().isAssignableFrom(EntityVillager.class)) {
            EntityVillager villager = (EntityVillager)entity;
            MerchantRecipeList trades = villager.func_70934_b(player);
            if (villager.func_70946_n() == 1 && trades != null) {
                MerchantRecipe trade = new MerchantRecipe(stack.func_77946_l(), new ItemStack(Items.field_151166_bC, 8));
                if (player.field_70170_p.field_73012_v.nextFloat() < 0.2f && MerchantRecipeHelper.addToListWithCheck(trades, trade)) {
                    PlayerUtils.sendChat(player, StatCollector.func_74838_a((String)"chat.zss.trade.generic.sell.1"));
                } else {
                    PlayerUtils.sendChat(player, StatCollector.func_74838_a((String)"chat.zss.trade.generic.sorry.1"));
                }
            } else {
                PlayerUtils.sendChat(player, StatCollector.func_74838_a((String)"chat.zss.trade.generic.sorry.0"));
            }
        }
        return true;
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int slot, boolean isHeld) {
        if (!world.field_72995_K && entity.field_71093_bK == 0 && world.func_82737_E() % 10L == 0L && TargetUtils.canEntitySeeSky(world, entity)) {
            this.setLastPosition(stack, entity);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public boolean hasEffect(ItemStack stack, int pass) {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIcon(ItemStack stack, int renderPass, EntityPlayer player, ItemStack usingItem, int useRemaining) {
        if (usingItem == null) {
            return this.iconArray[0];
        }
        int ticksInUse = stack.func_77988_m() - useRemaining;
        if (ticksInUse > this.func_77626_a(stack) / 2) {
            return this.iconArray[3];
        }
        if (ticksInUse > this.func_77626_a(stack) / 3) {
            return this.iconArray[2];
        }
        if (ticksInUse > this.func_77626_a(stack) / 7) {
            return this.iconArray[1];
        }
        return this.iconArray[0];
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister register) {
        this.field_77791_bV = register.func_94245_a("zeldaswordskills:" + this.func_77658_a().substring(9));
        this.iconArray = new IIcon[4];
        for (int i = 0; i < this.iconArray.length; ++i) {
            this.iconArray[i] = register.func_94245_a("zeldaswordskills:" + this.func_77658_a().substring(9) + (i > 0 ? Integer.valueOf(i) : ""));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack itemstack, EntityPlayer player, List list, boolean isHeld) {
        list.add(EnumChatFormatting.ITALIC + StatCollector.func_74838_a((String)"tooltip.zss.magicmirror.desc.0"));
        list.add(EnumChatFormatting.ITALIC + StatCollector.func_74838_a((String)"tooltip.zss.magicmirror.desc.1"));
    }

    protected double[] getLastPosition(ItemStack stack) {
        double[] coordinates = null;
        if (stack.func_77942_o() && stack.func_77978_p().func_74764_b("mmLastPosX")) {
            coordinates = new double[]{stack.func_77978_p().func_74769_h("mmLastPosX"), stack.func_77978_p().func_74769_h("mmLastPosY"), stack.func_77978_p().func_74769_h("mmLastPosZ")};
        }
        return coordinates;
    }

    protected void setLastPosition(ItemStack stack, Entity entity) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        stack.func_77978_p().func_74780_a("mmLastPosX", entity.field_70165_t);
        stack.func_77978_p().func_74780_a("mmLastPosY", entity.field_70163_u);
        stack.func_77978_p().func_74780_a("mmLastPosZ", entity.field_70161_v);
    }
}

