/*
 * Decompiled with CFR 0.152.
 */
package zeldaswordskills.item;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.INpc;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.StatBase;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IIcon;
import net.minecraft.util.StatCollector;
import net.minecraft.village.MerchantRecipe;
import zeldaswordskills.ZSSAchievements;
import zeldaswordskills.api.item.IUnenchantable;
import zeldaswordskills.creativetab.ZSSCreativeTabs;
import zeldaswordskills.entity.EntityGoron;
import zeldaswordskills.entity.EntityMaskTrader;
import zeldaswordskills.entity.ZSSPlayerInfo;
import zeldaswordskills.entity.ZSSVillagerInfo;
import zeldaswordskills.item.ZSSItems;
import zeldaswordskills.util.MerchantRecipeHelper;
import zeldaswordskills.util.PlayerUtils;
import zeldaswordskills.util.TimedChatDialogue;

public class ItemTreasure
extends Item
implements IUnenchantable {
    @SideOnly(value=Side.CLIENT)
    private IIcon[] iconArray;

    public ItemTreasure() {
        this.func_77656_e(0);
        this.func_77625_d(1);
        this.func_77627_a(true);
        this.func_77637_a(ZSSCreativeTabs.tabMisc);
    }

    public boolean onLeftClickEntity(ItemStack stack, EntityPlayer player, Entity entity) {
        if (!player.field_70170_p.field_72995_K) {
            if (entity instanceof EntityVillager) {
                EntityVillager villager = (EntityVillager)entity;
                ZSSVillagerInfo villagerInfo = ZSSVillagerInfo.get(villager);
                Treasures treasure = Treasures.values()[stack.func_77960_j() % Treasures.values().length];
                MerchantRecipe trade = ZSSVillagerInfo.getTreasureTrade(treasure);
                villager.func_70642_aH();
                if (treasure == Treasures.ZELDAS_LETTER) {
                    if (!(entity instanceof EntityGoron) && villager.func_94057_bL().contains("Mask Salesman")) {
                        EntityMaskTrader trader = new EntityMaskTrader(villager.field_70170_p);
                        trader.func_70012_b(villager.field_70165_t, villager.field_70163_u, villager.field_70161_v, villager.field_70177_z, villager.field_70125_A);
                        trader.func_94058_c(villager.func_94057_bL());
                        if (!trader.field_70170_p.field_72995_K) {
                            trader.field_70170_p.func_72838_d((Entity)trader);
                        }
                        villager.func_70106_y();
                        PlayerUtils.playSound(player, "zeldaswordskills:success", 1.0f, 1.0f);
                        player.func_71029_a((StatBase)ZSSAchievements.maskTrader);
                        if (ZSSPlayerInfo.get(player).getCurrentMaskStage() == 0) {
                            ArrayList<String> chat = new ArrayList<String>(5);
                            for (int i = 0; i < 5; ++i) {
                                chat.add(StatCollector.func_74838_a((String)("chat.zss.treasure." + treasure.name + ".success." + i)));
                            }
                            new TimedChatDialogue(player, chat);
                        } else {
                            PlayerUtils.sendChat(player, StatCollector.func_74838_a((String)("chat.zss.treasure." + treasure.name + ".already_open")));
                        }
                        player.func_70062_b(0, null);
                    } else {
                        PlayerUtils.sendChat(player, StatCollector.func_74838_a((String)("chat.zss.treasure." + treasure.name + ".fail")));
                    }
                } else if (trade != null && villagerInfo.isInterested(treasure, stack)) {
                    ItemStack required = trade.func_77396_b();
                    if (required == null || PlayerUtils.consumeInventoryItem(player, required, required.field_77994_a)) {
                        PlayerUtils.playSound(player, "zeldaswordskills:success", 1.0f, 1.0f);
                        player.func_70062_b(0, trade.func_77397_d());
                        PlayerUtils.sendChat(player, StatCollector.func_74838_a((String)("chat." + this.func_77667_c(stack).substring(5) + ".give")));
                        PlayerUtils.sendChat(player, StatCollector.func_74837_a((String)"chat.zss.treasure.received", (Object[])new Object[]{trade.func_77397_d().func_82833_r()}));
                        if (villagerInfo.onTradedTreasure(player, treasure, player.func_70694_bm())) {
                            PlayerUtils.sendChat(player, StatCollector.func_74838_a((String)("chat." + this.func_77667_c(stack).substring(5) + ".next")));
                        }
                    } else {
                        PlayerUtils.sendChat(player, StatCollector.func_74837_a((String)"chat.zss.treasure.trade.fail", (Object[])new Object[]{required.field_77994_a, required.func_82833_r(), required.field_77994_a > 1 ? "s" : ""}));
                    }
                } else if (treasure.canSell() && villagerInfo.isHunter()) {
                    int price;
                    ItemStack treasureStack = new ItemStack(ZSSItems.treasure, 1, treasure.ordinal());
                    int n = price = villagerInfo.isMonsterHunter() ? treasure.getValue() + treasure.getValue() / 2 : treasure.getValue();
                    if (MerchantRecipeHelper.addToListWithCheck(villager.func_70934_b(player), new MerchantRecipe(treasureStack, new ItemStack(Items.field_151166_bC, price)))) {
                        PlayerUtils.playSound(player, "zeldaswordskills:success", 1.0f, 1.0f);
                        PlayerUtils.sendChat(player, StatCollector.func_74837_a((String)"chat.zss.treasure.hunter.new", (Object[])new Object[]{treasureStack.func_82833_r()}));
                    } else {
                        PlayerUtils.sendChat(player, StatCollector.func_74837_a((String)"chat.zss.treasure.hunter.old", (Object[])new Object[]{treasureStack.func_82833_r()}));
                    }
                } else if (villagerInfo.isFinalTrade(treasure, stack)) {
                    PlayerUtils.sendChat(player, StatCollector.func_74838_a((String)("chat." + this.func_77667_c(stack).substring(5) + ".wait")));
                } else {
                    PlayerUtils.sendChat(player, StatCollector.func_74838_a((String)"chat.zss.treasure.uninterested"));
                }
            } else if (entity instanceof INpc) {
                PlayerUtils.sendChat(player, StatCollector.func_74838_a((String)"chat.zss.treasure.uninterested"));
            }
        }
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_77617_a(int par1) {
        return this.iconArray[par1 % Treasures.values().length];
    }

    public String func_77667_c(ItemStack stack) {
        return super.func_77658_a() + "." + Treasures.values()[stack.func_77960_j() % Treasures.values().length].name;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item item, CreativeTabs tab, List list) {
        for (int i = 0; i < Treasures.values().length; ++i) {
            list.add(new ItemStack(item, 1, i));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister register) {
        this.iconArray = new IIcon[Treasures.values().length];
        for (int i = 0; i < Treasures.values().length; ++i) {
            this.iconArray[i] = register.func_94245_a("zeldaswordskills:" + Treasures.values()[i].name);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean par4) {
        list.add(EnumChatFormatting.ITALIC + StatCollector.func_74838_a((String)("tooltip." + this.func_77667_c(stack).substring(5) + ".desc.0")));
    }

    public static enum Treasures {
        CLAIM_CHECK("claim_check"),
        COJIRO("cojiro"),
        EVIL_CRYSTAL("evil_crystal"),
        EYE_DROPS("eye_drops"),
        EYEBALL_FROG("eyeball_frog"),
        GORON_SWORD("goron_sword"),
        JELLY_BLOB("jelly_blob", true, 32),
        MONSTER_CLAW("monster_claw", true, 24),
        ODD_MUSHROOM("odd_mushroom"),
        ODD_POTION("odd_potion"),
        POACHER_SAW("poacher_saw"),
        POCKET_EGG("pocket_egg"),
        PRESCRIPTION("prescription"),
        TENTACLE("tentacle", true, 16),
        ZELDAS_LETTER("zeldas_letter");

        public final String name;
        private final boolean canSell;
        private final int value;

        private Treasures(String name) {
            this(name, false, 0);
        }

        private Treasures(String name, boolean canSell, int value) {
            this.name = name;
            this.canSell = canSell;
            this.value = 24;
        }

        public boolean canSell() {
            return this.canSell;
        }

        public int getValue() {
            return this.value;
        }
    }
}

