/*
 * Decompiled with CFR 0.152.
 */
package zeldaswordskills.item;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import cpw.mods.fml.common.Optional;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import mods.battlegear2.api.PlayerEventChild;
import mods.battlegear2.api.weapons.IBattlegearWeapon;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.stats.StatBase;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IIcon;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import zeldaswordskills.ZSSAchievements;
import zeldaswordskills.api.item.IFairyUpgrade;
import zeldaswordskills.api.item.ISacredFlame;
import zeldaswordskills.api.item.ISwingSpeed;
import zeldaswordskills.api.item.IUnenchantable;
import zeldaswordskills.block.tileentity.TileEntityDungeonCore;
import zeldaswordskills.creativetab.ZSSCreativeTabs;
import zeldaswordskills.item.ZSSItems;
import zeldaswordskills.lib.Config;
import zeldaswordskills.util.PlayerUtils;
import zeldaswordskills.util.WorldUtils;

@Optional.Interface(iface="mods.battlegear2.api.weapons.IBattlegearWeapon", modid="battlegear2", striprefs=true)
public class ItemZeldaSword
extends ItemSword
implements IBattlegearWeapon,
IFairyUpgrade,
ISacredFlame,
ISwingSpeed,
IUnenchantable {
    protected final boolean twoHanded;
    protected final float weaponDamage;
    protected final Item.ToolMaterial toolMaterial;
    protected boolean isMaster = false;
    @SideOnly(value=Side.CLIENT)
    protected IIcon brokenIcon;
    protected boolean givesBrokenItem = true;

    public ItemZeldaSword(Item.ToolMaterial material, float bonusDamage) {
        this(material, bonusDamage, false);
    }

    public ItemZeldaSword(Item.ToolMaterial material, float bonusDamage, boolean twoHanded) {
        super(material);
        this.setNoRepair();
        this.toolMaterial = material;
        this.weaponDamage = 4.0f + bonusDamage + material.func_78000_c();
        this.twoHanded = twoHanded;
        this.func_77637_a(ZSSCreativeTabs.tabCombat);
    }

    public ItemZeldaSword setMasterSword() {
        this.setNoItemOnBreak();
        this.isMaster = true;
        return this;
    }

    public boolean isMasterSword() {
        return this.isMaster;
    }

    public ItemZeldaSword setNoItemOnBreak() {
        this.givesBrokenItem = false;
        return this;
    }

    @Override
    public float getExhaustion() {
        return 0.0f;
    }

    @Override
    public int getSwingSpeed() {
        return this.twoHanded ? 15 : 0;
    }

    public int func_77619_b() {
        return this.isMaster ? 0 : super.func_77619_b();
    }

    public boolean func_77644_a(ItemStack stack, EntityLivingBase target, EntityLivingBase attacker) {
        stack.func_77972_a(1, attacker);
        this.onStackDamaged(stack, attacker);
        return true;
    }

    public boolean func_150894_a(ItemStack stack, World world, Block block, int x, int y, int z, EntityLivingBase entity) {
        if ((double)block.func_149712_f(world, x, y, z) != 0.0) {
            stack.func_77972_a(stack.func_77973_b() == ZSSItems.swordGiant ? stack.func_77958_k() + 1 : 2, entity);
            this.onStackDamaged(stack, entity);
        }
        return true;
    }

    protected void onStackDamaged(ItemStack stack, EntityLivingBase entity) {
        if (stack.field_77994_a == 0 && this.givesBrokenItem && entity instanceof EntityPlayer) {
            PlayerUtils.addItemToInventory((EntityPlayer)entity, new ItemStack(ZSSItems.swordBroken, 1, Item.func_150891_b((Item)this)));
        }
    }

    public Multimap func_111205_h() {
        HashMultimap multimap = HashMultimap.create();
        multimap.put((Object)SharedMonsterAttributes.field_111264_e.func_111108_a(), (Object)new AttributeModifier(field_111210_e, "Weapon modifier", (double)this.weaponDamage, 0));
        return multimap;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_77617_a(int damage) {
        return damage == -1 ? this.brokenIcon : this.field_77791_bV;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister register) {
        this.field_77791_bV = register.func_94245_a("zeldaswordskills:" + this.func_77658_a().substring(9));
        if (this.givesBrokenItem) {
            this.brokenIcon = register.func_94245_a("zeldaswordskills:broken_" + this.func_77658_a().substring(9));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean isHeld) {
        list.add(EnumChatFormatting.ITALIC + StatCollector.func_74838_a((String)("tooltip." + this.func_77658_a().substring(5) + ".desc.0")));
        if (stack.func_77973_b() == ZSSItems.swordTempered) {
            if (stack.func_77942_o() && stack.func_77978_p().func_74764_b("zssHitCount")) {
                list.add(EnumChatFormatting.ITALIC + StatCollector.func_74837_a((String)"tooltip.zss.sword_tempered.desc.1", (Object[])new Object[]{stack.func_77978_p().func_74762_e("zssHitCount")}));
            }
        } else if (stack.func_77973_b() == ZSSItems.swordGolden && stack.func_77942_o() && stack.func_77978_p().func_74764_b("SacredFlames")) {
            int level = stack.func_77978_p().func_74762_e("SacredFlames");
            for (int i = 1; i < 5; ++i) {
                if (i == 3 || (level & i) == 0) continue;
                list.add(EnumChatFormatting.ITALIC + StatCollector.func_74837_a((String)"tooltip.zss.sword_golden.desc.1", (Object[])new Object[]{StatCollector.func_74838_a((String)("misc.zss.sacred_flame.name." + i))}));
            }
        }
    }

    @Override
    public void handleFairyUpgrade(EntityItem item, EntityPlayer player, TileEntityDungeonCore core) {
        ItemStack stack = item.func_92059_d();
        if (stack.func_77942_o() && stack.func_77978_p().func_74764_b("zssHitCount") && stack.func_77978_p().func_74762_e("zssHitCount") > Config.getRequiredKills()) {
            item.func_70106_y();
            WorldUtils.spawnItemWithRandom(core.func_145831_w(), new ItemStack(ZSSItems.swordGolden), core.field_145851_c, core.field_145848_d + 2, core.field_145849_e);
            core.func_145831_w().func_72908_a((double)core.field_145851_c + 0.5, (double)(core.field_145848_d + 1), (double)core.field_145849_e + 0.5, "zeldaswordskills:fairy_blessing", 1.0f, 1.0f);
            PlayerUtils.sendChat(player, StatCollector.func_74838_a((String)"chat.zss.sword.blessing"));
            player.func_71029_a((StatBase)ZSSAchievements.swordGolden);
        } else {
            core.func_145831_w().func_72908_a((double)core.field_145851_c + 0.5, (double)(core.field_145848_d + 1), (double)core.field_145849_e + 0.5, "zeldaswordskills:fairy_laugh", 1.0f, 1.0f);
            PlayerUtils.sendChat(player, StatCollector.func_74838_a((String)"chat.zss.fairy.laugh.unworthy"));
        }
    }

    @Override
    public boolean hasFairyUpgrade(ItemStack stack) {
        return this == ZSSItems.swordTempered;
    }

    public static void onKilledMob(EntityPlayer player, IMob mob) {
        if (!player.field_70170_p.field_72995_K && player.func_70694_bm() != null && player.func_70694_bm().func_77973_b() == ZSSItems.swordTempered) {
            ItemStack stack = player.func_70694_bm();
            NBTTagCompound tag = stack.func_77978_p();
            if (tag == null) {
                tag = new NBTTagCompound();
            }
            tag.func_74768_a("zssHitCount", tag.func_74762_e("zssHitCount") + 1);
            stack.func_77982_d(tag);
            if (tag.func_74762_e("zssHitCount") > Config.getRequiredKills()) {
                player.func_71029_a((StatBase)ZSSAchievements.swordEvil);
            }
        }
    }

    @Override
    public boolean onActivatedSacredFlame(ItemStack stack, World world, EntityPlayer player, int type, boolean isActive) {
        return false;
    }

    @Override
    public boolean onClickedSacredFlame(ItemStack stack, World world, EntityPlayer player, int type, boolean isActive) {
        if (world.field_72995_K) {
            return false;
        }
        if (this == ZSSItems.swordGolden && isActive) {
            NBTTagCompound tag = stack.func_77978_p();
            if (tag == null) {
                tag = new NBTTagCompound();
            }
            if ((tag.func_74762_e("SacredFlames") & type) == 0) {
                tag.func_74768_a("SacredFlames", tag.func_74762_e("SacredFlames") | type);
                stack.func_77982_d(tag);
                world.func_72956_a((Entity)player, "zeldaswordskills:flame_absorb", 1.0f, 1.0f);
                PlayerUtils.sendChat(player, StatCollector.func_74837_a((String)"chat.zss.sacred_flame.new", (Object[])new Object[]{this.func_77653_i(stack), StatCollector.func_74838_a((String)("misc.zss.sacred_flame.name." + type))}));
                player.func_71029_a((StatBase)ZSSAchievements.swordFlame);
                this.addSacredFlameEnchantments(stack, type);
                return true;
            }
            PlayerUtils.sendChat(player, StatCollector.func_74837_a((String)"chat.zss.sacred_flame.old.same", (Object[])new Object[]{this.func_77653_i(stack)}));
        } else if (isActive) {
            PlayerUtils.sendChat(player, StatCollector.func_74838_a((String)"chat.zss.sacred_flame.incorrect.sword"));
        } else {
            PlayerUtils.sendChat(player, StatCollector.func_74838_a((String)"chat.zss.sacred_flame.inactive"));
        }
        WorldUtils.playSoundAtEntity((Entity)player, "zeldaswordskills:swordmiss", 0.4f, 0.5f);
        return false;
    }

    private void addSacredFlameEnchantments(ItemStack stack, int type) {
        switch (type) {
            case 1: {
                stack.func_77966_a(Enchantment.field_77334_n, 2);
                break;
            }
            case 2: {
                stack.func_77966_a(Enchantment.field_77337_m, 2);
                break;
            }
            case 4: {
                stack.func_77966_a(Enchantment.field_77335_o, 3);
            }
        }
        boolean flag = false;
        NBTTagList enchList = stack.func_77978_p().func_150295_c("ench", 10);
        for (int i = 0; i < enchList.func_74745_c(); ++i) {
            NBTTagCompound compound = enchList.func_150305_b(i);
            if (compound.func_74765_d("id") != Enchantment.field_77338_j.field_77352_x) continue;
            short lvl = compound.func_74765_d("lvl");
            if (lvl < Enchantment.field_77338_j.func_77325_b()) {
                enchList.func_74744_a(i);
                stack.func_77966_a(Enchantment.field_77338_j, lvl + 1);
            }
            flag = true;
            break;
        }
        if (!flag) {
            stack.func_77966_a(Enchantment.field_77338_j, 1);
        }
    }

    @Optional.Method(modid="battlegear2")
    public boolean sheatheOnBack(ItemStack stack) {
        return true;
    }

    @Optional.Method(modid="battlegear2")
    public boolean isOffhandHandDual(ItemStack stack) {
        return (Config.allowOffhandMaster() || !this.isMaster) && !this.twoHanded;
    }

    @Optional.Method(modid="battlegear2")
    public boolean offhandAttackEntity(PlayerEventChild.OffhandAttackEvent event, ItemStack main, ItemStack offhand) {
        return true;
    }

    @Optional.Method(modid="battlegear2")
    public boolean offhandClickAir(PlayerInteractEvent event, ItemStack main, ItemStack offhand) {
        return true;
    }

    @Optional.Method(modid="battlegear2")
    public boolean offhandClickBlock(PlayerInteractEvent event, ItemStack main, ItemStack offhand) {
        return true;
    }

    @Optional.Method(modid="battlegear2")
    public void performPassiveEffects(Side side, ItemStack main, ItemStack offhand) {
    }

    @Optional.Method(modid="battlegear2")
    public boolean allowOffhand(ItemStack main, ItemStack offhand) {
        return !this.twoHanded;
    }
}

