/*
 * Decompiled with CFR 0.152.
 */
package zeldaswordskills.network;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import net.minecraft.entity.player.EntityPlayer;
import zeldaswordskills.entity.ZSSPlayerInfo;
import zeldaswordskills.network.AbstractPacket;
import zeldaswordskills.skills.SkillBase;

public class ActivateSkillPacket
extends AbstractPacket {
    private boolean wasTriggered = false;
    private byte skillId;

    public ActivateSkillPacket() {
    }

    public ActivateSkillPacket(SkillBase skill) {
        this(skill, false);
    }

    public ActivateSkillPacket(SkillBase skill, boolean wasTriggered) {
        this.wasTriggered = wasTriggered;
        this.skillId = skill.getId();
    }

    @Override
    public void encodeInto(ChannelHandlerContext ctx, ByteBuf buffer) {
        buffer.writeBoolean(this.wasTriggered);
        buffer.writeByte((int)this.skillId);
    }

    @Override
    public void decodeInto(ChannelHandlerContext ctx, ByteBuf buffer) {
        this.wasTriggered = buffer.readBoolean();
        this.skillId = buffer.readByte();
    }

    @Override
    public void handleClientSide(EntityPlayer player) {
        if (ZSSPlayerInfo.get(player) != null) {
            if (this.wasTriggered) {
                ZSSPlayerInfo.get(player).triggerSkill(player.field_70170_p, this.skillId);
            } else {
                ZSSPlayerInfo.get(player).activateSkill(player.field_70170_p, this.skillId);
            }
        }
    }

    @Override
    public void handleServerSide(EntityPlayer player) {
        if (ZSSPlayerInfo.get(player) != null) {
            if (this.wasTriggered) {
                ZSSPlayerInfo.get(player).triggerSkill(player.field_70170_p, this.skillId);
            } else {
                ZSSPlayerInfo.get(player).activateSkill(player.field_70170_p, this.skillId);
            }
        }
    }
}

