/*
 * Decompiled with CFR 0.152.
 */
package zeldaswordskills.network;

import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import cpw.mods.fml.relauncher.Side;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import zeldaswordskills.network.packet.AbstractMessageHandler;
import zeldaswordskills.network.packet.bidirectional.AbstractBiMessageHandler;
import zeldaswordskills.network.packet.bidirectional.ActivateSkillPacket;
import zeldaswordskills.network.packet.bidirectional.AttackTimePacket;
import zeldaswordskills.network.packet.bidirectional.DeactivateSkillPacket;
import zeldaswordskills.network.packet.bidirectional.PlaySoundPacket;
import zeldaswordskills.network.packet.client.AbstractClientMessageHandler;
import zeldaswordskills.network.packet.client.AttackBlockedPacket;
import zeldaswordskills.network.packet.client.InLiquidPacket;
import zeldaswordskills.network.packet.client.MortalDrawPacket;
import zeldaswordskills.network.packet.client.PacketISpawnParticles;
import zeldaswordskills.network.packet.client.SetNockedArrowPacket;
import zeldaswordskills.network.packet.client.SpawnNayruParticlesPacket;
import zeldaswordskills.network.packet.client.SyncEntityInfoPacket;
import zeldaswordskills.network.packet.client.SyncPlayerInfoPacket;
import zeldaswordskills.network.packet.client.SyncSkillPacket;
import zeldaswordskills.network.packet.client.UnpressKeyPacket;
import zeldaswordskills.network.packet.client.UpdateBuffPacket;
import zeldaswordskills.network.packet.client.UpdateComboPacket;
import zeldaswordskills.network.packet.server.AbstractServerMessageHandler;
import zeldaswordskills.network.packet.server.AddExhaustionPacket;
import zeldaswordskills.network.packet.server.BombTickPacket;
import zeldaswordskills.network.packet.server.BorrowMaskPacket;
import zeldaswordskills.network.packet.server.DashImpactPacket;
import zeldaswordskills.network.packet.server.EndComboPacket;
import zeldaswordskills.network.packet.server.GetBombPacket;
import zeldaswordskills.network.packet.server.OpenGuiPacket;
import zeldaswordskills.network.packet.server.RefreshSpinPacket;
import zeldaswordskills.network.packet.server.TargetIdPacket;

public class PacketDispatcher {
    private static byte packetId = 0;
    private static final SimpleNetworkWrapper dispatcher = NetworkRegistry.INSTANCE.newSimpleChannel("zss_channel");

    public static final void initialize() {
        PacketDispatcher.registerMessage(PlaySoundPacket.Handler.class, PlaySoundPacket.class);
        PacketDispatcher.registerBiMessage(ActivateSkillPacket.Handler.class, ActivateSkillPacket.class);
        PacketDispatcher.registerBiMessage(AttackTimePacket.Handler.class, AttackTimePacket.class);
        PacketDispatcher.registerBiMessage(DeactivateSkillPacket.Handler.class, DeactivateSkillPacket.class);
        PacketDispatcher.registerMessage(AttackBlockedPacket.Handler.class, AttackBlockedPacket.class);
        PacketDispatcher.registerMessage(InLiquidPacket.Handler.class, InLiquidPacket.class);
        PacketDispatcher.registerMessage(MortalDrawPacket.Handler.class, MortalDrawPacket.class);
        PacketDispatcher.registerMessage(PacketISpawnParticles.Handler.class, PacketISpawnParticles.class);
        PacketDispatcher.registerMessage(SetNockedArrowPacket.Handler.class, SetNockedArrowPacket.class);
        PacketDispatcher.registerMessage(SpawnNayruParticlesPacket.Handler.class, SpawnNayruParticlesPacket.class);
        PacketDispatcher.registerMessage(SyncEntityInfoPacket.Handler.class, SyncEntityInfoPacket.class);
        PacketDispatcher.registerMessage(SyncPlayerInfoPacket.Handler.class, SyncPlayerInfoPacket.class);
        PacketDispatcher.registerMessage(SyncSkillPacket.Handler.class, SyncSkillPacket.class);
        PacketDispatcher.registerMessage(UnpressKeyPacket.Handler.class, UnpressKeyPacket.class);
        PacketDispatcher.registerMessage(UpdateBuffPacket.Handler.class, UpdateBuffPacket.class);
        PacketDispatcher.registerMessage(UpdateComboPacket.Handler.class, UpdateComboPacket.class);
        PacketDispatcher.registerMessage(AddExhaustionPacket.Handler.class, AddExhaustionPacket.class);
        PacketDispatcher.registerMessage(BombTickPacket.Handler.class, BombTickPacket.class);
        PacketDispatcher.registerMessage(BorrowMaskPacket.Handler.class, BorrowMaskPacket.class);
        PacketDispatcher.registerMessage(DashImpactPacket.Handler.class, DashImpactPacket.class);
        PacketDispatcher.registerMessage(EndComboPacket.Handler.class, EndComboPacket.class);
        PacketDispatcher.registerMessage(GetBombPacket.Handler.class, GetBombPacket.class);
        PacketDispatcher.registerMessage(OpenGuiPacket.Handler.class, OpenGuiPacket.class);
        PacketDispatcher.registerMessage(RefreshSpinPacket.Handler.class, RefreshSpinPacket.class);
        PacketDispatcher.registerMessage(TargetIdPacket.Handler.class, TargetIdPacket.class);
    }

    private static final <REQ extends IMessage, REPLY extends IMessage> void registerMessage(Class<? extends IMessageHandler<REQ, REPLY>> handlerClass, Class<REQ> messageClass, Side side) {
        byte by = packetId;
        packetId = (byte)(by + 1);
        dispatcher.registerMessage(handlerClass, messageClass, (int)by, side);
    }

    private static final <REQ extends IMessage, REPLY extends IMessage> void registerBiMessage(Class<? extends IMessageHandler<REQ, REPLY>> handlerClass, Class<REQ> messageClass) {
        dispatcher.registerMessage(handlerClass, messageClass, (int)packetId, Side.CLIENT);
        byte by = packetId;
        packetId = (byte)(by + 1);
        dispatcher.registerMessage(handlerClass, messageClass, (int)by, Side.SERVER);
    }

    private static final <REQ extends IMessage> void registerMessage(Class<? extends AbstractMessageHandler<REQ>> handlerClass, Class<REQ> messageClass) {
        if (AbstractClientMessageHandler.class.isAssignableFrom(handlerClass)) {
            PacketDispatcher.registerMessage(handlerClass, messageClass, Side.CLIENT);
        } else if (AbstractServerMessageHandler.class.isAssignableFrom(handlerClass)) {
            PacketDispatcher.registerMessage(handlerClass, messageClass, Side.SERVER);
        } else if (AbstractBiMessageHandler.class.isAssignableFrom(handlerClass)) {
            PacketDispatcher.registerBiMessage(handlerClass, messageClass);
        } else {
            throw new IllegalArgumentException("Cannot determine on which Side(s) to register " + handlerClass.getName() + " - unrecognized handler class!");
        }
    }

    public static final void sendTo(IMessage message, EntityPlayerMP player) {
        dispatcher.sendTo(message, player);
    }

    public static final void sendToAllAround(IMessage message, NetworkRegistry.TargetPoint point) {
        dispatcher.sendToAllAround(message, point);
    }

    public static final void sendToAllAround(IMessage message, int dimension, double x, double y, double z, double range) {
        PacketDispatcher.sendToAllAround(message, new NetworkRegistry.TargetPoint(dimension, x, y, z, range));
    }

    public static final void sendToAllAround(IMessage message, EntityPlayer player, double range) {
        PacketDispatcher.sendToAllAround(message, player.field_70170_p.field_73011_w.field_76574_g, player.field_70165_t, player.field_70163_u, player.field_70161_v, range);
    }

    public static final void sendToDimension(IMessage message, int dimensionId) {
        dispatcher.sendToDimension(message, dimensionId);
    }

    public static final void sendToServer(IMessage message) {
        dispatcher.sendToServer(message);
    }
}

