/*
 * Decompiled with CFR 0.152.
 */
package zeldaswordskills.network;

import cpw.mods.fml.common.network.ByteBufUtils;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import zeldaswordskills.entity.ZSSPlayerInfo;
import zeldaswordskills.network.AbstractPacket;

public class SyncPlayerInfoPacket
extends AbstractPacket {
    private NBTTagCompound compound;
    private boolean validate = true;

    public SyncPlayerInfoPacket() {
    }

    public SyncPlayerInfoPacket(ZSSPlayerInfo info) {
        this.compound = new NBTTagCompound();
        info.saveNBTData(this.compound);
    }

    public SyncPlayerInfoPacket setReset() {
        this.validate = false;
        return this;
    }

    @Override
    public void encodeInto(ChannelHandlerContext ctx, ByteBuf buffer) {
        ByteBufUtils.writeTag((ByteBuf)buffer, (NBTTagCompound)this.compound);
        buffer.writeBoolean(this.validate);
    }

    @Override
    public void decodeInto(ChannelHandlerContext ctx, ByteBuf buffer) {
        this.compound = ByteBufUtils.readTag((ByteBuf)buffer);
        this.validate = buffer.readBoolean();
    }

    @Override
    public void handleClientSide(EntityPlayer player) {
        ZSSPlayerInfo info = ZSSPlayerInfo.get(player);
        if (info != null) {
            info.loadNBTData(this.compound);
            if (this.validate) {
                info.validateSkills();
            }
        }
    }

    @Override
    public void handleServerSide(EntityPlayer player) {
    }
}

