/*
 * Decompiled with CFR 0.152.
 */
package zeldaswordskills.network;

import cpw.mods.fml.common.network.ByteBufUtils;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import zeldaswordskills.entity.ZSSPlayerInfo;
import zeldaswordskills.network.AbstractPacket;
import zeldaswordskills.skills.SkillBase;

public class SyncSkillPacket
extends AbstractPacket {
    private byte id;
    private NBTTagCompound compound;

    public SyncSkillPacket() {
    }

    public SyncSkillPacket(SkillBase skill) {
        this.id = skill.getId();
        this.compound = new NBTTagCompound();
        skill.writeToNBT(this.compound);
    }

    @Override
    public void encodeInto(ChannelHandlerContext ctx, ByteBuf buffer) {
        buffer.writeByte((int)this.id);
        ByteBufUtils.writeTag((ByteBuf)buffer, (NBTTagCompound)this.compound);
    }

    @Override
    public void decodeInto(ChannelHandlerContext ctx, ByteBuf buffer) {
        this.id = buffer.readByte();
        this.compound = ByteBufUtils.readTag((ByteBuf)buffer);
    }

    @Override
    public void handleClientSide(EntityPlayer player) {
        ZSSPlayerInfo.get(player).syncClientSideSkill(this.id, this.compound);
    }

    @Override
    public void handleServerSide(EntityPlayer player) {
    }
}

