/*
 * Decompiled with CFR 0.152.
 */
package zeldaswordskills.network;

import cpw.mods.fml.common.network.ByteBufUtils;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import java.util.logging.Level;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import zeldaswordskills.entity.ZSSPlayerInfo;
import zeldaswordskills.network.AbstractPacket;
import zeldaswordskills.skills.Combo;
import zeldaswordskills.skills.ICombo;
import zeldaswordskills.util.LogHelper;

public class UpdateComboPacket
extends AbstractPacket {
    private NBTTagCompound compound;

    public UpdateComboPacket() {
    }

    public UpdateComboPacket(Combo combo) {
        this.compound = combo.writeToNBT();
    }

    @Override
    public void encodeInto(ChannelHandlerContext ctx, ByteBuf buffer) {
        ByteBufUtils.writeTag((ByteBuf)buffer, (NBTTagCompound)this.compound);
    }

    @Override
    public void decodeInto(ChannelHandlerContext ctx, ByteBuf buffer) {
        this.compound = ByteBufUtils.readTag((ByteBuf)buffer);
    }

    @Override
    public void handleClientSide(EntityPlayer player) {
        Combo combo = Combo.readFromNBT(this.compound);
        try {
            ICombo skill = (ICombo)((Object)ZSSPlayerInfo.get(player).getPlayerSkill(combo.getSkill()));
            if (skill != null) {
                combo.getEntityFromWorld(player.field_70170_p);
                skill.setCombo(combo);
            }
        }
        catch (ClassCastException e) {
            LogHelper.log(Level.SEVERE, "Class Cast Exception from invalid Combo skill id of " + combo.getSkill());
        }
    }

    @Override
    public void handleServerSide(EntityPlayer player) {
    }
}

