/*
 * Decompiled with CFR 0.152.
 */
package zeldaswordskills.network.packet.client;

import cpw.mods.fml.common.network.ByteBufUtils;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import zeldaswordskills.entity.ZSSEntityInfo;
import zeldaswordskills.entity.buff.BuffBase;
import zeldaswordskills.network.packet.client.AbstractClientMessageHandler;

public class UpdateBuffPacket
implements IMessage {
    private BuffBase buff;
    private boolean remove;

    public UpdateBuffPacket() {
    }

    public UpdateBuffPacket(BuffBase buff, boolean remove) {
        this.buff = buff;
        this.remove = remove;
    }

    public void toBytes(ByteBuf buffer) {
        ByteBufUtils.writeTag((ByteBuf)buffer, (NBTTagCompound)this.buff.writeToNBT(new NBTTagCompound()));
        buffer.writeBoolean(this.remove);
    }

    public void fromBytes(ByteBuf buffer) {
        this.buff = BuffBase.readFromNBT(ByteBufUtils.readTag((ByteBuf)buffer));
        this.remove = buffer.readBoolean();
    }

    public static class Handler
    extends AbstractClientMessageHandler<UpdateBuffPacket> {
        @Override
        public IMessage handleClientMessage(EntityPlayer player, UpdateBuffPacket message, MessageContext ctx) {
            if (message.remove) {
                ZSSEntityInfo.get((EntityLivingBase)player).getActiveBuffsMap().remove((Object)message.buff.getBuff());
            } else {
                ZSSEntityInfo.get((EntityLivingBase)player).getActiveBuffsMap().put(message.buff.getBuff(), message.buff);
            }
            return null;
        }
    }
}

