/*
 * Decompiled with CFR 0.152.
 */
package zeldaswordskills.skills.sword;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S12PacketEntityVelocity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.StatCollector;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import zeldaswordskills.api.damage.DamageUtils;
import zeldaswordskills.api.item.IDashItem;
import zeldaswordskills.client.ZSSKeyHandler;
import zeldaswordskills.entity.ZSSPlayerSkills;
import zeldaswordskills.lib.Config;
import zeldaswordskills.network.PacketDispatcher;
import zeldaswordskills.network.packet.bidirectional.ActivateSkillPacket;
import zeldaswordskills.network.packet.server.DashImpactPacket;
import zeldaswordskills.skills.ILockOnTarget;
import zeldaswordskills.skills.SkillActive;
import zeldaswordskills.util.PlayerUtils;
import zeldaswordskills.util.TargetUtils;
import zeldaswordskills.util.WorldUtils;

public class Dash
extends SkillActive {
    private static final double BASE_MOVE = (double)0.1f;
    private boolean isActive = false;
    private double distance;
    @SideOnly(value=Side.CLIENT)
    private Vec3 trajectory;
    private Vec3 initialPosition;
    private Entity target;
    private int impactTime;

    public Dash(String name) {
        super(name);
    }

    private Dash(Dash skill) {
        super(skill);
    }

    @Override
    public Dash newInstance() {
        return new Dash(this);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void addInformation(List<String> desc, EntityPlayer player) {
        desc.add(this.getDamageDisplay(this.getDamage(), false));
        desc.add(StatCollector.func_74837_a((String)this.getInfoString("info", 1), (Object[])new Object[]{2 + this.level}));
        desc.add(this.getRangeDisplay(this.getRange()));
        desc.add(StatCollector.func_74837_a((String)this.getInfoString("info", 2), (Object[])new Object[]{String.format("%.1f", this.getMinDistance())}));
        desc.add(this.getExhaustionDisplay(this.getExhaustion()));
    }

    @Override
    public boolean isActive() {
        return this.isActive || this.impactTime > 0;
    }

    @Override
    protected float getExhaustion() {
        return 1.0f - 0.1f * (float)this.level;
    }

    private int getDamage() {
        return 2 + this.level;
    }

    private double getRange() {
        return 3.0 + (double)this.level;
    }

    private double getMinDistance() {
        return 2.0 - 0.2 * (double)this.level;
    }

    @Override
    public boolean canUse(EntityPlayer player) {
        Item item = player.func_70694_bm() != null ? player.func_70694_bm().func_77973_b() : null;
        return super.canUse(player) && !this.isActive() && (PlayerUtils.isSkillItem(item) || item instanceof IDashItem);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean canExecute(EntityPlayer player) {
        return player.field_70122_E && PlayerUtils.isUsingItem(player) && this.canUse(player);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean isKeyListener(Minecraft mc, KeyBinding key) {
        return key == ZSSKeyHandler.keys[2] || Config.allowVanillaControls() && key == mc.field_71474_y.field_74312_F;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean keyPressed(Minecraft mc, KeyBinding key, EntityPlayer player) {
        if (this.canExecute(player)) {
            PacketDispatcher.sendToServer(new ActivateSkillPacket(this));
            return true;
        }
        return false;
    }

    @Override
    protected boolean onActivated(World world, EntityPlayer player) {
        this.isActive = true;
        this.initialPosition = Vec3.func_72443_a((double)player.field_70165_t, (double)(player.field_70163_u + (double)player.func_70047_e() - (double)0.1f), (double)player.field_70161_v);
        ILockOnTarget skill = ZSSPlayerSkills.get(player).getTargetingSkill();
        this.target = skill != null && skill.isLockedOn() ? skill.getCurrentTarget() : TargetUtils.acquireLookTarget((EntityLivingBase)player, (int)this.getRange(), this.getRange(), true);
        if (this.target != null && world.field_72995_K) {
            double d0 = this.target.field_70165_t - player.field_70165_t;
            double d1 = this.target.field_70163_u + (double)(this.target.field_70131_O / 3.0f) - player.field_70163_u;
            double d2 = this.target.field_70161_v - player.field_70161_v;
            this.trajectory = Vec3.func_72443_a((double)d0, (double)d1, (double)d2).func_72432_b();
        }
        return this.isActive();
    }

    @Override
    protected void onDeactivated(World world, EntityPlayer player) {
        this.impactTime = 0;
        this.setNotDashing();
    }

    @Override
    public void onUpdate(EntityPlayer player) {
        if (this.impactTime > 0) {
            --this.impactTime;
            if (this.impactTime == 0) {
                this.target = null;
            }
        }
        if (this.isActive) {
            MovingObjectPosition mop;
            if (player.field_70170_p.field_72995_K && (mop = TargetUtils.checkForImpact(player.field_70170_p, (Entity)player, (Entity)player, 0.5, false)) != null) {
                PacketDispatcher.sendToServer(new DashImpactPacket(player, mop));
                player.field_70724_aR = player.field_71075_bZ.field_75098_d ? 0 : 10 - this.level;
                this.impactTime = 5;
                if (mop.field_72313_a == MovingObjectPosition.MovingObjectType.ENTITY) {
                    this.target = mop.field_72308_g;
                }
                double d = Math.sqrt(player.field_70159_w * player.field_70159_w + player.field_70179_y * player.field_70179_y);
                player.func_70016_h(-player.field_70159_w * d, 0.15 * d, -player.field_70179_y * d);
                this.trajectory = null;
                this.setNotDashing();
            }
            this.distance += 1.0;
            if (this.distance > this.getRange() + 1.0 || !(this.target instanceof EntityLivingBase)) {
                this.setNotDashing();
            }
        }
    }

    public void onImpact(World world, EntityPlayer player, MovingObjectPosition mop) {
        if (mop != null && mop.field_72313_a == MovingObjectPosition.MovingObjectType.ENTITY) {
            this.target = mop.field_72308_g;
            double dist = this.target.func_70011_f(this.initialPosition.field_72450_a, this.initialPosition.field_72448_b, this.initialPosition.field_72449_c);
            dist -= (double)(this.target.field_70130_N / 2.0f + player.field_70130_N / 2.0f);
            double speed = player.func_110140_aT().func_111151_a(SharedMonsterAttributes.field_111263_d).func_111126_e();
            double sf = 1.0 + (speed - (double)0.1f);
            if (speed > 0.075 && dist > this.getMinDistance() && player.func_70068_e(this.target) < 6.0) {
                float dmg = (float)this.getDamage() + (float)(dist / 2.0 - 2.0);
                this.impactTime = 5;
                this.target.func_70097_a(DamageUtils.causeNonSwordDamage((Entity)player), (float)((double)dmg * sf * sf));
                double resist = 1.0;
                if (this.target instanceof EntityLivingBase) {
                    resist -= ((EntityLivingBase)this.target).func_110148_a(SharedMonsterAttributes.field_111266_c).func_111126_e();
                }
                double k = sf * resist * (this.distance / 3.0) * (double)0.6f;
                this.target.func_70024_g(player.field_70159_w * k * (0.2 + 0.1 * (double)this.level), 0.1 + k * ((double)this.level * 0.025), player.field_70179_y * k * (0.2 + 0.1 * (double)this.level));
                if (this.target instanceof EntityPlayerMP && !player.field_70170_p.field_72995_K) {
                    ((EntityPlayerMP)this.target).field_71135_a.func_147359_a((Packet)new S12PacketEntityVelocity(this.target));
                }
            }
        }
        WorldUtils.playSoundAtEntity((Entity)player, "zeldaswordskills:slam", 0.4f, 0.5f);
        this.setNotDashing();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean isAnimating() {
        return this.isActive;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean onRenderTick(EntityPlayer player, float partialTickTime) {
        if (this.target instanceof EntityLivingBase && this.trajectory != null) {
            double speed = player.func_110140_aT().func_111151_a(SharedMonsterAttributes.field_111263_d).func_111126_e() - (double)0.1f;
            double dfactor = 1.0 + speed + speed * (1.0 - (this.getRange() - this.distance) / this.getRange());
            player.field_70159_w = this.trajectory.field_72450_a * dfactor * dfactor;
            player.field_70179_y = this.trajectory.field_72449_c * dfactor * dfactor;
        }
        return false;
    }

    @Override
    public boolean onBeingAttacked(EntityPlayer player, DamageSource source) {
        if (this.impactTime > 0 && source.func_76346_g() == this.target) {
            return true;
        }
        return source.field_76373_n.equals("mob") && source.func_76346_g() != null && player.func_70068_e(source.func_76346_g()) < 6.0;
    }

    private void setNotDashing() {
        this.isActive = false;
        this.distance = 0.0;
        this.initialPosition = null;
        if (!this.isActive()) {
            this.target = null;
        }
    }
}

