/*
 * Decompiled with CFR 0.152.
 */
package zeldaswordskills.skills.sword;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.entity.DirtyEntityAccessor;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import zeldaswordskills.client.ZSSClientEvents;
import zeldaswordskills.client.ZSSKeyHandler;
import zeldaswordskills.entity.ZSSEntityInfo;
import zeldaswordskills.entity.ZSSPlayerSkills;
import zeldaswordskills.entity.buff.Buff;
import zeldaswordskills.lib.Config;
import zeldaswordskills.network.PacketDispatcher;
import zeldaswordskills.network.packet.bidirectional.ActivateSkillPacket;
import zeldaswordskills.skills.ICombo;
import zeldaswordskills.skills.ILockOnTarget;
import zeldaswordskills.skills.SkillActive;
import zeldaswordskills.util.PlayerUtils;
import zeldaswordskills.util.WorldUtils;

public class EndingBlow
extends SkillActive {
    private int activeTimer = 0;
    @SideOnly(value=Side.CLIENT)
    private int ticksTilFail;
    @SideOnly(value=Side.CLIENT)
    private int keyPressed;
    private int lastNumHits;
    private EntityLivingBase entityHit;
    private int xp;

    public EndingBlow(String name) {
        super(name);
    }

    private EndingBlow(EndingBlow skill) {
        super(skill);
    }

    @Override
    public EndingBlow newInstance() {
        return new EndingBlow(this);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void addInformation(List<String> desc, EntityPlayer player) {
        desc.add(this.getDamageDisplay(this.level * 20, true) + "%");
        desc.add(this.getDurationDisplay(this.getDuration(), true));
        desc.add(this.getExhaustionDisplay(this.getExhaustion()));
    }

    @Override
    public boolean isActive() {
        return this.activeTimer > 0;
    }

    @Override
    protected float getExhaustion() {
        return 2.0f - (float)this.level * 0.1f;
    }

    public int getDuration() {
        return 110 - this.level * 10;
    }

    @Override
    public boolean canUse(EntityPlayer player) {
        ICombo skill;
        if (!this.isActive() && super.canUse(player) && PlayerUtils.isHoldingSkillItem(player) && (skill = ZSSPlayerSkills.get(player).getComboSkill()) != null && skill.isComboInProgress()) {
            if (this.lastNumHits > 0) {
                return skill.getCombo().getConsecutiveHits() > 1 && skill.getCombo().getSize() > this.lastNumHits + 2;
            }
            return skill.getCombo().getConsecutiveHits() > 1;
        }
        return false;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean canExecute(EntityPlayer player) {
        return this.ticksTilFail > 0 && this.keyPressed > 1 && this.canUse(player);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean isKeyListener(Minecraft mc, KeyBinding key) {
        return key == mc.field_71474_y.field_74351_w || key == ZSSKeyHandler.keys[2] || Config.allowVanillaControls() && key == mc.field_71474_y.field_74312_F;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean keyPressed(Minecraft mc, KeyBinding key, EntityPlayer player) {
        if (key == mc.field_71474_y.field_74351_w) {
            if (this.ticksTilFail == 0) {
                this.ticksTilFail = 6;
            }
            ++this.keyPressed;
        } else if (this.canExecute(player)) {
            this.ticksTilFail = 0;
            this.keyPressed = 0;
            PacketDispatcher.sendToServer(new ActivateSkillPacket(this));
            return true;
        }
        return false;
    }

    @Override
    protected boolean onActivated(World world, EntityPlayer player) {
        this.activeTimer = 3;
        ICombo skill = ZSSPlayerSkills.get(player).getComboSkill();
        if (skill.getCombo() != null) {
            this.lastNumHits = skill.getCombo().getSize();
        }
        if (world.field_72995_K) {
            ZSSClientEvents.performComboAttack(Minecraft.func_71410_x(), ZSSPlayerSkills.get(player).getTargetingSkill());
            this.ticksTilFail = 0;
            this.keyPressed = 0;
        }
        return this.isActive();
    }

    @Override
    protected void onDeactivated(World world, EntityPlayer player) {
        this.activeTimer = 0;
        this.entityHit = null;
        this.xp = 0;
        if (world.field_72995_K) {
            this.keyPressed = 0;
            this.ticksTilFail = 0;
        }
    }

    @Override
    public void onUpdate(EntityPlayer player) {
        if (player.field_70170_p.field_72995_K && this.ticksTilFail > 0) {
            --this.ticksTilFail;
            if (this.ticksTilFail == 0) {
                this.keyPressed = 0;
            }
        }
        if (this.lastNumHits > 0) {
            ICombo skill;
            if (this.entityHit != null && this.xp > 0) {
                this.updateEntityState(player);
            }
            if ((skill = ZSSPlayerSkills.get(player).getComboSkill()) == null || !skill.isComboInProgress()) {
                this.lastNumHits = 0;
            }
        }
        if (this.isActive()) {
            --this.activeTimer;
            if (this.activeTimer == 0 && !player.field_70170_p.field_72995_K) {
                WorldUtils.playSoundAtEntity((Entity)player, "zeldaswordskills:grunt", 0.3f, 0.8f);
                ZSSEntityInfo.get((EntityLivingBase)player).applyBuff(Buff.DEFENSE_DOWN, this.getDuration() * 2, 50);
            }
        }
    }

    private void updateEntityState(EntityPlayer player) {
        if (!player.field_70170_p.field_72995_K) {
            if (this.entityHit.func_110143_aJ() <= 0.0f) {
                if (this.entityHit instanceof EntityLiving) {
                    DirtyEntityAccessor.setLivingXp((EntityLiving)this.entityHit, this.xp, true);
                } else {
                    WorldUtils.spawnXPOrbsWithRandom(player.field_70170_p, player.field_70170_p.field_73012_v, MathHelper.func_76128_c((double)this.entityHit.field_70165_t), MathHelper.func_76128_c((double)this.entityHit.field_70163_u), MathHelper.func_76128_c((double)this.entityHit.field_70161_v), this.xp);
                }
            } else {
                WorldUtils.playSoundAtEntity((Entity)player, "zeldaswordskills:grunt", 0.3f, 0.8f);
                ZSSEntityInfo.get((EntityLivingBase)player).applyBuff(Buff.DEFENSE_DOWN, this.getDuration(), 50);
            }
        }
        this.entityHit = null;
        this.xp = 0;
    }

    @Override
    public float postImpact(EntityPlayer player, EntityLivingBase entity, float amount) {
        this.activeTimer = 0;
        ICombo combo = ZSSPlayerSkills.get(player).getComboSkill();
        ILockOnTarget lock = ZSSPlayerSkills.get(player).getTargetingSkill();
        if (combo != null && combo.isComboInProgress() && lock != null && lock.getCurrentTarget() == combo.getCombo().getLastEntityHit()) {
            amount *= 1.0f + (float)this.level * 0.2f;
            WorldUtils.playSoundAtEntity((Entity)player, "zeldaswordskills:mortaldraw", 0.4f, 0.5f);
            this.entityHit = entity;
            this.xp = this.level + 1 + player.field_70170_p.field_73012_v.nextInt(Math.max(2, MathHelper.func_76123_f((float)entity.func_110143_aJ())));
        }
        return amount;
    }
}

