/*
 * Decompiled with CFR 0.152.
 */
package zeldaswordskills.skills.sword;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.world.World;
import zeldaswordskills.client.ZSSClientEvents;
import zeldaswordskills.client.ZSSKeyHandler;
import zeldaswordskills.entity.ZSSPlayerSkills;
import zeldaswordskills.entity.projectile.EntityLeapingBlow;
import zeldaswordskills.network.PacketDispatcher;
import zeldaswordskills.network.packet.bidirectional.ActivateSkillPacket;
import zeldaswordskills.skills.SkillActive;
import zeldaswordskills.skills.sword.SwordBasic;
import zeldaswordskills.util.PlayerUtils;
import zeldaswordskills.util.WorldUtils;

public class LeapingBlow
extends SkillActive {
    private boolean isActive;
    private boolean isMaster;

    public LeapingBlow(String name) {
        super(name);
    }

    private LeapingBlow(LeapingBlow skill) {
        super(skill);
    }

    @Override
    public LeapingBlow newInstance() {
        return new LeapingBlow(this);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void addInformation(List<String> desc, EntityPlayer player) {
        desc.add(this.getDamageDisplay(PlayerUtils.isHoldingMasterSword(player) ? this.level * 2 : this.level, true));
        desc.add(this.getRangeDisplay(3.0f + 0.5f * (float)this.level));
        desc.add(this.getAreaDisplay(0.5f + 0.25f * (float)this.level));
        desc.add(this.getDurationDisplay(this.getPotionDuration(player), false));
        desc.add(this.getExhaustionDisplay(this.getExhaustion()));
    }

    @Override
    public boolean isActive() {
        return this.isActive;
    }

    @Override
    protected float getExhaustion() {
        return 2.0f - 0.1f * (float)this.level;
    }

    @Override
    protected boolean autoAddExhaustion() {
        return false;
    }

    private float getDamage(EntityPlayer player) {
        return (float)((double)(PlayerUtils.isHoldingMasterSword(player) ? this.level * 2 : this.level) + player.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e());
    }

    private int getPotionDuration(EntityPlayer player) {
        return (PlayerUtils.isHoldingMasterSword(player) ? 110 : 50) + this.level * 10;
    }

    @Override
    public boolean canUse(EntityPlayer player) {
        return super.canUse(player) && !this.isActive() && PlayerUtils.isHoldingSword(player);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean canExecute(EntityPlayer player) {
        return !this.isActive() && player.field_70122_E && PlayerUtils.isUsingItem(player);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean isKeyListener(Minecraft mc, KeyBinding key) {
        return key == mc.field_71474_y.field_74314_A;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean keyPressed(Minecraft mc, KeyBinding key, EntityPlayer player) {
        if (this.canExecute(player)) {
            PacketDispatcher.sendToServer(new ActivateSkillPacket(this));
            KeyBinding.func_74510_a((int)mc.field_71474_y.field_74313_G.func_151463_i(), (boolean)false);
            KeyBinding.func_74510_a((int)ZSSKeyHandler.keys[6].func_151463_i(), (boolean)false);
            return true;
        }
        return false;
    }

    @Override
    protected boolean onActivated(World world, EntityPlayer player) {
        this.isActive = true;
        this.isMaster = PlayerUtils.isHoldingMasterSword(player) && PlayerUtils.getHealthMissing(player) == 0.0f;
        return this.isActive();
    }

    @Override
    protected void onDeactivated(World world, EntityPlayer player) {
        this.isActive = false;
    }

    public void onImpact(EntityPlayer player, float distance) {
        SwordBasic swordSkill = (SwordBasic)ZSSPlayerSkills.get(player).getPlayerSkill(swordBasic);
        if (this.isActive() && swordSkill != null && swordSkill.isActive() && PlayerUtils.isHoldingSword(player)) {
            if (player.field_70170_p.field_72995_K) {
                if (distance < 1.0f) {
                    ZSSClientEvents.performComboAttack(Minecraft.func_71410_x(), swordSkill);
                } else {
                    player.func_71038_i();
                }
            } else if (distance >= 1.0f) {
                player.func_71020_j(this.getExhaustion());
                EntityLeapingBlow entity = new EntityLeapingBlow(player.field_70170_p, (EntityLivingBase)player).setDamage(this.getDamage(player)).setLevel(this.level, this.isMaster);
                player.field_70170_p.func_72838_d((Entity)entity);
                WorldUtils.playSoundAtEntity((Entity)player, "zeldaswordskills:leapingblow", 0.4f, 0.5f);
            }
        }
        this.onDeactivated(player.field_70170_p, player);
    }
}

