/*
 * Decompiled with CFR 0.152.
 */
package zeldaswordskills.skills.sword;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import zeldaswordskills.client.ZSSKeyHandler;
import zeldaswordskills.entity.ZSSPlayerSkills;
import zeldaswordskills.lib.Config;
import zeldaswordskills.network.PacketDispatcher;
import zeldaswordskills.network.packet.bidirectional.ActivateSkillPacket;
import zeldaswordskills.skills.SkillActive;
import zeldaswordskills.util.PlayerUtils;
import zeldaswordskills.util.TargetUtils;
import zeldaswordskills.util.WorldUtils;

public class Parry
extends SkillActive {
    private int parryTimer;
    private int attacksParried;
    @SideOnly(value=Side.CLIENT)
    private int ticksTilFail;
    private boolean playMissSound;

    public Parry(String name) {
        super(name);
    }

    private Parry(Parry skill) {
        super(skill);
    }

    @Override
    public Parry newInstance() {
        return new Parry(this);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void addInformation(List<String> desc, EntityPlayer player) {
        desc.add(StatCollector.func_74837_a((String)this.getInfoString("info", 1), (Object[])new Object[]{(int)(this.getDisarmChance(player, null) * 100.0f)}));
        desc.add(StatCollector.func_74837_a((String)this.getInfoString("info", 2), (Object[])new Object[]{(int)(2.5f * (float)(this.getActiveTime() - this.getParryDelay()))}));
        desc.add(StatCollector.func_74837_a((String)this.getInfoString("info", 3), (Object[])new Object[]{this.getMaxParries()}));
        desc.add(this.getTimeLimitDisplay(this.getActiveTime() - this.getParryDelay()));
        desc.add(this.getExhaustionDisplay(this.getExhaustion()));
    }

    @Override
    public boolean isActive() {
        return this.parryTimer > 0;
    }

    @Override
    protected float getExhaustion() {
        return 0.3f - 0.02f * (float)this.level;
    }

    private int getActiveTime() {
        return 6 + this.level;
    }

    private int getParryDelay() {
        return 5 - this.level / 2;
    }

    private int getMaxParries() {
        return (1 + this.level) / 2;
    }

    private float getDisarmChance(EntityPlayer player, EntityLivingBase attacker) {
        float penalty = 0.15f * (float)this.attacksParried;
        float bonus = Config.getDisarmTimingBonus() * (float)(this.parryTimer > 0 ? this.parryTimer - this.getParryDelay() : 0);
        if (attacker instanceof EntityPlayer) {
            penalty += Config.getDisarmPenalty() * (float)ZSSPlayerSkills.get((EntityPlayer)attacker).getSkillLevel(this);
        }
        return (float)this.level * 0.1f - penalty + bonus;
    }

    @Override
    public boolean canUse(EntityPlayer player) {
        return super.canUse(player) && !this.isActive() && PlayerUtils.isHoldingSkillItem(player);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean canExecute(EntityPlayer player) {
        return this.canUse(player) && !PlayerUtils.isUsingItem(player);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean isKeyListener(Minecraft mc, KeyBinding key) {
        return key == ZSSKeyHandler.keys[5] || Config.allowVanillaControls() && key == mc.field_71474_y.field_74368_y;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean keyPressed(Minecraft mc, KeyBinding key, EntityPlayer player) {
        if (this.canExecute(player)) {
            if (Config.requiresDoubleTap()) {
                if (this.ticksTilFail > 0) {
                    PacketDispatcher.sendToServer(new ActivateSkillPacket(this));
                    this.ticksTilFail = 0;
                    return true;
                }
                this.ticksTilFail = 6;
            } else if (key != mc.field_71474_y.field_74368_y) {
                PacketDispatcher.sendToServer(new ActivateSkillPacket(this));
                return true;
            }
        }
        return false;
    }

    @Override
    protected boolean onActivated(World world, EntityPlayer player) {
        this.parryTimer = this.getActiveTime();
        this.attacksParried = 0;
        this.playMissSound = true;
        player.func_71038_i();
        return this.isActive();
    }

    @Override
    protected void onDeactivated(World world, EntityPlayer player) {
        this.parryTimer = 0;
    }

    @Override
    public void onUpdate(EntityPlayer player) {
        if (this.isActive()) {
            if (--this.parryTimer <= this.getParryDelay() && this.playMissSound) {
                this.playMissSound = false;
                WorldUtils.playSoundAtEntity((Entity)player, "zeldaswordskills:swordmiss", 0.4f, 0.5f);
            }
        } else if (player.field_70170_p.field_72995_K && this.ticksTilFail > 0) {
            --this.ticksTilFail;
        }
    }

    @Override
    public boolean onBeingAttacked(EntityPlayer player, DamageSource source) {
        if (source.func_76346_g() instanceof EntityLivingBase) {
            EntityLivingBase attacker = (EntityLivingBase)source.func_76346_g();
            if (this.attacksParried < this.getMaxParries() && this.parryTimer > this.getParryDelay() && attacker.func_70694_bm() != null && PlayerUtils.isHoldingSkillItem(player)) {
                if (player.field_70170_p.field_73012_v.nextFloat() < this.getDisarmChance(player, attacker)) {
                    this.disarm(attacker);
                }
                ++this.attacksParried;
                WorldUtils.playSoundAtEntity((Entity)player, "zeldaswordskills:swordstrike", 0.4f, 0.5f);
                this.playMissSound = false;
                TargetUtils.knockTargetBack(attacker, (EntityLivingBase)player);
                return true;
            }
        }
        return false;
    }

    private void disarm(EntityLivingBase attacker) {
        if (attacker.func_70694_bm() != null && !attacker.field_70170_p.field_72995_K) {
            EntityItem drop = new EntityItem(attacker.field_70170_p, attacker.field_70165_t, attacker.field_70163_u - (double)0.3f + (double)attacker.func_70047_e(), attacker.field_70161_v, attacker.func_70694_bm().func_77946_l());
            float f = 0.3f;
            float f1 = attacker.field_70170_p.field_73012_v.nextFloat() * (float)Math.PI * 2.0f;
            drop.field_70159_w = -MathHelper.func_76126_a((float)(attacker.field_70177_z / 180.0f * (float)Math.PI)) * MathHelper.func_76134_b((float)(attacker.field_70125_A / 180.0f * (float)Math.PI)) * f;
            drop.field_70179_y = MathHelper.func_76134_b((float)(attacker.field_70177_z / 180.0f * (float)Math.PI)) * MathHelper.func_76134_b((float)(attacker.field_70125_A / 180.0f * (float)Math.PI)) * f;
            drop.field_70181_x = -MathHelper.func_76126_a((float)(attacker.field_70125_A / 180.0f * (float)Math.PI)) * f + 0.1f;
            f = 0.02f * attacker.field_70170_p.field_73012_v.nextFloat();
            drop.field_70159_w += Math.cos(f1) * (double)f;
            drop.field_70181_x += (double)((attacker.field_70170_p.field_73012_v.nextFloat() - attacker.field_70170_p.field_73012_v.nextFloat()) * 0.1f);
            drop.field_70179_y += Math.sin(f1) * (double)f;
            drop.field_145804_b = 40;
            attacker.field_70170_p.func_72838_d((Entity)drop);
            attacker.func_70062_b(0, (ItemStack)null);
        }
    }
}

