/*
 * Decompiled with CFR 0.152.
 */
package zeldaswordskills.util;

import net.minecraft.block.Block;
import net.minecraft.block.BlockChest;
import net.minecraft.block.material.Material;
import net.minecraft.world.World;
import net.minecraft.world.gen.structure.StructureBoundingBox;
import zeldaswordskills.block.BlockChestLocked;
import zeldaswordskills.lib.Config;
import zeldaswordskills.world.gen.structure.RoomBase;

public class StructureGenUtils {
    public static int getAverageSurfaceHeight(World world, int posX, int posZ) {
        int height = world.func_72976_f(posX, posZ);
        int count = 1;
        for (int i = posX + 3; i < posX + 16; i += 3) {
            for (int j = posZ + 3; j < posZ + 16; j += 3) {
                height += world.func_72976_f(i, j);
                ++count;
            }
        }
        return height / count;
    }

    public static double getDistanceSqBetween(StructureBoundingBox box1, StructureBoundingBox box2) {
        int dx = box1.func_78881_e() - box2.func_78881_e();
        int dy = box1.func_78879_f() - box2.func_78879_f();
        int dz = box1.func_78891_g() - box2.func_78891_g();
        return dx * dx + dy * dy + dz * dz;
    }

    public static int getAverageDistanceToGround(World world, StructureBoundingBox box, int max) {
        int i;
        int total = i = StructureGenUtils.getDistanceToGround(world, box.func_78881_e(), box.field_78895_b, box.func_78891_g());
        if (i > max) {
            return max;
        }
        i = StructureGenUtils.getDistanceToGround(world, box.field_78897_a, box.field_78895_b, box.field_78896_c);
        total += i;
        if (i > max) {
            return max;
        }
        i = StructureGenUtils.getDistanceToGround(world, box.field_78897_a, box.field_78895_b, box.field_78892_f);
        total += i;
        if (i > max) {
            return max;
        }
        i = StructureGenUtils.getDistanceToGround(world, box.field_78893_d, box.field_78895_b, box.field_78896_c);
        total += i;
        if (i > max) {
            return max;
        }
        i = StructureGenUtils.getDistanceToGround(world, box.field_78893_d, box.field_78895_b, box.field_78892_f);
        total += i;
        if (i > max) {
            return max;
        }
        return total / 5;
    }

    public static int getDistanceToGround(World world, int x, int y, int z) {
        int i = 0;
        while (!world.func_147439_a(x, y - 1, z).func_149688_o().func_76220_a() && y > 5) {
            --y;
            ++i;
        }
        return i;
    }

    public static void fillWithBlocks(World world, StructureBoundingBox box, int minX, int maxX, int minY, int maxY, int minZ, int maxZ, Block block, int meta) {
        StructureGenUtils.fillWithBlocks(world, box, minX, maxX, minY, maxY, minZ, maxZ, block, meta, false);
    }

    public static void fillWithBlocks(World world, StructureBoundingBox box, int minX, int maxX, int minY, int maxY, int minZ, int maxZ, Block block, int meta, boolean ignoreBounds) {
        for (int i = minX; i < maxX; ++i) {
            for (int j = minY; j < maxY; ++j) {
                for (int k = minZ; k < maxZ; ++k) {
                    StructureGenUtils.setBlockAtPosition(world, box, i, j, k, block, meta, ignoreBounds);
                }
            }
        }
    }

    public static void fillWithoutReplace(World world, int minX, int maxX, int minY, int maxY, int minZ, int maxZ, Block block, int meta, int flag) {
        for (int i = minX; i < maxX; ++i) {
            for (int j = minY; j < maxY; ++j) {
                for (int k = minZ; k < maxZ; ++k) {
                    if (world.func_147439_a(i, j, k).func_149688_o().func_76220_a()) continue;
                    world.func_147465_d(i, j, k, block, meta, flag);
                }
            }
        }
    }

    public static void fillDown(World world, StructureBoundingBox box, Block block, int metadata) {
        for (int i = box.field_78897_a; i <= box.field_78893_d; ++i) {
            for (int k = box.field_78896_c; k <= box.field_78892_f; ++k) {
                for (int j = box.field_78895_b - 1; !(j <= 4 || world.func_147439_a(i, j, k).func_149688_o().func_76220_a() && world.func_147439_a(i, j, k).func_149688_o() != Material.field_151584_j); --j) {
                    world.func_147465_d(i, j, k, block, metadata, 2);
                }
            }
        }
    }

    public static void destroyBlocksAround(World world, int minX, int maxX, int minY, int maxY, int minZ, int maxZ, Block block, boolean drop) {
        for (int i = minX; i < maxX; ++i) {
            for (int j = minY; j < maxY; ++j) {
                for (int k = minZ; k < maxZ; ++k) {
                    if (block != null && world.func_147439_a(i, j, k) != block) continue;
                    world.func_147480_a(i, j, k, drop);
                }
            }
        }
    }

    public static int getXWithOffset(StructureBoundingBox box, int x, int z) {
        return box.field_78897_a + x;
    }

    public static int getYWithOffset(StructureBoundingBox box, int y) {
        return box.field_78895_b + y;
    }

    public static int getZWithOffset(StructureBoundingBox box, int x, int z) {
        return box.field_78896_c + z;
    }

    public static boolean isBlockChest(World world, int x, int y, int z) {
        Block block = world.func_147439_a(x, y, z);
        return block instanceof BlockChest || block instanceof BlockChestLocked;
    }

    public static void replaceMaterialWith(World world, int minX, int maxX, int minY, int maxY, int minZ, int maxZ, Material material, int blockId, int meta) {
        for (int i = minX; i < maxX; ++i) {
            for (int j = minY; j < maxY; ++j) {
                for (int k = minZ; k < maxZ; ++k) {
                    if (world.func_147439_a(i, j, k).func_149688_o() != material) continue;
                    world.func_147465_d(i, j, k, Block.func_149729_e((int)blockId), meta, 3);
                }
            }
        }
    }

    public static void setBlockAtPosition(World world, StructureBoundingBox box, int x, int y, int z, Block block, int meta) {
        StructureGenUtils.setBlockAtPosition(world, box, x, y, z, block, meta, false);
    }

    public static void setBlockAtPosition(World world, StructureBoundingBox box, int x, int y, int z, Block block, int meta, boolean ignoreBounds) {
        int j1 = StructureGenUtils.getXWithOffset(box, x, z);
        int k1 = StructureGenUtils.getYWithOffset(box, y);
        int l1 = StructureGenUtils.getZWithOffset(box, x, z);
        if (ignoreBounds || box.func_78890_b(j1, k1, l1)) {
            world.func_147465_d(j1, k1, l1, block, meta, 2);
        }
    }

    public static void adjustCornersForMaterial(World world, StructureBoundingBox box, Material material, int n, boolean checkAbove, boolean moveUp) {
        int count;
        int i;
        int n2 = i = moveUp ? 1 : -1;
        for (count = n; count > 0 && world.func_147439_a(box.field_78893_d, checkAbove ? box.field_78894_e + 1 : box.field_78895_b - 1, box.field_78892_f).func_149688_o() == material; --count) {
            box.func_78886_a(0, i, 0);
        }
        while (count > 0 && world.func_147439_a(box.field_78893_d, checkAbove ? box.field_78894_e + 1 : box.field_78895_b - 1, box.field_78896_c).func_149688_o() == material) {
            --count;
            box.func_78886_a(0, i, 0);
        }
        while (count > 0 && world.func_147439_a(box.field_78897_a, checkAbove ? box.field_78894_e + 1 : box.field_78895_b - 1, box.field_78892_f).func_149688_o() == material) {
            --count;
            box.func_78886_a(0, i, 0);
        }
        while (count > 0 && world.func_147439_a(box.field_78897_a, checkAbove ? box.field_78894_e + 1 : box.field_78895_b - 1, box.field_78896_c).func_149688_o() == material) {
            --count;
            box.func_78886_a(0, i, 0);
        }
    }

    public static void adjustForAir(World world, RoomBase room, StructureBoundingBox box) {
        int newCount;
        int maxShift;
        int i;
        int bottomCount;
        int difficulty;
        int worldHeight = room.inNether ? 128 : 160;
        int n = difficulty = room.inNether ? Config.getNetherDungeonDifficulty() : Config.getMainDungeonDifficulty();
        if (room.inOcean || difficulty == 1) {
            return;
        }
        int topCount = StructureGenUtils.getNumBlocksOfMaterial(world, box, Material.field_151579_a, 1);
        if (topCount == (bottomCount = StructureGenUtils.getNumBlocksOfMaterial(world, box, Material.field_151579_a, -1))) {
            return;
        }
        boolean shiftUp = bottomCount > topCount;
        int n2 = i = shiftUp ? 1 : -1;
        for (maxShift = box.func_78882_c(); maxShift > 0 && world.func_147437_c(box.func_78881_e(), (shiftUp ? box.field_78895_b : box.field_78894_e) - i, box.func_78891_g()) && box.field_78894_e < worldHeight && box.field_78895_b > 8; --maxShift) {
            box.func_78886_a(0, i, 0);
        }
        if (maxShift > 0) {
            StructureGenUtils.adjustCornersForMaterial(world, box, Material.field_151579_a, maxShift, !shiftUp, shiftUp);
        }
        if ((newCount = StructureGenUtils.getNumBlocksOfMaterial(world, box, Material.field_151579_a, shiftUp ? -1 : 1)) == 0) {
            if (room.inNether && difficulty != 3 || world.field_73012_v.nextFloat() < 1.0f - 0.3f * (float)difficulty) {
                box.func_78886_a(0, shiftUp ? -1 : 1, 0);
            }
        } else if (newCount > (shiftUp ? bottomCount : topCount)) {
            box.func_78886_a(0, (shiftUp ? -1 : 1) * (box.func_78882_c() - maxShift), 0);
        }
    }

    public static int getNumBlocksOfMaterial(World world, StructureBoundingBox box, Material material, int offY) {
        int count = 0;
        int y = offY > 0 ? box.field_78894_e + offY : box.field_78895_b + offY;
        count += world.func_147439_a(box.func_78881_e(), y, box.func_78891_g()).func_149688_o() == material ? 1 : 0;
        count += world.func_147439_a(box.field_78893_d, y, box.field_78892_f).func_149688_o() == material ? 1 : 0;
        count += world.func_147439_a(box.field_78893_d, y, box.field_78896_c).func_149688_o() == material ? 1 : 0;
        count += world.func_147439_a(box.field_78897_a, y, box.field_78892_f).func_149688_o() == material ? 1 : 0;
        return count += world.func_147439_a(box.field_78897_a, y, box.field_78896_c).func_149688_o() == material ? 1 : 0;
    }

    public static int getNumBlocksOfMaterialInArea(World world, StructureBoundingBox box, Material material, int y) {
        if (y < 0) {
            return StructureGenUtils.getNumBlocksOfMaterialInArea(world, Material.field_151579_a, box.field_78897_a, box.field_78893_d + 1, box.field_78895_b + y - 1, box.field_78895_b + y, box.field_78896_c, box.field_78892_f + 1);
        }
        return StructureGenUtils.getNumBlocksOfMaterialInArea(world, Material.field_151579_a, box.field_78897_a, box.field_78893_d + 1, box.field_78894_e + y, box.field_78894_e + y + 1, box.field_78896_c, box.field_78892_f + 1);
    }

    public static int getNumBlocksOfMaterialInArea(World world, Material material, int minX, int maxX, int minY, int maxY, int minZ, int maxZ) {
        int count = 0;
        for (int i = minX; i < maxX; ++i) {
            for (int j = minY; j < maxY; ++j) {
                for (int k = minZ; k < maxZ; ++k) {
                    if (world.func_147439_a(i, j, k).func_149688_o() != material) continue;
                    ++count;
                }
            }
        }
        return count;
    }
}

