/*
 * Decompiled with CFR 0.152.
 */
package zeldaswordskills.util;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.SimpleDateFormat;
import java.util.logging.Formatter;
import java.util.logging.LogRecord;

final class ZSSLogFormatter
extends Formatter {
    static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private SimpleDateFormat dateFormat = new SimpleDateFormat("HH:mm:ss");

    ZSSLogFormatter() {
    }

    @Override
    public String format(LogRecord record) {
        StringBuilder msg = new StringBuilder();
        msg.append("[" + this.dateFormat.format(record.getMillis()) + "] ");
        if (record.getLoggerName() != null) {
            msg.append("[" + record.getLoggerName() + "] ");
        } else {
            msg.append("[] ");
        }
        String level = record.getLevel().getLocalizedName();
        if (level != null && level.length() > 0) {
            msg.append("[" + level + "] ");
        } else {
            msg.append(" ");
        }
        msg.append(this.formatMessage(record));
        msg.append(LINE_SEPARATOR);
        Throwable thr = record.getThrown();
        if (thr != null) {
            StringWriter thrDump = new StringWriter();
            thr.printStackTrace(new PrintWriter(thrDump));
            msg.append(thrDump.toString());
        }
        return msg.toString();
    }
}

