/*
 * Decompiled with CFR 0.152.
 */
package zeldaswordskills.world.gen.structure;

import java.util.Random;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunkProvider;
import zeldaswordskills.lib.Config;
import zeldaswordskills.util.BossType;
import zeldaswordskills.world.gen.structure.MapGenBossRoom;
import zeldaswordskills.world.gen.structure.RoomBoss;

public class MapGenBossRoomNether
extends MapGenBossRoom {
    @Override
    public void generate(IChunkProvider provider, World world, Random rand, int chunkX, int chunkZ) {
        this.worldObj = world;
        this.loadOrCreateData(this.worldObj);
        int posX = (chunkX << 4) + rand.nextInt(16);
        int posZ = (chunkZ << 4) + rand.nextInt(16);
        BossType type = BossType.getBossType(world, posX, posZ);
        if (type != null) {
            int posY;
            RoomBoss room = new RoomBoss(type, chunkX, chunkZ, rand, rand.nextInt(6) + 8, Blocks.field_150424_aL);
            if (rand.nextFloat() < 0.2f && !this.areStructuresWithinRange(room, Config.getNetherMinBossDistance()) && (posY = rand.nextInt(128) - rand.nextInt(16)) > 16 && room.generate(this, world, rand, posX, posY, posZ)) {
                this.onStructureGenerated(type, chunkX, chunkZ);
            }
        }
    }

    @Override
    public String getTagName() {
        return "zssBossNether";
    }
}

