/*
 * Decompiled with CFR 0.152.
 */
package zeldaswordskills.world.gen.structure;

import java.util.Random;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunkProvider;
import zeldaswordskills.lib.Config;
import zeldaswordskills.world.gen.structure.MapGenSecretRoom;
import zeldaswordskills.world.gen.structure.RoomSecret;

public class MapGenSecretRoomNether
extends MapGenSecretRoom {
    @Override
    public void generate(IChunkProvider provider, World world, Random rand, int chunkX, int chunkZ) {
        this.worldObj = world;
        this.loadOrCreateData(this.worldObj);
        NBTTagList roomList = this.getStructureListFor(chunkX, chunkZ);
        int posX = chunkX << 4;
        int posZ = chunkZ << 4;
        for (int i = 0; i < Config.getNetherAttemptsPerChunk(); ++i) {
            if (!(rand.nextFloat() < Config.getNetherSecretRoomChance())) continue;
            int x = posX + rand.nextInt(16);
            int y = rand.nextInt(i % 4 == 1 ? 64 : 128) - rand.nextInt(16);
            int z = posZ + rand.nextInt(16);
            RoomSecret room = new RoomSecret(chunkX, chunkZ, rand.nextInt(6) + 3, Blocks.field_150424_aL);
            if (!room.generate(this, world, rand, x, y, z)) continue;
            roomList.func_74742_a((NBTBase)room.writeToNBT());
            this.updateChunkStructureMap(roomList, chunkX, chunkZ);
        }
        if (roomList.func_74745_c() > 0) {
            NBTTagCompound compound = new NBTTagCompound();
            compound.func_74782_a("roomList", (NBTBase)roomList);
            this.addRoomTag(compound, chunkX, chunkZ);
        }
    }

    @Override
    public String getTagName() {
        return "zssSecretNether";
    }
}

