/*
 * Decompiled with CFR 0.152.
 */
package zeldaswordskills.world.gen.structure;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.common.ChestGenHooks;
import zeldaswordskills.block.BlockPeg;
import zeldaswordskills.block.ZSSBlocks;
import zeldaswordskills.block.tileentity.TileEntityDungeonCore;
import zeldaswordskills.item.ZSSItems;
import zeldaswordskills.lib.Config;
import zeldaswordskills.util.BossType;
import zeldaswordskills.util.StructureGenUtils;
import zeldaswordskills.util.WorldUtils;
import zeldaswordskills.world.gen.DungeonLootLists;
import zeldaswordskills.world.gen.structure.RoomBase;
import zeldaswordskills.world.gen.structure.ZSSMapGenBase;

public class RoomSecret
extends RoomBase {
    protected static final int MAX_HEIGHT = 5;
    private Block door = null;
    private int side;

    public RoomSecret(int chunkX, int chunkZ, int size, Block blockRequired) {
        super(chunkX, chunkZ, size, 5, blockRequired);
    }

    @Override
    public boolean generate(ZSSMapGenBase mapGen, World world, Random rand, int x, int y, int z) {
        int range;
        int worldHeight;
        if (y < this.bBox.field_78894_e) {
            return false;
        }
        this.inNether = world.field_73011_w.field_76574_g == -1;
        this.bBox.func_78886_a(x, y - this.bBox.field_78894_e, z);
        int n = worldHeight = this.inNether ? 128 : world.func_72976_f(this.bBox.func_78881_e(), this.bBox.func_78891_g());
        if (this.bBox.field_78894_e > worldHeight) {
            this.bBox.func_78886_a(0, worldHeight - this.bBox.field_78894_e - 1, 0);
        }
        if (!this.validateTopLayer(world) && !this.placeInOcean(world, true)) {
            return false;
        }
        if (this.inNether && this.submerged && !this.placeInNether(world)) {
            return false;
        }
        StructureGenUtils.adjustForAir(world, this, this.bBox);
        this.checkSpecialCases(world, rand);
        this.setMetadata(world, x, z);
        int n2 = this.inOcean ? Config.getMinOceanDistance() : (range = this.inNether ? Config.getNetherMinDistance() : Config.getMinLandDistance());
        if (!mapGen.areStructuresWithinRange(this, range) && this.isWellHidden(world) && this.canGenerate(world)) {
            this.doStandardRoomGen(world, rand);
            return true;
        }
        return false;
    }

    @Override
    protected void setMetadata(World world, int x, int z) {
        boolean inWater;
        BossType type = BossType.getBossType(world, x, z);
        boolean bl = inWater = this.inOcean || StructureGenUtils.getNumBlocksOfMaterial(world, this.bBox, Material.field_151586_h, 1) > 0;
        if (type != null) {
            switch (type) {
                case HELL: {
                    this.metadata = 2;
                    break;
                }
                case OCEAN: {
                    this.metadata = inWater ? 6 : 0;
                    break;
                }
                default: {
                    this.metadata = 0;
                    break;
                }
            }
        } else {
            int n = this.metadata = inWater ? 6 : 0;
        }
        if (this.door != null) {
            this.metadata |= 8;
        }
    }

    @Override
    protected void decorateDungeon(World world, Random rand) {
        if (this.door != null) {
            this.placeDoor(world, rand);
        }
        this.doChestGen(world, rand);
        this.placeDungeonCore(world);
        this.placeJars(world, rand);
    }

    @Override
    protected void placeDungeonCore(World world) {
        StructureGenUtils.setBlockAtPosition(world, this.bBox, this.bBox.func_78883_b() / 2, 0, this.bBox.func_78880_d() / 2, ZSSBlocks.dungeonCore, this.getMetadata() | 8);
        int x = StructureGenUtils.getXWithOffset(this.bBox, this.bBox.func_78883_b() / 2, this.bBox.func_78880_d() / 2);
        int y = StructureGenUtils.getYWithOffset(this.bBox, 0);
        int z = StructureGenUtils.getZWithOffset(this.bBox, this.bBox.func_78883_b() / 2, this.bBox.func_78880_d() / 2);
        TileEntity te = world.func_147438_o(x, y, z);
        if (te instanceof TileEntityDungeonCore) {
            ((TileEntityDungeonCore)te).setDungeonBoundingBox(this.bBox);
            if (this.door != null) {
                ((TileEntityDungeonCore)te).setDoor(this.door, this.side);
            }
            if (!this.inNether && this.submerged && !this.inLava && !this.inOcean && this.bBox.func_78883_b() > 4 && (this.inMountain || world.field_73012_v.nextFloat() < Config.getFairySpawnerChance())) {
                ((TileEntityDungeonCore)te).setSpawner();
            }
        }
    }

    private void checkSpecialCases(World world, Random rand) {
        boolean flag;
        BiomeGenBase biome = world.func_72807_a(this.bBox.func_78881_e(), this.bBox.func_78891_g());
        boolean bl = flag = !this.submerged && this.bBox.field_78894_e > 64 && biome != null;
        if (this.inNether && !this.inLava) {
            if (rand.nextFloat() < 0.25f) {
                this.submerged = true;
                this.inLava = true;
            }
        } else if (flag && (biome.field_76791_y.toLowerCase().contains("hill") || biome.field_76791_y.toLowerCase().contains("mountain"))) {
            this.submerged = rand.nextFloat() < Config.getFairySpawnerChance();
            this.inMountain = true;
        }
        if (this.submerged && this.bBox.func_78883_b() > 3) {
            --this.bBox.field_78895_b;
        }
        if (!this.submerged && this.bBox.func_78883_b() > 5 && rand.nextFloat() < Config.getBarredRoomChance()) {
            this.door = rand.nextInt(4) == 0 ? (rand.nextInt(4) == 0 ? ZSSBlocks.barrierHeavy : ZSSBlocks.pegRusty) : (rand.nextInt(4) == 0 ? ZSSBlocks.barrierLight : ZSSBlocks.pegWooden);
            this.side = rand.nextInt(4);
        }
    }

    private void doChestGen(World world, Random rand) {
        int rX = this.bBox.func_78883_b() - 2;
        int rY = this.inLava && this.bBox.func_78882_c() > 3 ? 2 : 1;
        int rZ = this.bBox.func_78880_d() - 2;
        if (this.door instanceof BlockPeg) {
            switch (this.side) {
                case 0: {
                    rX = 1;
                    break;
                }
                case 2: {
                    rZ = 1;
                    rX = 1;
                    break;
                }
                case 3: {
                    rZ = 1;
                    break;
                }
                case 1: {
                    rZ = 1;
                    rX = 1;
                }
            }
            this.generateChestContents(world, rand, rX, rY, rZ, true);
        } else {
            this.generateChestContents(world, rand, rand.nextInt(rX) + 1, rY, rand.nextInt(rZ) + 1, true);
            if (this.bBox.func_78883_b() > 5 && rand.nextFloat() < Config.getDoubleChestChance()) {
                this.generateChestContents(world, rand, rand.nextInt(rX) + 1, rY, rand.nextInt(rZ) + 1, false);
            }
        }
    }

    private boolean generateChestContents(World world, Random rand, int x, int y, int z, boolean first) {
        int k1;
        int j1;
        int i1 = StructureGenUtils.getXWithOffset(this.bBox, x, z);
        if (this.bBox.func_78890_b(i1, j1 = StructureGenUtils.getYWithOffset(this.bBox, y), k1 = StructureGenUtils.getZWithOffset(this.bBox, x, z)) && !StructureGenUtils.isBlockChest(world, i1, j1, k1)) {
            Block chestBlock = rand.nextFloat() < Config.getLockedChestChance() ? ZSSBlocks.chestLocked : Blocks.field_150486_ae;
            world.func_147465_d(i1, j1, k1, chestBlock, 0, 2);
            TileEntity te = world.func_147438_o(i1, j1, k1);
            if (te instanceof IInventory) {
                IInventory chest = (IInventory)te;
                DungeonLootLists.generateChestContents(world, rand, chest, this, chestBlock == ZSSBlocks.chestLocked);
                if (first && rand.nextFloat() < Config.getHeartPieceChance()) {
                    WorldUtils.addItemToInventoryAtRandom(rand, new ItemStack(ZSSItems.heartPiece), chest, 3);
                }
                if (this.door != null) {
                    ItemStack loot = ChestGenHooks.getInfo((String)DungeonLootLists.BOSS_LOOT).getOneItem(rand);
                    if (rand.nextFloat() < 0.0625f * (1.0f / Math.max(Config.getBarredRoomChance(), 0.1f))) {
                        if (this.door == ZSSBlocks.pegWooden) {
                            loot = new ItemStack(ZSSItems.gauntletsSilver);
                        } else if (this.door == ZSSBlocks.barrierLight) {
                            loot = new ItemStack(ZSSItems.hammerSkull);
                        } else if (this.door == ZSSBlocks.pegRusty) {
                            loot = new ItemStack(ZSSItems.gauntletsGolden);
                        } else if (this.door == ZSSBlocks.barrierHeavy) {
                            loot = new ItemStack(ZSSItems.hammerMegaton);
                        }
                    }
                    if (loot != null) {
                        WorldUtils.addItemToInventoryAtRandom(rand, loot, chest, 3);
                    }
                }
            }
            if (world.func_147439_a(i1, j1 - 1, k1).func_149688_o() == Material.field_151587_i && this.bBox.func_78882_c() > 3) {
                world.func_147465_d(i1, j1 - 1, k1, ZSSBlocks.secretStone, this.getMetadata(), 2);
            }
            return true;
        }
        return false;
    }

    private void placeDoor(World world, Random rand) {
        int x = this.bBox.func_78881_e();
        int y = this.bBox.field_78895_b + (this.submerged ? 2 : 1);
        int z = this.bBox.func_78891_g();
        switch (this.side % 4) {
            case 0: {
                z = this.bBox.field_78892_f;
                break;
            }
            case 2: {
                z = this.bBox.field_78896_c;
                break;
            }
            case 3: {
                x = this.bBox.field_78893_d;
                break;
            }
            case 1: {
                x = this.bBox.field_78897_a;
            }
        }
        world.func_147465_d(x, y, z, this.door, 0, 2);
        world.func_147465_d(x, y + 1, z, this.door instanceof BlockPeg ? Blocks.field_150350_a : this.door, 0, 2);
    }

    private void placeJars(World world, Random rand) {
        int size = this.bBox.func_78883_b();
        if (size > 4) {
            int n = rand.nextInt(size - 3);
            for (int i = 0; i < n; ++i) {
                int z;
                int y;
                int x = this.bBox.field_78897_a + rand.nextInt(size);
                Material m = world.func_147439_a(x, y = this.bBox.field_78895_b + 1, z = this.bBox.field_78896_c + rand.nextInt(this.bBox.func_78880_d())).func_149688_o();
                if (m != Material.field_151579_a && !m.func_76224_d()) continue;
                world.func_147449_b(x, y, z, ZSSBlocks.ceramicJar);
            }
        }
    }
}

